/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.spark.CleanerListener;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.Success$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorListener$ShuffleCleanedEvent$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Iterable$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rUf\u0001B.]\u0001\u0015D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\t{\u0002\u0011\t\u0011)A\u0005}\"Q\u00111\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u0005-\u0001A!A!\u0002\u0013\ti\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u0013\u0005\u001d\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u001c\u0001\u0001\u0006I!a\u000b\t\u0013\u0005e\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u001e\u0001\u0001\u0006I!a\u000b\t\u0013\u0005u\u0002A1A\u0005\n\u0005}\u0002\u0002\u0003B\u0015\u0001\u0001\u0006I!!\u0011\t\u0013\t-\u0002A1A\u0005\n\t5\u0002\u0002\u0003B\u001c\u0001\u0001\u0006IAa\f\t\u0013\te\u0002A1A\u0005\n\tm\u0002\u0002\u0003B \u0001\u0001\u0006IA!\u0010\t\u0013\t\u0005\u0003A1A\u0005\n\t\r\u0003\u0002\u0003B'\u0001\u0001\u0006IA!\u0012\t\u0013\t=\u0003A1A\u0005\n\tE\u0003\u0002\u0003B/\u0001\u0001\u0006IAa\u0015\t\u0011\t}\u0003\u0001\"\u0001]\u0005CB\u0001B!\u001a\u0001\t\u0003a&q\r\u0005\b\u0005K\u0002A\u0011\u0001B8\u0011\u001d\u0011\t\b\u0001C\u0001\u0005_BqAa\u001d\u0001\t\u0003\u0011)\bC\u0004\u0003z\u0001!\t!a/\t\u000f\tm\u0004\u0001\"\u0011\u0003~!9!\u0011\u0012\u0001\u0005B\t-\u0005b\u0002BK\u0001\u0011\u0005#q\u0013\u0005\b\u0005C\u0003A\u0011\tBR\u0011\u001d\u0011i\u000b\u0001C!\u0005_CqA!/\u0001\t\u0003\u0012Y\fC\u0004\u0003F\u0002!\tEa2\t\u000f\tE\u0007\u0001\"\u0003\u0003T\"9!Q\u001c\u0001\u0005B\t}\u0007b\u0002Bu\u0001\u0011\u0005#1\u001e\u0005\b\u0005k\u0004A\u0011\tB|\u0011\u001d\u0011Y\u0010\u0001C!\u0005{Dqaa\u0001\u0001\t\u0003\u001a)\u0001C\u0004\u0004\f\u0001!\te!\u0004\t\u000f\rM\u0001\u0001\"\u0011\u0004\u0016!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0010\u0001\u0011%1\u0011\u0005\u0004\u0007\u0003[\u0002\u0001!a\u001c\t\u000f\u0005e1\u0006\"\u0001\u0002x!I\u0011\u0011P\u0016A\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003wZ\u0003\u0019!C\u0001\u0003{B\u0001\"!#,A\u0003&\u00111\u0006\u0005\n\u0003'[\u0003\u0019!C\u0001\u0003+C\u0011\"!(,\u0001\u0004%\t!a(\t\u0011\u0005\r6\u0006)Q\u0005\u0003/C\u0011\"!*,\u0001\u0004%\t!!&\t\u0013\u0005\u001d6\u00061A\u0005\u0002\u0005%\u0006\u0002CAWW\u0001\u0006K!a&\t\u0013\u0005=6\u00061A\u0005\n\u0005%\u0002\"CAYW\u0001\u0007I\u0011BAZ\u0011!\t9l\u000bQ!\n\u0005-\u0002\"CA]W\u0001\u0007I\u0011BA^\u0011%\t\u0019m\u000ba\u0001\n\u0013\t)\r\u0003\u0005\u0002J.\u0002\u000b\u0015BA_\u0011%\tYm\u000bb\u0001\n\u0003\ti\r\u0003\u0005\u0002f.\u0002\u000b\u0011BAh\u0011%\t9o\u000bb\u0001\n\u0003\tI\u000f\u0003\u0005\u0002r.\u0002\u000b\u0011BAv\u0011\u001d\t\u0019p\u000bC\u0001\u0003+Cq!!>,\t\u0003\t9\u0010C\u0004\u0002~.\"\t!a@\t\u000f\t\u00051\u0006\"\u0001\u0003\u0004!9!\u0011B\u0016\u0005\u0002\t-\u0001b\u0002B\bW\u0011\u0005!\u0011\u0003\u0004\u0007\u0007K\u0001Aia\n\t\u0015\t\u001daI!f\u0001\n\u0003\tY\f\u0003\u0006\u00046\u0019\u0013\t\u0012)A\u0005\u0003{Cq!!\u0007G\t\u0003\u00199\u0004\u0003\u0005\u0004>\u0019#\tFXAK\u0011%\u0019yDRA\u0001\n\u0003\u0019\t\u0005C\u0005\u0004F\u0019\u000b\n\u0011\"\u0001\u0004H!I1Q\f$\u0002\u0002\u0013\u0005#\u0011\u000b\u0005\n\u0007?2\u0015\u0011!C\u0001\u0003wC\u0011b!\u0019G\u0003\u0003%\taa\u0019\t\u0013\r5d)!A\u0005B\r=\u0004\"CB=\r\u0006\u0005I\u0011AB>\u0011%\u0019yHRA\u0001\n\u0003\u001a\t\tC\u0005\u0004\u0004\u001a\u000b\t\u0011\"\u0011\u0004\u0006\"I1q\u0011$\u0002\u0002\u0013\u00053\u0011R\u0004\n\u0007\u001b\u0003\u0011\u0011!E\u0005\u0007\u001f3\u0011b!\n\u0001\u0003\u0003EIa!%\t\u000f\u0005ea\u000b\"\u0001\u0004 \"I11\u0011,\u0002\u0002\u0013\u00153Q\u0011\u0005\n\u0007C3\u0016\u0011!CA\u0007GC\u0011ba*W\u0003\u0003%\ti!+\u0003!\u0015CXmY;u_Jd\u0015n\u001d;f]\u0016\u0014(BA/_\u0003%\u00198\r[3ek2,'O\u0003\u0002`A\u0006)1\u000f]1sW*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0007\u0001\u0019B\u0001\u00014k]B\u0011q\r[\u0007\u00029&\u0011\u0011\u000e\u0018\u0002\u000e'B\f'o\u001b'jgR,g.\u001a:\u0011\u0005-dW\"\u00010\n\u00055t&aD\"mK\u0006tWM\u001d'jgR,g.\u001a:\u0011\u0005=\u0014X\"\u00019\u000b\u0005Et\u0016\u0001C5oi\u0016\u0014h.\u00197\n\u0005M\u0004(a\u0002'pO\u001eLgnZ\u0001\fWfd\u0017N\\\"p]\u001aLw\r\u0005\u0002ww6\tqO\u0003\u0002ys\u000611m\\7n_:T!A\u001f1\u0002\u000b-LH.\u001b8\n\u0005q<(aC&zY&t7i\u001c8gS\u001e\faa\u00197jK:$\bCA6\u0000\u0013\r\t\tA\u0018\u0002\u0019\u000bb,7-\u001e;pe\u0006cGn\\2bi&|gn\u00117jK:$\u0018a\u00037jgR,g.\u001a:CkN\u00042aZA\u0004\u0013\r\tI\u0001\u0018\u0002\u0010\u0019&4X\rT5ti\u0016tWM\u001d\"vg\u0006)1\r\\8dWB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014y\u000bA!\u001e;jY&!\u0011qCA\t\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}QQ\u0011QDA\u0010\u0003C\t\u0019#!\n\u0011\u0005\u001d\u0004\u0001\"\u0002;\u0006\u0001\u0004)\b\"B?\u0006\u0001\u0004q\bbBA\u0002\u000b\u0001\u0007\u0011Q\u0001\u0005\b\u0003\u0017)\u0001\u0019AA\u0007\u00035IG\r\\3US6,w.\u001e;OgV\u0011\u00111\u0006\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0011\u0011\u0011G\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003k\tyC\u0001\u0003M_:<\u0017AD5eY\u0016$\u0016.\\3pkRt5\u000fI\u0001\u0011g\",hM\u001a7f)&lWm\\;u\u001dN\f\u0011c\u001d5vM\u001adW\rV5nK>,HOT:!\u0003%)\u00070Z2vi>\u00148/\u0006\u0002\u0002BAA\u00111IA(\u0003'\nI'\u0004\u0002\u0002F)!\u0011qIA%\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003'\tYE\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\u0011\t\t&!\u0012\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002V\u0005\rd\u0002BA,\u0003?\u0002B!!\u0017\u000205\u0011\u00111\f\u0006\u0004\u0003;\"\u0017A\u0002\u001fs_>$h(\u0003\u0003\u0002b\u0005=\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002f\u0005\u001d$AB*ue&twM\u0003\u0003\u0002b\u0005=\u0002cAA6W5\t\u0001AA\u0004Ue\u0006\u001c7.\u001a:\u0014\u0007-\n\t\b\u0005\u0003\u0002.\u0005M\u0014\u0002BA;\u0003_\u0011a!\u00118z%\u00164GCAA5\u0003%!\u0018.\\3pkR\fE/A\u0007uS6,w.\u001e;Bi~#S-\u001d\u000b\u0005\u0003\u007f\n)\t\u0005\u0003\u0002.\u0005\u0005\u0015\u0002BAB\u0003_\u0011A!\u00168ji\"I\u0011q\u0011\u0018\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\n\u0014A\u0003;j[\u0016|W\u000f^!uA!\u001aq&!$\u0011\t\u00055\u0012qR\u0005\u0005\u0003#\u000byC\u0001\u0005w_2\fG/\u001b7f\u00039\u0001XM\u001c3j]\u001e\u0014V-\\8wC2,\"!a&\u0011\t\u00055\u0012\u0011T\u0005\u0005\u00037\u000byCA\u0004C_>dW-\u00198\u0002%A,g\u000eZ5oOJ+Wn\u001c<bY~#S-\u001d\u000b\u0005\u0003\u007f\n\t\u000bC\u0005\u0002\bF\n\t\u00111\u0001\u0002\u0018\u0006y\u0001/\u001a8eS:<'+Z7pm\u0006d\u0007%\u0001\tiCN\f5\r^5wKNCWO\u001a4mK\u0006!\u0002.Y:BGRLg/Z*ik\u001a4G.Z0%KF$B!a \u0002,\"I\u0011q\u0011\u001b\u0002\u0002\u0003\u0007\u0011qS\u0001\u0012Q\u0006\u001c\u0018i\u0019;jm\u0016\u001c\u0006.\u001e4gY\u0016\u0004\u0013!C5eY\u0016\u001cF/\u0019:u\u00035IG\r\\3Ti\u0006\u0014Ho\u0018\u0013fcR!\u0011qPA[\u0011%\t9iNA\u0001\u0002\u0004\tY#\u0001\u0006jI2,7\u000b^1si\u0002\nAB];o]&tw\rV1tWN,\"!!0\u0011\t\u00055\u0012qX\u0005\u0005\u0003\u0003\fyCA\u0002J]R\f\u0001C];o]&tw\rV1tWN|F%Z9\u0015\t\u0005}\u0014q\u0019\u0005\n\u0003\u000fS\u0014\u0011!a\u0001\u0003{\u000bQB];o]&tw\rV1tWN\u0004\u0013\u0001D2bG\",GM\u00117pG.\u001cXCAAh!!\t\t.a7\u0002>\u0006}WBAAj\u0015\u0011\t).a6\u0002\u000f5,H/\u00192mK*!\u0011\u0011\\A\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\f\u0019NA\u0004ICNDW*\u00199\u0011\t\u0005E\u0017\u0011]\u0005\u0005\u0003G\f\u0019N\u0001\u0004CSR\u001cV\r^\u0001\u000eG\u0006\u001c\u0007.\u001a3CY>\u001c7n\u001d\u0011\u0002\u0015MDWO\u001a4mK&#7/\u0006\u0002\u0002lB1\u0011\u0011[Aw\u0003{KA!a<\u0002T\n9\u0001*Y:i'\u0016$\u0018aC:ik\u001a4G.Z%eg\u0002\na![:JI2,\u0017AE;qI\u0006$XMU;o]&tw\rV1tWN$B!a \u0002z\"9\u00111`!A\u0002\u0005u\u0016!\u00023fYR\f\u0017!D;qI\u0006$X\rV5nK>,H\u000f\u0006\u0002\u0002\u0000\u0005Q\u0011\r\u001a3TQV4g\r\\3\u0015\t\u0005}$Q\u0001\u0005\b\u0005\u000f\u0019\u0005\u0019AA_\u0003\tIG-A\u0007sK6|g/Z*ik\u001a4G.\u001a\u000b\u0005\u0003\u007f\u0012i\u0001C\u0004\u0003\b\u0011\u0003\r!!0\u0002)U\u0004H-\u0019;f\u0003\u000e$\u0018N^3TQV4g\r\\3t)\u0011\tyHa\u0005\t\u000f\tUQ\t1\u0001\u0003\u0018\u0005\u0019\u0011\u000eZ:\u0011\r\te!1EA_\u001d\u0011\u0011YBa\b\u000f\t\u0005e#QD\u0005\u0003\u0003cIAA!\t\u00020\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0013\u0005O\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0005\u0005C\ty#\u0001\u0006fq\u0016\u001cW\u000f^8sg\u0002\n1c\u001d5vM\u001adW\rV8BGRLg/\u001a&pEN,\"Aa\f\u0011\u0011\u0005E\u00171\\A_\u0005c\u0001b!!5\u00034\u0005u\u0016\u0002\u0002B\u001b\u0003'\u00141\"\u0011:sCf\u0014UO\u001a4fe\u0006!2\u000f[;gM2,Gk\\!di&4XMS8cg\u0002\n\u0001c\u001d;bO\u0016$vn\u00155vM\u001adW-\u0013#\u0016\u0005\tu\u0002\u0003CAi\u00037\fi,!0\u0002#M$\u0018mZ3U_NCWO\u001a4mK&#\u0005%A\u0007k_\n$vn\u0015;bO\u0016LEi]\u000b\u0003\u0005\u000b\u0002\u0002\"!5\u0002\\\u0006u&q\t\t\u0007\u00053\u0011I%!0\n\t\t-#q\u0005\u0002\u0004'\u0016\f\u0018A\u00046pER{7\u000b^1hK&#5\u000fI\u0001\tIJLg/\u001a:JIV\u0011!1\u000b\t\u0005\u0005+\u0012Y&\u0004\u0002\u0003X)!!\u0011LA&\u0003\u0011a\u0017M\\4\n\t\u0005\u0015$qK\u0001\nIJLg/\u001a:JI\u0002\na\"[:Fq\u0016\u001cW\u000f^8s\u0013\u0012dW\r\u0006\u0003\u0002\u0018\n\r\u0004b\u0002B\u0004)\u0001\u0007\u00111K\u0001\u0012i&lW\rZ(vi\u0016CXmY;u_J\u001cH\u0003\u0002B5\u0005W\u0002bA!\u0007\u0003J\u0005M\u0003b\u0002B7+\u0001\u0007\u00111F\u0001\u0005o\",g\u000e\u0006\u0002\u0003j\u0005Ibn\u001c)f]\u0012Lgn\u001a*f[>4\u0018\r\\#yK\u000e,Ho\u001c:t\u0003=)\u00070Z2vi>\u00148oS5mY\u0016$G\u0003BA@\u0005oBqA!\u0006\u0019\u0001\u0004\u0011I'A\u0007fq\u0016\u001cW\u000f^8s\u0007>,h\u000e^\u0001\u000b_:TuNY*uCJ$H\u0003BA@\u0005\u007fBqA!!\u001b\u0001\u0004\u0011\u0019)A\u0003fm\u0016tG\u000fE\u0002h\u0005\u000bK1Aa\"]\u0005U\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'m\u0015;beR\f\u0001b\u001c8K_\n,e\u000e\u001a\u000b\u0005\u0003\u007f\u0012i\tC\u0004\u0003\u0002n\u0001\rAa$\u0011\u0007\u001d\u0014\t*C\u0002\u0003\u0014r\u00131c\u00159be.d\u0015n\u001d;f]\u0016\u0014(j\u001c2F]\u0012\f1b\u001c8UCN\\7\u000b^1siR!\u0011q\u0010BM\u0011\u001d\u0011\t\t\ba\u0001\u00057\u00032a\u001aBO\u0013\r\u0011y\n\u0018\u0002\u0017'B\f'o\u001b'jgR,g.\u001a:UCN\\7\u000b^1si\u0006IqN\u001c+bg.,e\u000e\u001a\u000b\u0005\u0003\u007f\u0012)\u000bC\u0004\u0003\u0002v\u0001\rAa*\u0011\u0007\u001d\u0014I+C\u0002\u0003,r\u0013Ac\u00159be.d\u0015n\u001d;f]\u0016\u0014H+Y:l\u000b:$\u0017aD8o\u000bb,7-\u001e;pe\u0006#G-\u001a3\u0015\t\u0005}$\u0011\u0017\u0005\b\u0005\u0003s\u0002\u0019\u0001BZ!\r9'QW\u0005\u0004\u0005oc&AG*qCJ\\G*[:uK:,'/\u0012=fGV$xN]!eI\u0016$\u0017!E8o\u000bb,7-\u001e;peJ+Wn\u001c<fIR!\u0011q\u0010B_\u0011\u001d\u0011\ti\ba\u0001\u0005\u007f\u00032a\u001aBa\u0013\r\u0011\u0019\r\u0018\u0002\u001d'B\f'o\u001b'jgR,g.\u001a:Fq\u0016\u001cW\u000f^8s%\u0016lwN^3e\u00039ygN\u00117pG.,\u0006\u000fZ1uK\u0012$B!a \u0003J\"9!\u0011\u0011\u0011A\u0002\t-\u0007cA4\u0003N&\u0019!q\u001a/\u00033M\u0003\u0018M]6MSN$XM\\3s\u00052|7m[+qI\u0006$X\rZ\u0001\u0012G2,\u0017M\\\"bG\",GM\u00117pG.\u001cHCBA@\u0005+\u0014I\u000eC\u0004\u0003X\u0006\u0002\r!!\u001b\u0002\t\u0015DXm\u0019\u0005\b\u00057\f\u0003\u0019AA_\u0003\u0015\u0011H\rZ%e\u00039yg.\u00168qKJ\u001c\u0018n\u001d;S\t\u0012#B!a \u0003b\"9!\u0011\u0011\u0012A\u0002\t\r\bcA4\u0003f&\u0019!q\u001d/\u00033M\u0003\u0018M]6MSN$XM\\3s+:\u0004XM]:jgR\u0014F\tR\u0001\r_:|E\u000f[3s\u000bZ,g\u000e\u001e\u000b\u0005\u0003\u007f\u0012i\u000fC\u0004\u0003\u0002\u000e\u0002\rAa<\u0011\u0007\u001d\u0014\t0C\u0002\u0003tr\u0013!c\u00159be.d\u0015n\u001d;f]\u0016\u0014XI^3oi\u0006Q!\u000f\u001a3DY\u0016\fg.\u001a3\u0015\t\u0005}$\u0011 \u0005\b\u00057$\u0003\u0019AA_\u00039\u0019\b.\u001e4gY\u0016\u001cE.Z1oK\u0012$B!a \u0003\u0000\"91\u0011A\u0013A\u0002\u0005u\u0016!C:ik\u001a4G.Z%e\u0003A\u0011'o\\1eG\u0006\u001cHo\u00117fC:,G\r\u0006\u0003\u0002\u0000\r\u001d\u0001bBB\u0005M\u0001\u0007\u00111F\u0001\fEJ|\u0017\rZ2bgRLE-\u0001\u0007bG\u000e,Xn\u00117fC:,G\r\u0006\u0003\u0002\u0000\r=\u0001bBB\tO\u0001\u0007\u00111F\u0001\u0006C\u000e\u001c\u0017\nZ\u0001\u0012G\",7m\u001b9pS:$8\t\\3b]\u0016$G\u0003BA@\u0007/AqAa7)\u0001\u0004\tY#A\ff]N,(/Z#yK\u000e,Ho\u001c:JgR\u0013\u0018mY6fIR!\u0011\u0011NB\u000f\u0011\u001d\u00119!\u000ba\u0001\u0003'\nab\u00197fC:,\bo\u00155vM\u001adW\r\u0006\u0003\u0002\u0000\r\r\u0002b\u0002B\u0004U\u0001\u0007\u0011Q\u0018\u0002\u0014'\",hM\u001a7f\u00072,\u0017M\\3e\u000bZ,g\u000e^\n\n\r\u0006E$q^B\u0015\u0007_\u0001B!!\f\u0004,%!1QFA\u0018\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\f\u00042%!11GA\u0018\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\rIG\r\t\u000b\u0005\u0007s\u0019Y\u0004E\u0002\u0002l\u0019CqAa\u0002J\u0001\u0004\ti,\u0001\u0005m_\u001e,e/\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\t\re21\t\u0005\n\u0005\u000fY\u0005\u0013!a\u0001\u0003{\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004J)\"\u0011QXB&W\t\u0019i\u0005\u0005\u0003\u0004P\reSBAB)\u0015\u0011\u0019\u0019f!\u0016\u0002\u0013Ut7\r[3dW\u0016$'\u0002BB,\u0003_\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Yf!\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019)ga\u001b\u0011\t\u000552qM\u0005\u0005\u0007S\nyCA\u0002B]fD\u0011\"a\"P\u0003\u0003\u0005\r!!0\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u001d\u0011\r\rM4QOB3\u001b\t\t9.\u0003\u0003\u0004x\u0005]'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a&\u0004~!I\u0011qQ)\u0002\u0002\u0003\u00071QM\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QX\u0001\ti>\u001cFO]5oOR\u0011!1K\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]51\u0012\u0005\n\u0003\u000f#\u0016\u0011!a\u0001\u0007K\n1c\u00155vM\u001adWm\u00117fC:,G-\u0012<f]R\u00042!a\u001bW'\u0015161SB\u0018!!\u0019)ja'\u0002>\u000eeRBABL\u0015\u0011\u0019I*a\f\u0002\u000fI,h\u000e^5nK&!1QTBL\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0007\u001f\u000bQ!\u00199qYf$Ba!\u000f\u0004&\"9!qA-A\u0002\u0005u\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0007W\u001b\t\f\u0005\u0004\u0002.\r5\u0016QX\u0005\u0005\u0007_\u000byC\u0001\u0004PaRLwN\u001c\u0005\n\u0007gS\u0016\u0011!a\u0001\u0007s\t1\u0001\u001f\u00131\u0001")
public class ExecutorListener
extends SparkListener
implements CleanerListener,
Logging {
    private volatile ExecutorListener$ShuffleCleanedEvent$ ShuffleCleanedEvent$module;
    private final KylinConfig kylinConfig;
    private final ExecutorAllocationClient client;
    private final LiveListenerBus listenerBus;
    public final Clock org$apache$spark$scheduler$ExecutorListener$$clock;
    private final long org$apache$spark$scheduler$ExecutorListener$$idleTimeoutNs;
    private final long org$apache$spark$scheduler$ExecutorListener$$shuffleTimeoutNs;
    private final ConcurrentHashMap<String, Tracker> executors;
    private final HashMap<Object, ArrayBuffer<Object>> shuffleToActiveJobs;
    private final HashMap<Object, Object> stageToShuffleID;
    private final HashMap<Object, Seq<Object>> jobToStageIDs;
    private final String driverId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private ExecutorListener$ShuffleCleanedEvent$ ShuffleCleanedEvent() {
        if (this.ShuffleCleanedEvent$module == null) {
            this.ShuffleCleanedEvent$lzycompute$1();
        }
        return this.ShuffleCleanedEvent$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long org$apache$spark$scheduler$ExecutorListener$$idleTimeoutNs() {
        return this.org$apache$spark$scheduler$ExecutorListener$$idleTimeoutNs;
    }

    public long org$apache$spark$scheduler$ExecutorListener$$shuffleTimeoutNs() {
        return this.org$apache$spark$scheduler$ExecutorListener$$shuffleTimeoutNs;
    }

    private ConcurrentHashMap<String, Tracker> executors() {
        return this.executors;
    }

    private HashMap<Object, ArrayBuffer<Object>> shuffleToActiveJobs() {
        return this.shuffleToActiveJobs;
    }

    private HashMap<Object, Object> stageToShuffleID() {
        return this.stageToShuffleID;
    }

    private HashMap<Object, Seq<Object>> jobToStageIDs() {
        return this.jobToStageIDs;
    }

    private String driverId() {
        return this.driverId;
    }

    public boolean isExecutorIdle(String id) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)this.executors().get(id)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isIdle())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw SparkCoreErrors$.MODULE$.noExecutorIdleError(id);
        }));
    }

    public Seq<String> timedOutExecutors(long when) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executors()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String id = (String)tuple2._1();
            Tracker exec = (Tracker)tuple2._2();
            Iterable iterable = exec.isIdle() && exec.timeoutAt() <= when && !id.equalsIgnoreCase(this.driverId()) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)id)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public Seq<String> timedOutExecutors() {
        long now = this.org$apache$spark$scheduler$ExecutorListener$$clock.nanoTime();
        return ((MapLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executors()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorListener.$anonfun$timedOutExecutors$2(this, x0$1)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorListener.$anonfun$timedOutExecutors$3(now, x$2)))).keys().toSeq();
    }

    public Seq<String> noPendingRemovalExecutors() {
        return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executors()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorListener.$anonfun$noPendingRemovalExecutors$1(this, x0$1)))).keys().toSeq();
    }

    public void executorsKilled(Seq<String> ids) {
        ids.foreach((Function1 & Serializable & scala.Serializable)id -> {
            ExecutorListener.$anonfun$executorsKilled$1(this, id);
            return BoxedUnit.UNIT;
        });
    }

    public int executorCount() {
        return ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executors()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ExecutorListener.$anonfun$executorCount$1(this, name)))).toSeq().size();
    }

    public void onJobStart(SparkListenerJobStart event) {
        Seq shuffleStages = (Seq)event.stageInfos().flatMap((Function1 & Serializable & scala.Serializable)s -> (Seq)Option$.MODULE$.option2Iterable(s.shuffleDepId()).toSeq().map((Function1 & Serializable & scala.Serializable)shuffleId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)s.stageId())), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)shuffleId))), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        BooleanRef updateExecutors = BooleanRef.create((boolean)false);
        shuffleStages.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayBuffer arrayBuffer;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int stageId = tuple2._1$mcI$sp();
                int shuffle = tuple2._2$mcI$sp();
                Option option = this.shuffleToActiveJobs().get((Object)BoxesRunTime.boxToInteger((int)shuffle));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ArrayBuffer jobs = (ArrayBuffer)some.value();
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Reusing shuffle ").append(shuffle).append(" in job ").append(event.jobId()).append(".").toString());
                    updateExecutors$1.elem = true;
                    arrayBuffer = jobs;
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Registered new shuffle ").append(shuffle).append(" (from stage ").append(stageId).append(").").toString());
                    ArrayBuffer jobs = new ArrayBuffer();
                    this.shuffleToActiveJobs().update((Object)BoxesRunTime.boxToInteger((int)shuffle), (Object)jobs);
                    arrayBuffer = jobs;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer jobIDs = arrayBuffer;
            ArrayBuffer arrayBuffer2 = jobIDs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)event.jobId()));
            return arrayBuffer2;
        });
        if (updateExecutors.elem) {
            Seq activeShuffleIds = (Seq)shuffleStages.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp()), Seq$.MODULE$.canBuildFrom());
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executors().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exec -> {
                ExecutorListener.$anonfun$onJobStart$7(activeShuffleIds, exec);
                return BoxedUnit.UNIT;
            });
        }
        this.stageToShuffleID().$plus$plus$eq((TraversableOnce)shuffleStages);
        this.jobToStageIDs().update((Object)BoxesRunTime.boxToInteger((int)event.jobId()), shuffleStages.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._1$mcI$sp()), Seq$.MODULE$.canBuildFrom()));
    }

    public void onJobEnd(SparkListenerJobEnd event) {
        BooleanRef updateExecutors = BooleanRef.create((boolean)false);
        ArrayBuffer activeShuffles = new ArrayBuffer();
        this.shuffleToActiveJobs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayBuffer arrayBuffer;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int shuffleId = tuple2._1$mcI$sp();
                ArrayBuffer jobs = (ArrayBuffer)tuple2._2();
                jobs.$minus$eq((Object)BoxesRunTime.boxToInteger((int)event.jobId()));
                if (jobs.nonEmpty()) {
                    arrayBuffer = activeShuffles.$plus$eq((Object)BoxesRunTime.boxToInteger((int)shuffleId));
                } else {
                    updateExecutors$2.elem = true;
                    arrayBuffer = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer arrayBuffer2 = arrayBuffer;
            return arrayBuffer2;
        });
        if (updateExecutors.elem) {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executors().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exec -> {
                ExecutorListener.$anonfun$onJobEnd$2(activeShuffles, exec);
                return BoxedUnit.UNIT;
            });
        }
        this.jobToStageIDs().remove((Object)BoxesRunTime.boxToInteger((int)event.jobId())).foreach((Function1 & Serializable & scala.Serializable)stages -> {
            stages.foreach((Function1 & Serializable & scala.Serializable)id -> ExecutorListener.$anonfun$onJobEnd$4($this, BoxesRunTime.unboxToInt((Object)id)));
            return BoxedUnit.UNIT;
        });
    }

    public void onTaskStart(SparkListenerTaskStart event) {
        block0: {
            String executorId = event.taskInfo().executorId();
            if (!this.client.isExecutorActive(executorId)) break block0;
            Tracker exec = this.ensureExecutorIsTracked(executorId);
            exec.updateRunningTasks(1);
        }
    }

    public void onTaskEnd(SparkListenerTaskEnd event) {
        block2: {
            String executorId = event.taskInfo().executorId();
            Tracker exec = this.executors().get(executorId);
            if (exec == null) break block2;
            TaskEndReason taskEndReason = event.reason();
            if (Success$.MODULE$.equals(taskEndReason)) {
                this.stageToShuffleID().get((Object)BoxesRunTime.boxToInteger((int)event.stageId())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)shuffleId -> exec.addShuffle(shuffleId));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            exec.updateRunningTasks(-1);
        }
    }

    public void onExecutorAdded(SparkListenerExecutorAdded event) {
        Tracker exec = this.ensureExecutorIsTracked(event.executorId());
        exec.updateRunningTasks(0);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("New executor ").append(event.executorId()).append(" has registered (new total is ").append(this.executors().size()).append(")").toString());
    }

    public void onExecutorRemoved(SparkListenerExecutorRemoved event) {
        block0: {
            Tracker removed = this.executors().remove(event.executorId());
            if (removed == null) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Executor ").append(event.executorId()).append(" removed (new total is ").append(this.executors().size()).append(")").toString());
        }
    }

    public void onBlockUpdated(SparkListenerBlockUpdated event) {
        Tracker exec = this.ensureExecutorIsTracked(event.blockUpdatedInfo().blockManagerId().executorId());
        if (!(event.blockUpdatedInfo().blockId() instanceof RDDBlockId)) {
            if (event.blockUpdatedInfo().blockId() instanceof ShuffleDataBlockId) {
                BlockId blockId = event.blockUpdatedInfo().blockId();
                if (blockId instanceof ShuffleDataBlockId) {
                    ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId;
                    int shuffleId = shuffleDataBlockId.shuffleId();
                    exec.addShuffle(shuffleId);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            return;
        }
        StorageLevel storageLevel = event.blockUpdatedInfo().storageLevel();
        RDDBlockId blockId = (RDDBlockId)event.blockUpdatedInfo().blockId();
        if (storageLevel.isValid() && !storageLevel.useDisk()) {
            boolean hadCachedBlocks = exec.cachedBlocks().nonEmpty();
            BitSet blocks2 = (BitSet)exec.cachedBlocks().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)blockId.rddId()), (Function0 & Serializable & scala.Serializable)() -> new BitSet(blockId.splitIndex()));
            blocks2.$plus$eq(blockId.splitIndex());
            if (!hadCachedBlocks) {
                exec.updateTimeout();
            }
        } else {
            exec.cachedBlocks().get((Object)BoxesRunTime.boxToInteger((int)blockId.rddId())).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                ExecutorListener.$anonfun$onBlockUpdated$2(this, blockId, exec, blocks);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void cleanCachedBlocks(Tracker exec, int rddId) {
        block0: {
            exec.cachedBlocks().$minus$eq((Object)BoxesRunTime.boxToInteger((int)rddId));
            if (!exec.cachedBlocks().isEmpty()) break block0;
            exec.updateTimeout();
        }
    }

    public void onUnpersistRDD(SparkListenerUnpersistRDD event) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executors().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exec -> {
            this.cleanCachedBlocks(exec, event.rddId());
            return BoxedUnit.UNIT;
        });
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof ShuffleCleanedEvent && ((ShuffleCleanedEvent)sparkListenerEvent).org$apache$spark$scheduler$ExecutorListener$ShuffleCleanedEvent$$$outer() == this) {
            ShuffleCleanedEvent shuffleCleanedEvent = (ShuffleCleanedEvent)sparkListenerEvent;
            int id = shuffleCleanedEvent.id();
            this.cleanupShuffle(id);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void rddCleaned(int rddId) {
    }

    public void shuffleCleaned(int shuffleId) {
        this.listenerBus.post((SparkListenerEvent)new ShuffleCleanedEvent(this, shuffleId));
    }

    public void broadcastCleaned(long broadcastId) {
    }

    public void accumCleaned(long accId) {
    }

    public void checkpointCleaned(long rddId) {
    }

    public Tracker ensureExecutorIsTracked(String id) {
        return this.executors().computeIfAbsent(id, x$5 -> new Tracker());
    }

    private void cleanupShuffle(int id) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Cleaning up state related to shuffle ").append(id).append(".").toString());
        this.shuffleToActiveJobs().$minus$eq((Object)BoxesRunTime.boxToInteger((int)id));
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.removeShuffle(id);
            return BoxedUnit.UNIT;
        });
    }

    private final void ShuffleCleanedEvent$lzycompute$1() {
        ExecutorListener executorListener = this;
        synchronized (executorListener) {
            if (this.ShuffleCleanedEvent$module == null) {
                this.ShuffleCleanedEvent$module = new ExecutorListener$ShuffleCleanedEvent$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$timedOutExecutors$2(ExecutorListener $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        Tracker exec = (Tracker)tuple2._2();
        boolean bl = !exec.pendingRemoval() && !exec.hasActiveShuffle() && !id.equalsIgnoreCase($this.driverId());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutExecutors$3(long now$1, Tuple2 x$2) {
        return ((Tracker)x$2._2()).timeoutAt() < now$1;
    }

    public static final /* synthetic */ boolean $anonfun$noPendingRemovalExecutors$1(ExecutorListener $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        Tracker exec = (Tracker)tuple2._2();
        boolean bl = !exec.pendingRemoval() && !id.equalsIgnoreCase($this.driverId());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$executorsKilled$1(ExecutorListener $this, String id) {
        block0: {
            Tracker tracker = $this.executors().get(id);
            if (tracker == null) break block0;
            tracker.pendingRemoval_$eq(true);
        }
    }

    public static final /* synthetic */ boolean $anonfun$executorCount$1(ExecutorListener $this, String name) {
        return $this.kylinConfig.isUTEnv() || !name.equalsIgnoreCase($this.driverId());
    }

    public static final /* synthetic */ void $anonfun$onJobStart$7(Seq activeShuffleIds$1, Tracker exec) {
        block0: {
            if (exec.hasActiveShuffle()) break block0;
            exec.updateActiveShuffles((Iterable<Object>)activeShuffleIds$1);
        }
    }

    public static final /* synthetic */ void $anonfun$onJobEnd$2(ArrayBuffer activeShuffles$1, Tracker exec) {
        block0: {
            if (!exec.hasActiveShuffle()) break block0;
            exec.updateActiveShuffles((Iterable<Object>)activeShuffles$1);
        }
    }

    public static final /* synthetic */ HashMap $anonfun$onJobEnd$4(ExecutorListener $this, int id) {
        return $this.stageToShuffleID().$minus$eq((Object)BoxesRunTime.boxToInteger((int)id));
    }

    public static final /* synthetic */ void $anonfun$onBlockUpdated$2(ExecutorListener $this, RDDBlockId blockId$1, Tracker exec$2, BitSet blocks) {
        block0: {
            blocks.$minus$eq(blockId$1.splitIndex());
            if (!blocks.isEmpty()) break block0;
            $this.cleanCachedBlocks(exec$2, blockId$1.rddId());
        }
    }

    public ExecutorListener(KylinConfig kylinConfig, ExecutorAllocationClient client, LiveListenerBus listenerBus, Clock clock) {
        this.kylinConfig = kylinConfig;
        this.client = client;
        this.listenerBus = listenerBus;
        this.org$apache$spark$scheduler$ExecutorListener$$clock = clock;
        Logging.$init$((Logging)this);
        this.org$apache$spark$scheduler$ExecutorListener$$idleTimeoutNs = TimeUnit.SECONDS.toNanos(kylinConfig.getExecutorIdleTimeout());
        this.org$apache$spark$scheduler$ExecutorListener$$shuffleTimeoutNs = TimeUnit.SECONDS.toNanos(kylinConfig.getShuffleTrackingTimeout());
        this.executors = new ConcurrentHashMap();
        this.shuffleToActiveJobs = new HashMap();
        this.stageToShuffleID = new HashMap();
        this.jobToStageIDs = new HashMap();
        this.driverId = "driver";
    }

    private class ShuffleCleanedEvent
    implements SparkListenerEvent,
    Product,
    scala.Serializable {
        private final int id;
        public final /* synthetic */ ExecutorListener $outer;

        public int id() {
            return this.id;
        }

        public boolean logEvent() {
            return false;
        }

        public ShuffleCleanedEvent copy(int id) {
            return new ShuffleCleanedEvent(this.org$apache$spark$scheduler$ExecutorListener$ShuffleCleanedEvent$$$outer(), id);
        }

        public int copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "ShuffleCleanedEvent";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return BoxesRunTime.boxToInteger((int)this.id());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ShuffleCleanedEvent;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ShuffleCleanedEvent)) return false;
            if (((ShuffleCleanedEvent)object).org$apache$spark$scheduler$ExecutorListener$ShuffleCleanedEvent$$$outer() != this.org$apache$spark$scheduler$ExecutorListener$ShuffleCleanedEvent$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ShuffleCleanedEvent shuffleCleanedEvent = (ShuffleCleanedEvent)x$1;
            if (this.id() != shuffleCleanedEvent.id()) return false;
            if (!shuffleCleanedEvent.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExecutorListener org$apache$spark$scheduler$ExecutorListener$ShuffleCleanedEvent$$$outer() {
            return this.$outer;
        }

        public ShuffleCleanedEvent(ExecutorListener $outer, int id) {
            this.id = id;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            SparkListenerEvent.$init$((SparkListenerEvent)this);
            Product.$init$((Product)this);
        }
    }

    public class Tracker {
        private volatile long timeoutAt;
        private boolean pendingRemoval;
        private boolean hasActiveShuffle;
        private long idleStart;
        private int runningTasks;
        private final HashMap<Object, BitSet> cachedBlocks;
        private final HashSet<Object> shuffleIds;

        public long timeoutAt() {
            return this.timeoutAt;
        }

        public void timeoutAt_$eq(long x$1) {
            this.timeoutAt = x$1;
        }

        public boolean pendingRemoval() {
            return this.pendingRemoval;
        }

        public void pendingRemoval_$eq(boolean x$1) {
            this.pendingRemoval = x$1;
        }

        public boolean hasActiveShuffle() {
            return this.hasActiveShuffle;
        }

        public void hasActiveShuffle_$eq(boolean x$1) {
            this.hasActiveShuffle = x$1;
        }

        private long idleStart() {
            return this.idleStart;
        }

        private void idleStart_$eq(long x$1) {
            this.idleStart = x$1;
        }

        private int runningTasks() {
            return this.runningTasks;
        }

        private void runningTasks_$eq(int x$1) {
            this.runningTasks = x$1;
        }

        public HashMap<Object, BitSet> cachedBlocks() {
            return this.cachedBlocks;
        }

        public HashSet<Object> shuffleIds() {
            return this.shuffleIds;
        }

        public boolean isIdle() {
            return this.idleStart() >= 0L && !this.hasActiveShuffle();
        }

        public void updateRunningTasks(int delta) {
            this.runningTasks_$eq(package$.MODULE$.max(0, this.runningTasks() + delta));
            this.idleStart_$eq(this.runningTasks() == 0 ? this.org$apache$spark$scheduler$ExecutorListener$Tracker$$$outer().org$apache$spark$scheduler$ExecutorListener$$clock.nanoTime() : -1L);
            this.updateTimeout();
        }

        public void updateTimeout() {
            long l;
            if (this.idleStart() >= 0L) {
                long timeout = this.cachedBlocks().nonEmpty() || this.shuffleIds().nonEmpty() ? this.org$apache$spark$scheduler$ExecutorListener$Tracker$$$outer().org$apache$spark$scheduler$ExecutorListener$$shuffleTimeoutNs() : this.org$apache$spark$scheduler$ExecutorListener$Tracker$$$outer().org$apache$spark$scheduler$ExecutorListener$$idleTimeoutNs();
                long deadline = this.idleStart() + timeout;
                l = deadline >= 0L ? deadline : Long.MAX_VALUE;
            } else {
                l = Long.MAX_VALUE;
            }
            long newDeadline = l;
            this.timeoutAt_$eq(newDeadline);
        }

        public void addShuffle(int id) {
            block0: {
                if (!this.shuffleIds().add((Object)BoxesRunTime.boxToInteger((int)id))) break block0;
                this.hasActiveShuffle_$eq(true);
            }
        }

        public void removeShuffle(int id) {
            block1: {
                if (!this.shuffleIds().remove((Object)BoxesRunTime.boxToInteger((int)id)) || !this.shuffleIds().isEmpty()) break block1;
                this.hasActiveShuffle_$eq(false);
                if (this.isIdle()) {
                    this.updateTimeout();
                }
            }
        }

        public void updateActiveShuffles(Iterable<Object> ids) {
            block0: {
                boolean hadActiveShuffle = this.hasActiveShuffle();
                this.hasActiveShuffle_$eq(ids.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> this.shuffleIds().contains((Object)BoxesRunTime.boxToInteger((int)elem))));
                if (!hadActiveShuffle || !this.isIdle()) break block0;
                this.updateTimeout();
            }
        }

        public /* synthetic */ ExecutorListener org$apache$spark$scheduler$ExecutorListener$Tracker$$$outer() {
            return ExecutorListener.this;
        }

        public Tracker() {
            if (ExecutorListener.this == null) {
                throw null;
            }
            this.timeoutAt = Long.MAX_VALUE;
            this.pendingRemoval = false;
            this.hasActiveShuffle = false;
            this.idleStart = -1L;
            this.runningTasks = 0;
            this.cachedBlocks = new HashMap();
            this.shuffleIds = new HashSet();
        }
    }
}

