/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.alibaba.ttl.TtlRunnable;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.StopQueryBroadcastEventNotifier;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.util.AsyncQueryUtil;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.request.AsyncQuerySQLRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.AsyncQueryResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.AsyncQueryService;
import org.apache.kylin.rest.service.QueryService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AsyncQueryRequestLimits;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NAsyncQueryController
extends NBasicController {
    private static final Logger logger = LoggerFactory.getLogger(NAsyncQueryController.class);
    private static final List<String> FILE_ENCODING = Lists.newArrayList((Object[])new String[]{"utf-8", "gbk"});
    private static final List<String> FILE_FORMAT = Lists.newArrayList((Object[])new String[]{"csv", "json", "xlsx", "parquet"});
    @Autowired
    @Qualifier(value="queryService")
    private QueryService queryService;
    @Autowired
    @Qualifier(value="asyncQueryService")
    private AsyncQueryService asyncQueryService;
    @Autowired
    protected AclEvaluate aclEvaluate;
    ExecutorService executorService = Executors.newCachedThreadPool();

    @ApiOperation(value="query", tags={"QE"}, notes="Update Param: query_id, accept_partial, backdoor_toggles, cache_key; Update Response: query_id")
    @PostMapping(value={"/async_query"})
    @ResponseBody
    public EnvelopeResponse<AsyncQueryResponse> query(@Valid @RequestBody AsyncQuerySQLRequest sqlRequest) throws InterruptedException, IOException {
        this.aclEvaluate.checkProjectQueryPermission(sqlRequest.getProject());
        this.checkProjectName(sqlRequest.getProject());
        if (!FILE_ENCODING.contains(sqlRequest.getEncode().toLowerCase(Locale.ROOT))) {
            return new EnvelopeResponse(QueryErrorCode.ASYNC_QUERY_ILLEGAL_PARAM.toErrorCode().getString(), (Object)new AsyncQueryResponse(sqlRequest.getQueryId(), AsyncQueryResponse.Status.FAILED, "Format " + sqlRequest.getFormat() + " unsupported. Only " + FILE_FORMAT + " are supported"), "");
        }
        if (!FILE_FORMAT.contains(sqlRequest.getFormat().toLowerCase(Locale.ROOT))) {
            return new EnvelopeResponse(QueryErrorCode.ASYNC_QUERY_ILLEGAL_PARAM.toErrorCode().getString(), (Object)new AsyncQueryResponse(sqlRequest.getQueryId(), AsyncQueryResponse.Status.FAILED, "Format " + sqlRequest.getFormat() + " unsupported. Only " + FILE_FORMAT + " are supported"), "");
        }
        AtomicReference queryIdRef = new AtomicReference();
        AtomicReference exceptionHandle = new AtomicReference();
        SecurityContext context = SecurityContextHolder.getContext();
        if (StringUtils.isEmpty((CharSequence)sqlRequest.getSeparator())) {
            sqlRequest.setSeparator(",");
        }
        AsyncQueryRequestLimits asyncQueryRequestLimits = null;
        if (NProjectManager.getProjectConfig((String)sqlRequest.getProject()).isUniqueAsyncQueryYarnQueue()) {
            asyncQueryRequestLimits = new AsyncQueryRequestLimits();
        }
        AsyncQueryRequestLimits finalAsyncQueryRequestLimits = asyncQueryRequestLimits;
        this.executorService.submit((Runnable)Objects.requireNonNull(TtlRunnable.get(() -> {
            String format = sqlRequest.getFormat().toLowerCase(Locale.ROOT);
            String encode = sqlRequest.getEncode().toLowerCase(Locale.ROOT);
            SecurityContextHolder.setContext((SecurityContext)context);
            SparderEnv.setSeparator((String)sqlRequest.getSeparator());
            QueryContext queryContext = QueryContext.current();
            sqlRequest.setQueryId(queryContext.getQueryId());
            queryContext.getQueryTagInfo().setAsyncQuery(true);
            queryContext.getQueryTagInfo().setFileFormat(format);
            queryContext.getQueryTagInfo().setFileEncode(encode);
            queryContext.getQueryTagInfo().setFileName(sqlRequest.getFileName());
            queryContext.getQueryTagInfo().setSeparator(sqlRequest.getSeparator());
            queryContext.getQueryTagInfo().setIncludeHeader(sqlRequest.isIncludeHeader());
            queryContext.setProject(sqlRequest.getProject());
            logger.info("Start a new async query with queryId: {}", (Object)queryContext.getQueryId());
            String queryId = queryContext.getQueryId();
            queryIdRef.set(queryId);
            try {
                this.asyncQueryService.saveQueryUsername(sqlRequest.getProject(), queryId);
                SQLResponse response = this.queryService.queryWithCache((SQLRequest)sqlRequest);
                if (response.isException()) {
                    AsyncQueryUtil.createErrorFlag((String)sqlRequest.getProject(), (String)queryContext.getQueryId(), (String)response.getExceptionMessage());
                    exceptionHandle.set(response.getExceptionMessage());
                }
            }
            catch (Exception e) {
                try {
                    logger.error("failed to run query {}", (Object)queryContext.getQueryId(), (Object)e);
                    AsyncQueryUtil.createErrorFlag((String)sqlRequest.getProject(), (String)queryContext.getQueryId(), (String)e.getMessage());
                    exceptionHandle.set(e.getMessage());
                }
                catch (Exception e1) {
                    exceptionHandle.set((String)exceptionHandle.get() + "\n" + e.getMessage());
                    throw new RuntimeException(e1);
                }
            }
            finally {
                if (finalAsyncQueryRequestLimits != null) {
                    finalAsyncQueryRequestLimits.close();
                }
                logger.info("Async query with queryId: {} end", (Object)queryContext.getQueryId());
                QueryContext.current().close();
            }
        })));
        while (queryIdRef.get() == null) {
            Thread.sleep(200L);
        }
        switch (this.asyncQueryService.queryStatus(sqlRequest.getProject(), sqlRequest.getQueryId())) {
            case SUCCESS: {
                return new EnvelopeResponse("000", (Object)new AsyncQueryResponse((String)queryIdRef.get(), AsyncQueryResponse.Status.SUCCESSFUL, "query success"), "");
            }
            case FAILED: {
                return new EnvelopeResponse("000", (Object)new AsyncQueryResponse((String)queryIdRef.get(), AsyncQueryResponse.Status.FAILED, (String)exceptionHandle.get()), "");
            }
        }
        return new EnvelopeResponse("000", (Object)new AsyncQueryResponse((String)queryIdRef.get(), AsyncQueryResponse.Status.RUNNING, "query still running"), "");
    }

    @ApiOperation(value="cancel async query", tags={"QE"})
    @DeleteMapping(value={"/async_query"})
    @ResponseBody
    public EnvelopeResponse<Boolean> batchDelete(@RequestParam(value="project", required=false) String project, @RequestParam(value="older_than", required=false) String time, HttpServletRequest request) throws Exception {
        if (!NAsyncQueryController.isAdmin()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, "Access denied. Only admin users can delete the query results");
        }
        if (project != null) {
            this.aclEvaluate.checkProjectQueryPermission(project);
            this.checkProjectName(project);
        }
        try {
            if (this.asyncQueryService.batchDelete(project, time, request)) {
                return new EnvelopeResponse("000", (Object)true, "");
            }
            return new EnvelopeResponse("000", (Object)false, MsgPicker.getMsg().getCleanFolderFail());
        }
        catch (ParseException e) {
            logger.error(ErrorCodeServer.ASYNC_QUERY_TIME_FORMAT_ERROR.getMsg(new Object[0]), (Throwable)e);
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_TIME_FORMAT_ERROR, new Object[0]);
        }
    }

    @ApiOperation(value="delete all folder", tags={"QE"})
    @DeleteMapping(value={"/async_query/tenant_node"})
    @ResponseBody
    public EnvelopeResponse<Boolean> deleteAllFolder() throws Exception {
        if (this.asyncQueryService.deleteAllFolder()) {
            return new EnvelopeResponse("000", (Object)true, "");
        }
        return new EnvelopeResponse("000", (Object)false, MsgPicker.getMsg().getCleanFolderFail());
    }

    @ApiOperation(value="cancel async query", tags={"QE"})
    @DeleteMapping(value={"/async_query/{query_id:.+}"})
    @ResponseBody
    public EnvelopeResponse<Boolean> deleteByQueryId(@PathVariable(value="query_id") String queryId, @Valid @RequestBody(required=false) AsyncQuerySQLRequest sqlRequest, @RequestParam(value="project", required=false) String project) throws IOException {
        if (project == null) {
            if (sqlRequest == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_PROJECT_NAME_EMPTY, new Object[0]);
            }
            project = sqlRequest.getProject();
        }
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.checkProjectName(project);
        if (!this.asyncQueryService.hasPermission(queryId, project)) {
            return new EnvelopeResponse("401", (Object)false, "Access denied. Only admin users can delete the query results");
        }
        boolean result = this.asyncQueryService.deleteByQueryId(project, queryId);
        if (result) {
            return new EnvelopeResponse("000", (Object)true, "");
        }
        return new EnvelopeResponse("000", (Object)false, MsgPicker.getMsg().getCleanFolderFail());
    }

    @ApiOperation(value="stopQuery", tags={"QE"})
    @DeleteMapping(value={"/async_query/stop/{query_id:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> stopAsyncQuery(@PathVariable(value="query_id") String queryId, @RequestParam(value="project", required=false) String project) throws IOException {
        if (project == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_PROJECT_NAME_EMPTY, new Object[0]);
        }
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.checkProjectName(project);
        if (!this.asyncQueryService.hasPermission(queryId, project)) {
            return new EnvelopeResponse("401", (Object)"Access denied.", "Access denied. Only admin users can stop the query");
        }
        AsyncQueryService.QueryStatus queryStatus = this.asyncQueryService.queryStatus(project, queryId);
        if (queryStatus == AsyncQueryService.QueryStatus.MISS) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
        if (queryStatus != AsyncQueryService.QueryStatus.RUNNING) {
            return new EnvelopeResponse("999", (Object)"Query is not running", "Query is not running. please check");
        }
        this.queryService.stopQuery(queryId);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new StopQueryBroadcastEventNotifier(queryId));
        return new EnvelopeResponse("000", (Object)"", MsgPicker.getMsg().getAsyncQueryCancel(queryId));
    }

    @ApiOperation(value="query", tags={"QE"}, notes="Update Response: query_id")
    @GetMapping(value={"/async_query/{query_id:.+}/status"})
    @ResponseBody
    public EnvelopeResponse<AsyncQueryResponse> inqueryStatus(@Valid @RequestBody(required=false) AsyncQuerySQLRequest sqlRequest, @PathVariable(value="query_id") String queryId, @RequestParam(value="project", required=false) String project) throws IOException {
        AsyncQueryResponse asyncQueryResponse;
        if (project == null) {
            if (sqlRequest == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_PROJECT_NAME_EMPTY, new Object[0]);
            }
            project = sqlRequest.getProject();
        }
        this.aclEvaluate.checkProjectQueryPermission(project);
        this.checkProjectName(project);
        if (!this.asyncQueryService.hasPermission(queryId, project)) {
            return new EnvelopeResponse("401", null, "Access denied. Only task submitters or admin users can get the query status");
        }
        AsyncQueryService.QueryStatus queryStatus = this.asyncQueryService.queryStatus(project, queryId);
        switch (queryStatus) {
            case SUCCESS: {
                AsyncQueryUtil.SuccessFileContent content = AsyncQueryUtil.getSuccessFileContent((String)project, (String)queryId);
                ErrorCodeServer code = content == null ? null : ErrorCodeServer.of((String)content.getCode());
                String info = code == null ? "await fetching results" : code.getErrorMsg().getLocalizedString();
                asyncQueryResponse = new AsyncQueryResponse(queryId, AsyncQueryResponse.Status.SUCCESSFUL, info);
                break;
            }
            case RUNNING: {
                asyncQueryResponse = new AsyncQueryResponse(queryId, AsyncQueryResponse.Status.RUNNING, "still running");
                break;
            }
            case FAILED: {
                asyncQueryResponse = new AsyncQueryResponse(queryId, AsyncQueryResponse.Status.FAILED, this.asyncQueryService.retrieveSavedQueryException(project, queryId));
                break;
            }
            default: {
                asyncQueryResponse = new AsyncQueryResponse(queryId, AsyncQueryResponse.Status.MISSING, "query status is lost");
            }
        }
        return new EnvelopeResponse("000", (Object)asyncQueryResponse, "");
    }

    @ApiOperation(value="fileStatus", tags={"QE"}, notes="Update URL: file_status")
    @GetMapping(value={"/async_query/{query_id:.+}/file_status"})
    @ResponseBody
    public EnvelopeResponse<Long> fileStatus(@PathVariable(value="query_id") String queryId, @Valid @RequestBody(required=false) AsyncQuerySQLRequest sqlRequest, @RequestParam(value="project", required=false) String project) throws IOException {
        if (project == null) {
            if (sqlRequest == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_PROJECT_NAME_EMPTY, new Object[0]);
            }
            project = sqlRequest.getProject();
        }
        this.aclEvaluate.checkProjectQueryPermission(project);
        this.checkProjectName(project);
        if (!this.asyncQueryService.hasPermission(queryId, project)) {
            return new EnvelopeResponse("401", (Object)0L, "Access denied. Only task submitters or admin users can get the file status");
        }
        long length = this.asyncQueryService.fileStatus(project, queryId);
        return new EnvelopeResponse("000", (Object)length, "");
    }

    @ApiOperation(value="async query status", tags={"QE"})
    @GetMapping(value={"/async_query/{query_id:.+}/metadata"})
    @ResponseBody
    public EnvelopeResponse<List<List<String>>> metadata(@Valid @RequestBody(required=false) AsyncQuerySQLRequest sqlRequest, @PathVariable(value="query_id") String queryId, @RequestParam(value="project", required=false) String project) throws IOException {
        if (project == null) {
            if (sqlRequest == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_PROJECT_NAME_EMPTY, new Object[0]);
            }
            project = sqlRequest.getProject();
        }
        this.aclEvaluate.checkProjectQueryPermission(project);
        this.checkProjectName(project);
        if (!this.asyncQueryService.hasPermission(queryId, project)) {
            return new EnvelopeResponse("401", null, "Access denied. Only task submitters or admin users can get the metadata");
        }
        return new EnvelopeResponse("000", (Object)this.asyncQueryService.getMetaData(project, queryId), "");
    }

    @ApiOperation(value="downloadQueryResult", tags={"QE"}, notes="Update URL: result")
    @GetMapping(value={"/async_query/{query_id:.+}/result_download"})
    @ResponseBody
    public void downloadQueryResult(@PathVariable(value="query_id") String queryId, @RequestParam(value="oldIncludeHeader", required=false) Boolean oldIncludeHeader, @RequestParam(value="includeHeader", required=false) Boolean includeHeader, @Valid @RequestBody(required=false) AsyncQuerySQLRequest sqlRequest, HttpServletResponse response, @RequestParam(value="project", required=false) String project) throws IOException {
        if (project == null) {
            if (sqlRequest == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_PROJECT_NAME_EMPTY, new Object[0]);
            }
            project = sqlRequest.getProject();
        }
        if (oldIncludeHeader != null || includeHeader != null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_INCLUDE_HEADER_NOT_EMPTY, new Object[0]);
        }
        this.aclEvaluate.checkProjectQueryPermission(project);
        this.checkProjectName(project);
        KylinConfig config = this.queryService.getConfig();
        Message msg = MsgPicker.getMsg();
        if (!this.asyncQueryService.hasPermission(queryId, project)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, msg.getForbiddenExportAsyncQueryResult());
        }
        this.asyncQueryService.checkStatus(queryId, AsyncQueryService.QueryStatus.SUCCESS, project, MsgPicker.getMsg().getQueryResultNotFound());
        if (NAsyncQueryController.isAdmin() && !config.isAdminUserExportAllowed() || !NAsyncQueryController.isAdmin() && !config.isNoneAdminUserExportAllowed()) {
            throw new ForbiddenException(msg.getExportResultNotAllowed());
        }
        AsyncQueryService.FileInfo fileInfo = this.asyncQueryService.getFileInfo(project, queryId);
        String format = fileInfo.getFormat();
        String encode = fileInfo.getEncode();
        String fileName = fileInfo.getFileName();
        if (format.equals("xlsx")) {
            response.setContentType("application/octet-stream;charset=" + encode);
        } else {
            response.setContentType("application/" + format + ";charset=" + encode);
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "." + format + "\"");
        this.asyncQueryService.retrieveSavedQueryResult(project, queryId, response, format, encode);
    }

    @ApiOperation(value="async query result path", tags={"QE"})
    @GetMapping(value={"/async_query/{query_id:.+}/result_path"})
    @ResponseBody
    public EnvelopeResponse<String> queryPath(@PathVariable(value="query_id") String queryId, @Valid @RequestBody(required=false) AsyncQuerySQLRequest sqlRequest, HttpServletResponse response, @RequestParam(value="project", required=false) String project) throws IOException {
        if (project == null) {
            if (sqlRequest == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_PROJECT_NAME_EMPTY, new Object[0]);
            }
            project = sqlRequest.getProject();
        }
        this.aclEvaluate.checkProjectQueryPermission(project);
        this.checkProjectName(project);
        if (!this.asyncQueryService.hasPermission(queryId, project)) {
            return new EnvelopeResponse("401", (Object)"", "Access denied. Only task submitters or admin users can get the query path");
        }
        return new EnvelopeResponse("000", (Object)this.asyncQueryService.asyncQueryResultPath(project, queryId), "");
    }
}

