/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.gluten.memory.memtarget.DynamicOffHeapSizingMemoryTarget;
import org.apache.gluten.memory.memtarget.KnownNameAndStats;
import org.apache.gluten.memory.memtarget.LoggingMemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.memory.memtarget.NoopMemoryTarget;
import org.apache.gluten.memory.memtarget.OverAcquire;
import org.apache.gluten.memory.memtarget.RetryOnOomMemoryTarget;
import org.apache.gluten.memory.memtarget.ThrowOnOomMemoryTarget;
import org.apache.gluten.memory.memtarget.spark.RegularMemoryConsumer;
import org.apache.gluten.memory.memtarget.spark.TreeMemoryConsumer;
import org.apache.gluten.proto.MemoryUsageStats;
import org.apache.spark.SparkEnv$;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.SparkMemoryUtil;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

public final class SparkMemoryUtil$ {
    public static SparkMemoryUtil$ MODULE$;
    private final Class<MemoryManager> mmClazz;
    private final Field smpField;
    private final Field empField;
    private final Class<TaskMemoryManager> tmmClazz;
    private final Field consumersField;
    private final Field org$apache$spark$memory$SparkMemoryUtil$$taskIdField;

    static {
        new SparkMemoryUtil$();
    }

    private Class<MemoryManager> mmClazz() {
        return this.mmClazz;
    }

    private Field smpField() {
        return this.smpField;
    }

    private Field empField() {
        return this.empField;
    }

    private Class<TaskMemoryManager> tmmClazz() {
        return this.tmmClazz;
    }

    private Field consumersField() {
        return this.consumersField;
    }

    public Field org$apache$spark$memory$SparkMemoryUtil$$taskIdField() {
        return this.org$apache$spark$memory$SparkMemoryUtil$$taskIdField;
    }

    public String bytesToString(long size) {
        return Utils$.MODULE$.bytesToString(size);
    }

    public long getCurrentAvailableOffHeapMemory() {
        MemoryManager mm = SparkEnv$.MODULE$.get().memoryManager();
        StorageMemoryPool smp = (StorageMemoryPool)this.smpField().get(mm);
        ExecutionMemoryPool emp = (ExecutionMemoryPool)this.empField().get(mm);
        return smp.memoryFree() + emp.memoryFree();
    }

    public String dumpMemoryManagerStats(TaskMemoryManager tmm) {
        KnownNameAndStats knownNameAndStats;
        TaskMemoryManager taskMemoryManager = tmm;
        synchronized (taskMemoryManager) {
            HashSet consumers = (HashSet)this.consumersField().get(tmm);
            HashMap statsMap = new HashMap();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter((Set)consumers).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MemoryUsageStats memoryUsageStats;
                MemoryConsumer memoryConsumer = x0$1;
                if (memoryConsumer instanceof KnownNameAndStats) {
                    MemoryConsumer memoryConsumer2 = memoryConsumer;
                    memoryUsageStats = statsMap.put(((KnownNameAndStats)memoryConsumer2).name(), ((KnownNameAndStats)memoryConsumer2).stats());
                } else {
                    memoryUsageStats = statsMap.put(memoryConsumer.toString(), MemoryUsageStats.newBuilder().setCurrent(memoryConsumer.getUsed()).setPeak(-1L).build());
                }
                return memoryUsageStats;
            });
            Preconditions.checkState((statsMap.size() == consumers.size() ? 1 : 0) != 0);
            knownNameAndStats = new KnownNameAndStats(tmm, statsMap){
                private final TaskMemoryManager tmm$1;
                private final HashMap statsMap$1;

                public String name() {
                    return new java.lang.StringBuilder(5).append("Task.").append(SparkMemoryUtil$.MODULE$.org$apache$spark$memory$SparkMemoryUtil$$taskIdField().get(this.tmm$1)).toString();
                }

                public MemoryUsageStats stats() {
                    return MemoryUsageStats.newBuilder().setCurrent(this.tmm$1.getMemoryConsumptionForThisTask()).setPeak(-1L).putAllChildren(this.statsMap$1).build();
                }
                {
                    this.tmm$1 = tmm$1;
                    this.statsMap$1 = statsMap$1;
                }
            };
        }
        KnownNameAndStats stats = knownNameAndStats;
        return this.prettyPrintStats("Memory consumer stats: ", stats);
    }

    public String dumpMemoryTargetStats(MemoryTarget target) {
        return target.accept(new MemoryTargetVisitor<String>(){

            public String visit(OverAcquire overAcquire) {
                return overAcquire.getTarget().accept(this);
            }

            public String visit(RegularMemoryConsumer regularMemoryConsumer) {
                return this.collectFromTaskMemoryManager(regularMemoryConsumer.getTaskMemoryManager());
            }

            public String visit(ThrowOnOomMemoryTarget throwOnOomMemoryTarget) {
                return throwOnOomMemoryTarget.target().accept(this);
            }

            public String visit(TreeMemoryConsumer treeMemoryConsumer) {
                return this.collectFromTaskMemoryManager(treeMemoryConsumer.getTaskMemoryManager());
            }

            public String visit(TreeMemoryConsumer.Node node) {
                return node.parent().accept(this);
            }

            private String collectFromTaskMemoryManager(TaskMemoryManager tmm) {
                return SparkMemoryUtil$.MODULE$.dumpMemoryManagerStats(tmm);
            }

            public String visit(LoggingMemoryTarget loggingMemoryTarget) {
                return loggingMemoryTarget.delegated().accept(this);
            }

            public String visit(NoopMemoryTarget noopMemoryTarget) {
                return SparkMemoryUtil$.MODULE$.prettyPrintStats("No-op memory manager stats: ", noopMemoryTarget);
            }

            public String visit(DynamicOffHeapSizingMemoryTarget dynamicOffHeapSizingMemoryTarget) {
                return dynamicOffHeapSizingMemoryTarget.delegated().accept(this);
            }

            public String visit(RetryOnOomMemoryTarget retryOnOomMemoryTarget) {
                return retryOnOomMemoryTarget.target().accept(this);
            }
        });
    }

    public String prettyPrintStats(String title, KnownNameAndStats stats) {
        return this.prettyPrintToString(title, SparkMemoryUtil$.asPrintable$1(stats.name(), stats.stats()));
    }

    private String prettyPrintToString(String title, SparkMemoryUtil.PrintableMemoryUsageStats stats) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        IntRef nameWidth = IntRef.create((int)0);
        IntRef usedWidth = IntRef.create((int)0);
        IntRef peakWidth = IntRef.create((int)0);
        SparkMemoryUtil$.addPaddingSingleLevel$1(stats, Predef$.MODULE$.int2Integer(1), nameWidth, usedWidth, peakWidth);
        SparkMemoryUtil$.printSingleLevel$1(stats, "\t", "\t", sb, nameWidth, usedWidth, peakWidth);
        return sb.toString();
    }

    public static final /* synthetic */ long $anonfun$prettyPrintStats$1(SparkMemoryUtil.PrintableMemoryUsageStats x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.used().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MIN_VALUE));
    }

    private static final Seq sortStats$1(Seq stats) {
        return (Seq)stats.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SparkMemoryUtil$.$anonfun$prettyPrintStats$1(x$1)), Ordering.Long$.MODULE$.reverse());
    }

    private static final SparkMemoryUtil.PrintableMemoryUsageStats asPrintable$1(String name, MemoryUsageStats mus) {
        long l = mus.getPeak();
        Object object = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)l));
        return new SparkMemoryUtil.PrintableMemoryUsageStats(name, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)mus.getCurrent())), (Option<Object>)object, (Iterable<SparkMemoryUtil.PrintableMemoryUsageStats>)SparkMemoryUtil$.sortStats$1((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(mus.getChildrenMap().entrySet()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)entry -> SparkMemoryUtil$.asPrintable$1((String)entry.getKey(), (MemoryUsageStats)entry.getValue()), List$.MODULE$.canBuildFrom())));
    }

    private static final String getBytes$1(Option bytes) {
        return (String)bytes.map((Function1 & Serializable & scala.Serializable)size -> Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)size))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A");
    }

    private static final String getFullName$1(String name, String prefix) {
        return new StringOps(Predef$.MODULE$.augmentString("%s%s:")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, name}));
    }

    private static final void addPaddingSingleLevel$1(SparkMemoryUtil.PrintableMemoryUsageStats stats, Integer extraWidth, IntRef nameWidth$1, IntRef usedWidth$1, IntRef peakWidth$1) {
        nameWidth$1.elem = Math.max(nameWidth$1.elem, SparkMemoryUtil$.getFullName$1(stats.name(), "").length() + Predef$.MODULE$.Integer2int(extraWidth));
        usedWidth$1.elem = Math.max(usedWidth$1.elem, SparkMemoryUtil$.getBytes$1(stats.used()).length());
        peakWidth$1.elem = Math.max(peakWidth$1.elem, SparkMemoryUtil$.getBytes$1(stats.peak()).length());
        stats.children().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            SparkMemoryUtil$.addPaddingSingleLevel$1(x$2, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(extraWidth) + 3), nameWidth$1, usedWidth$1, peakWidth$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$prettyPrintToString$4(SparkMemoryUtil.PrintableMemoryUsageStats stats$1, String treeChildrenPrefix$1, StringBuilder sb$1, IntRef nameWidth$1, IntRef usedWidth$1, IntRef peakWidth$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SparkMemoryUtil.PrintableMemoryUsageStats child = (SparkMemoryUtil.PrintableMemoryUsageStats)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (i != stats$1.children().size() - 1) {
                SparkMemoryUtil$.printSingleLevel$1(child, new java.lang.StringBuilder(3).append(treeChildrenPrefix$1).append("+- ").toString(), new java.lang.StringBuilder(3).append(treeChildrenPrefix$1).append("|  ").toString(), sb$1, nameWidth$1, usedWidth$1, peakWidth$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                SparkMemoryUtil$.printSingleLevel$1(child, new java.lang.StringBuilder(3).append(treeChildrenPrefix$1).append("\\- ").toString(), new java.lang.StringBuilder(3).append(treeChildrenPrefix$1).append("   ").toString(), sb$1, nameWidth$1, usedWidth$1, peakWidth$1);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final void printSingleLevel$1(SparkMemoryUtil.PrintableMemoryUsageStats stats, String treePrefix, String treeChildrenPrefix, StringBuilder sb$1, IntRef nameWidth$1, IntRef usedWidth$1, IntRef peakWidth$1) {
        sb$1.append(System.lineSeparator());
        String name = SparkMemoryUtil$.getFullName$1(stats.name(), treePrefix);
        sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%s Current used bytes: %s, peak bytes: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{StringUtils.rightPad((String)name, (int)nameWidth$1.elem, (char)' '), StringUtils.leftPad((String)String.valueOf(SparkMemoryUtil$.getBytes$1(stats.used())), (int)usedWidth$1.elem, (char)' '), StringUtils.leftPad((String)String.valueOf(SparkMemoryUtil$.getBytes$1(stats.peak())), (int)peakWidth$1.elem, (char)' ')})));
        ((IterableLike)stats.children().zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkMemoryUtil$.$anonfun$prettyPrintToString$4(stats, treeChildrenPrefix, sb$1, nameWidth$1, usedWidth$1, peakWidth$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private SparkMemoryUtil$() {
        MODULE$ = this;
        this.mmClazz = MemoryManager.class;
        this.smpField = this.mmClazz().getDeclaredField("offHeapStorageMemoryPool");
        this.empField = this.mmClazz().getDeclaredField("offHeapExecutionMemoryPool");
        this.smpField().setAccessible(true);
        this.empField().setAccessible(true);
        this.tmmClazz = TaskMemoryManager.class;
        this.consumersField = this.tmmClazz().getDeclaredField("consumers");
        this.org$apache$spark$memory$SparkMemoryUtil$$taskIdField = this.tmmClazz().getDeclaredField("taskAttemptId");
        this.consumersField().setAccessible(true);
        this.org$apache$spark$memory$SparkMemoryUtil$$taskIdField().setAccessible(true);
    }
}

