/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.util.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.DFBuilderHelper$;
import org.apache.kylin.engine.spark.builder.DictionaryBuilderHelper;
import org.apache.kylin.engine.spark.job.CuboidAggregator;
import org.apache.kylin.engine.spark.job.DFChooser;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTree;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTreeFactory;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NCubeJoinedFlatTableDesc;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.StorageFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.datasource.storage.StorageStore;
import org.apache.spark.sql.datasource.storage.StorageStoreFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SparderTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockedDFBuildJob
extends SparkApplication {
    protected static final Logger logger = LoggerFactory.getLogger(MockedDFBuildJob.class);
    protected volatile NSpanningTree nSpanningTree;

    public static void main(String[] args) {
        MockedDFBuildJob nDataflowBuildJob = new MockedDFBuildJob();
        nDataflowBuildJob.execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        long start = System.currentTimeMillis();
        logger.info("Start Build");
        String dfName = this.getParam("dataflowId");
        HashSet segmentIds = Sets.newHashSet((Object[])StringUtils.split((String)this.getParam("segmentIds")));
        Set layoutIds = NSparkCubingUtil.str2Longs((String)this.getParam("layoutIds"));
        try {
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
            IndexPlan indexPlan = dfMgr.getDataflow(dfName).getIndexPlan();
            Set<LayoutEntity> cuboids = NSparkCubingUtil.toLayouts((IndexPlan)indexPlan, (Set)layoutIds).stream().filter(Objects::nonNull).collect(Collectors.toSet());
            this.nSpanningTree = NSpanningTreeFactory.fromLayouts(cuboids, (String)dfName);
            StorageStore storageStore = StorageStoreFactory.create((NDataModel.DataStorageType)indexPlan.getModel().getStorageType());
            for (String segId : segmentIds) {
                NDataSegment seg = dfMgr.getDataflow(dfName).getSegment(segId);
                ArrayList dimensions = new ArrayList(indexPlan.getModel().getEffectiveCols().keySet());
                List sparkTypes = dimensions.stream().map(x -> indexPlan.getModel().getColRef(x).getType()).map(tp -> SparderTypeUtil.toSparkType((org.apache.kylin.metadata.datatype.DataType)tp, (boolean)false)).collect(Collectors.toList());
                StructField[] collect = (StructField[])IntStream.range(0, dimensions.size()).mapToObj(x -> new StructField(String.valueOf(dimensions.get(x)), (DataType)sparkTypes.get(x), true, Metadata.empty())).toArray(StructField[]::new);
                StructType structType = new StructType(collect);
                boolean needJoin = DFChooser.needJoinLookupTables(seg.getModel(), this.nSpanningTree);
                NCubeJoinedFlatTableDesc flatTableDesc = new NCubeJoinedFlatTableDesc(indexPlan, seg.getSegRange(), Boolean.valueOf(needJoin));
                NSpanningTree nSpanningTree = NSpanningTreeFactory.fromLayouts((Collection)indexPlan.getAllLayouts(), (String)dfName);
                for (TblColRef ref : DictionaryBuilderHelper.extractTreeRelatedGlobalDicts(seg, nSpanningTree.getAllIndexEntities())) {
                    int columnIndex = flatTableDesc.getColumnIndex(ref);
                    structType = structType.add(structType.apply(columnIndex).name() + DFBuilderHelper$.MODULE$.ENCODE_SUFFIX(), DataTypes.IntegerType);
                }
                Dataset ds = this.ss.createDataFrame((List)Lists.newArrayList(), structType);
                cuboids.forEach(layout -> {
                    CuboidAggregator.agg((Dataset<Row>)ds, (Set<Integer>)layout.getOrderedDimensions().keySet(), (Map<Integer, NDataModel.Measure>)indexPlan.getEffectiveMeasures(), seg, nSpanningTree);
                    NDataLayout dataCuboid = NDataLayout.newDataLayout((NDataflow)seg.getDataflow(), (String)seg.getId(), (long)layout.getId());
                    dataCuboid.setRows(123L);
                    dataCuboid.setSourceByteSize(123L);
                    dataCuboid.setSourceRows(123L);
                    dataCuboid.setBuildJobId(RandomUtil.randomUUIDStr());
                    dataCuboid.setFileCount(123L);
                    dataCuboid.setByteSize(123L);
                    ((NSparkCubingEngine.NSparkCubingStorage)StorageFactory.createEngineAdapter((IStorageAware)layout, NSparkCubingEngine.NSparkCubingStorage.class)).saveTo(storageStore.getStoragePath(seg, layout.getId()), (Dataset<Row>)ds, this.ss);
                    NDataflowUpdate update = new NDataflowUpdate(seg.getDataflow().getUuid());
                    update.setToAddOrUpdateLayouts(new NDataLayout[]{dataCuboid});
                    NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project).updateDataflow(update);
                });
            }
            if (this.config.isPersistFlatTableEnabled()) {
                NDataflow df = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project).getDataflow(dfName);
                NDataflowUpdate update = new NDataflowUpdate(dfName);
                ArrayList segsToUpdate = Lists.newArrayList();
                for (String segId : segmentIds) {
                    NDataSegment seg = df.getSegment(segId).copy();
                    seg.setFlatTableReady(true);
                    segsToUpdate.add(seg);
                }
                update.setToUpdateSegs(segsToUpdate.toArray(new NDataSegment[0]));
                NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project).updateDataflow(update);
            }
        }
        finally {
            logger.info("Finish build take" + (System.currentTimeMillis() - start) + " ms");
        }
    }
}

