/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.VersionConflictException;
import org.apache.kylin.common.persistence.event.Event;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.persistence.transaction.AbstractAuditLogReplayWorker;
import org.apache.kylin.common.persistence.transaction.MessageSynchronization;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionException;

public class AuditLogReplayWorker
extends AbstractAuditLogReplayWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditLogReplayWorker.class);
    private volatile long logOffset = 0L;
    private final Queue<AuditIdTimeItem> delayIdQueue = new ConcurrentLinkedQueue<AuditIdTimeItem>();
    private final long idEarliestTimeoutMills;
    private final long idTimeoutMills;
    private final int replayDelayBatch;

    public AuditLogReplayWorker(KylinConfig config, AuditLogStore restorer) {
        super(config, restorer);
        this.idTimeoutMills = config.getEventualReplayDelayItemTimeout();
        this.replayDelayBatch = config.getEventualReplayDelayItemBatch();
        this.idEarliestTimeoutMills = TimeUnit.HOURS.toMillis(3L);
        this.consumeExecutor = restorer instanceof JdbcAuditLogStore ? Executors.newScheduledThreadPool(1, new DaemonThreadFactory("ReplayWorker")) : publicExecutorPool;
    }

    @Override
    public void startSchedule(long currentId, boolean syncImmediately) {
        this.updateOffset(currentId);
        this.delayIdQueue.clear();
        long minId = this.auditLogStore.getMinId();
        if (this.logOffset + 1L < minId) {
            log.warn("restore from currentId:{} + 1< minId:{} is irregular", (Object)currentId, (Object)minId);
        }
        if (syncImmediately) {
            this.catchupInternal(1);
        }
        long interval = this.config.getCatchUpInterval();
        this.consumeExecutor.scheduleWithFixedDelay(() -> this.catchupInternal(1), interval, interval, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void updateOffset(long expected) {
        if (expected > this.logOffset) {
            this.logOffset = expected;
        }
    }

    @Override
    protected boolean hasCatch(long targetId) {
        return this.logOffset >= targetId;
    }

    @Override
    protected void catchupInternal(int countDown) {
        if (this.isStopped.get()) {
            log.info("Catchup Already stopped");
            return;
        }
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            this.catchupToMaxId(this.logOffset);
        }
        catch (AbstractAuditLogReplayWorker.DatabaseNotAvailableException | TransactionException e) {
            log.warn("cannot create transaction or auditlog database connect error, ignore it", e);
            this.threadWait(5000L);
        }
        catch (Exception e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof VersionConflictException && countDown > 0) {
                this.handleConflictOnce((VersionConflictException)rootCause, countDown);
            }
            if (rootCause instanceof InterruptedException) {
                log.info("may be canceled due to reload meta, skip this replay");
            }
            this.delayIdQueue.clear();
            this.handleReloadAll(e);
        }
    }

    private List<Long> collectReplayDelayedId(int maxCount) {
        if (this.delayIdQueue.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList needReplayedIdList = Lists.newArrayList();
        ArrayList timeoutItemList = Lists.newArrayList();
        Iterator retryQueueIterator = this.delayIdQueue.iterator();
        long currentTime = System.currentTimeMillis();
        while (retryQueueIterator.hasNext()) {
            AuditIdTimeItem idTimeItem = (AuditIdTimeItem)retryQueueIterator.next();
            needReplayedIdList.add(idTimeItem.getAuditLogId());
            if (idTimeItem.isTimeout(currentTime, this.idTimeoutMills)) {
                timeoutItemList.add(idTimeItem);
                retryQueueIterator.remove();
            }
            if (needReplayedIdList.size() < maxCount) continue;
            break;
        }
        if (CollectionUtils.isNotEmpty((Collection)timeoutItemList)) {
            log.warn("delay timeout id->{}", (Object)AuditLogReplayWorker.collectionToJoinString(timeoutItemList));
        }
        if (CollectionUtils.isEmpty((Collection)needReplayedIdList)) {
            try (SetLogCategory ignored = new SetLogCategory("metadata");){
                log.debug("needReplayedIdList is empty");
            }
            return Lists.newArrayList();
        }
        return needReplayedIdList;
    }

    private void fetchAndReplayDelayId(MessageSynchronization replayer, List<Long> needReplayedIdList) {
        if (CollectionUtils.isEmpty(needReplayedIdList)) {
            return;
        }
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            List<AuditLog> fetchAuditLog = this.auditLogStore.fetch(needReplayedIdList);
            if (CollectionUtils.isEmpty(fetchAuditLog)) {
                return;
            }
            log.debug("try replay delay id:{}", (Object)AuditLogReplayWorker.collectionToJoinString(needReplayedIdList));
            this.replayLogs(replayer, fetchAuditLog);
            Set replaySuccessIdSet = fetchAuditLog.stream().map(AuditLog::getId).collect(Collectors.toSet());
            this.delayIdQueue.removeIf(winId -> replaySuccessIdSet.contains(((AuditIdTimeItem)winId).auditLogId));
            log.warn("finished replay delay id:{},queue:{}", (Object)AuditLogReplayWorker.collectionToJoinString(replaySuccessIdSet), (Object)this.delayIdQueue.size());
        }
        catch (Exception e) {
            log.error("tryReplayDelayedId error", (Throwable)e);
            this.delayIdQueue.clear();
        }
    }

    public void catchupToMaxId(long currentId) {
        MessageSynchronization replayer = MessageSynchronization.getInstance(this.config);
        ResourceStore store = ResourceStore.getKylinMetaStore(this.config);
        replayer.setChecker(store.getChecker());
        List<Long> needReplayedIdList = this.collectReplayDelayedId(this.replayDelayBatch);
        AbstractAuditLogReplayWorker.FixedWindow currentWindow = new AbstractAuditLogReplayWorker.FixedWindow(currentId, this.auditLogStore.getMaxId());
        if (currentWindow.isEmpty() && CollectionUtils.isEmpty(needReplayedIdList)) {
            return;
        }
        boolean allCommitOk = this.waitMaxIdOk(currentWindow.getStart(), currentWindow.getEnd());
        long newOffset = this.auditLogStore instanceof JdbcAuditLogStore ? JdbcUtil.withTransaction(((JdbcAuditLogStore)this.auditLogStore).getTransactionManager(), () -> this.doFetchAndReplay(replayer, needReplayedIdList, currentWindow, allCommitOk)).longValue() : this.doFetchAndReplay(replayer, needReplayedIdList, currentWindow, allCommitOk);
        this.updateOffset(newOffset);
    }

    private long doFetchAndReplay(MessageSynchronization replayer, List<Long> needReplayedIdList, AbstractAuditLogReplayWorker.FixedWindow currentWindow, boolean allCommitOk) {
        this.fetchAndReplayDelayId(replayer, needReplayedIdList);
        if (currentWindow.isEmpty()) {
            return -1L;
        }
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            log.debug("start restore from {}", (Object)currentWindow);
        }
        AbstractAuditLogReplayWorker.SlideWindow stepWin = new AbstractAuditLogReplayWorker.SlideWindow(currentWindow);
        while (stepWin.forwardRightStep(1000L)) {
            List<AuditLog> logs = this.auditLogStore.fetch(stepWin.getStart(), stepWin.length());
            this.replayLogs(replayer, logs);
            if (!allCommitOk) {
                this.recordStepAbsentIdList(stepWin, logs);
            }
            stepWin.syncRightStep();
        }
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            log.debug("end restore from {}, delay queue:{}", (Object)currentWindow, (Object)this.delayIdQueue.size());
        }
        return currentWindow.getEnd();
    }

    private boolean waitMaxIdOk(long currentId, long maxId) {
        try {
            if (maxId == currentId) {
                return true;
            }
            return this.waitLogCommit(this.replayWaitMaxRetryTimes, currentId, maxId);
        }
        catch (Exception e) {
            throw new AbstractAuditLogReplayWorker.DatabaseNotAvailableException(e);
        }
    }

    private boolean waitLogCommit(int maxTimes, long currentId, long maxId) {
        if (!this.config.isNeedReplayConsecutiveLog()) {
            return true;
        }
        int count = 0;
        while (!this.logAllCommit(currentId, maxId)) {
            this.threadWait(this.replayWaitMaxTimeoutMills);
            if (++count < maxTimes) continue;
            return false;
        }
        return true;
    }

    private void handleConflictOnce(VersionConflictException e, int countDown) {
        MessageSynchronization replayer = MessageSynchronization.getInstance(this.config);
        RawResource originResource = e.getResource();
        RawResource targetResource = e.getTargetResource();
        String metaKey = originResource.getMetaKey();
        log.warn("Resource <{}:{}> version conflict, msg:{}", new Object[]{metaKey, originResource.getMvcc(), e.getMessage()});
        log.info("Try to reload {}", (Object)originResource.getMetaKey());
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore(this.config);
        MetadataStore metaStore = resourceStore.getMetadataStore();
        RawResourceFilter filter = RawResourceFilter.equalFilter("metaKey", metaKey);
        List rawResources = metaStore.get(originResource.getMetaType(), filter, true, true);
        if (!CollectionUtils.isEmpty(rawResources)) {
            RawResource correctedResource = (RawResource)rawResources.get(0);
            log.info("Origin version is {},  current version in store is {}", (Object)originResource.getMvcc(), (Object)correctedResource.getMvcc());
            String resPath = correctedResource.generateKeyWithType();
            AuditLog fixResource = new AuditLog(0L, resPath, correctedResource.getByteSource(), correctedResource.getTs(), originResource.getMvcc() + 1L, null, null, null, null, correctedResource.getProject(), false);
            replayer.replay(new UnitMessages(Lists.newArrayList((Object[])new Event[]{Event.fromLog(fixResource)})));
            AuditLog currentAuditLog = resourceStore.getAuditLogStore().get(resPath, targetResource.getMvcc());
            if (currentAuditLog != null) {
                log.info("After fix conflict, set offset to {}", (Object)currentAuditLog.getId());
                this.updateOffset(currentAuditLog.getId());
            }
        } else {
            log.error("Reload metadata <{}> failed, current resource is not exist", (Object)metaKey);
        }
        this.catchupInternal(countDown - 1);
    }

    private void recordStepAbsentIdList(AbstractAuditLogReplayWorker.FixedWindow stepWin, List<AuditLog> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        if ((long)logs.size() == stepWin.length()) {
            return;
        }
        ArrayList replayedIdList = Lists.newArrayList();
        try {
            long curTime = System.currentTimeMillis();
            Long latestTime = logs.stream().map(AuditLog::getTimestamp).max(Long::compareTo).orElse(curTime);
            if (curTime - latestTime > this.idEarliestTimeoutMills) {
                log.warn("skip too earliest id,{}->{}", (Object)curTime, (Object)latestTime);
                return;
            }
            replayedIdList.addAll(logs.stream().map(AuditLog::getId).collect(Collectors.toList()));
            List<Long> absentIdList = this.findAbsentId(replayedIdList, stepWin);
            log.warn("find absent id list:{},in {}", (Object)AuditLogReplayWorker.collectionToJoinString(absentIdList), (Object)stepWin);
            absentIdList.forEach(id -> this.delayIdQueue.add(new AuditIdTimeItem((long)id, curTime)));
        }
        catch (Exception e) {
            log.error("recordStepAbsentIdList:{},{} error", new Object[]{stepWin, AuditLogReplayWorker.collectionToJoinString(replayedIdList), e});
        }
    }

    @NonNull
    private List<Long> findAbsentId(List<Long> replayedIdList, AbstractAuditLogReplayWorker.FixedWindow fixedWindow) {
        if (CollectionUtils.isEmpty(replayedIdList)) {
            return Lists.newArrayList();
        }
        HashSet<Long> replayedIdSet = new HashSet<Long>(replayedIdList);
        return LongStream.rangeClosed(fixedWindow.start + 1L, fixedWindow.end).boxed().filter(id -> !replayedIdSet.contains(id)).collect(Collectors.toList());
    }

    private static String collectionToJoinString(Collection<?> objects) {
        if (CollectionUtils.isEmpty(objects)) {
            return "";
        }
        return Joiner.on((String)",").join(objects);
    }

    @Override
    @Generated
    public long getLogOffset() {
        return this.logOffset;
    }

    static class AuditIdTimeItem {
        private final long auditLogId;
        private final long logTimestamp;

        public AuditIdTimeItem(long auditLogId, long logTimestamp) {
            this.auditLogId = auditLogId;
            this.logTimestamp = logTimestamp;
        }

        public boolean isTimeout(long currentTime, long timeout) {
            return currentTime - this.logTimestamp > timeout;
        }

        public String toString() {
            return "[" + this.auditLogId + "," + this.logTimestamp + "]";
        }

        @Generated
        public long getAuditLogId() {
            return this.auditLogId;
        }

        @Generated
        public long getLogTimestamp() {
            return this.logTimestamp;
        }
    }
}

