/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class JdbcDataSource {
    private static Map<Properties, DataSource> instances = Maps.newConcurrentMap();
    private static Map<DataSource, DataSourceTransactionManager> tmManagerMap = Maps.newConcurrentMap();

    private JdbcDataSource() {
    }

    public static DataSource getDataSource(Properties props) throws Exception {
        if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
            return BasicDataSourceFactory.createDataSource((Properties)props);
        }
        if (instances.containsKey(props)) {
            return instances.get(props);
        }
        instances.putIfAbsent(props, (DataSource)BasicDataSourceFactory.createDataSource((Properties)props));
        return instances.get(props);
    }

    public static DataSourceTransactionManager getTransactionManager(DataSource dataSource) {
        if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
            return new DataSourceTransactionManager(dataSource);
        }
        if (tmManagerMap.containsKey(dataSource)) {
            return tmManagerMap.get(dataSource);
        }
        tmManagerMap.putIfAbsent(dataSource, new DataSourceTransactionManager(dataSource));
        return tmManagerMap.get(dataSource);
    }

    public static DataSourceTransactionManager getTransactionManager(Properties props) throws Exception {
        DataSource dataSource = JdbcDataSource.getDataSource(props);
        return JdbcDataSource.getTransactionManager(dataSource);
    }

    public static Collection<DataSource> getDataSources() {
        return instances.values();
    }
}

