/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.lock;

import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;

public abstract class DistributedLockFactory {
    public abstract Lock getLockForClient(String var1, String var2);

    public abstract void initialize();

    public Lock getLockForCurrentThread(String key) {
        return this.getLockForClient(DistributedLockFactory.threadProcessAndHost(), key);
    }

    public Lock lockForCurrentProcess(String key) {
        return this.getLockForClient(DistributedLockFactory.processAndHost(), key);
    }

    private static String threadProcessAndHost() {
        return Thread.currentThread().getId() + "-" + DistributedLockFactory.processAndHost();
    }

    private static String processAndHost() {
        byte[] bytes = ManagementFactory.getRuntimeMXBean().getName().getBytes(Charset.defaultCharset());
        return new String(bytes, Charset.defaultCharset());
    }
}

