/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.exception;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.kylin.common.exception.ErrorCodeException;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.common.util.ResourceUtils;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCode
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorCode.class);
    private static final String CN_LANG = "cn";
    private static final String EN_ERROR_CODE_FILE = "kylin_errorcode_conf_en.properties";
    private static final String ZH_ERROR_CODE_FILE = "kylin_errorcode_conf_zh.properties";
    private static final String ZH_SEPARATOR = "\uff1a";
    private static final String EN_SEPARATOR = ":";
    private static final ImmutableMap<String, String> EN_MAP;
    private static final ImmutableMap<String, String> ZH_MAP;
    private static final ThreadLocal<ImmutableMap<String, String>> FRONT_MAP;
    private final String keCode;

    public ErrorCode(String keCode) {
        this.keCode = keCode;
    }

    public static void setMsg(String lang) {
        FRONT_MAP.set(EN_MAP);
    }

    private static ImmutableMap<String, String> getMap() {
        ImmutableMap<String, String> res = FRONT_MAP.get();
        return res == null ? EN_MAP : res;
    }

    public String getLocalizedString() {
        ImmutableMap<String, String> res = ErrorCode.getMap();
        String description = (String)res.getOrDefault((Object)this.keCode, (Object)"unknown");
        String separator = ZH_MAP.equals(res) ? ZH_SEPARATOR : EN_SEPARATOR;
        return String.format(Locale.ROOT, "%s(%s)%s", this.keCode, description, separator);
    }

    public static String getLocalizedString(String keCode) {
        ImmutableMap<String, String> res = ErrorCode.getMap();
        String description = (String)res.getOrDefault((Object)keCode, (Object)"unknown");
        String separator = ZH_MAP.equals(res) ? ZH_SEPARATOR : EN_SEPARATOR;
        return String.format(Locale.ROOT, "%s(%s)%s", keCode, description, separator);
    }

    public String getString() {
        String description = (String)EN_MAP.getOrDefault((Object)this.keCode, (Object)"unknown");
        return String.format(Locale.ROOT, "%s(%s)", this.keCode, description);
    }

    public String getCodeString() {
        return this.keCode;
    }

    static {
        FRONT_MAP = new ThreadLocal();
        try {
            URL resource = ResourceUtils.getServerConfUrl(EN_ERROR_CODE_FILE);
            log.info("loading enMap {}", (Object)resource.getPath());
            EN_MAP = ImmutableMap.copyOf(new ConcurrentHashMap<String, String>(FileUtils.readFromPropertiesFile(resource.openStream())));
            log.info("loading enMap successful");
            resource = ResourceUtils.getServerConfUrl(ZH_ERROR_CODE_FILE);
            log.info("loading zhMap {}", (Object)resource.getPath());
            ZH_MAP = ImmutableMap.copyOf(new ConcurrentHashMap<String, String>(FileUtils.readFromPropertiesFile(resource.openStream())));
            log.info("loading zhMap successful");
            FRONT_MAP.set(EN_MAP);
        }
        catch (IOException e) {
            throw new ErrorCodeException("loading old error code failed.", e);
        }
    }
}

