/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata.jdbc;

import java.util.Arrays;
import java.util.NavigableSet;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStoreTool;
import org.apache.kylin.common.persistence.metadata.JdbcPartialAuditLogStore;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.JdbcInfo;
import org.apache.kylin.junit.annotation.JdbcMetadataInfo;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MetadataInfo(onlyProps=true)
@JdbcMetadataInfo
@OverwriteProp(key="kylin.metadata.url", value="test@jdbc,driverClassName=org.h2.Driver,url=jdbc:h2:mem:db_default;DB_CLOSE_DELAY=-1;MODE=MYSQL,username=sa,password=")
class JdbcPartialAuditLogStoreTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcPartialAuditLogStoreTest.class);

    JdbcPartialAuditLogStoreTest() {
    }

    @Test
    void testPartialAuditLogRestore() throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        JdbcPartialAuditLogStore auditLogStore = new JdbcPartialAuditLogStore(TestUtils.getTestConfig(), null);
        workerStore.getMetadataStore().setAuditLogStore((AuditLogStore)auditLogStore);
        auditLogStore.restore(101L);
        Assertions.assertEquals((long)101L, (long)auditLogStore.getLogOffset());
        auditLogStore.close();
    }

    @Test
    void testPartialFetchAuditLog() throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        JdbcPartialAuditLogStore auditLogStore = new JdbcPartialAuditLogStore(TestUtils.getTestConfig(), "uuid1");
        workerStore.getMetadataStore().setAuditLogStore((AuditLogStore)auditLogStore);
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        auditLogStore.batchInsert(Arrays.asList(JdbcAuditLogStoreTool.createProjectAuditLog("abc", "uuid1", 0L), JdbcAuditLogStoreTool.createProjectAuditLog("abc", null, 0L), JdbcAuditLogStoreTool.createProjectAuditLog("abc2", "uuid1", 0L), JdbcAuditLogStoreTool.createProjectAuditLog("abc2", "uuid2", 0L)));
        auditLogStore.catchupWithMaxTimeout();
        NavigableSet totalR = workerStore.listResourcesRecursively("PROJECT");
        Assertions.assertEquals((int)2, (int)totalR.size());
        auditLogStore.close();
    }

    @Test
    void testPartialFetchAuditLogEmptyFilter(JdbcInfo jdbcInfo) throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        JdbcPartialAuditLogStore auditLogStore = new JdbcPartialAuditLogStore(TestUtils.getTestConfig(), null);
        workerStore.getMetadataStore().setAuditLogStore((AuditLogStore)auditLogStore);
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        auditLogStore.batchInsert(Arrays.asList(JdbcAuditLogStoreTool.createProjectAuditLog("abc", 0L), JdbcAuditLogStoreTool.createProjectAuditLog("abc2", 0L), JdbcAuditLogStoreTool.createProjectAuditLog("abc3", 0L), JdbcAuditLogStoreTool.createProjectAuditLog("abc4", 0L), JdbcAuditLogStoreTool.createProjectAuditLog("t1", 0L)));
        auditLogStore.catchupWithMaxTimeout();
        NavigableSet totalR = workerStore.listResourcesRecursively("PROJECT");
        Assertions.assertEquals((int)5, (int)totalR.size());
        auditLogStore.close();
    }
}

