/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStoreTool;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.JdbcInfo;
import org.apache.kylin.junit.annotation.JdbcMetadataInfo;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;

@MetadataInfo(onlyProps=true)
@JdbcMetadataInfo
public class JdbcAuditLogReplayerTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcAuditLogReplayerTest.class);

    @Test
    public void testDatabaseNotAvailable(JdbcInfo info) throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc", info, false);
        auditLogStore.restore(0L);
        Assert.assertEquals((long)2L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        String auditLogTableName = info.getTableName() + "_audit_log_v2";
        jdbcTemplate.batchUpdate(new String[]{"ALTER TABLE " + auditLogTableName + " RENAME TO TEST_AUDIT_LOG_TEST", "ALTER TABLE " + info.getTableName() + "_project RENAME TO TEST_TEST"});
        try {
            auditLogStore.catchupWithTimeout();
        }
        catch (BadSqlGrammarException e) {
            log.info("expected exception {}", (Object)e.getMessage());
        }
        jdbcTemplate.update("ALTER TABLE TEST_AUDIT_LOG_TEST RENAME TO " + auditLogTableName);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abcd", info, false);
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> 3 == workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        auditLogStore.close();
    }
}

