/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.insert.InsertModel;
import org.mybatis.dynamic.sql.insert.render.DefaultInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueCollector;
import org.mybatis.dynamic.sql.insert.render.InsertRenderingUtilities;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.ValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.Messages;

public class InsertRenderer<T> {
    private final InsertModel<T> model;
    private final RenderingStrategy renderingStrategy;

    private InsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
    }

    public InsertStatementProvider<T> render() {
        ValuePhraseVisitor visitor = new ValuePhraseVisitor(this.renderingStrategy);
        FieldAndValueCollector collector = this.model.mapColumnMappings(m -> m.accept(visitor)).filter(Optional::isPresent).map(Optional::get).collect(FieldAndValueCollector.collect());
        if (collector.isEmpty()) {
            throw new InvalidSqlException(Messages.getString("ERROR.10"));
        }
        String insertStatement = InsertRenderingUtilities.calculateInsertStatement(this.model.table(), collector);
        return DefaultInsertStatementProvider.withRow(this.model.row()).withInsertStatement(insertStatement).build();
    }

    public static <T> Builder<T> withInsertModel(InsertModel<T> model) {
        return new Builder<T>().withInsertModel(model);
    }

    public static class Builder<T> {
        private InsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withInsertModel(InsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public InsertRenderer<T> build() {
            return new InsertRenderer(this);
        }
    }
}

