/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.constraints.AssertTrue;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.insensitive.ProjectInsensitiveRequest;
import org.apache.kylin.rest.request.Validation;
import org.springframework.validation.FieldError;

public class ProjectRequest
implements Validation,
ProjectInsensitiveRequest {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="override_kylin_properties")
    private LinkedHashMap<String, String> overrideKylinProps;

    @AssertTrue
    @JsonIgnore
    public boolean isNameValid() {
        Pattern pattern = Pattern.compile("^(?![_])\\w+$");
        try {
            return pattern.matcher(this.name).matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getErrorMessage(List<FieldError> errors) {
        Message message = MsgPicker.getMsg();
        if (!CollectionUtils.isEmpty(errors) && errors.get(0).getField().equalsIgnoreCase("nameValid")) {
            return message.getInvalidProjectName();
        }
        return "";
    }

    public List<String> inSensitiveFields() {
        return Arrays.asList("name");
    }

    @Generated
    public ProjectRequest() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LinkedHashMap<String, String> getOverrideKylinProps() {
        return this.overrideKylinProps;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOverrideKylinProps(LinkedHashMap<String, String> overrideKylinProps) {
        this.overrideKylinProps = overrideKylinProps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectRequest)) {
            return false;
        }
        ProjectRequest other = (ProjectRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LinkedHashMap<String, String> this$overrideKylinProps = this.getOverrideKylinProps();
        LinkedHashMap<String, String> other$overrideKylinProps = other.getOverrideKylinProps();
        return !(this$overrideKylinProps == null ? other$overrideKylinProps != null : !((Object)this$overrideKylinProps).equals(other$overrideKylinProps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LinkedHashMap<String, String> $overrideKylinProps = this.getOverrideKylinProps();
        result = result * 59 + ($overrideKylinProps == null ? 43 : ((Object)$overrideKylinProps).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProjectRequest(name=" + this.getName() + ", description=" + this.getDescription() + ", overrideKylinProps=" + this.getOverrideKylinProps() + ")";
    }
}

