/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.HostInfoFetcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;

@Configuration
public class InitConfiguration {
    @Autowired
    private HostInfoFetcher hostInfoFetcher;

    @PostConstruct
    public void init() {
        if (KylinConfig.getInstanceFromEnv().isCheckHostname() && this.hostInfoFetcher.getHostname().indexOf("_") != -1) {
            throw new KylinRuntimeException("The hostname does not support containing '_' characters, please modify the hostname of Kylin 5.0 nodes.");
        }
    }

    @Bean
    @SpringSessionDataSource
    @Primary
    public DataSource dataSource() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StorageURL url = config.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        if (!url.getScheme().equals("jdbc") && !config.isUTEnv()) {
            throw new RuntimeException("Failed to init jdbc data source!");
        }
        return JdbcDataSource.getDataSource((Properties)props);
    }
}

