/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.health;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.rest.config.initialize.AfterMetadataReadyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnEnabledHealthIndicator(value="fileSystem")
public class FileSystemHealthIndicator
implements HealthIndicator,
ApplicationListener<AfterMetadataReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemHealthIndicator.class);
    private static final ScheduledExecutorService FILE_SYSTEM_HEALTH_EXECUTOR = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("FileSystemHealthChecker"));
    private volatile boolean isHealth = false;

    public void onApplicationEvent(AfterMetadataReadyEvent event) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        FILE_SYSTEM_HEALTH_EXECUTOR.scheduleWithFixedDelay(() -> this.healthCheck(), 0L, config.getMetadataCheckDuration(), TimeUnit.MILLISECONDS);
    }

    public void healthCheck() {
        try {
            this.checkFileSystem();
            this.isHealth = true;
            return;
        }
        catch (IOException e) {
            logger.error("File System is closed, try to clean cache.", (Throwable)e);
            try {
                FileSystem.closeAll();
                this.checkFileSystem();
                this.isHealth = true;
                return;
            }
            catch (IOException e2) {
                logger.error("File System is closed AND DID NOT RECOVER", (Throwable)e2);
                this.isHealth = false;
                return;
            }
        }
    }

    @VisibleForTesting
    public void checkFileSystem() throws IOException {
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        fileSystem.exists(new Path("/"));
    }

    public Health health() {
        return this.isHealth ? Health.up().build() : Health.down().build();
    }
}

