/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import java.math.BigDecimal;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.schema.NumericElementFacetBuilder;
import springfox.documentation.service.AllowableRangeValues;

public class RangeAnnotations {
    private static final Logger LOG = LoggerFactory.getLogger(RangeAnnotations.class);

    private RangeAnnotations() {
        throw new UnsupportedOperationException();
    }

    public static AllowableRangeValues stringLengthRange(Size size) {
        LOG.debug("@Size detected: adding MinLength/MaxLength to field");
        return new AllowableRangeValues(RangeAnnotations.minValue(size), RangeAnnotations.maxValue(size));
    }

    private static String minValue(Size size) {
        return String.valueOf(Math.max(size.min(), 0));
    }

    private static String maxValue(Size size) {
        return String.valueOf(Math.max(0, Math.min(size.max(), Integer.MAX_VALUE)));
    }

    public static Compatibility<AllowableRangeValues, NumericElementFacet> allowableRange(Optional<Min> min, Optional<Max> max) {
        AllowableRangeValues myvalues = null;
        NumericElementFacet range = null;
        if (min.isPresent() && max.isPresent()) {
            LOG.debug("@Min+@Max detected: adding AllowableRangeValues to field ");
            myvalues = new AllowableRangeValues(Double.toString(min.get().value()), Boolean.valueOf(false), Double.toString(max.get().value()), Boolean.valueOf(false));
            range = new NumericElementFacetBuilder().multipleOf(NumericElementFacet.DEFAULT_MULTIPLE).minimum(BigDecimal.valueOf(min.get().value())).exclusiveMinimum(Boolean.valueOf(false)).maximum(BigDecimal.valueOf(max.get().value())).exclusiveMaximum(Boolean.valueOf(false)).build();
        } else if (min.isPresent()) {
            LOG.debug("@Min detected: adding AllowableRangeValues to field ");
            myvalues = new AllowableRangeValues(Double.toString(min.get().value()), Boolean.valueOf(false), null, null);
            range = new NumericElementFacetBuilder().multipleOf(NumericElementFacet.DEFAULT_MULTIPLE).minimum(BigDecimal.valueOf(min.get().value())).exclusiveMinimum(Boolean.valueOf(false)).maximum(null).exclusiveMaximum(null).build();
        } else if (max.isPresent()) {
            LOG.debug("@Max detected: adding AllowableRangeValues to field ");
            myvalues = new AllowableRangeValues(null, null, Double.toString(max.get().value()), Boolean.valueOf(false));
            range = new NumericElementFacetBuilder().multipleOf(NumericElementFacet.DEFAULT_MULTIPLE).minimum(null).exclusiveMinimum(null).maximum(BigDecimal.valueOf(max.get().value())).exclusiveMaximum(Boolean.valueOf(false)).build();
        }
        return new Compatibility(myvalues, range);
    }
}

