/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.rest.response.BasicResponse;
import org.apache.kylin.rest.response.ComputedColumnConflictResponse;

public class BuildBaseIndexResponse
extends BasicResponse {
    public static final BuildBaseIndexResponse EMPTY = new BuildBaseIndexResponse();
    @JsonProperty(value="base_table_index")
    private IndexInfo tableIndex;
    @JsonProperty(value="base_agg_index")
    private IndexInfo aggIndex;
    @JsonProperty(value="computed_column_conflict")
    private ComputedColumnConflictResponse ccConflict;

    public static BuildBaseIndexResponse from(IndexPlan indexPlan) {
        BuildBaseIndexResponse response = new BuildBaseIndexResponse();
        response.addLayout(indexPlan.getBaseAggLayout());
        response.addLayout(indexPlan.getBaseTableLayout());
        return response;
    }

    public void addLayout(LayoutEntity baseLayout) {
        if (baseLayout == null) {
            return;
        }
        IndexInfo info = new IndexInfo();
        info.setDimCount((int)baseLayout.getColOrder().stream().filter(id -> id < 100000).count());
        info.setMeasureCount((int)baseLayout.getColOrder().stream().filter(id -> id >= 100000).count());
        if (IndexEntity.isTableIndex((long)baseLayout.getId())) {
            this.tableIndex = info;
        } else {
            this.aggIndex = info;
        }
        info.setLayoutId(baseLayout.getId());
    }

    public void judgeIndexOperateType(boolean previousExist, boolean isAgg) {
        IndexInfo index;
        IndexInfo indexInfo = index = isAgg ? this.aggIndex : this.tableIndex;
        if (index != null) {
            if (previousExist) {
                index.setOperateType(OperateType.UPDATE);
            } else {
                index.setOperateType(OperateType.CREATE);
            }
        }
    }

    public void setIndexUpdateType(Set<Long> ids) {
        for (long id : ids) {
            if (IndexEntity.isAggIndex((long)id) && this.aggIndex != null) {
                this.aggIndex.setOperateType(OperateType.UPDATE);
            }
            if (!IndexEntity.isTableIndex((long)id) || this.tableIndex == null) continue;
            this.tableIndex.setOperateType(OperateType.UPDATE);
        }
    }

    public boolean hasIndexChange() {
        return this.tableIndex != null || this.aggIndex != null;
    }

    public boolean hasTableIndexChange() {
        return this.tableIndex != null;
    }

    @Generated
    public IndexInfo getTableIndex() {
        return this.tableIndex;
    }

    @Generated
    public IndexInfo getAggIndex() {
        return this.aggIndex;
    }

    @Generated
    public ComputedColumnConflictResponse getCcConflict() {
        return this.ccConflict;
    }

    @Generated
    public void setTableIndex(IndexInfo tableIndex) {
        this.tableIndex = tableIndex;
    }

    @Generated
    public void setAggIndex(IndexInfo aggIndex) {
        this.aggIndex = aggIndex;
    }

    @Generated
    public void setCcConflict(ComputedColumnConflictResponse ccConflict) {
        this.ccConflict = ccConflict;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildBaseIndexResponse)) {
            return false;
        }
        BuildBaseIndexResponse other = (BuildBaseIndexResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IndexInfo this$tableIndex = this.getTableIndex();
        IndexInfo other$tableIndex = other.getTableIndex();
        if (this$tableIndex == null ? other$tableIndex != null : !((Object)this$tableIndex).equals(other$tableIndex)) {
            return false;
        }
        IndexInfo this$aggIndex = this.getAggIndex();
        IndexInfo other$aggIndex = other.getAggIndex();
        if (this$aggIndex == null ? other$aggIndex != null : !((Object)this$aggIndex).equals(other$aggIndex)) {
            return false;
        }
        ComputedColumnConflictResponse this$ccConflict = this.getCcConflict();
        ComputedColumnConflictResponse other$ccConflict = other.getCcConflict();
        return !(this$ccConflict == null ? other$ccConflict != null : !((Object)this$ccConflict).equals(other$ccConflict));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildBaseIndexResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndexInfo $tableIndex = this.getTableIndex();
        result = result * 59 + ($tableIndex == null ? 43 : ((Object)$tableIndex).hashCode());
        IndexInfo $aggIndex = this.getAggIndex();
        result = result * 59 + ($aggIndex == null ? 43 : ((Object)$aggIndex).hashCode());
        ComputedColumnConflictResponse $ccConflict = this.getCcConflict();
        result = result * 59 + ($ccConflict == null ? 43 : ((Object)$ccConflict).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BuildBaseIndexResponse(tableIndex=" + this.getTableIndex() + ", aggIndex=" + this.getAggIndex() + ", ccConflict=" + this.getCcConflict() + ")";
    }

    @Generated
    public BuildBaseIndexResponse(IndexInfo tableIndex, IndexInfo aggIndex, ComputedColumnConflictResponse ccConflict) {
        this.tableIndex = tableIndex;
        this.aggIndex = aggIndex;
        this.ccConflict = ccConflict;
    }

    @Generated
    public BuildBaseIndexResponse() {
    }

    private static enum OperateType {
        UPDATE,
        CREATE;

    }

    private static class IndexInfo {
        @JsonProperty(value="dimension_count")
        private int dimCount;
        @JsonProperty(value="measure_count")
        private int measureCount;
        @JsonProperty(value="layout_id")
        private long layoutId;
        @JsonProperty(value="operate_type")
        private OperateType operateType = OperateType.CREATE;

        @Generated
        public IndexInfo() {
        }

        @Generated
        public int getDimCount() {
            return this.dimCount;
        }

        @Generated
        public int getMeasureCount() {
            return this.measureCount;
        }

        @Generated
        public long getLayoutId() {
            return this.layoutId;
        }

        @Generated
        public OperateType getOperateType() {
            return this.operateType;
        }

        @Generated
        public void setDimCount(int dimCount) {
            this.dimCount = dimCount;
        }

        @Generated
        public void setMeasureCount(int measureCount) {
            this.measureCount = measureCount;
        }

        @Generated
        public void setLayoutId(long layoutId) {
            this.layoutId = layoutId;
        }

        @Generated
        public void setOperateType(OperateType operateType) {
            this.operateType = operateType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexInfo)) {
                return false;
            }
            IndexInfo other = (IndexInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDimCount() != other.getDimCount()) {
                return false;
            }
            if (this.getMeasureCount() != other.getMeasureCount()) {
                return false;
            }
            if (this.getLayoutId() != other.getLayoutId()) {
                return false;
            }
            OperateType this$operateType = this.getOperateType();
            OperateType other$operateType = other.getOperateType();
            return !(this$operateType == null ? other$operateType != null : !((Object)((Object)this$operateType)).equals((Object)other$operateType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IndexInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDimCount();
            result = result * 59 + this.getMeasureCount();
            long $layoutId = this.getLayoutId();
            result = result * 59 + (int)($layoutId >>> 32 ^ $layoutId);
            OperateType $operateType = this.getOperateType();
            result = result * 59 + ($operateType == null ? 43 : ((Object)((Object)$operateType)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BuildBaseIndexResponse.IndexInfo(dimCount=" + this.getDimCount() + ", measureCount=" + this.getMeasureCount() + ", layoutId=" + this.getLayoutId() + ", operateType=" + (Object)((Object)this.getOperateType()) + ")";
        }
    }
}

