/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.metadata.job.JobBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableParams {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableParams.class);
    private final Map<String, String> params = Maps.newHashMap();

    public final String getParam(String key) {
        return this.params.get(key);
    }

    public final void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public final void setParams(Map<String, String> params) {
        if (MapUtils.isNotEmpty(params)) {
            this.params.putAll(params);
        }
    }

    public final void setParentId(String parentId) {
        this.setParam("parentId", parentId);
    }

    public final void setSubmitter(String submitter) {
        this.setParam("submitter", submitter);
    }

    public final void setParent(AbstractExecutable parent) {
        this.setParentId(parent.getId());
    }

    public List<String> getAllNotifyUsers(KylinConfig kylinConfig) {
        Object[] adminDls = kylinConfig.getAdminDls();
        return Lists.newArrayList((Object[])adminDls);
    }

    public final String getParentId() {
        return this.getParam("parentId");
    }

    public final String getSubmitter() {
        return this.getParam("submitter");
    }

    public long getDataRangeEnd() {
        return Optional.ofNullable(this.getParam("dataRangeEnd")).map(Long::parseLong).orElse(0L);
    }

    public long getDataRangeStart() {
        return Optional.ofNullable(this.getParam("dataRangeStart")).map(Long::parseLong).orElse(0L);
    }

    public Set<Long> getToBeDeletedLayoutIds() {
        LinkedHashSet<Long> layoutIdList = new LinkedHashSet<Long>();
        String idStr = this.getParam("layoutIds");
        if (StringUtils.isNotBlank((CharSequence)idStr)) {
            for (String id : idStr.split(",")) {
                layoutIdList.add(Long.parseLong(id));
            }
        }
        return layoutIdList;
    }

    public Set<Long> getLayoutIds() {
        if (this.getParam("layoutIds") != null) {
            return Sets.newHashSet((Object[])StringUtils.split((String)this.getParam("layoutIds"), (String)",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        }
        return null;
    }

    public Set<String> getSegmentIds() {
        if (this.getParam("segmentIds") != null) {
            return Sets.newHashSet((Object[])StringUtils.split((String)this.getParam("segmentIds"), (String)","));
        }
        return null;
    }

    public void setSparkYarnQueue(String queue) {
        this.setParam(KylinConfig.getInstanceFromEnv().getQueueKey(), queue);
    }

    public String getSparkYarnQueue() {
        return this.getParam(KylinConfig.getInstanceFromEnv().getQueueKey());
    }

    public static String toBucketParam(Set<JobBucket> buckets) {
        String param = "";
        try {
            HashMap bucketParams = Maps.newHashMap();
            buckets.forEach(bucket -> {
                bucketParams.computeIfAbsent(bucket.getSegmentId(), k -> Maps.newHashMap());
                ((Map)bucketParams.get(bucket.getSegmentId())).computeIfAbsent(bucket.getLayoutId(), k -> Maps.newHashMap());
                ((Map)((Map)bucketParams.get(bucket.getSegmentId())).get(bucket.getLayoutId())).put(bucket.getPartitionId(), bucket.getBucketId());
            });
            param = JsonUtil.writeValueAsString((Object)bucketParams);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return param;
    }

    public static Set<JobBucket> getBuckets(String content) {
        HashSet buckets = Sets.newHashSet();
        if (content == null) {
            return buckets;
        }
        try {
            HashMap bucketParams = (HashMap)JsonUtil.readValue((String)content, (TypeReference)new TypeReference<HashMap<String, Map<Long, Map<Long, Long>>>>(){});
            bucketParams.forEach((segment, layouts) -> layouts.forEach((layoutId, partitions) -> partitions.forEach((partitionId, bucketId) -> buckets.add(new JobBucket(segment, layoutId.longValue(), bucketId.longValue(), partitionId.longValue())))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buckets;
    }

    public final Map<String, Set<Long>> getPartitionsBySegment() {
        Set<JobBucket> buckets = ExecutableParams.getBuckets(this.getParam("buckets"));
        HashMap partitions = Maps.newHashMap();
        buckets.forEach(bucket -> {
            partitions.putIfAbsent(bucket.getSegmentId(), Sets.newHashSet());
            ((Set)partitions.get(bucket.getSegmentId())).add(bucket.getPartitionId());
        });
        return partitions;
    }

    @Generated
    public ExecutableParams() {
    }

    @Generated
    public Map<String, String> getParams() {
        return this.params;
    }
}

