/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRenameProposer
extends AbstractProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelRenameProposer.class);
    private static final String MODEL_ALIAS_PREFIX = "AUTO_MODEL_";
    public static final String MODEL_ALIAS_TRUNCATE_SUFFIX = "_TRUNC";

    public ModelRenameProposer(AbstractContext proposeContext) {
        super(proposeContext);
    }

    @Override
    public void execute() {
        Set<String> usedNames = this.getAllModelNames();
        List<AbstractContext.ModelContext> modelContexts = this.proposeContext.getModelContexts();
        for (AbstractContext.ModelContext modelCtx : modelContexts) {
            if (modelCtx.isTargetModelMissing()) continue;
            NDataModel targetModel = modelCtx.getTargetModel();
            String alias = modelCtx.getOriginModel() == null ? this.proposeModelAlias(targetModel, usedNames) : modelCtx.getOriginModel().getAlias();
            targetModel.setAlias(alias);
        }
    }

    private Set<String> getAllModelNames() {
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)this.project);
        HashSet modelNames = Sets.newHashSet();
        modelNames.addAll(dataModelManager.listAllModelAlias());
        modelNames.addAll(this.getProposeContext().getExtraMeta().getAllModels());
        return modelNames;
    }

    private String proposeModelAlias(NDataModel model, Set<String> usedModelNames) {
        String targetName;
        Set usedNames = usedModelNames.stream().map(name -> name.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        String rootTableAlias = model.getRootFactTable().getAlias();
        int suffix = 0;
        do {
            if (suffix++ < 0) {
                throw new IllegalStateException("Potential infinite loop in getModelName().");
            }
            targetName = StringUtils.isNotEmpty((CharSequence)this.proposeContext.getModelName()) ? this.proposeContext.getModelName() + "_" + suffix : MODEL_ALIAS_PREFIX + rootTableAlias + "_" + suffix;
            if (targetName.length() <= 127) continue;
            String truncateSuffix = "_TRUNC_" + suffix;
            int truncatePosition = Math.max(127 - truncateSuffix.length(), 0);
            targetName = targetName.substring(0, truncatePosition) + truncateSuffix;
        } while (usedNames.contains(targetName.toUpperCase(Locale.ROOT)));
        log.info("The alias of the model({}) was rename to {}.", (Object)model.getId(), (Object)targetName);
        usedModelNames.add(targetName.toUpperCase(Locale.ROOT));
        return targetName;
    }

    @Override
    public String getIdentifierName() {
        return "ModelRenameProposer";
    }
}

