/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AlertMessageRequest;
import org.apache.kylin.rest.response.ClusterStatisticStatusResponse;
import org.apache.kylin.rest.response.ClusterStatusResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ExecutorMemoryResponse;
import org.apache.kylin.rest.response.ExecutorThreadInfoResponse;
import org.apache.kylin.rest.service.MonitorService;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDBIOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/monitor"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NMonitorController
extends NBasicController {
    @Autowired
    @Qualifier(value="monitorService")
    private MonitorService monitorService;

    @Deprecated
    @ApiOperation(value="getMemoryMetrics", tags={"SM"}, notes="Update URL: memory_info")
    @GetMapping(value={"/memory_info"})
    @ResponseBody
    public EnvelopeResponse<List<ExecutorMemoryResponse>> getMemoryMetrics() {
        return new EnvelopeResponse("000", (Object)Lists.newArrayList(), "");
    }

    @Deprecated
    @ApiOperation(value="getThreadInfoMetrics", tags={"SM"}, notes="Update URL: thread_info")
    @GetMapping(value={"/thread_info"})
    @ResponseBody
    public EnvelopeResponse<List<ExecutorThreadInfoResponse>> getThreadInfoMetrics() {
        return new EnvelopeResponse("000", (Object)Lists.newArrayList(), "");
    }

    @ApiOperation(value="getStatus", tags={"SM"})
    @GetMapping(value={"/status"})
    @ResponseBody
    public EnvelopeResponse<ClusterStatusResponse> getClusterCurrentStatus() {
        ClusterStatusResponse result;
        try {
            result = this.monitorService.currentClusterStatus();
        }
        catch (InfluxDBIOException ie) {
            throw new RuntimeException("Failed to connect InfluxDB service. Please check its status and the network.");
        }
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="getStatusStatistics", tags={"SM"})
    @GetMapping(value={"/status/statistics"})
    @ResponseBody
    public EnvelopeResponse<ClusterStatisticStatusResponse> getClusterStatisticStatus(@RequestParam(value="start") long start, @RequestParam(value="end") long end) {
        ClusterStatisticStatusResponse result;
        long now = System.currentTimeMillis();
        long l = end = end > now ? now : end;
        if (start > end) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_END_LESS_THAN_START, new Object[]{String.valueOf(start), String.valueOf(end)});
        }
        try {
            result = this.monitorService.statisticClusterByFloorTime(start, end);
        }
        catch (InfluxDBIOException ie) {
            throw new RuntimeException("Failed to connect InfluxDB service. Please check its status and the network.");
        }
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="alert", tags={"SM"})
    @PostMapping(value={"/alert"})
    @ResponseBody
    public void alert(@RequestBody @Valid AlertMessageRequest alertMessageRequest) {
        this.monitorService.handleAlertMessage(alertMessageRequest);
    }
}

