/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.config.external.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.auth.ram.identify.StsConfig;
import com.alibaba.nacos.client.auth.ram.utils.SpasAdapter;
import com.alibaba.nacos.client.config.http.ServerHttpAgent;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.common.utils.UuidUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class NacosServerHttpAgent
extends ServerHttpAgent {
    private static final Logger LOGGER = LogUtils.logger(NacosServerHttpAgent.class);
    private static final NacosRestTemplate NACOS_RESTTEMPLATE = ConfigHttpClientManager.getInstance().getNacosRestTemplate();
    final ServerListManager serverListMgr;
    private final long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);
    private SecurityProxy securityProxy;
    private String namespaceId;
    private ScheduledExecutorService executorService;
    private String accessKey;
    private String secretKey;
    private String encode;
    private int maxRetry = 3;
    private volatile StsCredential stsCredential;

    public NacosServerHttpAgent(ServerListManager mgr) {
        super(mgr);
        this.serverListMgr = mgr;
    }

    public NacosServerHttpAgent(ServerListManager mgr, Properties properties) {
        super(mgr, properties);
        this.serverListMgr = mgr;
        this.init(properties);
    }

    public NacosServerHttpAgent(final Properties properties) throws NacosException {
        super(properties);
        this.serverListMgr = new ServerListManager(properties);
        this.namespaceId = properties.getProperty("namespace");
        List serverUrls = this.serverListMgr.getServerUrls();
        this.securityProxy = new SecurityProxy(serverUrls, NACOS_RESTTEMPLATE);
        this.init(properties);
        this.securityProxy.login(properties);
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.config.security.updater");
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                NacosServerHttpAgent.this.securityProxy.login(properties);
            }
        }, 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
    }

    public static String getAppname() {
        return ParamUtil.getAppName();
    }

    private static String getStsResponse() throws Exception {
        String securityCredentials = StsConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = StsConfig.getInstance().getSecurityCredentialsUrl();
        try {
            HttpRestResult result = NACOS_RESTTEMPLATE.get(securityCredentialsUrl, Header.EMPTY, Query.EMPTY, String.class);
            if (!result.ok()) {
                LOGGER.error("can not get security credentials, securityCredentialsUrl: {}, responseCode: {}, response: {}", new Object[]{securityCredentialsUrl, result.getCode(), result.getMessage()});
                throw new NacosException(500, "can not get security credentials, responseCode: " + result.getCode() + ", response: " + result.getMessage());
            }
            return (String)result.getData();
        }
        catch (Exception e) {
            LOGGER.error("can not get security credentials", (Throwable)e);
            throw e;
        }
    }

    public HttpRestResult<String> httpPostJson(String path, Object body) throws Exception {
        return this.httpPostJson(path, new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, String>(), body, StandardCharsets.UTF_8.name(), 600000);
    }

    public HttpRestResult<String> httpPostJson(String path, Object body, String encode, int readTimeoutMs) throws Exception {
        return this.httpPostJson(path, new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, String>(), body, encode, readTimeoutMs);
    }

    public HttpRestResult<String> httpPostJson(String path, Map<String, String> headers, Map<String, String> paramValues, Object body, String encode, int readTimeoutMs) throws Exception {
        long endTime = System.currentTimeMillis() + (long)readTimeoutMs;
        this.injectSecurityInfo(paramValues);
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        do {
            try {
                Header newHeaders = this.getSpasHeaders(paramValues, encode);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                Query query = Query.newInstance().initParams(paramValues);
                HttpClientConfig httpConfig = HttpClientConfig.builder().setReadTimeOutMillis(readTimeoutMs).setConTimeOutMillis(ConfigHttpClientManager.getInstance().getConnectTimeoutOrDefault(60000)).build();
                String reqUrl = this.getUrl(currentServerAddr, path);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[NacosServerHttpAgent] HttpPostJson Start, currentServerAddr: {}, contentPath: {}", (Object)currentServerAddr, (Object)this.serverListMgr.getContentPath());
                    LOGGER.debug("[NacosServerHttpAgent] HttpPostJson Req, url: {}, headers: {}, query: {}, body: {}", new Object[]{reqUrl, newHeaders, query.toQueryUrl(), JacksonUtils.toJson((Object)body)});
                }
                HttpRestResult result = NACOS_RESTTEMPLATE.exchange(reqUrl, httpConfig, newHeaders, query, body, "POST", String.class);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[NacosServerHttpAgent] HttpPostJson End, res: {}", (Object)result);
                }
                if (!this.isFail((HttpRestResult<String>)result)) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)result);
            }
            catch (ConnectException connectException) {
                LOGGER.error("[NACOS ConnectException httpDelete] currentServerAddr:{}, err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)ExceptionUtil.getStackTrace((Throwable)connectException));
            }
            catch (SocketTimeoutException stoe) {
                LOGGER.error("[NACOS SocketTimeoutException httpDelete] currentServerAddr:{}\uff0c err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)ExceptionUtil.getStackTrace((Throwable)stoe));
            }
            catch (Exception ex) {
                LOGGER.error("[NACOS Exception httpDelete] currentServerAddr: " + this.serverListMgr.getCurrentServerAddr(), (Throwable)ex);
                throw ex;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = (String)this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-DELETE] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server, currentServerAddr : {}", (Object)currentServerAddr);
        throw new ConnectException("no available server, currentServerAddr : " + currentServerAddr);
    }

    private String getUrl(String serverAddr, String relativePath) {
        return serverAddr + ContextPathUtil.normalizeContextPath((String)this.serverListMgr.getContentPath()) + relativePath;
    }

    private boolean isFail(HttpRestResult<String> result) {
        return result.getCode() == 500 || result.getCode() == 502 || result.getCode() == 503 || result.getCode() == 404;
    }

    private void injectSecurityInfo(Map<String, String> params) {
        Map identityContext = this.securityProxy.getIdentityContext(RequestResource.configBuilder().build());
        String accessToken = (String)identityContext.get("accessToken");
        if (StringUtils.isNotBlank((String)accessToken)) {
            params.put("accessToken", accessToken);
        }
        if (StringUtils.isNotBlank((String)this.namespaceId) && !params.containsKey("tenant")) {
            params.put("tenant", this.namespaceId);
        }
    }

    private void init(Properties properties) {
        this.initEncode(properties);
        this.initAkSk(properties);
        this.initMaxRetry(properties);
    }

    private void initEncode(Properties properties) {
        this.encode = TemplateUtils.stringEmptyAndThenExecute((String)properties.getProperty("encode"), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "UTF-8";
            }
        });
    }

    private void initAkSk(Properties properties) {
        String ak;
        String ramRoleName = properties.getProperty("ramRoleName");
        if (!StringUtils.isBlank((CharSequence)ramRoleName)) {
            StsConfig.getInstance().setRamRoleName(ramRoleName);
        }
        this.accessKey = StringUtils.isBlank((CharSequence)(ak = properties.getProperty("accessKey"))) ? SpasAdapter.getAk() : ak;
        String sk = properties.getProperty("secretKey");
        this.secretKey = StringUtils.isBlank((CharSequence)sk) ? SpasAdapter.getSk() : sk;
    }

    private void initMaxRetry(Properties properties) {
        this.maxRetry = ConvertUtils.toInt((String)String.valueOf(properties.get("maxRetry")), (int)3);
    }

    public void start() throws NacosException {
        this.serverListMgr.start();
    }

    private Header getSpasHeaders(Map<String, String> paramValues, String encode) throws Exception {
        Header header = Header.newInstance();
        if (StsConfig.getInstance().isStsOn()) {
            StsCredential stsCredential = this.getStsCredential();
            this.accessKey = stsCredential.accessKeyId;
            this.secretKey = stsCredential.accessKeySecret;
            header.addParam("Spas-SecurityToken", stsCredential.securityToken);
        }
        if (StringUtils.isNotEmpty((String)this.accessKey) && StringUtils.isNotEmpty((String)this.secretKey)) {
            header.addParam("Spas-AccessKey", this.accessKey);
            Map signHeaders = SpasAdapter.getSignHeaders(paramValues, (String)this.secretKey);
            if (signHeaders != null) {
                header.addAll(signHeaders);
            }
        }
        if (StringUtils.isNotBlank((String)paramValues.get("accessToken"))) {
            header.addParam("accessToken", paramValues.get("accessToken"));
        }
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5Utils.md5Hex((String)(ts + ParamUtil.getAppKey()), (String)"UTF-8");
        header.addParam("Client-AppName", ParamUtil.getAppName());
        header.addParam("Client-RequestTS", ts);
        header.addParam("Client-RequestToken", token);
        header.addParam("Client-Version", VersionUtils.version);
        header.addParam("exConfigInfo", "true");
        header.addParam("RequestId", UuidUtils.generateUuid());
        header.addParam("Accept-Charset", encode);
        return header;
    }

    private StsCredential getStsCredential() throws Exception {
        StsCredential stsCredentialTmp;
        boolean cacheSecurityCredentials = StsConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && this.stsCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = this.stsCredential.expiration.getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = StsConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return this.stsCredential;
            }
        }
        String stsResponse = NacosServerHttpAgent.getStsResponse();
        this.stsCredential = stsCredentialTmp = (StsCredential)JacksonUtils.toObj((String)stsResponse, (TypeReference)new TypeReference<StsCredential>(){});
        LOGGER.info("[getSTSCredential] code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", new Object[]{this.stsCredential.getCode(), this.stsCredential.getAccessKeyId(), this.stsCredential.getLastUpdated(), this.stsCredential.getExpiration()});
        return this.stsCredential;
    }

    public String getName() {
        return this.serverListMgr.getName();
    }

    public String getNamespace() {
        return this.serverListMgr.getNamespace();
    }

    public String getTenant() {
        return this.serverListMgr.getTenant();
    }

    public String getEncode() {
        return this.encode;
    }

    public void shutdown() throws NacosException {
        String className = ((Object)((Object)this)).getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LOGGER);
        ConfigHttpClientManager.getInstance().shutdown();
        SpasAdapter.freeCredentialInstance();
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    private static class StsCredential {
        @JsonProperty(value="AccessKeyId")
        private String accessKeyId;
        @JsonProperty(value="AccessKeySecret")
        private String accessKeySecret;
        @JsonProperty(value="Expiration")
        private Date expiration;
        @JsonProperty(value="SecurityToken")
        private String securityToken;
        @JsonProperty(value="LastUpdated")
        private Date lastUpdated;
        @JsonProperty(value="Code")
        private String code;

        private StsCredential() {
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return "STSCredential{accessKeyId='" + this.accessKeyId + '\'' + ", accessKeySecret='" + this.accessKeySecret + '\'' + ", expiration=" + this.expiration + ", securityToken='" + this.securityToken + '\'' + ", lastUpdated=" + this.lastUpdated + ", code='" + this.code + '\'' + '}';
        }
    }
}

