/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.MetadataBackupRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.FileService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.ScheduleService;
import org.apache.kylin.rest.service.SystemService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/system"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NSystemController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NSystemController.class);
    @Autowired
    @Qualifier(value="systemService")
    private SystemService systemService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    private FileService fileService;

    @VisibleForTesting
    public void setAclEvaluate(AclEvaluate aclEvaluate) {
        this.aclEvaluate = aclEvaluate;
    }

    @VisibleForTesting
    public AclEvaluate getAclEvaluate() {
        return this.aclEvaluate;
    }

    @PutMapping(value={"/roll_event_log"})
    @ResponseBody
    public EnvelopeResponse<String> rollEventLog() {
        if (ToolUtil.waitForSparderRollUp()) {
            return new EnvelopeResponse("000", (Object)"", "");
        }
        return new EnvelopeResponse("999", (Object)"", "Rollup sparder eventLog failed.");
    }

    @ApiOperation(value="host", tags={"DW"})
    @GetMapping(value={"/host"})
    @ResponseBody
    public EnvelopeResponse<String> getHostname() {
        return new EnvelopeResponse("000", (Object)AddressUtil.getLocalInstance(), "");
    }

    @ApiOperation(value="reload metadata", tags={"MID"})
    @PostMapping(value={"/metadata/reload"})
    @ResponseBody
    public EnvelopeResponse<String> reloadMetadata() throws IOException {
        this.systemService.reloadMetadata();
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/transaction/simulation"})
    @ResponseBody
    public EnvelopeResponse<String> simulateUnitOfWork(String project, int seconds) {
        this.aclEvaluate.checkProjectAdminPermission(project);
        if (KylinConfig.getInstanceFromEnv().isUnitOfWorkSimulationEnabled()) {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                long index;
                for (index = 0L; index < (long)seconds; ++index) {
                    Thread.sleep(1000L);
                }
                return index;
            }, (String)project);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="cleanup garbage", tags={"MID"})
    @PostMapping(value={"/do_cleanup_garbage"})
    @ResponseBody
    public EnvelopeResponse<String> doCleanupGarbage(HttpServletRequest request) throws Exception {
        this.scheduleService.routineTask();
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/transaction/simulation/insert_meta"})
    @ResponseBody
    public EnvelopeResponse<String> simulateInsertMeta(@RequestParam(value="count", required=false, defaultValue="5") int count, @RequestParam(value="sleepSec", required=false, defaultValue="20") long sleepSec) {
        if (KylinConfig.getInstanceFromEnv().isUnitOfWorkSimulationEnabled()) {
            List<String> projectList = IntStream.range(0, 5).mapToObj(i -> "simulation" + i).collect(Collectors.toList());
            projectList.forEach(p -> {
                if (CollectionUtils.isNotEmpty((Collection)this.projectService.getReadableProjects(p, true))) {
                    EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                        this.projectService.dropProject(p);
                        return null;
                    }, (String)p);
                }
            });
            log.debug("insert_meta begin to create project");
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").sleepMills(TimeUnit.SECONDS.toMillis(sleepSec)).processor(() -> {
                projectList.forEach(p -> this.projectService.createProject(p, new ProjectInstance()));
                return null;
            }).build());
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"broadcast_metadata_backup"})
    @ResponseBody
    public EnvelopeResponse<String> broadcastMetadataBackup(@RequestBody MetadataBackupRequest request) {
        log.info("ResourceGroup[{}] broadcastMetadataBackup tmpFilePath : {}", (Object)request.getResourceGroupId(), (Object)request.getTmpFilePath());
        this.fileService.saveBroadcastMetadataBackup(request.getBackupDir(), request.getTmpFilePath(), request.getTmpFileSize(), request.getResourceGroupId(), request.getFromHost());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"metadata_backup_tmp_file"})
    @ResponseBody
    public EnvelopeResponse<String> downloadMetadataBackTmpFile(@RequestBody MetadataBackupRequest request, HttpServletResponse response) throws IOException {
        log.info("ResourceGroup[{}] downloadMetadataBackTmpFile tmpFilePath : {}", (Object)request.getResourceGroupId(), (Object)request.getTmpFilePath());
        InputStream backupInputStream = this.fileService.getMetadataBackupFromTmpPath(request.getTmpFilePath(), request.getTmpFileSize());
        this.setDownloadResponse(backupInputStream, "metadata.zip", "application/octet-stream", response);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @DeleteMapping(value={"clean_sparder_event_log"})
    @ResponseBody
    public EnvelopeResponse<String> queryNodeCleanSparderEventsLogs() {
        this.systemService.cleanSparderEventLog();
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

