/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config;

import javax.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Order(value=200)
@Configuration
@EnableWebSecurity
@Profile(value={"testing", "ldap", "custom"})
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    @Autowired
    Filter fillEmptyAuthorizationFilter;
    @Autowired
    LogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    AuthenticationEntryPoint nUnauthorisedEntryPoint;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)http.formLogin().and()).httpBasic().authenticationEntryPoint(this.nUnauthorisedEntryPoint).and()).logout();
        ((HttpSecurity)http.headers().frameOptions(HeadersConfigurer.FrameOptionsConfig::sameOrigin).and()).csrf(AbstractHttpConfigurer::disable).addFilterBefore(this.fillEmptyAuthorizationFilter, BasicAuthenticationFilter.class);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/api/streaming_jobs/spark", "/api/streaming_jobs/stats", "/api/streaming_jobs/dataflow/**", "/api/epoch/maintenance_mode", "/api/health", "/api/health/**", "/api/prometheus", "/api/monitor/spark/prometheus", "/api/user/update_user", "/api/metastore/cleanup", "/api/metastore/cleanup_storage", "/api/epoch", "/api/broadcast/**", "/api/config/is_cloud", "/api/system/license/file", "/api/system/license/content", "/api/system/license/trial", "/api/system/license", "/api/system/diag/progress", "/api/system/roll_event_log", "/api/user/authentication*/**", "/api/query/history_queries/table_names", "/api/models/model_info", "/api/**/metrics", "/api/system/backup", "/api/jobs/spark", "/api/jobs/stage/status", "/api/jobs/error", "/api/jobs/wait_and_run_time", "/api/cache*/**", "/api/admin/public_config", "/api/admin/instance_info", "/api/projects", "/api/system/license/info"})).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/api/monitor/alert", "/api/admin*/**"})).access("hasRole('ROLE_ADMIN')").and()).authorizeRequests().antMatchers(new String[]{"/api/cubes/src/tables"})).access("hasRole('ROLE_ANALYST')").and()).authorizeRequests().antMatchers(new String[]{"/api/query*/**", "/api/metadata*/**", "/api/cubes*/**", "/api/models*/**", "/api/job*/**", "/api/**"})).authenticated();
        http.logout().invalidateHttpSession(true).deleteCookies(new String[]{"JSESSIONID"}).logoutUrl("/api/j_spring_security_logout").logoutSuccessHandler(this.logoutSuccessHandler);
        http.sessionManagement(configurer -> configurer.sessionFixation().newSession());
    }
}

