/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Ordering;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.cuboid.ComparatorUtils;
import org.apache.kylin.metadata.cube.cuboid.IndexMatcher;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.DeriveInfo;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.QueryRouter;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryLayoutChooser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryLayoutChooser.class);

    private QueryLayoutChooser() {
    }

    public static NLayoutCandidate selectPartialLayoutCandidate(NDataflow dataflow, List<NDataSegment> prunedSegments, SQLDigest sqlDigest) {
        NLayoutCandidate candidate = null;
        ArrayList toRemovedSegments = Lists.newArrayList();
        for (NDataSegment segment : prunedSegments) {
            long layoutId;
            if (candidate == null) {
                candidate = QueryLayoutChooser.selectLayoutCandidate(dataflow, Lists.newArrayList((Object[])new NDataSegment[]{segment}), sqlDigest);
            }
            long l = layoutId = candidate == null ? -1L : candidate.getLayoutEntity().getId();
            if (segment.getSegDetails().getLayoutById(layoutId) != null) continue;
            toRemovedSegments.add(segment);
        }
        prunedSegments.removeAll(toRemovedSegments);
        return candidate;
    }

    public static NLayoutCandidate selectLayoutCandidate(NDataflow dataflow, List<NDataSegment> prunedSegments, SQLDigest sqlDigest) {
        if (CollectionUtils.isEmpty(prunedSegments)) {
            log.info("There is no segment to answer sql");
            return NLayoutCandidate.ofEmptyCandidate();
        }
        ChooserContext chooserContext = new ChooserContext(sqlDigest, dataflow);
        if (chooserContext.isIndexMatchersInvalid()) {
            return null;
        }
        Collection<NDataLayout> commonLayouts = QueryLayoutChooser.getCommonLayouts(prunedSegments, dataflow);
        log.info("Matching dataflow with seg num: {} layout num: {}", (Object)prunedSegments.size(), (Object)commonLayouts.size());
        Map<Long, List<NDataLayout>> commonLayoutsMap = commonLayouts.stream().collect(Collectors.toMap(NDataLayout::getLayoutId, xva$0 -> Lists.newArrayList((Object[])new NDataLayout[]{xva$0})));
        List<NLayoutCandidate> candidates = QueryLayoutChooser.collectAllLayoutCandidates(dataflow, chooserContext, commonLayoutsMap);
        return QueryLayoutChooser.chooseBestLayoutCandidate(dataflow, sqlDigest, chooserContext, candidates, "selectLayoutCandidate");
    }

    public static List<NLayoutCandidate> collectAllLayoutCandidates(NDataflow dataflow, ChooserContext chooserContext, Map<Long, List<NDataLayout>> dataLayoutMap) {
        ArrayList candidates = Lists.newArrayList();
        for (Map.Entry<Long, List<NDataLayout>> entry : dataLayoutMap.entrySet()) {
            LayoutEntity layout = dataflow.getIndexPlan().getLayoutEntity(entry.getKey());
            log.trace("Matching index: id = {}", (Object)entry.getKey());
            IndexMatcher.MatchResult matchResult = chooserContext.getTableIndexMatcher().match(layout);
            if (!matchResult.isMatched()) {
                matchResult = chooserContext.getAggIndexMatcher().match(layout);
            }
            if (!matchResult.isMatched()) {
                log.trace("The [{}] cannot match with the {}", (Object)chooserContext.getSqlDigest().toString(), (Object)layout);
                continue;
            }
            NLayoutCandidate candidate = new NLayoutCandidate(layout);
            CapabilityResult tempResult = new CapabilityResult(matchResult);
            if (!matchResult.getNeedDerive().isEmpty()) {
                candidate.setDerivedToHostMap(matchResult.getNeedDerive());
                candidate.setDerivedLookups(candidate.getDerivedToHostMap().keySet().stream().map(i -> chooserContext.convertToRef(i).getTable()).collect(Collectors.toSet()));
            }
            List<NDataLayout> dataLayouts = entry.getValue();
            long allRows = dataLayouts.stream().mapToLong(NDataLayout::getRows).sum();
            candidate.setCost((double)allRows * ((double)tempResult.influences.size() + matchResult.getInfluenceFactor()));
            candidate.setCapabilityResult(tempResult);
            long[] rangeAndLatest = QueryLayoutChooser.calcSegRangeAndMaxEnd(chooserContext, dataflow, dataLayouts);
            candidate.setRange(rangeAndLatest[0]);
            candidate.setMaxSegEnd(rangeAndLatest[1]);
            candidates.add(candidate);
        }
        return candidates;
    }

    private static long[] calcSegRangeAndMaxEnd(ChooserContext chooserContext, NDataflow df, List<NDataLayout> dataLayouts) {
        long[] rangeAndLatest = new long[2];
        if (!QueryRouter.isVacantIndexPruningEnabled(chooserContext.getKylinConfig())) {
            return rangeAndLatest;
        }
        ArrayList segmentNameList = Lists.newArrayList();
        for (NDataLayout dataLayout : dataLayouts) {
            NDataSegment segment = df.getSegment(dataLayout.getSegDetails().getId());
            Long end = (Long)segment.getSegRange().getEnd();
            Long start = (Long)segment.getSegRange().getStart();
            rangeAndLatest[0] = rangeAndLatest[0] + (end - start);
            rangeAndLatest[1] = Math.max(rangeAndLatest[1], end);
            segmentNameList.add(segment.getName());
        }
        log.trace("All available segments are: {}", (Object)segmentNameList);
        return rangeAndLatest;
    }

    public static NLayoutCandidate selectHighIntegrityCandidate(NDataflow dataflow, Candidate candidate, SQLDigest digest) {
        List<NDataSegment> prunedSegments = candidate.getPrunedSegments(dataflow);
        if (!QueryRouter.isVacantIndexPruningEnabled(NProjectManager.getProjectConfig((String)dataflow.getProject()))) {
            return null;
        }
        if (CollectionUtils.isEmpty(prunedSegments)) {
            log.info("There is no segment to answer sql");
            return NLayoutCandidate.ofEmptyCandidate();
        }
        ChooserContext chooserContext = new ChooserContext(digest, dataflow);
        if (chooserContext.isIndexMatchersInvalid()) {
            return null;
        }
        Map<Long, List<NDataLayout>> idToDataLayoutsMap = QueryLayoutChooser.getCommonLayouts(prunedSegments);
        List<NLayoutCandidate> allLayoutCandidates = QueryLayoutChooser.collectAllLayoutCandidates(dataflow, chooserContext, idToDataLayoutsMap);
        return QueryLayoutChooser.chooseBestLayoutCandidate(dataflow, digest, chooserContext, allLayoutCandidates, "selectHighIntegrityCandidate");
    }

    public static NLayoutCandidate chooseBestLayoutCandidate(NDataflow dataflow, SQLDigest digest, ChooserContext chooserContext, List<NLayoutCandidate> allLayoutCandidates, String invokedByMethod) {
        QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted exception occurs.", (String)"Current step involves gathering all the layouts that can potentially provide a response to this query.");
        if (allLayoutCandidates.isEmpty()) {
            log.info("There is no layouts can match with the [{}]", (Object)digest.toString());
            return null;
        }
        QueryLayoutChooser.sortCandidates(allLayoutCandidates, chooserContext, digest);
        log.debug("Invoked by method {}. Successfully matched {} candidates within the model ({}/{}), and {} has been selected.", new Object[]{invokedByMethod, allLayoutCandidates.size(), dataflow.getProject(), dataflow.getId(), allLayoutCandidates.get(0).toString()});
        return allLayoutCandidates.get(0);
    }

    private static Map<Long, List<NDataLayout>> getCommonLayouts(List<NDataSegment> prunedSegments) {
        HashMap idToDataLayoutsMap = Maps.newHashMap();
        for (NDataSegment segment : prunedSegments) {
            segment.getLayoutsMap().forEach((id, dataLayout) -> {
                idToDataLayoutsMap.putIfAbsent(id, Lists.newArrayList());
                ((List)idToDataLayoutsMap.get(id)).add(dataLayout);
            });
        }
        return idToDataLayoutsMap;
    }

    private static Collection<NDataLayout> getCommonLayouts(List<NDataSegment> segments, NDataflow dataflow) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)dataflow.getProject());
        if (!projectConfig.isHeterogeneousSegmentEnabled()) {
            return dataflow.getLatestReadySegment().getLayoutsMap().values();
        }
        HashMap commonLayouts = Maps.newHashMap();
        if (CollectionUtils.isEmpty(segments)) {
            return commonLayouts.values();
        }
        boolean isMppOnTheFlyLayoutsEnabled = dataflow.getConfig().isMppOnTheFlyLayoutsEnabled();
        for (int i = 0; i < segments.size(); ++i) {
            boolean isReadyEmptySeg;
            NDataSegment dataSegment = segments.get(i);
            Map layoutIdMapToDataLayout = dataSegment.getLayoutsMap();
            boolean bl = isReadyEmptySeg = isMppOnTheFlyLayoutsEnabled && dataSegment.getStatus() == SegmentStatusEnum.READY && layoutIdMapToDataLayout.isEmpty();
            if (i == 0 || isReadyEmptySeg) {
                commonLayouts.putAll(layoutIdMapToDataLayout);
                continue;
            }
            commonLayouts.keySet().retainAll(layoutIdMapToDataLayout.keySet());
        }
        return commonLayouts.values();
    }

    public static void sortCandidates(List<NLayoutCandidate> candidates, ChooserContext chooserContext, SQLDigest sqlDigest) {
        List<Integer> filterColIds = QueryLayoutChooser.getFilterColIds(chooserContext, sqlDigest);
        List<Integer> nonFilterColIds = QueryLayoutChooser.getNonFilterColIds(chooserContext, sqlDigest);
        Ordering<NLayoutCandidate> ordering = QueryRouter.isVacantIndexPruningEnabled(chooserContext.getKylinConfig()) ? QueryLayoutChooser.getEnhancedSorter(filterColIds, nonFilterColIds) : QueryLayoutChooser.getDefaultSorter(filterColIds, nonFilterColIds);
        candidates.sort((Comparator<NLayoutCandidate>)ordering);
    }

    private static Ordering<NLayoutCandidate> getEnhancedSorter(List<Integer> filterColIds, List<Integer> nonFilterColIds) {
        return Ordering.from(QueryLayoutChooser.segmentRangeComparator()).compound(QueryLayoutChooser.preferAggComparator()).compound(QueryLayoutChooser.derivedLayoutComparator()).compound(QueryLayoutChooser.rowSizeComparator()).compound(QueryLayoutChooser.filterColumnComparator(filterColIds)).compound(QueryLayoutChooser.dimensionSizeComparator()).compound(QueryLayoutChooser.measureSizeComparator()).compound(QueryLayoutChooser.nonFilterColumnComparator(nonFilterColIds)).compound(QueryLayoutChooser.segmentEffectivenessComparator());
    }

    private static Ordering<NLayoutCandidate> getDefaultSorter(List<Integer> filterColIds, List<Integer> nonFilterColIds) {
        return Ordering.from(QueryLayoutChooser.preferAggComparator()).compound(QueryLayoutChooser.derivedLayoutComparator()).compound(QueryLayoutChooser.rowSizeComparator()).compound(QueryLayoutChooser.filterColumnComparator(filterColIds)).compound(QueryLayoutChooser.dimensionSizeComparator()).compound(QueryLayoutChooser.measureSizeComparator()).compound(QueryLayoutChooser.nonFilterColumnComparator(nonFilterColIds));
    }

    private static List<Integer> getFilterColIds(ChooserContext chooserContext, SQLDigest sqlDigest) {
        ImmutableSet filterColSet = ImmutableSet.copyOf((Collection)sqlDigest.getFilterColumns());
        ArrayList filterCols = Lists.newArrayList((Iterable)filterColSet);
        return filterCols.stream().sorted(ComparatorUtils.filterColComparator((ChooserContext)chooserContext)).map(col -> (Integer)chooserContext.getTblColMap().get(col)).collect(Collectors.toList());
    }

    private static List<Integer> getNonFilterColIds(ChooserContext chooserContext, SQLDigest sqlDigest) {
        Set nonFilterColSet = sqlDigest.isRawQuery ? sqlDigest.getAllColumns().stream().filter(colRef -> colRef.getFilterLevel() == TblColRef.FilterColEnum.NONE).collect(Collectors.toSet()) : sqlDigest.getGroupByColumns().stream().filter(colRef -> colRef.getFilterLevel() == TblColRef.FilterColEnum.NONE).collect(Collectors.toSet());
        ArrayList nonFilterColumns = Lists.newArrayList(nonFilterColSet);
        nonFilterColumns.sort(ComparatorUtils.nonFilterColComparator());
        return nonFilterColumns.stream().map(col -> (Integer)chooserContext.getTblColMap().get(col)).collect(Collectors.toList());
    }

    public static Comparator<NLayoutCandidate> segmentRangeComparator() {
        return (c1, c2) -> Long.compare(c2.getRange(), c1.getRange());
    }

    public static Comparator<NLayoutCandidate> segmentEffectivenessComparator() {
        return (c1, c2) -> Long.compare(c2.getMaxSegEnd(), c1.getMaxSegEnd());
    }

    public static Comparator<NLayoutCandidate> preferAggComparator() {
        return (layoutCandidate1, layoutCandidate2) -> {
            if (!KylinConfig.getInstanceFromEnv().isPreferAggIndex()) {
                return 0;
            }
            if (!layoutCandidate1.getLayoutEntity().getIndex().isTableIndex() && layoutCandidate2.getLayoutEntity().getIndex().isTableIndex()) {
                return -1;
            }
            if (layoutCandidate1.getLayoutEntity().getIndex().isTableIndex() && !layoutCandidate2.getLayoutEntity().getIndex().isTableIndex()) {
                return 1;
            }
            return 0;
        };
    }

    public static Comparator<NLayoutCandidate> derivedLayoutComparator() {
        return (candidate1, candidate2) -> {
            int result = 0;
            if (candidate1.getDerivedToHostMap().isEmpty() && !candidate2.getDerivedToHostMap().isEmpty()) {
                result = -1;
            } else if (!candidate1.getDerivedToHostMap().isEmpty() && candidate2.getDerivedToHostMap().isEmpty()) {
                result = 1;
            }
            IndexPlan indexPlan = candidate1.getLayoutEntity().getIndex().getIndexPlan();
            KylinConfig config = indexPlan.getConfig();
            if (config.isTableExclusionEnabled() && config.isSnapshotPreferred()) {
                result = -1 * result;
            }
            return result;
        };
    }

    public static Comparator<NLayoutCandidate> rowSizeComparator() {
        return Comparator.comparingDouble(NLayoutCandidate::getCost);
    }

    public static Comparator<NLayoutCandidate> dimensionSizeComparator() {
        return Comparator.comparingInt(candidate -> candidate.getLayoutEntity().getOrderedDimensions().size());
    }

    public static Comparator<NLayoutCandidate> measureSizeComparator() {
        return Comparator.comparingInt(candidate -> candidate.getLayoutEntity().getOrderedMeasures().size());
    }

    public static Comparator<NLayoutCandidate> filterColumnComparator(List<Integer> sortedFilters) {
        return Ordering.from(QueryLayoutChooser.shardByComparator(sortedFilters)).compound(QueryLayoutChooser.colComparator(sortedFilters));
    }

    public static Comparator<NLayoutCandidate> nonFilterColumnComparator(List<Integer> sortedNonFilters) {
        return QueryLayoutChooser.colComparator(sortedNonFilters);
    }

    public static Comparator<NLayoutCandidate> colComparator(List<Integer> sortedCols) {
        return (layoutCandidate1, layoutCandidate2) -> {
            List<Integer> position1 = QueryLayoutChooser.getColumnsPos(layoutCandidate1, sortedCols);
            List<Integer> position2 = QueryLayoutChooser.getColumnsPos(layoutCandidate2, sortedCols);
            Iterator<Integer> iter1 = position1.iterator();
            Iterator<Integer> iter2 = position2.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                int i2;
                int i1 = iter1.next();
                int c = i1 - (i2 = iter2.next().intValue());
                if (c == 0) continue;
                return c;
            }
            return 0;
        };
    }

    public static Comparator<NLayoutCandidate> shardByComparator(List<Integer> columns) {
        return (candidate1, candidate2) -> {
            int shardByCol1Idx = QueryLayoutChooser.getShardByColIndex(candidate1, columns);
            int shardByCol2Idx = QueryLayoutChooser.getShardByColIndex(candidate2, columns);
            return shardByCol1Idx - shardByCol2Idx;
        };
    }

    private static int getShardByColIndex(NLayoutCandidate candidate1, List<Integer> columns) {
        int shardByCol1Idx = Integer.MAX_VALUE;
        List shardByCols1 = candidate1.getLayoutEntity().getShardByColumns();
        if (CollectionUtils.isNotEmpty((Collection)shardByCols1)) {
            int tmpCol = (Integer)shardByCols1.get(0);
            for (int i = 0; i < columns.size(); ++i) {
                if (columns.get(i) != tmpCol) continue;
                shardByCol1Idx = i;
                break;
            }
        }
        return shardByCol1Idx;
    }

    private static List<Integer> getColumnsPos(NLayoutCandidate candidate, List<Integer> sortedColumns) {
        ArrayList positions = Lists.newArrayList();
        for (Integer col : sortedColumns) {
            DeriveInfo deriveInfo = (DeriveInfo)candidate.getDerivedToHostMap().get(col);
            if (deriveInfo == null) {
                positions.add(QueryLayoutChooser.getDimsIndexInLayout(col, candidate));
                continue;
            }
            for (Integer hostColId : deriveInfo.columns) {
                positions.add(QueryLayoutChooser.getDimsIndexInLayout(hostColId, candidate));
            }
        }
        return positions;
    }

    private static int getDimsIndexInLayout(Integer id, NLayoutCandidate candidate) {
        return id == null ? -1 : candidate.getLayoutEntity().getColOrder().indexOf((Object)id);
    }
}

