/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.expression;

import java.io.Serializable;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.AttributeReferenceTransformer;
import org.apache.gluten.expression.BoundReferenceTransformer;
import org.apache.gluten.expression.CaseWhenTransformer;
import org.apache.gluten.expression.CastTransformer;
import org.apache.gluten.expression.CheckOverflowTransformer;
import org.apache.gluten.expression.ChildTransformer;
import org.apache.gluten.expression.CreateArrayTransformer;
import org.apache.gluten.expression.CreateMapTransformer;
import org.apache.gluten.expression.DecimalArithmeticExpressionTransformer;
import org.apache.gluten.expression.DecimalRoundTransformer;
import org.apache.gluten.expression.ExplodeTransformer;
import org.apache.gluten.expression.ExpressionMappings$;
import org.apache.gluten.expression.ExpressionTransformer;
import org.apache.gluten.expression.ExtractDateTransformer;
import org.apache.gluten.expression.GenericExpressionTransformer;
import org.apache.gluten.expression.GenericExpressionTransformer$;
import org.apache.gluten.expression.IfTransformer;
import org.apache.gluten.expression.InSetTransformer;
import org.apache.gluten.expression.InTransformer;
import org.apache.gluten.expression.JsonTupleExpressionTransformer;
import org.apache.gluten.expression.LambdaFunctionTransformer;
import org.apache.gluten.expression.LiteralTransformer;
import org.apache.gluten.expression.LiteralTransformer$;
import org.apache.gluten.expression.MonthsBetweenTransformer;
import org.apache.gluten.expression.ScalarSubqueryTransformer;
import org.apache.gluten.expression.TimestampAddTransformer;
import org.apache.gluten.expression.Transformable;
import org.apache.gluten.expression.UDFMappings$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.test.TestStats;
import org.apache.gluten.utils.DecimalArithmeticUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.ArrayExists;
import org.apache.spark.sql.catalyst.expressions.ArrayFilter;
import org.apache.spark.sql.catalyst.expressions.ArrayForAll;
import org.apache.spark.sql.catalyst.expressions.ArraySort;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.AtLeastNNonNulls;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.DateDiff;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.DynamicPruningExpression;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EulerNumber;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetDateField;
import org.apache.spark.sql.catalyst.expressions.GetMapValue;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetTimeField;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Inline;
import org.apache.spark.sql.catalyst.expressions.JsonTuple;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeDecimal;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp;
import org.apache.spark.sql.catalyst.expressions.MapEntries;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.NaNvl;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.Pi;
import org.apache.spark.sql.catalyst.expressions.PosExplode;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.PromotePrecision;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF;
import org.apache.spark.sql.catalyst.expressions.Shuffle;
import org.apache.spark.sql.catalyst.expressions.Size;
import org.apache.spark.sql.catalyst.expressions.SparkVersion;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringSplit;
import org.apache.spark.sql.catalyst.expressions.StringToMap;
import org.apache.spark.sql.catalyst.expressions.StringTranslate;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.TaggingExpression;
import org.apache.spark.sql.catalyst.expressions.TimeAdd;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.TransformKeys;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp;
import org.apache.spark.sql.catalyst.expressions.TryEval;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.Uuid;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.optimizer.NormalizeNaNAndZero;
import org.apache.spark.sql.execution.ScalarSubquery;
import org.apache.spark.sql.hive.HiveUDFTransformer$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ExpressionConverter$
implements SQLConfHelper,
Logging {
    public static ExpressionConverter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExpressionConverter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<ExpressionTransformer> replaceWithExpressionTransformer(Seq<Expression> exprs, Seq<Attribute> attributeSeq) {
        Map<Class<?>, String> expressionsMap = ExpressionMappings$.MODULE$.expressionsMap();
        return (Seq)exprs.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.replaceWithExpressionTransformer0((Expression)expr, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom());
    }

    public ExpressionTransformer replaceWithExpressionTransformer(Expression expr, Seq<Attribute> attributeSeq) {
        Map<Class<?>, String> expressionsMap = ExpressionMappings$.MODULE$.expressionsMap();
        return this.replaceWithExpressionTransformer0(expr, attributeSeq, expressionsMap);
    }

    public boolean canReplaceWithExpressionTransformer(Expression expr, Seq<Attribute> attributeSeq) {
        boolean bl;
        try {
            this.replaceWithExpressionTransformer(expr, attributeSeq);
            bl = true;
        }
        catch (Exception e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression replaceAttributeReference(Expression expr) {
        Expression expression = expr;
        if (!(expression instanceof AttributeReference)) return expression;
        AttributeReference attributeReference = (AttributeReference)expression;
        DataType dataType = attributeReference.dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        if (dataType != null) {
            if (!dataType.equals(booleanType$)) return expression;
            return new EqualNullSafe((Expression)attributeReference, (Expression)Literal$.MODULE$.TrueLiteral());
        }
        if (booleanType$ == null) return new EqualNullSafe((Expression)attributeReference, (Expression)Literal$.MODULE$.TrueLiteral());
        return expression;
    }

    private ExpressionTransformer replacePythonUDFWithExpressionTransformer(PythonUDF udf, Seq<Attribute> attributeSeq, Map<Class<?>, String> expressionsMap) {
        Option substraitExprName = UDFMappings$.MODULE$.pythonUDFMap().get((Object)udf.name());
        Option option = substraitExprName;
        if (!(option instanceof Some)) {
            throw new GlutenNotSupportException(new StringBuilder(27).append("Not supported python udf: ").append(udf).append(".").toString());
        }
        Some some = (Some)option;
        String name = (String)some.value();
        GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(name, (Seq<ExpressionTransformer>)((Seq)udf.children().map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$1, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), (Expression)udf);
        return genericExpressionTransformer;
    }

    private ExpressionTransformer replaceScalaUDFWithExpressionTransformer(ScalaUDF udf, Seq<Attribute> attributeSeq, Map<Class<?>, String> expressionsMap) {
        if (udf.udfName().isEmpty()) {
            throw new GlutenNotSupportException("UDF name is not found!");
        }
        Option substraitExprName = UDFMappings$.MODULE$.scalaUDFMap().get(udf.udfName().get());
        Option option = substraitExprName;
        if (!(option instanceof Some)) {
            throw new GlutenNotSupportException(new StringBuilder(26).append("Not supported scala udf: ").append(udf).append(".").toString());
        }
        Some some = (Some)option;
        String name = (String)some.value();
        GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(name, (Seq<ExpressionTransformer>)((Seq)udf.children().map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$2, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), (Expression)udf);
        return genericExpressionTransformer;
    }

    private DecimalArithmeticExpressionTransformer genRescaleDecimalTransformer(String substraitName, BinaryArithmetic b, Seq<Attribute> attributeSeq, Map<Class<?>, String> expressionsMap) {
        BinaryArithmetic rescaleBinary = DecimalArithmeticUtil$.MODULE$.rescaleLiteral(b);
        Tuple2<Expression, Expression> tuple2 = DecimalArithmeticUtil$.MODULE$.rescaleCastForDecimal(DecimalArithmeticUtil$.MODULE$.removeCastForDecimal((Expression)rescaleBinary.left()), DecimalArithmeticUtil$.MODULE$.removeCastForDecimal((Expression)rescaleBinary.right()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression left = (Expression)tuple2._1();
        Expression right = (Expression)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
        Tuple2 tuple23 = tuple22;
        Expression left2 = (Expression)tuple23._1();
        Expression right2 = (Expression)tuple23._2();
        DecimalType resultType = DecimalArithmeticUtil$.MODULE$.getResultType(b, (DecimalType)left2.dataType(), (DecimalType)right2.dataType());
        ExpressionTransformer leftChild = this.replaceWithExpressionTransformer0(left2, attributeSeq, expressionsMap);
        ExpressionTransformer rightChild = this.replaceWithExpressionTransformer0(right2, attributeSeq, expressionsMap);
        return new DecimalArithmeticExpressionTransformer(substraitName, leftChild, rightChild, resultType, (Expression)b);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExpressionTransformer replaceWithExpressionTransformer0(Expression expr2, Seq<Attribute> attributeSeq, Map<Class<?>, String> expressionsMap) {
        Expression a;
        Expression a2;
        Expression a3;
        BinaryArithmetic binaryArithmetic;
        boolean bl;
        void var5_100;
        Expression expression;
        TryEval tryEval;
        boolean bl2;
        CheckOverflow checkOverflow;
        boolean bl3;
        String substraitExprName;
        while (true) {
            PromotePrecision promotePrecision;
            Expression expression2;
            Round round;
            BoxedUnit boxedUnit;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("replaceWithExpressionTransformer expr: ").append(expr2).append(" class: ").append(expr2.getClass()).append(" ").append("name: ").append(expr2.prettyName()).toString());
            Expression expression3 = expr2;
            if (expression3 instanceof PythonUDF) {
                PythonUDF pythonUDF = (PythonUDF)expression3;
                return this.replacePythonUDFWithExpressionTransformer(pythonUDF, attributeSeq, expressionsMap);
            }
            if (expression3 instanceof ScalaUDF) {
                ScalaUDF scalaUDF = (ScalaUDF)expression3;
                return this.replaceScalaUDFWithExpressionTransformer(scalaUDF, attributeSeq, expressionsMap);
            }
            if (HiveUDFTransformer$.MODULE$.isHiveUDF(expr2)) {
                return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genHiveUDFTransformer(expr2, attributeSeq);
            }
            if (expression3 instanceof StaticInvoke) {
                StaticInvoke staticInvoke = (StaticInvoke)expression3;
                String objectName = new StringOps(Predef$.MODULE$.augmentString(staticInvoke.staticObject().getName())).stripSuffix("$");
                if (objectName.endsWith("UrlCodec")) {
                    Expression child = (Expression)staticInvoke.arguments().head();
                    String string = staticInvoke.functionName();
                    if ("decode".equals(string)) {
                        return new GenericExpressionTransformer("url_decode", (Seq<ExpressionTransformer>)child.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$4, attributeSeq, expressionsMap)), (Expression)staticInvoke);
                    }
                    if (!"encode".equals(string)) throw new MatchError((Object)string);
                    return new GenericExpressionTransformer("url_encode", (Seq<ExpressionTransformer>)child.map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$5, attributeSeq, expressionsMap)), (Expression)staticInvoke);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            substraitExprName = this.getAndCheckSubstraitName(expr2, expressionsMap);
            Option<ExpressionTransformer> backendConverted = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().extraExpressionConverter(substraitExprName, expr2, attributeSeq);
            if (backendConverted.isDefined()) {
                return (ExpressionTransformer)backendConverted.get();
            }
            bl3 = false;
            checkOverflow = null;
            bl2 = false;
            tryEval = null;
            expression = expr2;
            if (expression instanceof CreateArray) {
                CreateArray createArray = (CreateArray)expression;
                Seq children = (Seq)createArray.children().map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$6, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom());
                CreateArrayTransformer createArrayTransformer = new CreateArrayTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, createArray);
                return var5_100;
            }
            if (expression instanceof GetArrayItem) {
                GetArrayItem getArrayItem = (GetArrayItem)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genGetArrayItemTransformer(substraitExprName, this.replaceWithExpressionTransformer0(getArrayItem.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(getArrayItem.right(), attributeSeq, expressionsMap), (Expression)getArrayItem);
                return var5_100;
            }
            if (expression instanceof CreateMap) {
                CreateMap createMap = (CreateMap)expression;
                Seq children = (Seq)createMap.children().map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$7, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom());
                CreateMapTransformer createMapTransformer = new CreateMapTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, createMap);
                return var5_100;
            }
            if (expression instanceof GetMapValue) {
                GetMapValue getMapValue = (GetMapValue)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genGetMapValueTransformer(substraitExprName, this.replaceWithExpressionTransformer0(getMapValue.child(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(getMapValue.key(), attributeSeq, expressionsMap), getMapValue);
                return var5_100;
            }
            if (expression instanceof MapEntries) {
                MapEntries mapEntries = (MapEntries)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genMapEntriesTransformer(substraitExprName, this.replaceWithExpressionTransformer0(mapEntries.child(), attributeSeq, expressionsMap), (Expression)mapEntries);
                return var5_100;
            }
            if (expression instanceof Explode) {
                Explode explode = (Explode)expression;
                ExplodeTransformer explodeTransformer = new ExplodeTransformer(substraitExprName, this.replaceWithExpressionTransformer0(explode.child(), attributeSeq, expressionsMap), explode);
                return var5_100;
            }
            if (expression instanceof PosExplode) {
                PosExplode posExplode = (PosExplode)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genPosExplodeTransformer(substraitExprName, this.replaceWithExpressionTransformer0(posExplode.child(), attributeSeq, expressionsMap), posExplode, attributeSeq);
                return var5_100;
            }
            if (expression instanceof Inline) {
                Inline inline = (Inline)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genInlineTransformer(substraitExprName, this.replaceWithExpressionTransformer0(inline.child(), attributeSeq, expressionsMap), (Expression)inline);
                return var5_100;
            }
            if (expression instanceof Alias) {
                Alias alias = (Alias)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genAliasTransformer(substraitExprName, this.replaceWithExpressionTransformer0(alias.child(), attributeSeq, expressionsMap), (Expression)alias);
                return var5_100;
            }
            if (expression instanceof AttributeReference) {
                AttributeReferenceTransformer attributeReferenceTransformer;
                AttributeReference attributeReference = (AttributeReference)expression;
                if (attributeSeq == null) {
                    throw new UnsupportedOperationException("attributeSeq should not be null.");
                }
                try {
                    Expression bindReference = BindReferences$.MODULE$.bindReference(expr2, package$.MODULE$.AttributeSeq(attributeSeq), false);
                    BoundReference b = (BoundReference)bindReference;
                    attributeReferenceTransformer = new AttributeReferenceTransformer(substraitExprName, attributeReference, b);
                }
                catch (IllegalStateException e) {
                    throw new UnsupportedOperationException(new StringBuilder(31).append("Failed to bind reference for ").append(expr2).append(": ").append(e.getMessage()).toString());
                }
                AttributeReferenceTransformer attributeReferenceTransformer2 = attributeReferenceTransformer;
                return var5_100;
            }
            if (expression instanceof BoundReference) {
                BoundReference boundReference = (BoundReference)expression;
                BoundReferenceTransformer boundReferenceTransformer = new BoundReferenceTransformer(substraitExprName, boundReference);
                return var5_100;
            }
            if (expression instanceof Literal) {
                Literal literal = (Literal)expression;
                LiteralTransformer literalTransformer = new LiteralTransformer(literal);
                return var5_100;
            }
            if (expression instanceof DateDiff) {
                DateDiff dateDiff = (DateDiff)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genDateDiffTransformer(substraitExprName, this.replaceWithExpressionTransformer0(dateDiff.endDate(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(dateDiff.startDate(), attributeSeq, expressionsMap), dateDiff);
                return var5_100;
            }
            if (expression instanceof Round && (round = (Round)expression).child().dataType() instanceof DecimalType) {
                DecimalRoundTransformer decimalRoundTransformer = new DecimalRoundTransformer(substraitExprName, this.replaceWithExpressionTransformer0(round.child(), attributeSeq, expressionsMap), round);
                return var5_100;
            }
            if (expression instanceof ToUnixTimestamp) {
                ToUnixTimestamp toUnixTimestamp = (ToUnixTimestamp)expression;
                GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)this.replaceWithExpressionTransformer0(toUnixTimestamp.timeExp(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(toUnixTimestamp.format(), attributeSeq, expressionsMap), (List)Nil$.MODULE$))), (Expression)toUnixTimestamp);
                return var5_100;
            }
            if (expression instanceof UnixTimestamp) {
                UnixTimestamp unixTimestamp = (UnixTimestamp)expression;
                GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)this.replaceWithExpressionTransformer0(unixTimestamp.timeExp(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(unixTimestamp.format(), attributeSeq, expressionsMap), (List)Nil$.MODULE$))), (Expression)new ToUnixTimestamp(unixTimestamp.timeExp(), unixTimestamp.format(), unixTimestamp.timeZoneId(), unixTimestamp.failOnError()));
                return var5_100;
            }
            if (expression instanceof TruncTimestamp) {
                TruncTimestamp truncTimestamp = (TruncTimestamp)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTruncTimestampTransformer(substraitExprName, this.replaceWithExpressionTransformer0(truncTimestamp.format(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(truncTimestamp.timestamp(), attributeSeq, expressionsMap), (Option<String>)truncTimestamp.timeZoneId(), truncTimestamp);
                return var5_100;
            }
            if (expression instanceof MonthsBetween) {
                MonthsBetween monthsBetween = (MonthsBetween)expression;
                MonthsBetweenTransformer monthsBetweenTransformer = new MonthsBetweenTransformer(substraitExprName, this.replaceWithExpressionTransformer0(monthsBetween.date1(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(monthsBetween.date2(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(monthsBetween.roundOff(), attributeSeq, expressionsMap), monthsBetween);
                return var5_100;
            }
            if (expression instanceof If) {
                If if_ = (If)expression;
                IfTransformer ifTransformer = new IfTransformer(substraitExprName, this.replaceWithExpressionTransformer0(if_.predicate(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(if_.trueValue(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(if_.falseValue(), attributeSeq, expressionsMap), if_);
                return var5_100;
            }
            if (expression instanceof CaseWhen) {
                CaseWhen caseWhen = (CaseWhen)expression;
                CaseWhenTransformer caseWhenTransformer = new CaseWhenTransformer(substraitExprName, (Seq<Tuple2<ExpressionTransformer, ExpressionTransformer>>)((Seq)caseWhen.branches().map((Function1 & Serializable & scala.Serializable)expr -> new Tuple2((Object)MODULE$.replaceWithExpressionTransformer0((Expression)expr._1(), attributeSeq, expressionsMap), (Object)MODULE$.replaceWithExpressionTransformer0((Expression)expr._2(), attributeSeq, expressionsMap)), Seq$.MODULE$.canBuildFrom())), (Option<ExpressionTransformer>)caseWhen.elseValue().map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.replaceWithExpressionTransformer0((Expression)expr, attributeSeq, expressionsMap)), caseWhen);
                return var5_100;
            }
            if (expression instanceof In) {
                In in = (In)expression;
                if (in.list().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$replaceWithExpressionTransformer0$8(x$8)))) {
                    throw new GlutenNotSupportException(new StringBuilder(57).append("In list option does not support non-foldable expression, ").append(in.list().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.sql(), Seq$.MODULE$.canBuildFrom())).toString());
                }
                InTransformer inTransformer = new InTransformer(substraitExprName, this.replaceWithExpressionTransformer0(in.value(), attributeSeq, expressionsMap), in);
                return var5_100;
            }
            if (expression instanceof InSet) {
                InSet inSet = (InSet)expression;
                InSetTransformer inSetTransformer = new InSetTransformer(substraitExprName, this.replaceWithExpressionTransformer0(inSet.child(), attributeSeq, expressionsMap), inSet);
                return var5_100;
            }
            if (expression instanceof ScalarSubquery) {
                ScalarSubquery scalarSubquery = (ScalarSubquery)expression;
                ScalarSubqueryTransformer scalarSubqueryTransformer = new ScalarSubqueryTransformer(substraitExprName, scalarSubquery);
                return var5_100;
            }
            if (expression instanceof Cast) {
                Cast cast = (Cast)expression;
                Cast newCast = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genCastWithNewChild(cast);
                CastTransformer castTransformer = new CastTransformer(substraitExprName, this.replaceWithExpressionTransformer0(newCast.child(), attributeSeq, expressionsMap), newCast);
                return var5_100;
            }
            if (expression instanceof String2TrimExpression) {
                Tuple2 tuple2;
                String2TrimExpression string2TrimExpression = (String2TrimExpression)expression;
                String2TrimExpression string2TrimExpression2 = string2TrimExpression;
                if (string2TrimExpression2 instanceof StringTrim) {
                    StringTrim stringTrim = (StringTrim)string2TrimExpression2;
                    Expression srcStr = stringTrim.srcStr();
                    Option trimStr = stringTrim.trimStr();
                    tuple2 = new Tuple2((Object)srcStr, (Object)trimStr);
                } else if (string2TrimExpression2 instanceof StringTrimLeft) {
                    StringTrimLeft stringTrimLeft = (StringTrimLeft)string2TrimExpression2;
                    Expression srcStr = stringTrimLeft.srcStr();
                    Option trimStr = stringTrimLeft.trimStr();
                    tuple2 = new Tuple2((Object)srcStr, (Object)trimStr);
                } else {
                    if (!(string2TrimExpression2 instanceof StringTrimRight)) throw new MatchError((Object)string2TrimExpression2);
                    StringTrimRight stringTrimRight = (StringTrimRight)string2TrimExpression2;
                    Expression srcStr = stringTrimRight.srcStr();
                    Option trimStr = stringTrimRight.trimStr();
                    tuple2 = new Tuple2((Object)srcStr, (Object)trimStr);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                Expression srcStr = (Expression)tuple22._1();
                Option trimStr = (Option)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)srcStr, (Object)trimStr);
                Tuple2 tuple24 = tuple23;
                Expression srcStr2 = (Expression)tuple24._1();
                Option trimStr2 = (Option)tuple24._2();
                Seq children = (Seq)Option$.MODULE$.option2Iterable(trimStr2.map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$11, attributeSeq, expressionsMap))).toSeq().$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.replaceWithExpressionTransformer0(srcStr2, attributeSeq, expressionsMap), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
                GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, (Expression)string2TrimExpression);
                return var5_100;
            }
            if (expression instanceof HashExpression) {
                HashExpression hashExpression = (HashExpression)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genHashExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)hashExpression.children().map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.replaceWithExpressionTransformer0((Expression)expr, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), hashExpression);
                return var5_100;
            }
            if (expression instanceof GetStructField) {
                ExpressionTransformer expressionTransformer;
                GetStructField getStructField = (GetStructField)expression;
                try {
                    BoundReference bindRef = this.bindGetStructField(getStructField, package$.MODULE$.AttributeSeq(attributeSeq));
                    expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genGetStructFieldTransformer(substraitExprName, this.replaceWithExpressionTransformer0(getStructField.child(), attributeSeq, expressionsMap), bindRef.ordinal(), getStructField);
                }
                catch (IllegalStateException e) {
                    throw new UnsupportedOperationException(new StringBuilder(31).append("Failed to bind reference for ").append(getStructField).append(": ").append(e.getMessage()).toString());
                }
                ExpressionTransformer expressionTransformer2 = expressionTransformer;
                return var5_100;
            }
            if (expression instanceof GetArrayStructFields) {
                GetArrayStructFields getArrayStructFields = (GetArrayStructFields)expression;
                GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)this.replaceWithExpressionTransformer0(getArrayStructFields.child(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)LiteralTransformer$.MODULE$.apply(BoxesRunTime.boxToInteger((int)getArrayStructFields.ordinal())), (List)Nil$.MODULE$))), (Expression)getArrayStructFields);
                return var5_100;
            }
            if (expression instanceof StringTranslate) {
                StringTranslate stringTranslate = (StringTranslate)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genStringTranslateTransformer(substraitExprName, this.replaceWithExpressionTransformer0(stringTranslate.srcExpr(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringTranslate.matchingExpr(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringTranslate.replaceExpr(), attributeSeq, expressionsMap), stringTranslate);
                return var5_100;
            }
            if (expression instanceof RegExpReplace) {
                RegExpReplace regExpReplace = (RegExpReplace)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genRegexpReplaceTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.subject(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.regexp(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.rep(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.pos(), attributeSeq, expressionsMap), (List)Nil$.MODULE$))))), regExpReplace);
                return var5_100;
            }
            if (expression instanceof Size) {
                Size size = (Size)expression;
                ExpressionTransformer child = this.replaceWithExpressionTransformer0(size.child(), attributeSeq, expressionsMap);
                GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)child, (List)new .colon.colon((Object)LiteralTransformer$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)size.legacySizeOfNull())), (List)Nil$.MODULE$))), (Expression)size);
                return var5_100;
            }
            if (expression instanceof CreateNamedStruct) {
                CreateNamedStruct createNamedStruct = (CreateNamedStruct)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genNamedStructTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)createNamedStruct.children().map((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$12, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), createNamedStruct, attributeSeq);
                return var5_100;
            }
            if (expression instanceof NamedLambdaVariable) {
                NamedLambdaVariable namedLambdaVariable = (NamedLambdaVariable)expression;
                GenericExpressionTransformer genericExpressionTransformer = GenericExpressionTransformer$.MODULE$.apply(substraitExprName, LiteralTransformer$.MODULE$.apply(namedLambdaVariable.name()), (Expression)namedLambdaVariable);
                return var5_100;
            }
            if (expression instanceof LambdaFunction) {
                LambdaFunction lambdaFunction = (LambdaFunction)expression;
                LambdaFunctionTransformer lambdaFunctionTransformer = new LambdaFunctionTransformer(substraitExprName, this.replaceWithExpressionTransformer0(lambdaFunction.function(), attributeSeq, expressionsMap), (Seq<ExpressionTransformer>)((Seq)lambdaFunction.arguments().map((Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$13, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), lambdaFunction);
                return var5_100;
            }
            if (expression instanceof JsonTuple) {
                JsonTuple jsonTuple = (JsonTuple)expression;
                Seq children = (Seq)jsonTuple.children().map((Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$14, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom());
                JsonTupleExpressionTransformer jsonTupleExpressionTransformer = new JsonTupleExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, (Expression)jsonTuple);
                return var5_100;
            }
            if (expression instanceof Like) {
                Like like = (Like)expression;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genLikeTransformer(substraitExprName, this.replaceWithExpressionTransformer0(like.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(like.right(), attributeSeq, expressionsMap), like);
                return var5_100;
            }
            if (expression instanceof MakeDecimal) {
                MakeDecimal makeDecimal = (MakeDecimal)expression;
                GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)this.replaceWithExpressionTransformer0(makeDecimal.child(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)LiteralTransformer$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)makeDecimal.nullOnOverflow())), (List)Nil$.MODULE$))), (Expression)makeDecimal);
                return var5_100;
            }
            if (!(expression instanceof PromotePrecision) || !((expression2 = (promotePrecision = (PromotePrecision)expression).child()) instanceof Cast)) break;
            Cast cast = (Cast)expression2;
            Expression child = cast.child();
            if (!(cast.dataType() instanceof DecimalType) || !(child.dataType() instanceof DecimalType) || BackendsApiManager$.MODULE$.getSettings().transformCheckOverflow()) break;
            expr2 = child;
        }
        if (bl = expression instanceof NormalizeNaNAndZero ? true : (expression instanceof PromotePrecision ? true : (expression instanceof TaggingExpression ? true : expression instanceof DynamicPruningExpression))) {
            ChildTransformer childTransformer = new ChildTransformer(substraitExprName, this.replaceWithExpressionTransformer0((Expression)expr2.children().head(), attributeSeq, expressionsMap), expr2);
            return var5_100;
        }
        boolean bl4 = expression instanceof GetDateField ? true : expression instanceof GetTimeField;
        if (bl4) {
            ExtractDateTransformer extractDateTransformer = new ExtractDateTransformer(substraitExprName, this.replaceWithExpressionTransformer0((Expression)expr2.children().head(), attributeSeq, expressionsMap), expr2);
            return var5_100;
        }
        if (expression instanceof StringToMap) {
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genStringToMapTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)expr2.children().map((Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$15, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), expr2);
            return var5_100;
        }
        if (expression instanceof CheckOverflow) {
            bl3 = true;
            checkOverflow = (CheckOverflow)expression;
            Expression b = checkOverflow.child();
            DecimalType decimalType = checkOverflow.dataType();
            if (b instanceof BinaryArithmetic) {
                BinaryArithmetic binaryArithmetic2 = (BinaryArithmetic)b;
                if (!BackendsApiManager$.MODULE$.getSettings().transformCheckOverflow() && DecimalArithmeticUtil$.MODULE$.isDecimalArithmetic(binaryArithmetic2)) {
                    DecimalArithmeticUtil$.MODULE$.checkAllowDecimalArithmetic();
                    String arithmeticExprName = this.getAndCheckSubstraitName((Expression)binaryArithmetic2, expressionsMap);
                    ExpressionTransformer left = this.replaceWithExpressionTransformer0((Expression)binaryArithmetic2.left(), attributeSeq, expressionsMap);
                    ExpressionTransformer right = this.replaceWithExpressionTransformer0((Expression)binaryArithmetic2.right(), attributeSeq, expressionsMap);
                    DecimalArithmeticExpressionTransformer decimalArithmeticExpressionTransformer = new DecimalArithmeticExpressionTransformer(arithmeticExprName, left, right, decimalType, (Expression)binaryArithmetic2);
                    return var5_100;
                }
            }
        }
        if (bl3) {
            CheckOverflowTransformer checkOverflowTransformer = new CheckOverflowTransformer(substraitExprName, this.replaceWithExpressionTransformer0(checkOverflow.child(), attributeSeq, expressionsMap), checkOverflow);
            return var5_100;
        }
        if (expression.getClass().getSimpleName().equals("CheckOverflowInTableInsert")) {
            throw new GlutenNotSupportException("CheckOverflowInTableInsert is used in ANSI mode, but Gluten does not support ANSI mode.");
        }
        if (expression instanceof BinaryArithmetic && DecimalArithmeticUtil$.MODULE$.isDecimalArithmetic(binaryArithmetic = (BinaryArithmetic)expression)) {
            DecimalArithmeticUtil$.MODULE$.checkAllowDecimalArithmetic();
            ExpressionTransformer expressionTransformer = !BackendsApiManager$.MODULE$.getSettings().transformCheckOverflow() ? new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)expr2.children().map((Function1 & Serializable & scala.Serializable)x$16 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$16, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), expr2) : this.genRescaleDecimalTransformer(substraitExprName, binaryArithmetic, attributeSeq, expressionsMap);
            return var5_100;
        }
        if (expression instanceof NaNvl) {
            NaNvl naNvl = (NaNvl)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genNaNvlTransformer(substraitExprName, this.replaceWithExpressionTransformer0(naNvl.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(naNvl.right(), attributeSeq, expressionsMap), naNvl);
            return var5_100;
        }
        if (expression instanceof AtLeastNNonNulls) {
            AtLeastNNonNulls atLeastNNonNulls = (AtLeastNNonNulls)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genAtLeastNNonNullsTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)atLeastNNonNulls.children().map((Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$17, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), atLeastNNonNulls);
            return var5_100;
        }
        if (expression instanceof MakeTimestamp) {
            MakeTimestamp makeTimestamp = (MakeTimestamp)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genMakeTimestampTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)makeTimestamp.children().map((Function1 & Serializable & scala.Serializable)x$18 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$18, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), (Expression)makeTimestamp);
            return var5_100;
        }
        if (expression.getClass().getSimpleName().equals("TimestampAdd")) {
            Option extract = SparkShimLoader$.MODULE$.getSparkShims().extractExpressionTimestampAddUnit(expression);
            if (extract.isEmpty()) {
                throw new UnsupportedOperationException("Not support expression TimestampAdd.");
            }
            BinaryExpression add = (BinaryExpression)expression;
            TimestampAddTransformer timestampAddTransformer = new TimestampAddTransformer(substraitExprName, (String)((IterableLike)extract.get()).head(), this.replaceWithExpressionTransformer0((Expression)add.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0((Expression)add.right(), attributeSeq, expressionsMap), (String)((TraversableLike)extract.get()).last(), (Expression)add);
            return var5_100;
        }
        if (expression instanceof Transformable) {
            Expression expression4 = expression;
            Seq childrenTransformers = (Seq)expression4.children().map((Function1 & Serializable & scala.Serializable)x$19 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$19, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom());
            ExpressionTransformer expressionTransformer = ((Transformable)expression4).getTransformer((Seq<ExpressionTransformer>)childrenTransformers);
            return var5_100;
        }
        if (expression instanceof Uuid) {
            Uuid uuid = (Uuid)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genUuidTransformer(substraitExprName, uuid);
            return var5_100;
        }
        if (expression instanceof ArrayFilter) {
            ArrayFilter arrayFilter = (ArrayFilter)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayFilterTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayFilter.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayFilter.function(), attributeSeq, expressionsMap), arrayFilter);
            return var5_100;
        }
        if (expression instanceof ArrayTransform) {
            ArrayTransform arrayTransform = (ArrayTransform)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayTransformTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayTransform.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayTransform.function(), attributeSeq, expressionsMap), arrayTransform);
            return var5_100;
        }
        if (expression instanceof ArraySort) {
            ArraySort arraySort = (ArraySort)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArraySortTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arraySort.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arraySort.function(), attributeSeq, expressionsMap), arraySort);
            return var5_100;
        }
        if (expression instanceof TryEval) {
            bl2 = true;
            tryEval = (TryEval)expression;
            Expression a4 = tryEval.child();
            if (a4 instanceof Add) {
                Add add = (Add)a4;
                ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(add.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(add.right(), attributeSeq, expressionsMap), tryEval, "checked_add");
                return var5_100;
            }
        }
        if (bl2 && (a3 = tryEval.child()) instanceof Subtract) {
            Subtract subtract = (Subtract)a3;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(subtract.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(subtract.right(), attributeSeq, expressionsMap), tryEval, "checked_subtract");
            return var5_100;
        }
        if (bl2 && (a2 = tryEval.child()) instanceof Divide) {
            Divide divide = (Divide)a2;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(divide.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(divide.right(), attributeSeq, expressionsMap), tryEval, "checked_divide");
            return var5_100;
        }
        if (bl2 && (a = tryEval.child()) instanceof Multiply) {
            Multiply multiply = (Multiply)a;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(multiply.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(multiply.right(), attributeSeq, expressionsMap), tryEval, "checked_multiply");
            return var5_100;
        }
        if (expression instanceof Add) {
            Add add = (Add)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(add.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(add.right(), attributeSeq, expressionsMap), (Expression)add, "checked_add");
            return var5_100;
        }
        if (expression instanceof Subtract) {
            Subtract subtract = (Subtract)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(subtract.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(subtract.right(), attributeSeq, expressionsMap), (Expression)subtract, "checked_subtract");
            return var5_100;
        }
        if (expression instanceof Multiply) {
            Multiply multiply = (Multiply)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(multiply.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(multiply.right(), attributeSeq, expressionsMap), (Expression)multiply, "checked_multiply");
            return var5_100;
        }
        if (expression instanceof Divide) {
            Divide divide = (Divide)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(divide.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(divide.right(), attributeSeq, expressionsMap), (Expression)divide, "checked_divide");
            return var5_100;
        }
        if (bl2) {
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryEvalTransformer(substraitExprName, this.replaceWithExpressionTransformer0(tryEval.child(), attributeSeq, expressionsMap), tryEval);
            return var5_100;
        }
        if (expression instanceof ArrayForAll) {
            ArrayForAll arrayForAll = (ArrayForAll)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayForAllTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayForAll.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayForAll.function(), attributeSeq, expressionsMap), arrayForAll);
            return var5_100;
        }
        if (expression instanceof ArrayExists) {
            ArrayExists arrayExists = (ArrayExists)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayExistsTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayExists.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayExists.function(), attributeSeq, expressionsMap), arrayExists);
            return var5_100;
        }
        if (expression.getClass().getSimpleName().equals("ArrayInsert")) {
            Seq children = SparkShimLoader$.MODULE$.getSparkShims().extractExpressionArrayInsert(expression);
            GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)children.map((Function1 & Serializable & scala.Serializable)x$20 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$20, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), expression);
            return var5_100;
        }
        if (expression instanceof Shuffle) {
            Shuffle shuffle = (Shuffle)expression;
            GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)this.replaceWithExpressionTransformer0(shuffle.child(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)new LiteralTransformer(Literal$.MODULE$.apply(shuffle.randomSeed().get())), (List)Nil$.MODULE$))), (Expression)shuffle);
            return var5_100;
        }
        if (expression instanceof PreciseTimestampConversion) {
            PreciseTimestampConversion preciseTimestampConversion = (PreciseTimestampConversion)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genPreciseTimestampConversionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)new .colon.colon((Object)this.replaceWithExpressionTransformer0(preciseTimestampConversion.child(), attributeSeq, expressionsMap), (List)Nil$.MODULE$)), preciseTimestampConversion);
            return var5_100;
        }
        if (expression instanceof TransformKeys) {
            String mapKeyDedupPolicy;
            TransformKeys transformKeys = (TransformKeys)expression;
            String string = mapKeyDedupPolicy = (String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.MAP_KEY_DEDUP_POLICY());
            String string2 = SQLConf.MapKeyDedupPolicy$.MODULE$.LAST_WIN().toString();
            if (string == null) {
                if (string2 == null) throw new GlutenNotSupportException("LAST_WIN policy is not supported yet in native to deduplicate map keys");
            } else if (string.equals(string2)) {
                throw new GlutenNotSupportException("LAST_WIN policy is not supported yet in native to deduplicate map keys");
            }
            GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)transformKeys.children().map((Function1 & Serializable & scala.Serializable)x$21 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$21, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), (Expression)transformKeys);
            return var5_100;
        }
        if (expression instanceof EulerNumber) {
            LiteralTransformer literalTransformer = new LiteralTransformer(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Math.E)));
            return var5_100;
        }
        if (expression instanceof Pi) {
            LiteralTransformer literalTransformer = new LiteralTransformer(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Math.PI)));
            return var5_100;
        }
        if (expression instanceof SparkVersion) {
            LiteralTransformer literalTransformer = LiteralTransformer$.MODULE$.apply(new StringBuilder(1).append(org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()).append(" ").append(org.apache.spark.package$.MODULE$.SPARK_REVISION()).toString());
            return var5_100;
        }
        if (expression instanceof DateAdd) {
            DateAdd dateAdd = (DateAdd)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genDateAddTransformer(attributeSeq, substraitExprName, (Seq<Expression>)dateAdd.children(), (Expression)dateAdd);
            return var5_100;
        }
        if (expression instanceof TimeAdd) {
            TimeAdd timeAdd = (TimeAdd)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genDateAddTransformer(attributeSeq, substraitExprName, (Seq<Expression>)timeAdd.children(), (Expression)timeAdd);
            return var5_100;
        }
        if (expression instanceof StringSplit) {
            StringSplit stringSplit = (StringSplit)expression;
            ExpressionTransformer expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genStringSplitTransformer(substraitExprName, this.replaceWithExpressionTransformer0(stringSplit.str(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringSplit.regex(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringSplit.limit(), attributeSeq, expressionsMap), stringSplit);
            return var5_100;
        }
        GenericExpressionTransformer genericExpressionTransformer = new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)expression.children().map((Function1 & Serializable & scala.Serializable)x$22 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$22, attributeSeq, expressionsMap), Seq$.MODULE$.canBuildFrom())), expression);
        return var5_100;
    }

    private String getAndCheckSubstraitName(Expression expr, Map<Class<?>, String> expressionsMap) {
        TestStats.addExpressionClassName(expr.getClass().getName());
        Option substraitExprNameOpt = expressionsMap.get((Object)expr.getClass());
        if (substraitExprNameOpt.isEmpty()) {
            throw new GlutenNotSupportException(new StringBuilder(84).append("Not supported to map spark function name").append(" to substrait function name: ").append(expr).append(", class name: ").append(expr.getClass().getSimpleName()).append(".").toString());
        }
        String substraitExprName = (String)substraitExprNameOpt.get();
        if (!BackendsApiManager$.MODULE$.getValidatorApiInstance().doExprValidate(substraitExprName, expr)) {
            throw new GlutenNotSupportException(new StringBuilder(16).append("Not supported: ").append(expr).append(".").toString());
        }
        return substraitExprName;
    }

    private BoundReference bindGetStructField(GetStructField structField, package.AttributeSeq input) {
        IntRef newOrdinal = IntRef.create((int)-1);
        ArrayBuffer names = new ArrayBuffer();
        GetStructField root = structField;
        while (root instanceof GetStructField) {
            GetStructField curField = root;
            String name = curField.childSchema().fields()[curField.ordinal()].name();
            names.$plus$eq((Object)name);
            root = root.child();
        }
        if (!(root instanceof AttributeReference)) {
            return new BoundReference(structField.ordinal(), structField.dataType(), structField.nullable());
        }
        names.$plus$eq((Object)((AttributeReference)root).name());
        input.attrs().foreach((Function1 & Serializable & scala.Serializable)attribute -> {
            ExpressionConverter$.$anonfun$bindGetStructField$1(names, newOrdinal, attribute);
            return BoxedUnit.UNIT;
        });
        if (newOrdinal.elem == -1) {
            throw new IllegalStateException(new StringBuilder(18).append("Couldn't find ").append(structField).append(" in ").append(input.attrs().mkString("[", ",", "]")).toString());
        }
        return new BoundReference(newOrdinal.elem, structField.dataType(), structField.nullable());
    }

    public static final /* synthetic */ boolean $anonfun$replaceWithExpressionTransformer0$8(Expression x$8) {
        return !x$8.foldable();
    }

    public static final /* synthetic */ void $anonfun$bindGetStructField$1(ArrayBuffer names$1, IntRef newOrdinal$1, Attribute attribute) {
        int level = names$1.size() - 1;
        Object object = names$1.apply(level);
        String string = attribute.name();
        if (!(object != null ? !object.equals(string) : string != null)) {
            ObjectRef candidateFields = ObjectRef.create(null);
            ObjectRef dtType = ObjectRef.create((Object)attribute.dataType());
            while ((DataType)dtType.elem instanceof StructType && level >= 1) {
                candidateFields.elem = ((StructType)((DataType)dtType.elem)).fields();
                String curName = (String)names$1.apply(--level);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((StructField[])candidateFields.elem).length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    block0: {
                        String string = ((StructField[])candidateFields$1.elem)[i].name();
                        String string2 = curName;
                        if (string != null ? !string.equals(string2) : string2 != null) break block0;
                        dtType$1.elem = ((StructField[])candidateFields$1.elem)[i].dataType();
                        newOrdinal$1.elem = i;
                    }
                });
            }
        }
    }

    private ExpressionConverter$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
        Logging.$init$((Logging)this);
    }
}

