/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.candidate;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.recommendation.candidate.LayoutMetric;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;

public class RawRecItemTable
extends SqlTable {
    public final SqlColumn<Integer> id = this.column("id", JDBCType.INTEGER);
    public final SqlColumn<String> project = this.column("project", JDBCType.VARCHAR);
    public final SqlColumn<String> modelID = this.column("model_id", JDBCType.VARCHAR);
    public final SqlColumn<String> uniqueFlag = this.column("unique_flag", JDBCType.VARCHAR);
    public final SqlColumn<Integer> semanticVersion = this.column("semantic_version", JDBCType.INTEGER);
    public final SqlColumn<RawRecItem.RawRecType> type = this.column("type", JDBCType.TINYINT, RecTypeHandler.class.getName());
    public final SqlColumn<RecItemV2> recEntity = this.column("rec_entity", JDBCType.VARCHAR, RecItemV2Handler.class.getName());
    public final SqlColumn<int[]> dependIDs = this.column("depend_ids", JDBCType.VARCHAR, DependIdHandler.class.getName());
    public final SqlColumn<Long> mvcc = this.column("mvcc", JDBCType.BIGINT);
    public final SqlColumn<LayoutMetric> layoutMetric = this.column("layout_metric", JDBCType.VARCHAR, LayoutMetricHandler.class.getName());
    public final SqlColumn<Double> cost = this.column("cost", JDBCType.DOUBLE);
    public final SqlColumn<Double> totalLatencyOfLastDay = this.column("total_latency_of_last_day", JDBCType.DOUBLE);
    public final SqlColumn<Integer> hitCount = this.column("hit_count", JDBCType.INTEGER);
    public final SqlColumn<Double> totalTime = this.column("total_time", JDBCType.DOUBLE);
    public final SqlColumn<Double> maxTime = this.column("max_time", JDBCType.DOUBLE);
    public final SqlColumn<Double> minTime = this.column("min_time", JDBCType.DOUBLE);
    public final SqlColumn<String> queryHistoryInfo = this.column("query_history_info", JDBCType.VARCHAR);
    public final SqlColumn<RawRecItem.RawRecState> state = this.column("state", JDBCType.TINYINT, RecStateHandler.class.getName());
    public final SqlColumn<Long> createTime = this.column("create_time", JDBCType.BIGINT);
    public final SqlColumn<Long> updateTime = this.column("update_time", JDBCType.BIGINT);
    public final SqlColumn<String> recSource = this.column("reserved_field_1", JDBCType.VARCHAR);

    public RawRecItemTable(String tableName) {
        super(tableName);
    }

    public static class LayoutMetricHandler
    implements TypeHandler<LayoutMetric> {
        public void setParameter(PreparedStatement ps, int i, LayoutMetric parameter, JdbcType jdbcType) throws SQLException {
            try {
                ps.setString(i, parameter == null ? null : JsonUtil.writeValueAsString((Object)parameter));
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("cannot serialize layoutMetric", (Throwable)e);
            }
        }

        public LayoutMetric getResult(ResultSet rs, String columnName) throws SQLException {
            return this.toLayoutMetric(rs.getString(columnName));
        }

        public LayoutMetric getResult(ResultSet rs, int columnIndex) throws SQLException {
            return this.toLayoutMetric(rs.getString(columnIndex));
        }

        public LayoutMetric getResult(CallableStatement cs, int columnIndex) throws SQLException {
            return this.toLayoutMetric(cs.getString(columnIndex));
        }

        public LayoutMetric toLayoutMetric(String jsonString) {
            if (StringUtils.isEmpty((CharSequence)jsonString)) {
                return null;
            }
            try {
                return (LayoutMetric)JsonUtil.readValue((String)jsonString, LayoutMetric.class);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot deserialize layout metric correctly", e);
            }
        }
    }

    public static class DependIdHandler
    implements TypeHandler<int[]> {
        public void setParameter(PreparedStatement ps, int i, int[] parameter, JdbcType jdbcType) throws SQLException {
            Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (Object)"dependIDs cannot be null");
            try {
                ps.setString(i, JsonUtil.writeValueAsString((Object)parameter));
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("cannot serialize dependIDs", (Throwable)e);
            }
        }

        public int[] getResult(ResultSet rs, String columnName) throws SQLException {
            return RawRecItem.toDependIds(rs.getString(columnName));
        }

        public int[] getResult(ResultSet rs, int columnIndex) throws SQLException {
            return RawRecItem.toDependIds(rs.getString(columnIndex));
        }

        public int[] getResult(CallableStatement cs, int columnIndex) throws SQLException {
            return RawRecItem.toDependIds(cs.getString(columnIndex));
        }
    }

    public static class RecItemV2Handler
    implements TypeHandler<RecItemV2> {
        private static final String REC_TYPE = "type";

        public void setParameter(PreparedStatement ps, int i, RecItemV2 parameter, JdbcType jdbcType) throws SQLException {
            Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (Object)"recommendation entity cannot be null");
            try {
                ps.setString(i, JsonUtil.writeValueAsString((Object)parameter));
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("cannot serialize recEntity", (Throwable)e);
            }
        }

        public RecItemV2 getResult(ResultSet rs, String columnName) throws SQLException {
            return RawRecItem.toRecItem(rs.getString(columnName), rs.getByte(REC_TYPE));
        }

        public RecItemV2 getResult(ResultSet rs, int columnIndex) throws SQLException {
            return RawRecItem.toRecItem(rs.getString(columnIndex), rs.getByte(REC_TYPE));
        }

        public RecItemV2 getResult(CallableStatement cs, int columnIndex) throws SQLException {
            return RawRecItem.toRecItem(cs.getString(columnIndex), cs.getByte(REC_TYPE));
        }
    }

    public static class RecStateHandler
    implements TypeHandler<RawRecItem.RawRecState> {
        public void setParameter(PreparedStatement ps, int i, RawRecItem.RawRecState parameter, JdbcType jdbcType) throws SQLException {
            Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (Object)"recommendation state cannot be null");
            ps.setByte(i, (byte)parameter.id());
        }

        public RawRecItem.RawRecState getResult(ResultSet rs, String columnName) throws SQLException {
            return RawRecItem.toRecState(rs.getByte(columnName));
        }

        public RawRecItem.RawRecState getResult(ResultSet rs, int columnIndex) throws SQLException {
            return RawRecItem.toRecState(rs.getByte(columnIndex));
        }

        public RawRecItem.RawRecState getResult(CallableStatement cs, int columnIndex) throws SQLException {
            return RawRecItem.toRecState(cs.getByte(columnIndex));
        }
    }

    public static class RecTypeHandler
    implements TypeHandler<RawRecItem.RawRecType> {
        public void setParameter(PreparedStatement ps, int i, RawRecItem.RawRecType parameter, JdbcType jdbcType) throws SQLException {
            Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (Object)"recommendation type cannot be null");
            ps.setByte(i, (byte)parameter.id());
        }

        public RawRecItem.RawRecType getResult(ResultSet rs, String columnName) throws SQLException {
            return RawRecItem.toRecType(rs.getByte(columnName));
        }

        public RawRecItem.RawRecType getResult(ResultSet rs, int columnIndex) throws SQLException {
            return RawRecItem.toRecType(rs.getByte(columnIndex));
        }

        public RawRecItem.RawRecType getResult(CallableStatement cs, int columnIndex) throws SQLException {
            return RawRecItem.toRecType(cs.getByte(columnIndex));
        }
    }
}

