/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;

public class TimeRange
implements Serializable {
    long start;
    long end;

    public TimeRange() {
    }

    public TimeRange(Long s, Long e) {
        this.start = s == null || s <= 0L ? 0L : s;
        this.end = e == null || e == Long.MAX_VALUE ? Long.MAX_VALUE : e;
        Preconditions.checkState((this.start <= this.end ? 1 : 0) != 0, (Object)this.getRangeCheckErrorMsg(this.start, this.end));
    }

    public TimeRange(Long s, Long e, Map<Integer, Long> offsetStart, Map<Integer, Long> offsetEnd) {
        this.start = s == null || s <= 0L ? 0L : s;
        this.end = e == null || e == Long.MAX_VALUE ? Long.MAX_VALUE : e;
        Preconditions.checkState((this.start <= this.end ? 1 : 0) != 0, (Object)this.getRangeCheckErrorMsg(this.start, this.end));
        for (Map.Entry<Integer, Long> entry : offsetStart.entrySet()) {
            Integer partition = entry.getKey();
            Long startOffset = offsetStart.get(partition);
            Long endOffset = offsetEnd.get(partition);
            Preconditions.checkState((startOffset <= endOffset ? 1 : 0) != 0, (Object)this.getRangeCheckErrorMsg(startOffset, endOffset));
        }
    }

    private String getRangeCheckErrorMsg(Long start, Long end) {
        return String.format(Locale.ROOT, "expect: start <= end, actually: %s <= %s", start, end);
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long duration() {
        return this.end - this.start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRange timeRange = (TimeRange)o;
        return this.start == timeRange.start && this.end == timeRange.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "TimeRange[" + this.start + "," + this.end + ").Time String[" + DateFormat.formatToTimeStr((long)this.start) + "," + DateFormat.formatToTimeStr((long)this.end) + "]";
    }
}

