/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetMapper;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetTable;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.InsertDSL;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class QueryHistoryIdOffsetStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryHistoryIdOffsetStore.class);
    public static final String QUERY_HISTORY_OFFSET = "_query_history_offset";
    private final QueryHistoryIdOffsetTable table;
    private final SqlSessionTemplate sqlSessionTemplate;
    private final DataSourceTransactionManager transactionManager;

    public QueryHistoryIdOffsetStore(KylinConfig config) throws Exception {
        this(config, QueryHistoryIdOffsetStore.genQueryHistoryIdOffsetTableName(config));
    }

    private QueryHistoryIdOffsetStore(KylinConfig config, String tableName) throws Exception {
        StorageURL url = config.getCoreMetadataDBUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.table = new QueryHistoryIdOffsetTable(tableName);
        this.transactionManager = JdbcDataSource.getTransactionManager((DataSource)dataSource);
        this.sqlSessionTemplate = new SqlSessionTemplate(QueryHistoryIdOffsetUtil.getSqlSessionFactory(dataSource, this.table.tableNameAtRuntime()));
    }

    private static String genQueryHistoryIdOffsetTableName(KylinConfig config) {
        StorageURL url = config.getCoreMetadataDBUrl();
        String tablePrefix = config.isUTEnv() ? "test_opt" : url.getIdentifier();
        return tablePrefix + QUERY_HISTORY_OFFSET;
    }

    public void save(QueryHistoryIdOffset offset) {
        InsertStatementProvider<QueryHistoryIdOffset> insertStatement;
        QueryHistoryIdOffsetMapper mapper = (QueryHistoryIdOffsetMapper)this.sqlSessionTemplate.getMapper(QueryHistoryIdOffsetMapper.class);
        int rows = mapper.insert(insertStatement = this.getInsertProvider(offset));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to insert query history offset for project (%s)", offset.getProject()));
        }
        log.debug("Insert one query history offset for project ({}) into database.", (Object)offset.getProject());
    }

    public void update(QueryHistoryIdOffset offset) {
        UpdateStatementProvider updateStatement;
        QueryHistoryIdOffsetMapper mapper = (QueryHistoryIdOffsetMapper)this.sqlSessionTemplate.getMapper(QueryHistoryIdOffsetMapper.class);
        int rows = mapper.update(updateStatement = this.getUpdateProvider(offset));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to update query history project for project (%s)", offset.getProject()));
        }
        log.debug("Update one query history offset for project ({})", (Object)offset.getProject());
    }

    public void updateWithoutCheckMvcc(QueryHistoryIdOffset offset) {
        UpdateStatementProvider updateStatement;
        QueryHistoryIdOffsetMapper mapper = (QueryHistoryIdOffsetMapper)this.sqlSessionTemplate.getMapper(QueryHistoryIdOffsetMapper.class);
        int rows = mapper.update(updateStatement = this.getUpdateWithoutCheckMvccProvider(offset));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to update query history project for project (%s)", offset.getProject()));
        }
        log.debug("Update one query history offset for project ({})", (Object)offset.getProject());
    }

    public QueryHistoryIdOffset queryByProject(String project, String type) {
        QueryHistoryIdOffsetMapper mapper = (QueryHistoryIdOffsetMapper)this.sqlSessionTemplate.getMapper(QueryHistoryIdOffsetMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByProjectStatementProvider(project, type);
        return mapper.selectOne(statementProvider);
    }

    public List<QueryHistoryIdOffset> queryAll() {
        QueryHistoryIdOffsetMapper mapper = (QueryHistoryIdOffsetMapper)this.sqlSessionTemplate.getMapper(QueryHistoryIdOffsetMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
        return mapper.selectMany(statementProvider);
    }

    public void deleteByProject(String project) {
        QueryHistoryIdOffsetMapper mapper = (QueryHistoryIdOffsetMapper)this.sqlSessionTemplate.getMapper(QueryHistoryIdOffsetMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        mapper.delete(deleteStatement);
        log.info("Delete query history offset for project ({})", (Object)project);
    }

    InsertStatementProvider<QueryHistoryIdOffset> getInsertProvider(QueryHistoryIdOffset offset) {
        InsertDSL provider = SqlBuilder.insert((Object)offset).into((SqlTable)this.table);
        return provider.map(this.table.project).toProperty("project").map(this.table.type).toProperty("type").map(this.table.offset).toProperty("offset").map(this.table.updateTime).toProperty("updateTime").map(this.table.createTime).toProperty("createTime").map(this.table.mvcc).toProperty("mvcc").build().render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider getUpdateProvider(QueryHistoryIdOffset offset) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.offset).equalTo(offset::getOffset).set(this.table.updateTime).equalTo(offset::getUpdateTime).set(this.table.mvcc).equalTo((Object)(offset.getMvcc() + 1L)).where(this.table.id, (VisitableCondition)SqlBuilder.isEqualTo(offset::getId), new AndOrCriteriaGroup[0])).and(this.table.mvcc, (VisitableCondition)SqlBuilder.isEqualTo(offset::getMvcc), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider getUpdateWithoutCheckMvccProvider(QueryHistoryIdOffset offset) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.offset).equalTo(offset::getOffset).set(this.table.updateTime).equalTo(offset::getUpdateTime).set(this.table.mvcc).equalTo((Object)(offset.getMvcc() + 1L)).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo(offset::getProject), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo(offset::getType), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByProjectStatementProvider(String project, String type) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)type), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectFields(QueryHistoryIdOffsetTable offsetTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{offsetTable.id, offsetTable.project, offsetTable.type, offsetTable.offset, offsetTable.updateTime, offsetTable.createTime, offsetTable.mvcc});
    }

    @Generated
    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

