/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.util.BitSets;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class IndexEntity
implements Serializable {
    public static final long TABLE_INDEX_START_ID = 20000000000L;
    public static final long INDEX_ID_STEP = 10000L;
    @JsonBackReference
    private IndexPlan indexPlan;
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="dimensions")
    private List<Integer> dimensions = Lists.newArrayList();
    @JsonProperty(value="measures")
    private List<Integer> measures = Lists.newArrayList();
    @JsonManagedReference
    @JsonProperty(value="layouts")
    private List<LayoutEntity> layouts = Lists.newArrayList();
    @JsonProperty(value="next_layout_offset")
    private long nextLayoutOffset = 1L;
    private final AtomicReference<Object> effectiveDimCols = new AtomicReference();
    private final AtomicReference<Object> effectiveMeasures = new AtomicReference();
    private final AtomicReference<Object> dimensionSet = new AtomicReference();
    private final AtomicReference<Object> measureSet = new AtomicReference();

    public static IndexEntity from(LayoutEntity layout) {
        IndexEntity index = new IndexEntity();
        index.setDimensions((List<Integer>)layout.getDimsIds());
        index.setMeasures((List<Integer>)layout.getMeasureIds());
        index.setLayouts(Lists.newArrayList((Object[])new LayoutEntity[]{layout}));
        index.setId(layout.getIndexId());
        layout.setIndex(index);
        return index;
    }

    private BiMap<Integer, TblColRef> initEffectiveDimCols() {
        return Maps.filterKeys(this.getModel().getEffectiveCols(), input -> input != null && this.getDimensionBitset().get(input.intValue()));
    }

    private ImmutableBiMap<Integer, NDataModel.Measure> initEffectiveMeasures() {
        NDataModel model = this.getModel();
        ImmutableBiMap.Builder measuresBuilder = ImmutableBiMap.builder();
        for (int m : this.measures) {
            if (!model.getEffectiveMeasures().containsKey((Object)m)) continue;
            measuresBuilder.put((Object)m, model.getEffectiveMeasures().get((Object)m));
        }
        return measuresBuilder.build();
    }

    public ImmutableBitSet getDimensionBitset() {
        return ImmutableBitSet.valueOf(this.dimensions);
    }

    public ImmutableBitSet getMeasureBitset() {
        return ImmutableBitSet.valueOf(this.measures);
    }

    private ImmutableSet<TblColRef> initDimensionSet() {
        return ImmutableSet.copyOf((Collection)this.getEffectiveDimCols().values());
    }

    private ImmutableSet<NDataModel.Measure> initMeasureSet() {
        return this.getEffectiveMeasures().values();
    }

    public boolean dimensionsDerive(Collection<Integer> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return true;
        }
        for (int fk : columnIds) {
            if (this.getEffectiveDimCols().containsKey((Object)fk)) continue;
            return false;
        }
        return true;
    }

    public boolean dimensionsDerive(Integer ... columnIds) {
        Integer[] integerArray = columnIds;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int fk = integerArray[i];
            if (this.getEffectiveDimCols().containsKey((Object)fk)) continue;
            return false;
        }
        return true;
    }

    public boolean fullyDerive(IndexEntity child) {
        if (!this.isTableIndex() == child.isTableIndex()) {
            return false;
        }
        if (this.totalFieldSize(child) >= this.totalFieldSize(this)) {
            return false;
        }
        return child.getDimensionBitset().andNot(this.getDimensionBitset()).isEmpty() && child.getMeasureBitset().andNot(this.getMeasureBitset()).isEmpty();
    }

    private int totalFieldSize(IndexEntity entity) {
        return entity.getDimensions().size() + entity.getMeasures().size();
    }

    public LayoutEntity getLastLayout() {
        List<LayoutEntity> existing = this.getLayouts();
        if (existing.isEmpty()) {
            return null;
        }
        return existing.get(existing.size() - 1);
    }

    public IndexPlan getIndexPlan() {
        return this.indexPlan;
    }

    public NDataModel getModel() {
        return this.indexPlan.getModel();
    }

    public void setIndexPlan(IndexPlan indexPlan) {
        this.checkIsNotCachedAndShared();
        this.indexPlan = indexPlan;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.checkIsNotCachedAndShared();
        this.id = id;
    }

    public List<Integer> getDimensions() {
        return this.getColIds(this.dimensions);
    }

    public void setDimensions(List<Integer> dimensions) {
        this.checkIsNotCachedAndShared();
        this.dimensions = dimensions;
    }

    public List<Integer> getMeasures() {
        return this.getColIds(this.measures);
    }

    public void setMeasures(List<Integer> measures) {
        this.checkIsNotCachedAndShared();
        this.measures = measures;
    }

    private List<Integer> getColIds(List<Integer> cols) {
        return this.isCachedAndShared() ? Lists.newArrayList(cols) : cols;
    }

    public List<LayoutEntity> getLayouts() {
        return this.isCachedAndShared() ? ImmutableList.copyOf(this.layouts) : this.layouts;
    }

    public LayoutEntity getLayout(long layoutId) {
        if (layoutId < this.id || layoutId >= this.id + 10000L) {
            return null;
        }
        return this.getLayouts().stream().filter(l -> l.getId() == layoutId).findFirst().orElse(null);
    }

    public void setLayouts(List<LayoutEntity> layouts) {
        this.checkIsNotCachedAndShared();
        this.layouts = layouts;
    }

    public boolean isCachedAndShared() {
        return this.indexPlan != null && this.indexPlan.isCachedAndShared();
    }

    public void checkIsNotCachedAndShared() {
        if (this.indexPlan != null) {
            this.indexPlan.checkIsNotCachedAndShared();
        }
    }

    public boolean isTableIndex() {
        return IndexEntity.isTableIndex(this.id);
    }

    public static boolean isTableIndex(long id) {
        return id >= 20000000000L;
    }

    public static boolean isAggIndex(long id) {
        return id >= 0L && !IndexEntity.isTableIndex(id);
    }

    public void removeLayouts(List<LayoutEntity> deprecatedLayouts, Predicate<LayoutEntity> isSkip, boolean deleteAuto, boolean deleteManual) {
        this.checkIsNotCachedAndShared();
        ArrayList toRemoveLayouts = Lists.newArrayList();
        for (LayoutEntity cuboidLayout : deprecatedLayouts) {
            LayoutEntity toRemoveLayout;
            if (isSkip != null && isSkip.test(cuboidLayout) || (toRemoveLayout = (LayoutEntity)this.getLayouts().stream().filter(originLayout -> Objects.equals(originLayout, cuboidLayout)).findFirst().orElse(null)) == null) continue;
            if (deleteAuto) {
                toRemoveLayout.setAuto(false);
            }
            if (deleteManual) {
                toRemoveLayout.setManual(false);
            }
            if (!toRemoveLayout.isExpired()) continue;
            toRemoveLayouts.add(toRemoveLayout);
        }
        this.getLayouts().removeAll(toRemoveLayouts);
    }

    public long searchNextAvailableLayoutId() {
        return this.searchNextAvailableLayoutId(this.getLayouts(), this.getId(), (int)this.getNextLayoutOffset());
    }

    public long searchNextAvailableLayoutId(List<LayoutEntity> existedLayouts, long baseId, int defaultOffset) {
        HashSet existedId = new HashSet();
        existedLayouts.forEach(l -> existedId.add(l.getId()));
        long candidateId = baseId + (long)defaultOffset;
        while (existedId.contains(candidateId)) {
            ++candidateId;
        }
        return candidateId;
    }

    public String toString() {
        return "IndexEntity{ Id=" + this.id + ", dimBitSet=" + this.getDimensionBitset() + ", measureBitSet=" + this.getMeasureBitset() + "}.";
    }

    public void assignId(long id) {
        this.id = id;
        int inc = 1;
        for (LayoutEntity layout : this.layouts) {
            layout.setId(id + (long)inc);
            ++inc;
        }
    }

    public void addLayout(LayoutEntity layout) {
        if (layout.notAssignId()) {
            layout.setId(this.getId() + this.getNextLayoutOffset());
            this.setNextLayoutOffset((this.getNextLayoutOffset() + 1L) % 10000L);
        }
        layout.setIndex(this);
        this.getLayouts().add(layout);
    }

    public IndexIdentifier createIndexIdentifier() {
        ArrayList dimensions = Lists.newArrayList(this.getDimensions());
        ArrayList measures = Lists.newArrayList(this.getMeasures());
        dimensions.sort(Integer::compareTo);
        measures.sort(Integer::compareTo);
        return new IndexIdentifier(dimensions, measures, this.isTableIndex());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexEntity)) {
            return false;
        }
        IndexEntity other = (IndexEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        List<Integer> this$dimensions = this.getDimensions();
        List<Integer> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        List<Integer> this$measures = this.getMeasures();
        List<Integer> other$measures = other.getMeasures();
        if (this$measures == null ? other$measures != null : !((Object)this$measures).equals(other$measures)) {
            return false;
        }
        List<LayoutEntity> this$layouts = this.getLayouts();
        List<LayoutEntity> other$layouts = other.getLayouts();
        return !(this$layouts == null ? other$layouts != null : !((Object)this$layouts).equals(other$layouts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        List<Integer> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        List<Integer> $measures = this.getMeasures();
        result = result * 59 + ($measures == null ? 43 : ((Object)$measures).hashCode());
        List<LayoutEntity> $layouts = this.getLayouts();
        result = result * 59 + ($layouts == null ? 43 : ((Object)$layouts).hashCode());
        return result;
    }

    @Generated
    public void setNextLayoutOffset(long nextLayoutOffset) {
        this.nextLayoutOffset = nextLayoutOffset;
    }

    @Generated
    public long getNextLayoutOffset() {
        return this.nextLayoutOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public BiMap<Integer, TblColRef> getEffectiveDimCols() {
        Object value = this.effectiveDimCols.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.effectiveDimCols;
            synchronized (atomicReference) {
                value = this.effectiveDimCols.get();
                if (value == null) {
                    BiMap<Integer, TblColRef> actualValue = this.initEffectiveDimCols();
                    value = actualValue == null ? this.effectiveDimCols : actualValue;
                    this.effectiveDimCols.set(value);
                }
            }
        }
        return (BiMap)(value == this.effectiveDimCols ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ImmutableBiMap<Integer, NDataModel.Measure> getEffectiveMeasures() {
        Object value = this.effectiveMeasures.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.effectiveMeasures;
            synchronized (atomicReference) {
                value = this.effectiveMeasures.get();
                if (value == null) {
                    ImmutableBiMap<Integer, NDataModel.Measure> actualValue = this.initEffectiveMeasures();
                    value = actualValue == null ? this.effectiveMeasures : actualValue;
                    this.effectiveMeasures.set(value);
                }
            }
        }
        return (ImmutableBiMap)(value == this.effectiveMeasures ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ImmutableSet<TblColRef> getDimensionSet() {
        Object value = this.dimensionSet.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.dimensionSet;
            synchronized (atomicReference) {
                value = this.dimensionSet.get();
                if (value == null) {
                    ImmutableSet<TblColRef> actualValue = this.initDimensionSet();
                    value = actualValue == null ? this.dimensionSet : actualValue;
                    this.dimensionSet.set(value);
                }
            }
        }
        return (ImmutableSet)(value == this.dimensionSet ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ImmutableSet<NDataModel.Measure> getMeasureSet() {
        Object value = this.measureSet.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.measureSet;
            synchronized (atomicReference) {
                value = this.measureSet.get();
                if (value == null) {
                    ImmutableSet<NDataModel.Measure> actualValue = this.initMeasureSet();
                    value = actualValue == null ? this.measureSet : actualValue;
                    this.measureSet.set(value);
                }
            }
        }
        return (ImmutableSet)(value == this.measureSet ? null : value);
    }

    public static class IndexIdentifier {
        int[] dims;
        int[] measures;
        boolean isTableIndex;
        private final AtomicReference<Object> dimBitSet = new AtomicReference();
        private final AtomicReference<Object> measureBitSet = new AtomicReference();

        public IndexIdentifier(List<Integer> dimBitSet, List<Integer> measureBitSet, boolean isTableIndex) {
            this(dimBitSet, measureBitSet);
            this.isTableIndex = isTableIndex;
        }

        IndexIdentifier(List<Integer> dimBitSet, List<Integer> measureBitSet) {
            this.dims = dimBitSet.stream().mapToInt(d -> d).toArray();
            this.measures = measureBitSet.stream().mapToInt(d -> d).toArray();
        }

        public String toString() {
            return "IndexEntity{dim=" + Arrays.toString(this.dims) + ", measure=" + Arrays.toString(this.measures) + ", isTableIndex=" + this.isTableIndex + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexIdentifier that = (IndexIdentifier)o;
            return this.isTableIndex == that.isTableIndex && Objects.equals(this.getDimBitSet(), that.getDimBitSet()) && Objects.equals(this.getMeasureBitSet(), that.getMeasureBitSet());
        }

        public int hashCode() {
            return Objects.hash(this.getDimBitSet(), this.getMeasureBitSet(), this.isTableIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        private BitSet getDimBitSet() {
            Object value = this.dimBitSet.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.dimBitSet;
                synchronized (atomicReference) {
                    value = this.dimBitSet.get();
                    if (value == null) {
                        BitSet actualValue = BitSets.valueOf((int[])this.dims);
                        value = actualValue == null ? this.dimBitSet : actualValue;
                        this.dimBitSet.set(value);
                    }
                }
            }
            return (BitSet)(value == this.dimBitSet ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        private BitSet getMeasureBitSet() {
            Object value = this.measureBitSet.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.measureBitSet;
                synchronized (atomicReference) {
                    value = this.measureBitSet.get();
                    if (value == null) {
                        BitSet actualValue = BitSets.valueOf((int[])this.measures);
                        value = actualValue == null ? this.measureBitSet : actualValue;
                        this.measureBitSet.set(value);
                    }
                }
            }
            return (BitSet)(value == this.measureBitSet ? null : value);
        }
    }

    public static enum Range {
        BATCH,
        STREAMING,
        HYBRID,
        EMPTY;

    }

    public static enum Source {
        RECOMMENDED_AGG_INDEX,
        RECOMMENDED_TABLE_INDEX,
        CUSTOM_AGG_INDEX,
        CUSTOM_TABLE_INDEX,
        BASE_AGG_INDEX,
        BASE_TABLE_INDEX;

    }

    public static enum Status {
        NO_BUILD,
        BUILDING,
        LOCKED,
        ONLINE;

    }
}

