/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Generated;
import org.apache.kylin.metadata.datatype.DataType;

public class DimensionRangeInfo
implements Serializable {
    @JsonProperty(value="min")
    private String min;
    @JsonProperty(value="max")
    private String max;

    public DimensionRangeInfo(String min, String max) {
        if (min == null && max != null || min != null && max == null) {
            throw new IllegalStateException();
        }
        this.min = min;
        this.max = max;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public DimensionRangeInfo merge(DimensionRangeInfo dimensionRangeInfo, DataType dataType) {
        String minValue = dataType.compare(this.min, dimensionRangeInfo.getMin()) < 0 ? this.min : dimensionRangeInfo.getMin();
        String maxValue = dataType.compare(this.max, dimensionRangeInfo.getMax()) > 0 ? this.max : dimensionRangeInfo.getMax();
        return new DimensionRangeInfo(minValue, maxValue);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionRangeInfo)) {
            return false;
        }
        DimensionRangeInfo other = (DimensionRangeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$min = this.getMin();
        String other$min = other.getMin();
        if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
            return false;
        }
        String this$max = this.getMax();
        String other$max = other.getMax();
        return !(this$max == null ? other$max != null : !this$max.equals(other$max));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DimensionRangeInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : $min.hashCode());
        String $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : $max.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DimensionRangeInfo(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    @Generated
    public DimensionRangeInfo() {
    }
}

