/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.cuboid.KECuboidSchedulerV1;
import org.apache.kylin.metadata.cube.cuboid.KECuboidSchedulerV2;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;

public abstract class CuboidScheduler
implements Serializable {
    protected final IndexPlan indexPlan;
    protected final RuleBasedIndex ruleBasedAggIndex;

    public static CuboidScheduler getInstance(IndexPlan indexPlan, RuleBasedIndex ruleBasedIndex, boolean skipAll) {
        if (ruleBasedIndex.getSchedulerVersion() == 1) {
            return new KECuboidSchedulerV1(indexPlan, ruleBasedIndex, skipAll);
        }
        if (ruleBasedIndex.getSchedulerVersion() == 2) {
            return new KECuboidSchedulerV2(indexPlan, ruleBasedIndex, skipAll);
        }
        throw new NotImplementedException("Not Support version " + ruleBasedIndex.getSchedulerVersion());
    }

    public static CuboidScheduler getInstance(IndexPlan indexPlan, RuleBasedIndex ruleBasedIndex) {
        return CuboidScheduler.getInstance(indexPlan, ruleBasedIndex, false);
    }

    protected CuboidScheduler(IndexPlan indexPlan, RuleBasedIndex ruleBasedAggIndex) {
        this.indexPlan = indexPlan;
        this.ruleBasedAggIndex = ruleBasedAggIndex == null ? indexPlan.getRuleBasedIndex() : ruleBasedAggIndex;
    }

    public abstract List<ColOrder> getAllColOrders();

    public abstract int getCuboidCount();

    public abstract void validateOrder();

    public abstract void updateOrder();

    public abstract List<ColOrder> calculateCuboidsForAggGroup(NAggregationGroup var1);

    public IndexPlan getIndexPlan() {
        return this.indexPlan;
    }

    public long getAggGroupCombinationSize() {
        return this.indexPlan.getConfig().getCubeAggrGroupMaxCombination();
    }

    protected ColOrder extractDimAndMeaFromBigInt(BigInteger bigInteger) {
        List<Integer> allDims = this.ruleBasedAggIndex.getDimensions();
        List<Integer> allMeas = this.ruleBasedAggIndex.getMeasures();
        return this.extractDimAndMeaFromBigInt(allDims, allMeas, bigInteger);
    }

    protected ColOrder extractDimAndMeaFromBigInt(List<Integer> allDims, List<Integer> allMeas, BigInteger bigInteger) {
        ArrayList dims = Lists.newArrayList();
        ArrayList meas = Lists.newArrayList();
        int size = allDims.size() + allMeas.size();
        for (int i = 0; i < size; ++i) {
            int shift = size - i - 1;
            if (!bigInteger.testBit(shift)) continue;
            if (i >= allDims.size()) {
                meas.add(allMeas.get(i - allDims.size()));
                continue;
            }
            dims.add(allDims.get(i));
        }
        return new ColOrder(dims, meas);
    }

    public static class ColOrder {
        private List<Integer> dimensions;
        private List<Integer> measures;

        public List<Integer> toList() {
            return Stream.concat(this.dimensions.stream(), this.measures.stream()).collect(Collectors.toList());
        }

        @Generated
        public List<Integer> getDimensions() {
            return this.dimensions;
        }

        @Generated
        public List<Integer> getMeasures() {
            return this.measures;
        }

        @Generated
        public void setDimensions(List<Integer> dimensions) {
            this.dimensions = dimensions;
        }

        @Generated
        public void setMeasures(List<Integer> measures) {
            this.measures = measures;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColOrder)) {
                return false;
            }
            ColOrder other = (ColOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$dimensions = this.getDimensions();
            List<Integer> other$dimensions = other.getDimensions();
            if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
                return false;
            }
            List<Integer> this$measures = this.getMeasures();
            List<Integer> other$measures = other.getMeasures();
            return !(this$measures == null ? other$measures != null : !((Object)this$measures).equals(other$measures));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColOrder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $dimensions = this.getDimensions();
            result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
            List<Integer> $measures = this.getMeasures();
            result = result * 59 + ($measures == null ? 43 : ((Object)$measures).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CuboidScheduler.ColOrder(dimensions=" + this.getDimensions() + ", measures=" + this.getMeasures() + ")";
        }

        @Generated
        public ColOrder(List<Integer> dimensions, List<Integer> measures) {
            this.dimensions = dimensions;
            this.measures = measures;
        }
    }
}

