/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerDimEnc
extends DimensionEncoding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(IntegerDimEnc.class);
    private static final long[] CAP = new long[]{0L, 127L, 32767L, 0x7FFFFFL, Integer.MAX_VALUE, 0x7FFFFFFFFFL, 0x7FFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, Long.MAX_VALUE};
    private static final long[] MASK = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    private static final long[] TAIL = new long[]{0L, 128L, 32768L, 0x800000L, 0x80000000L, 0x8000000000L, 0x800000000000L, 0x80000000000000L, Long.MIN_VALUE};
    public static final String ENCODING_NAME = "integer";
    private int fixedLen;
    private transient int avoidVerbose = 0;
    private transient int avoidVerbose2 = 0;

    public IntegerDimEnc() {
    }

    public IntegerDimEnc(int len) {
        if (len <= 0 || len >= CAP.length) {
            throw new IllegalArgumentException();
        }
        this.fixedLen = len;
    }

    @Override
    public int getLengthOfEncoding() {
        return this.fixedLen;
    }

    @Override
    public void encode(String valueStr, byte[] output, int outputOffset) {
        if (valueStr == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.fixedLen, (byte)-1);
            return;
        }
        long integer = Long.parseLong(valueStr);
        if ((integer > CAP[this.fixedLen] || integer < TAIL[this.fixedLen]) && this.avoidVerbose++ % 10000 == 0) {
            logger.warn("Expect at most " + this.fixedLen + " bytes, but got " + valueStr + ", will truncate, hit times:" + this.avoidVerbose);
        }
        if (integer == TAIL[this.fixedLen] && this.avoidVerbose2++ % 10000 == 0) {
            logger.warn("Value " + valueStr + " does not fit into " + this.fixedLen + " bytes ");
        }
        BytesUtil.writeLong((long)(integer + CAP[this.fixedLen]), (byte[])output, (int)outputOffset, (int)this.fixedLen);
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        boolean positive;
        if (IntegerDimEnc.isNull(bytes, offset, len)) {
            return null;
        }
        long integer = BytesUtil.readLong((byte[])bytes, (int)offset, (int)len) - CAP[this.fixedLen];
        boolean bl = positive = ((integer &= MASK[this.fixedLen]) & 128L << (this.fixedLen - 1 << 3)) == 0L;
        if (!positive) {
            integer |= MASK[this.fixedLen] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return String.valueOf(integer);
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new IntegerSerializer();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.fixedLen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixedLen = in.readShort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerDimEnc that = (IntegerDimEnc)o;
        return this.fixedLen == that.fixedLen;
    }

    public int hashCode() {
        return this.fixedLen;
    }

    static {
        for (int i = 1; i < TAIL.length; ++i) {
            long head = MASK[i] ^ 0xFFFFFFFFFFFFFFFFL;
            IntegerDimEnc.TAIL[i] = head | TAIL[i];
        }
    }

    public class IntegerSerializer
    extends DataTypeSerializer<Object> {
        private byte[] currentBuf() {
            byte[] buf = (byte[])this.current.get();
            if (buf == null) {
                buf = new byte[IntegerDimEnc.this.fixedLen];
                this.current.set(buf);
            }
            return buf;
        }

        public void serialize(Object value, ByteBuffer out) {
            byte[] buf = this.currentBuf();
            String valueStr = value == null ? null : value.toString();
            IntegerDimEnc.this.encode(valueStr, buf, 0);
            out.put(buf);
        }

        public Object deserialize(ByteBuffer in) {
            byte[] buf = this.currentBuf();
            in.get(buf);
            return IntegerDimEnc.this.decode(buf, 0, buf.length);
        }

        @Override
        public int peekLength(ByteBuffer in) {
            return IntegerDimEnc.this.fixedLen;
        }

        @Override
        public int maxLength() {
            return IntegerDimEnc.this.fixedLen;
        }

        @Override
        public int getStorageBytesEstimate() {
            return IntegerDimEnc.this.fixedLen;
        }

        @Override
        public Object valueOf(String str) {
            return str;
        }
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return IntegerDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new IntegerDimEnc(Integer.parseInt(args[0]));
        }
    }
}

