/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import lombok.Generated;
import org.apache.spark.scheduler.ContainerSchedulerManager;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QueryResourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryResourceService.class);

    public String getQueueName() {
        String queue = this.getContainerSchedulerManager().getQueueName();
        log.info("queueName={}", (Object)queue);
        return queue;
    }

    public QueryResource adjustQueryResource(QueryResource resource) {
        long mem;
        ContainerSchedulerManager manager = this.getContainerSchedulerManager();
        int cores = resource.getCores();
        long memory = resource.getMemory();
        int core = cores / manager.getExecutorCores();
        int adjustNum = (int)Math.min((long)core, mem = memory / manager.getExecutorMemory());
        if (adjustNum == 0) {
            return new QueryResource();
        }
        adjustNum = this.updateExecutorNum(adjustNum, resource.force);
        return new QueryResource(resource.queueName, manager.getExecutorCores() * adjustNum, manager.getExecutorMemory() * (long)adjustNum, resource.force);
    }

    private int updateExecutorNum(int num, boolean force) {
        ContainerSchedulerManager manager = this.getContainerSchedulerManager();
        if (num < 0) {
            num *= -1;
            int available = manager.getExecutorCount() - 1;
            return (num = Math.min(num, available)) == 0 ? 0 : manager.releaseExecutor(num, force).size() * -1;
        }
        return manager.requestExecutor(num) ? num : 0;
    }

    private ContainerSchedulerManager getContainerSchedulerManager() {
        return (ContainerSchedulerManager)SparderEnv.containerSchedulerManager().get();
    }

    public boolean isAvailable() {
        boolean available = SparderEnv.containerSchedulerManager().isDefined() && SparderEnv.isSparkAvailable();
        log.info("node is available={}", (Object)available);
        return available;
    }

    public static class QueryResource {
        private String queueName;
        private int cores;
        private long memory;
        private boolean force;

        @Generated
        public String getQueueName() {
            return this.queueName;
        }

        @Generated
        public int getCores() {
            return this.cores;
        }

        @Generated
        public long getMemory() {
            return this.memory;
        }

        @Generated
        public boolean isForce() {
            return this.force;
        }

        @Generated
        public void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Generated
        public void setCores(int cores) {
            this.cores = cores;
        }

        @Generated
        public void setMemory(long memory) {
            this.memory = memory;
        }

        @Generated
        public void setForce(boolean force) {
            this.force = force;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryResource)) {
                return false;
            }
            QueryResource other = (QueryResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$queueName = this.getQueueName();
            String other$queueName = other.getQueueName();
            if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
                return false;
            }
            if (this.getCores() != other.getCores()) {
                return false;
            }
            if (this.getMemory() != other.getMemory()) {
                return false;
            }
            return this.isForce() == other.isForce();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueryResource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $queueName = this.getQueueName();
            result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
            result = result * 59 + this.getCores();
            long $memory = this.getMemory();
            result = result * 59 + (int)($memory >>> 32 ^ $memory);
            result = result * 59 + (this.isForce() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "QueryResourceService.QueryResource(queueName=" + this.getQueueName() + ", cores=" + this.getCores() + ", memory=" + this.getMemory() + ", force=" + this.isForce() + ")";
        }

        @Generated
        public QueryResource(String queueName, int cores, long memory, boolean force) {
            this.queueName = queueName;
            this.cores = cores;
            this.memory = memory;
            this.force = force;
        }

        @Generated
        public QueryResource() {
        }
    }
}

