/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata.jdbc;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.ByteArrayTypeHandler;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.CompressionUtils;

public class ContentTypeHandler
extends ByteArrayTypeHandler {
    public byte[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        byte[] s = super.getNullableResult(rs, columnName);
        try {
            return CompressionUtils.decompress(s);
        }
        catch (Exception e) {
            throw new KylinRuntimeException("Can not compression the content!", e);
        }
    }

    public byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        byte[] s = super.getNullableResult(rs, columnIndex);
        try {
            return CompressionUtils.decompress(s);
        }
        catch (Exception e) {
            throw new KylinRuntimeException("Can not compression the content!", e);
        }
    }

    public byte[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        byte[] s = super.getNullableResult(cs, columnIndex);
        try {
            return CompressionUtils.decompress(s);
        }
        catch (Exception e) {
            throw new KylinRuntimeException("Can not compression the content!", e);
        }
    }
}

