/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.step.merge;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.SegmentExec;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.engine.spark.job.step.merge.MergeStage$;
import org.apache.kylin.engine.spark.job.step.merge.MergeStage$LayoutMergeTask$;
import org.apache.kylin.engine.spark.model.SegmentFlatTableDesc;
import org.apache.kylin.engine.spark.scheduler.JobRuntime;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.util.concurrent.RateLimiter;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.StorageListener;
import org.apache.spark.sql.datasource.storage.StorageStoreUtils$;
import org.apache.spark.sql.datasource.storage.WriteTaskStats;
import org.apache.spark.tracker.AppStatusContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc!B A\u0003\u0003\t\u0006\u0002\u00031\u0001\u0005\u000b\u0007I\u0011B1\t\u0011\u0015\u0004!\u0011!Q\u0001\n\tD\u0001B\u001a\u0001\u0003\u0006\u0004%Ia\u001a\u0005\te\u0002\u0011\t\u0011)A\u0005Q\")1\u000f\u0001C\u0001i\"9\u0011\u0010\u0001b\u0001\n+Q\bbBA\u0004\u0001\u0001\u0006ia\u001f\u0005\n\u0003\u0013\u0001!\u0019!C\u000b\u0003\u0017A\u0001\"!\u0007\u0001A\u00035\u0011Q\u0002\u0005\t\u00037\u0001!\u0019!C\u000bu\"9\u0011Q\u0004\u0001!\u0002\u001bY\b\"CA\u0010\u0001\t\u0007IQCA\u0011\u0011!\t\t\u0004\u0001Q\u0001\u000e\u0005\r\u0002\"CA\u001a\u0001\t\u0007IQCA\u001b\u0011!\t\u0019\u0005\u0001Q\u0001\u000e\u0005]\u0002\"CA#\u0001\t\u0007IQCA$\u0011!\t)\u0006\u0001Q\u0001\u000e\u0005%\u0003\u0002CA,\u0001\t\u0007IQ\u0003>\t\u000f\u0005e\u0003\u0001)A\u0007w\"A\u00111\f\u0001C\u0002\u0013U!\u0010C\u0004\u0002^\u0001\u0001\u000bQB>\t\u0013\u0005}\u0003A1A\u0005\u0016\u0005\u0005\u0004\u0002CA7\u0001\u0001\u0006i!a\u0019\t\u0013\u0005=\u0004A1A\u0005\u0016\u0005E\u0004\u0002CA@\u0001\u0001\u0006i!a\u001d\t\u0013\u0005\u0005\u0005A1A\u0005\u0016\u0005\r\u0005\u0002CAK\u0001\u0001\u0006i!!\"\t\u0013\u0005]\u0005A1A\u0005\u0012\u0005e\u0005\u0002CAX\u0001\u0001\u0006I!a'\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011\u0011\u0019\u0001\u0005\u0012\u0005\r\u0007bBAf\u0001\u0011%\u0011Q\u001a\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqAa'\u0001\t#\u0012i\nC\u0004\u0003$\u0002!\tF!*\t\u000f\t\r\b\u0001\"\u0015\u0003f\"9!\u0011\u001f\u0001\u0005\u0012\u0005\r\u0007b\u0002Bz\u0001\u0011E!Q\u001f\u0005\b\u0007\u0013\u0001A\u0011CAb\u0011\u001d\u0019Y\u0001\u0001C\u0001\u0007\u001b1a!a6\u0001\u0011\u0006e\u0007BCAwU\tU\r\u0011\"\u0001\u0002p\"Q!\u0011\u0002\u0016\u0003\u0012\u0003\u0006I!!=\t\rMTC\u0011\u0001B\u0006\u0011\u001d\u0011yA\u000bC!\u00033C\u0011B!\u0005+\u0003\u0003%\tAa\u0005\t\u0013\t]!&%A\u0005\u0002\te\u0001\u0002\u0003B\u0018U\u0005\u0005I\u0011\t>\t\u0013\tE\"&!A\u0005\u0002\tM\u0002\"\u0003B\u001eU\u0005\u0005I\u0011\u0001B\u001f\u0011%\u0011IEKA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003V)\n\t\u0011\"\u0001\u0003X!I!\u0011\r\u0016\u0002\u0002\u0013\u0005#1\r\u0005\n\u0005KR\u0013\u0011!C!\u0005OB\u0011B!\u001b+\u0003\u0003%\tEa\u001b\b\u0013\r\u0005\u0002!!A\t\u0012\r\rb!CAl\u0001\u0005\u0005\t\u0012CB\u0013\u0011\u0019\u0019(\b\"\u0001\u00042!I!Q\r\u001e\u0002\u0002\u0013\u0015#q\r\u0005\n\u0007gQ\u0014\u0011!CA\u0007kA\u0011b!\u000f;\u0003\u0003%\tia\u000f\u0003\u00155+'oZ3Ti\u0006<WM\u0003\u0002B\u0005\u0006)Q.\u001a:hK*\u00111\tR\u0001\u0005gR,\u0007O\u0003\u0002F\r\u0006\u0019!n\u001c2\u000b\u0005\u001dC\u0015!B:qCJ\\'BA%K\u0003\u0019)gnZ5oK*\u00111\nT\u0001\u0006Wfd\u0017N\u001c\u0006\u0003\u001b:\u000ba!\u00199bG\",'\"A(\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011\u0006\f\u0018\t\u0003'Zk\u0011\u0001\u0016\u0006\u0002+\u0006)1oY1mC&\u0011q\u000b\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eSV\"\u0001#\n\u0005m#%aC*fO6,g\u000e^#yK\u000e\u0004\"!\u00180\u000e\u0003\tK!a\u0018\"\u0003\u0013M#\u0018mZ3Fq\u0016\u001c\u0017A\u00036pE\u000e{g\u000e^3yiV\t!\r\u0005\u0002ZG&\u0011A\r\u0012\u0002\u000b'\u0016<W.\u001a8u\u0015>\u0014\u0017a\u00036pE\u000e{g\u000e^3yi\u0002\n1\u0002Z1uCN+w-\\3oiV\t\u0001\u000e\u0005\u0002ja6\t!N\u0003\u0002lY\u0006)Qn\u001c3fY*\u0011QN\\\u0001\u0005GV\u0014WM\u0003\u0002p\u0015\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0002rU\naa\nR1uCN+w-\\3oi\u0006aA-\u0019;b'\u0016<W.\u001a8uA\u00051A(\u001b8jiz\"2!^<y!\t1\b!D\u0001A\u0011\u0015\u0001W\u00011\u0001c\u0011\u00151W\u00011\u0001i\u0003\u0015QwNY%e+\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006!A.\u00198h\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003{\n11\u000b\u001e:j]\u001e\faA[8c\u0013\u0012\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014)\u000baaY8n[>t\u0017\u0002BA\f\u0003#\u00111bS=mS:\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013A\u00033bi\u00064Gn\\<JI\u0006YA-\u0019;bM2|w/\u00133!\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\t\t\u0019\u0003\u0005\u0003\u0002&\u00055RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0007M\fHN\u0003\u0002H\u0019&!\u0011qFA\u0014\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u00035\u0019\b/\u0019:l'\u0016\u001c8/[8oA\u0005\u0001\u0012\r\u001d9Ti\u0006$Xo]\"p]R,\u0007\u0010^\u000b\u0003\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0005\u0003{\tY#A\u0004ue\u0006\u001c7.\u001a:\n\t\u0005\u0005\u00131\b\u0002\u0011\u0003B\u00048\u000b^1ukN\u001cuN\u001c;fqR\f\u0011#\u00199q'R\fG/^:D_:$X\r\u001f;!\u0003\u001d\u0011XO\u001c;j[\u0016,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014G\u0003%\u00198\r[3ek2,'/\u0003\u0003\u0002T\u00055#A\u0003&pEJ+h\u000e^5nK\u0006A!/\u001e8uS6,\u0007%A\u0004qe>TWm\u0019;\u0002\u0011A\u0014xN[3di\u0002\n\u0011b]3h[\u0016tG/\u00133\u0002\u0015M,w-\\3oi&#\u0007%A\u0005eCR\fWj\u001c3fYV\u0011\u00111\r\t\u0005\u0003K\nI'\u0004\u0002\u0002h)\u00111N\\\u0005\u0005\u0003W\n9G\u0001\u0006O\t\u0006$\u0018-T8eK2\f!\u0002Z1uC6{G-\u001a7!\u0003-\u0019Ho\u001c:bO\u0016$\u0016\u0010]3\u0016\u0005\u0005M\u0004\u0003BA;\u0003wj!!a\u001e\u000b\t\u0005e\u0014qM\u0001\u000b\u001d\u0012\u000bG/Y'pI\u0016d\u0017\u0002BA?\u0003o\u0012q\u0002R1uCN#xN]1hKRK\b/Z\u0001\rgR|'/Y4f)f\u0004X\rI\u0001\tk:lWM]4fIV\u0011\u0011Q\u0011\t\u0006\u0003\u000f\u000b\t\n[\u0007\u0003\u0003\u0013SA!a#\u0002\u000e\u00069Q.\u001e;bE2,'bAAH)\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0007\u0005V4g-\u001a:\u0002\u0013UtW.\u001a:hK\u0012\u0004\u0013AE:qCJ\\7k\u00195fIVdWM\u001d)p_2,\"!a'\u0011\t\u0005u\u00151\u0016\b\u0005\u0003?\u000b9\u000bE\u0002\u0002\"Rk!!a)\u000b\u0007\u0005\u0015\u0006+\u0001\u0004=e>|GOP\u0005\u0004\u0003S#\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u00055&bAAU)\u0006\u00192\u000f]1sWN\u001b\u0007.\u001a3vY\u0016\u0014\bk\\8mA\u0005iq-\u001a;K_\n\u001cuN\u001c;fqR,\"!!.\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/G\u0003-\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8\n\t\u0005}\u0016\u0011\u0018\u0002\u0011'B\f'o[!qa2L7-\u0019;j_:\fA\"\\3sO\u0016Le\u000eZ5dKN$\"!!2\u0011\u0007M\u000b9-C\u0002\u0002JR\u0013A!\u00168ji\u0006YQ.\u001a:hK2\u000b\u0017p\\;u)\u0011\t)-a4\t\u000f\u0005E\u0007\u00051\u0001\u0002T\u0006!A/Y:l!\r\t)NK\u0007\u0002\u0001\tyA*Y=pkRlUM]4f)\u0006\u001c8n\u0005\u0005+%\u0006m\u0017\u0011]At!\u0011\t).!8\n\u0007\u0005}'L\u0001\u0003UCN\\\u0007cA*\u0002d&\u0019\u0011Q\u001d+\u0003\u000fA\u0013x\u000eZ;diB\u00191+!;\n\u0007\u0005-HK\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004he>,\b/\u001a3\u0016\u0005\u0005E\bCBAz\u0003{\u0014\u0019A\u0004\u0003\u0002v\u0006eh\u0002BAQ\u0003oL\u0011!V\u0005\u0004\u0003w$\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\u0014\tAA\u0002TKFT1!a?U!\rI'QA\u0005\u0004\u0005\u000fQ'a\u0003(ECR\fG*Y=pkR\f\u0001b\u001a:pkB,G\r\t\u000b\u0005\u0003'\u0014i\u0001C\u0004\u0002n6\u0002\r!!=\u0002\u0017\u001d,G\u000fV1tW\u0012+7oY\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0002T\nU\u0001\"CAw_A\u0005\t\u0019AAy\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0007+\t\u0005E(QD\u0016\u0003\u0005?\u0001BA!\t\u0003,5\u0011!1\u0005\u0006\u0005\u0005K\u00119#A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0006+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003.\t\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u000e\u0011\u0007M\u00139$C\u0002\u0003:Q\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0010\u0003FA\u00191K!\u0011\n\u0007\t\rCKA\u0002B]fD\u0011Ba\u00124\u0003\u0003\u0005\rA!\u000e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u0005\u0005\u0004\u0003P\tE#qH\u0007\u0003\u0003\u001bKAAa\u0015\u0002\u000e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IFa\u0018\u0011\u0007M\u0013Y&C\u0002\u0003^Q\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003HU\n\t\u00111\u0001\u0003@\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00036\u0005AAo\\*ue&tw\rF\u0001|\u0003\u0019)\u0017/^1mgR!!\u0011\fB7\u0011%\u00119\u0005OA\u0001\u0002\u0004\u0011y$A\u0006oK^,f.\u001b;fI\u0012\u001bF\u0003\u0002B:\u0005\u007f\u0002b!!\n\u0003v\te\u0014\u0002\u0002B<\u0003O\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002&\tm\u0014\u0002\u0002B?\u0003O\u00111AU8x\u0011\u001d\u0011\t)\ta\u0001\u0005\u0007\u000b\u0001\u0002\\1z_V$\u0018\n\u001a\t\u0004y\n\u0015\u0015b\u0001BD{\n!Aj\u001c8h\u0003=iWM]4f\t\u0006$\u0018\rT1z_V$HCBAc\u0005\u001b\u00139\nC\u0004\u0003\u0010\n\u0002\rA!%\u0002\r1\f\u0017p\\;u!\rI'1S\u0005\u0004\u0005+S'\u0001\u0004'bs>,H/\u00128uSRL\bb\u0002BME\u0001\u0007!1O\u0001\tk:LG/\u001a3E'\u0006q!/Z2pe\u0012$\u0016m]6J]\u001a|G\u0003BAc\u0005?CqA!)$\u0001\u0004\tY.A\u0001u\u00039qWm^*pkJ\u001cWm\u0015;biN$bAa*\u0003N\n=\u0007\u0003\u0002BU\u0005\u000ftAAa+\u0003D:!!Q\u0016Ba\u001d\u0011\u0011yKa0\u000f\t\tE&Q\u0018\b\u0005\u0005g\u0013YL\u0004\u0003\u00036\nef\u0002BAQ\u0005oK\u0011aT\u0005\u0003\u001b:K!a\u0013'\n\u0005%S\u0015BA$I\u0013\t)e)C\u0002\u0003F\u0012\u000b1bU3h[\u0016tG/\u0012=fG&!!\u0011\u001aBf\u0005-\u0019v.\u001e:dKN#\u0018\r^:\u000b\u0007\t\u0015G\tC\u0004\u0003\u0010\u0012\u0002\rA!%\t\u000f\tEG\u00051\u0001\u0003T\u00061qN]5hS:\u0004BA!6\u0003`6\u0011!q\u001b\u0006\u0005\u00053\u0014Y.A\u0004ti>\u0014\u0018mZ3\u000b\t\tu\u0017qE\u0001\u000bI\u0006$\u0018m]8ve\u000e,\u0017\u0002\u0002Bq\u0005/\u0014ab\u0016:ji\u0016$\u0016m]6Ti\u0006$8/\u0001\u0007d_2,XN\\%e\rVt7\r\u0006\u0003\u0002\u001c\n\u001d\bb\u0002BuK\u0001\u0007!1^\u0001\u0007G>d'+\u001a4\u0011\t\u0005\u0015$Q^\u0005\u0005\u0005_\f9GA\u0005UE2\u001cu\u000e\u001c*fM\u0006qQ.\u001a:hK\u001ac\u0017\r\u001e+bE2,\u0017AE4fiVsW.\u001a:hK\u00124E\u000bU1uQN,\"Aa>\u0011\r\u0005M\u0018Q B}!\u0011\u0011Yp!\u0002\u000e\u0005\tu(\u0002\u0002B\u0000\u0007\u0003\t!AZ:\u000b\u0007\r\rA*\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0007\u000f\u0011iP\u0001\u0003QCRD\u0017\u0001E7fe\u001e,7i\u001c7v[:\u0014\u0015\u0010^3t\u00035iWM]4f\t&l'+\u00198hKR\u00111q\u0002\t\t\u0007#\u00199\"a'\u0004\u001c5\u001111\u0003\u0006\u0004\u0007+y\u0018\u0001B;uS2LAa!\u0007\u0004\u0014\t\u0019Q*\u00199\u0011\u0007%\u001ci\"C\u0002\u0004 )\u0014!\u0003R5nK:\u001c\u0018n\u001c8SC:<W-\u00138g_\u0006yA*Y=pkRlUM]4f)\u0006\u001c8\u000eE\u0002\u0002Vj\u001aRAOB\u0014\u0003O\u0004\u0002b!\u000b\u0004.\u0005E\u00181[\u0007\u0003\u0007WQ1!!\u0012U\u0013\u0011\u0019yca\u000b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0004$\u0005)\u0011\r\u001d9msR!\u00111[B\u001c\u0011\u001d\ti/\u0010a\u0001\u0003c\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004>\r\r\u0003#B*\u0004@\u0005E\u0018bAB!)\n1q\n\u001d;j_:D\u0011b!\u0012?\u0003\u0003\u0005\r!a5\u0002\u0007a$\u0003\u0007")
public abstract class MergeStage
implements SegmentExec,
StageExec {
    private volatile MergeStage$LayoutMergeTask$ LayoutMergeTask$module;
    private final SegmentJob jobContext;
    private final NDataSegment dataSegment;
    private final String jobId;
    private final KylinConfig config;
    private final String dataflowId;
    private final SparkSession sparkSession;
    private final AppStatusContext appStatusContext;
    private final JobRuntime runtime;
    private final String project;
    private final String segmentId;
    private final NDataModel dataModel;
    private final NDataModel.DataStorageType storageType;
    private final Buffer<NDataSegment> unmerged;
    private final String sparkSchedulerPool;
    private String stageId;
    private volatile Option<Throwable> anonymousFailure;
    private LinkedBlockingQueue<SegmentExec.ResultType> pipe;
    private LinkedBlockingQueue<Option<Throwable>> failFastQueue;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public String getSegmentId() {
        return StageExec.getSegmentId$(this);
    }

    @Override
    public RateLimiter createRateLimiter(double permitsPerSecond) {
        return StageExec.createRateLimiter$(this, permitsPerSecond);
    }

    @Override
    public double createRateLimiter$default$1() {
        return StageExec.createRateLimiter$default$1$(this);
    }

    @Override
    public void onStageStart() {
        StageExec.onStageStart$(this);
    }

    @Override
    public void onStageFinished(ExecutableState state) {
        StageExec.onStageFinished$(this, state);
    }

    @Override
    public ExecutableState onStageFinished$default$1() {
        return StageExec.onStageFinished$default$1$(this);
    }

    @Override
    public void onStageSkipped() {
        StageExec.onStageSkipped$(this);
    }

    @Override
    public void updateStageInfo(String status, String errMsg, java.util.Map<String, String> updateInfo) {
        StageExec.updateStageInfo$(this, status, errMsg, updateInfo);
    }

    @Override
    public String getStageId() {
        return StageExec.getStageId$(this);
    }

    @Override
    public void setStageId(String stageId) {
        StageExec.setStageId$(this, stageId);
    }

    @Override
    public void doExecute() {
        StageExec.doExecute$(this);
    }

    @Override
    public void doExecuteWithoutFinally() {
        StageExec.doExecuteWithoutFinally$(this);
    }

    @Override
    public void reportTaskProgress() {
        SegmentExec.reportTaskProgress$(this);
    }

    @Override
    public <T extends SegmentExec.Task> void slowStartExec(Iterator<T> taskIter, Function1<T, BoxedUnit> taskExec) {
        SegmentExec.slowStartExec$(this, taskIter, taskExec);
    }

    @Override
    public final void failFastCheck() {
        SegmentExec.failFastCheck$(this);
    }

    @Override
    public final int failFastPoll(long timeout, TimeUnit unit) {
        return SegmentExec.failFastPoll$(this, timeout, unit);
    }

    @Override
    public final long failFastPoll$default$1() {
        return SegmentExec.failFastPoll$default$1$(this);
    }

    @Override
    public final TimeUnit failFastPoll$default$2() {
        return SegmentExec.failFastPoll$default$2$(this);
    }

    @Override
    public final void handleFailure(Option<Throwable> failure) {
        SegmentExec.handleFailure$(this, failure);
    }

    @Override
    public final void setConfig4CurrentThread() {
        SegmentExec.setConfig4CurrentThread$(this);
    }

    @Override
    public void drain(long timeout, TimeUnit unit) {
        SegmentExec.drain$(this, timeout, unit);
    }

    @Override
    public long drain$default$1() {
        return SegmentExec.drain$default$1$(this);
    }

    @Override
    public TimeUnit drain$default$2() {
        return SegmentExec.drain$default$2$(this);
    }

    @Override
    public void saveV3Metadata(List<SegmentExec.LayoutDetailResult> results) {
        SegmentExec.saveV3Metadata$(this, results);
    }

    @Override
    public void saveMetadata(List<SegmentExec.LayoutResult> results) {
        SegmentExec.saveMetadata$(this, results);
    }

    @Override
    public final int updateDataLayouts(NDataflowManager manager, Seq<NDataLayout> dataLayouts) {
        return SegmentExec.updateDataLayouts$(this, manager, dataLayouts);
    }

    @Override
    public void scheduleCheckpoint() {
        SegmentExec.scheduleCheckpoint$(this);
    }

    @Override
    public final Dataset<Row> wrapLayoutDS(LayoutEntity layout, Dataset<Row> parentDS) {
        return SegmentExec.wrapLayoutDS$(this, layout, parentDS);
    }

    @Override
    public final void newDataLayout(NDataSegment segment, LayoutEntity layout, Dataset<Row> layoutDS, String readableDesc, Option<StorageListener> storageListener) {
        SegmentExec.newDataLayout$(this, segment, layout, layoutDS, readableDesc, storageListener);
    }

    @Override
    public final void newEmptyDataLayout(LayoutEntity layout, NDataLayout.AbnormalType abnormalType) {
        SegmentExec.newEmptyDataLayout$(this, layout, abnormalType);
    }

    @Override
    public Set<Integer> wrapDimensions(LayoutEntity layout) {
        return SegmentExec.wrapDimensions$(this, layout);
    }

    @Override
    public final WriteTaskStats saveWithStatistics(LayoutEntity layout, Dataset<Row> layoutDS, NDataSegment segment, String readableDesc, Option<StorageListener> storageListener, long bucketId) {
        return SegmentExec.saveWithStatistics$(this, layout, layoutDS, segment, readableDesc, storageListener, bucketId);
    }

    @Override
    public final long saveWithStatistics$default$6() {
        return SegmentExec.saveWithStatistics$default$6$(this);
    }

    @Override
    public HashMap<String, DimensionRangeInfo> calDimRange(NDataSegment segment, Dataset<Row> ds) {
        return SegmentExec.calDimRange$(this, segment, ds);
    }

    @Override
    public HashMap<String, DimensionRangeInfo> calPartitionDimRange(NDataSegment segment, Dataset<Row> ds) {
        return SegmentExec.calPartitionDimRange$(this, segment, ds);
    }

    @Override
    public void cleanup() {
        SegmentExec.cleanup$(this);
    }

    @Override
    public void cleanupLayoutTempData(NDataSegment segment, Seq<LayoutEntity> layouts) {
        SegmentExec.cleanupLayoutTempData$(this, segment, layouts);
    }

    @Override
    public <T> Seq<T> polledResultSeq(BlockingQueue<T> resultQueue) {
        return SegmentExec.polledResultSeq$(this, resultQueue);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public MergeStage$LayoutMergeTask$ LayoutMergeTask() {
        if (this.LayoutMergeTask$module == null) {
            this.LayoutMergeTask$lzycompute$1();
        }
        return this.LayoutMergeTask$module;
    }

    @Override
    public String stageId() {
        return this.stageId;
    }

    @Override
    public void stageId_$eq(String x$1) {
        this.stageId = x$1;
    }

    @Override
    public Option<Throwable> anonymousFailure() {
        return this.anonymousFailure;
    }

    @Override
    public void anonymousFailure_$eq(Option<Throwable> x$1) {
        this.anonymousFailure = x$1;
    }

    private LinkedBlockingQueue<SegmentExec.ResultType> pipe$lzycompute() {
        MergeStage mergeStage = this;
        synchronized (mergeStage) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.pipe = SegmentExec.pipe$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.pipe;
    }

    @Override
    public final LinkedBlockingQueue<SegmentExec.ResultType> pipe() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.pipe$lzycompute() : this.pipe;
    }

    private LinkedBlockingQueue<Option<Throwable>> failFastQueue$lzycompute() {
        MergeStage mergeStage = this;
        synchronized (mergeStage) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.failFastQueue = SegmentExec.failFastQueue$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.failFastQueue;
    }

    @Override
    public final LinkedBlockingQueue<Option<Throwable>> failFastQueue() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.failFastQueue$lzycompute() : this.failFastQueue;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SegmentJob jobContext() {
        return this.jobContext;
    }

    private NDataSegment dataSegment() {
        return this.dataSegment;
    }

    @Override
    public final String jobId() {
        return this.jobId;
    }

    @Override
    public final KylinConfig config() {
        return this.config;
    }

    @Override
    public final String dataflowId() {
        return this.dataflowId;
    }

    @Override
    public final SparkSession sparkSession() {
        return this.sparkSession;
    }

    @Override
    public final AppStatusContext appStatusContext() {
        return this.appStatusContext;
    }

    @Override
    public final JobRuntime runtime() {
        return this.runtime;
    }

    @Override
    public final String project() {
        return this.project;
    }

    @Override
    public final String segmentId() {
        return this.segmentId;
    }

    @Override
    public final NDataModel dataModel() {
        return this.dataModel;
    }

    @Override
    public final NDataModel.DataStorageType storageType() {
        return this.storageType;
    }

    public final Buffer<NDataSegment> unmerged() {
        return this.unmerged;
    }

    @Override
    public String sparkSchedulerPool() {
        return this.sparkSchedulerPool;
    }

    @Override
    public SparkApplication getJobContext() {
        return this.jobContext();
    }

    public void mergeIndices() {
        this.cleanupLayoutTempData(this.dataSegment(), (Seq<LayoutEntity>)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.jobContext().getReadOnlyLayouts()).asScala()).toSeq());
        Iterable tasks = (Iterable)((TraversableLike)this.unmerged().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(segment.getSegDetails().getEffectiveLayouts()).asScala(), Buffer$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getLayoutId())).values().map((Function1)this.LayoutMergeTask(), Iterable$.MODULE$.canBuildFrom());
        this.slowStartExec(tasks.iterator(), (Function1 & Serializable & scala.Serializable)task -> {
            this.mergeLayout(task);
            return BoxedUnit.UNIT;
        });
    }

    private void mergeLayout(LayoutMergeTask task) {
        NDataLayout head = (NDataLayout)task.grouped().head();
        LayoutEntity layout = head.getLayout();
        long layoutId = layout.getId();
        Dataset<Row> unitedDS = this.newUnitedDS(Predef$.MODULE$.long2Long(layoutId));
        if (Objects.isNull(unitedDS)) {
            return;
        }
        this.mergeDataLayout(layout, unitedDS);
    }

    private Dataset<Row> newUnitedDS(Long layoutId) {
        ObjectRef unitedDS = ObjectRef.create(null);
        this.unmerged().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            MergeStage.$anonfun$newUnitedDS$1(this, layoutId, unitedDS, segment);
            return BoxedUnit.UNIT;
        });
        return (Dataset)unitedDS.elem;
    }

    private void mergeDataLayout(LayoutEntity layout, Dataset<Row> unitedDS) {
        String readableDesc = new StringBuilder(13).append("Merge layout ").append(layout.getId()).toString();
        Dataset<Row> layoutDS = this.wrapLayoutDS(layout, unitedDS);
        this.newDataLayout(this.dataSegment(), layout, layoutDS, readableDesc, (Option<StorageListener>)None$.MODULE$);
    }

    @Override
    public void recordTaskInfo(SegmentExec.Task t) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Segment ").append(this.segmentId()).append(" submit task: ").append(t.getTaskDesc()).toString());
    }

    @Override
    public SegmentExec.SourceStats newSourceStats(LayoutEntity layout, WriteTaskStats origin) {
        long sourceRows = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)this.unmerged().map((Function1 & Serializable & scala.Serializable)segment -> segment.getLayout(layout.getId()), Buffer$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MergeStage.$anonfun$newSourceStats$2(x$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getSourceRows()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Layout ").append(layout.getId()).append(" source rows ").append(sourceRows).toString());
        return new SegmentExec.SourceStats(sourceRows);
    }

    @Override
    public String columnIdFunc(TblColRef colRef) {
        String string;
        if (this.config().isUTEnv()) {
            SegmentFlatTableDesc tableDesc = new SegmentFlatTableDesc(this.config(), this.dataSegment(), null);
            string = tableDesc.getColumnIdAsString(colRef);
        } else {
            string = "-1";
        }
        return string;
    }

    public void mergeFlatTable() {
        if (!this.config().isPersistFlatTableEnabled()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flat table persisting is not enabled.");
            this.onStageSkipped();
            return;
        }
        Seq<Path> unmergedFTPaths = this.getUnmergedFTPaths();
        if (unmergedFTPaths.isEmpty()) {
            this.onStageSkipped();
            return;
        }
        ObjectRef tableDS = ObjectRef.create((Object)this.sparkSession().read().parquet(((Path)unmergedFTPaths.head()).toString()));
        String schema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)tableDS.elem).schema().fieldNames())).mkString(",");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("FLAT-TABLE schema ").append(schema).toString());
        boolean schemaMatched = ((IterableLike)unmergedFTPaths.drop(1)).forall((Function1 & Serializable & scala.Serializable)fp -> BoxesRunTime.boxToBoolean((boolean)MergeStage.$anonfun$mergeFlatTable$3(this, schema, fp)));
        if (!schemaMatched) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skip FLAT-TABLE schema not matched.");
            this.onStageSkipped();
            return;
        }
        ((IterableLike)unmergedFTPaths.drop(1)).foreach((Function1 & Serializable & scala.Serializable)fp -> {
            MergeStage.$anonfun$mergeFlatTable$6(this, tableDS, fp);
            return BoxedUnit.UNIT;
        });
        Path newPath = this.config().getFlatTableDir(this.project(), this.dataflowId(), this.segmentId());
        this.sparkSession().sparkContext().setLocalProperty("spark.scheduler.pool", "merge");
        this.sparkSession().sparkContext().setJobDescription("Persist flat table.");
        ((Dataset)tableDS.elem).write().mode(SaveMode.Overwrite).parquet(newPath.toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Persist merged FLAT-TABLE ").append(newPath).append(" with schema ").append(schema).toString());
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.config(), (String)this.project());
        NDataSegment copiedSegment = dataflowManager.getDataflow(this.dataflowId()).getSegment(this.segmentId()).copy();
        copiedSegment.setFlatTableReady(true);
        NDataflowUpdate update = new NDataflowUpdate(this.dataflowId());
        update.setToUpdateSegs(new NDataSegment[]{copiedSegment});
        dataflowManager.updateDataflow(update);
    }

    public Seq<Path> getUnmergedFTPaths() {
        Buffer notReadies = (Buffer)((TraversableLike)this.unmerged().filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isFlatTableReady()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Buffer$.MODULE$.canBuildFrom());
        if (notReadies.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("[UNEXPECTED_THINGS_HAPPENED] Merging FLAT-TABLE, ").append("but found that some flat table were not ready like [").append(notReadies.mkString(",")).append("]").toString());
            return (Seq)Nil$.MODULE$;
        }
        FileSystem fs = this.config().isBuildFilesSeparationEnabled() ? HadoopUtil.getWritingClusterFileSystem() : HadoopUtil.getWorkingFileSystem();
        Buffer notExists = (Buffer)((TraversableLike)this.unmerged().filterNot((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)this.exists$1(segment, fs)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Buffer$.MODULE$.canBuildFrom());
        if (notExists.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("[UNEXPECTED_THINGS_HAPPENED] Merging FLAT-TABLE, ").append("but found that some flat table were not exists like [").append(notExists.mkString(",")).append("]").toString());
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.unmerged().map((Function1 & Serializable & scala.Serializable)segment -> this.config().getFlatTableDir(this.project(), this.dataflowId(), segment.getId()), Buffer$.MODULE$.canBuildFrom());
    }

    public void mergeColumnBytes() {
        UnitOfWork.doInTransactionWithRetry((UnitOfWork.Callback)new UnitOfWork.Callback<BoxedUnit>(this){
            private final /* synthetic */ MergeStage $outer;

            public void preProcess() {
                super.preProcess();
            }

            public void onProcessError(Throwable x$1) {
                super.onProcessError(x$1);
            }

            public void process() {
                SourceUsageManager usageManager = SourceUsageManager.getInstance((KylinConfig)this.$outer.config());
                long totalCount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.unmerged().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$process$1(x$7)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                java.util.Map evaluated = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableLike)this.$outer.unmerged().flatMap((Function1 & Serializable & scala.Serializable)segment -> {
                    java.util.Map existed = segment.getColumnSourceBytes().isEmpty() && segment.getSourceCount() != 0L ? usageManager.calcAvgColumnSourceBytes(segment) : segment.getColumnSourceBytes();
                    return (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(existed).asScala();
                }, Buffer$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8._1()).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> (Long)((TraversableOnce)x$9.map((Function1 & Serializable & scala.Serializable)x$10 -> (Long)x$10._2(), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$11, x$12) -> Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(x$11) + Predef$.MODULE$.Long2long(x$12))))).asJava();
                NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.$outer.config(), (String)this.$outer.project());
                NDataSegment copiedSegment = dataflowManager.getDataflow(this.$outer.dataflowId()).getSegment(this.$outer.segmentId()).copy();
                NDataflowUpdate dataflowUpdate = new NDataflowUpdate(this.$outer.dataflowId());
                copiedSegment.setSourceCount(totalCount);
                copiedSegment.setDimensionRangeInfoMap(this.$outer.mergeDimRange());
                copiedSegment.getColumnSourceBytes().putAll(evaluated);
                dataflowUpdate.setToUpdateSegs(new NDataSegment[]{copiedSegment});
                this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Merge COLUMN-BYTES segment ").append($this.$outer.segmentId()).toString());
                dataflowManager.updateDataflow(dataflowUpdate);
            }

            public static final /* synthetic */ long $anonfun$process$1(NDataSegment x$7) {
                return x$7.getSourceCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$1$adapted(org.apache.kylin.metadata.cube.model.NDataSegment ), $anonfun$process$2(org.apache.kylin.metadata.sourceusage.SourceUsageManager org.apache.kylin.metadata.cube.model.NDataSegment ), $anonfun$process$3(scala.Tuple2 ), $anonfun$process$4(scala.collection.mutable.Buffer ), $anonfun$process$7(org.apache.kylin.engine.spark.job.step.merge.MergeStage$$anon$1 ), $anonfun$process$5(scala.Tuple2 ), $anonfun$process$6(java.lang.Long java.lang.Long )}, serializedLambda);
            }
        }, (String)this.project());
    }

    public java.util.Map<String, DimensionRangeInfo> mergeDimRange() {
        java.util.Map<String, Object> map;
        Buffer emptyDimRangeSeg = (Buffer)this.unmerged().filter((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)MergeStage.$anonfun$mergeDimRange$1(seg)));
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)this.config(), (String)this.project()).getDataflow(this.dataflowId());
        NDataSegment mergedSegment = dataflow.getSegment(this.segmentId());
        if (mergedSegment.isFlatTableReady()) {
            Path flatTablePath = this.config().getFlatTableDir(this.project(), this.dataflowId(), this.segmentId());
            Dataset mergedDS = this.sparkSession().read().parquet(flatTablePath.toString());
            map = this.calDimRange(mergedSegment, (Dataset<Row>)mergedDS);
        } else if (emptyDimRangeSeg.nonEmpty()) {
            map = new HashMap<String, DimensionRangeInfo>();
        } else {
            BiMap dimCols = dataflow.getIndexPlan().getEffectiveDimCols();
            scala.collection.immutable.Map mergedDimRange = (scala.collection.immutable.Map)((TraversableLike)((TraversableLike)((TraversableOnce)this.unmerged().map((Function1 & Serializable & scala.Serializable)seg -> JavaConverters$.MODULE$.mapAsScalaMap(seg.getDimensionRangeInfoMap()).toSeq(), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$13, x$14) -> (Seq)x$13.$plus$plus((GenTraversableOnce)x$14, Seq$.MODULE$.canBuildFrom()))).groupBy((Function1 & Serializable & scala.Serializable)x$15 -> (String)x$15._1()).mapValues((Function1 & Serializable & scala.Serializable)x$16 -> ((Seq)x$16.map((Function1 & Serializable & scala.Serializable)x$17 -> (DimensionRangeInfo)x$17._2(), Seq$.MODULE$.canBuildFrom())).seq()).filter((Function1 & Serializable & scala.Serializable)dim -> BoxesRunTime.boxToBoolean((boolean)dimCols.containsKey((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt((String)dim._1())))))).map((Function1 & Serializable & scala.Serializable)dim -> new Tuple2(dim._1(), ((TraversableOnce)dim._2()).reduce((Function2 & Serializable & scala.Serializable)(x$18, x$19) -> x$18.merge(x$19, ((TblColRef)dimCols.get((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt((String)dim._1())))).getType()))), Map$.MODULE$.canBuildFrom());
            map = JavaConverters$.MODULE$.mapAsJavaMap((Map)mergedDimRange);
        }
        return map;
    }

    private final void LayoutMergeTask$lzycompute$1() {
        MergeStage mergeStage = this;
        synchronized (mergeStage) {
            if (this.LayoutMergeTask$module == null) {
                this.LayoutMergeTask$module = new MergeStage$LayoutMergeTask$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$newUnitedDS$1(MergeStage $this, Long layoutId$1, ObjectRef unitedDS$1, NDataSegment segment) {
        NDataLayout dataLayout = segment.getLayout(Predef$.MODULE$.Long2long(layoutId$1));
        if (Objects.isNull(dataLayout)) {
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("[UNEXPECTED_THINGS_HAPPENED] Layout not found ").append("layout ").append(layoutId$1).append(" segment ").append(segment.getId()).toString());
        } else {
            LayoutEntity layout = dataLayout.getLayout();
            Dataset layoutDS = StorageStoreUtils$.MODULE$.toDF(segment, layout, $this.sparkSession());
            unitedDS$1.elem = Objects.isNull((Dataset)unitedDS$1.elem) ? layoutDS : ((Dataset)unitedDS$1.elem).union(layoutDS);
        }
    }

    public static final /* synthetic */ boolean $anonfun$newSourceStats$2(Object x$1) {
        return Objects.isNull(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$mergeFlatTable$3(MergeStage $this, String schema$1, Path fp) {
        Dataset otherDS = $this.sparkSession().read().parquet(fp.toString());
        String other = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherDS.schema().fieldNames())).mkString(",");
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("FLAT-TABLE schema ").append(other).toString());
        return schema$1.equals(other);
    }

    public static final /* synthetic */ void $anonfun$mergeFlatTable$6(MergeStage $this, ObjectRef tableDS$1, Path fp) {
        Dataset other = $this.sparkSession().read().parquet(fp.toString());
        tableDS$1.elem = ((Dataset)tableDS$1.elem).union(other);
    }

    private final boolean exists$1(NDataSegment segment, FileSystem fs$1) {
        boolean bl;
        try {
            Path pathFT = this.config().getFlatTableDir(this.project(), this.dataflowId(), segment.getId());
            bl = fs$1.exists(pathFT);
        }
        catch (IOException ioe) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("[UNEXPECTED_THINGS_HAPPENED] Checking FLAT-TABLE exists of segment ").append(segment.getId()).toString(), ioe);
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$mergeDimRange$1(NDataSegment seg) {
        return seg.getDimensionRangeInfoMap().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public MergeStage(SegmentJob jobContext, NDataSegment dataSegment) {
        void var3_3;
        this.jobContext = jobContext;
        this.dataSegment = dataSegment;
        Logging.$init$((Logging)this);
        SegmentExec.$init$(this);
        StageExec.$init$(this);
        this.jobId = jobContext.getJobId();
        this.config = jobContext.getConfig();
        this.dataflowId = jobContext.getDataflowId();
        this.sparkSession = jobContext.getSparkSession();
        this.appStatusContext = jobContext.getAppStatusContext();
        this.runtime = jobContext.getRuntime();
        this.project = dataSegment.getProject();
        this.segmentId = dataSegment.getId();
        this.dataModel = dataSegment.getModel();
        this.storageType = this.dataModel().getStorageType();
        Buffer segments = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(jobContext.getUnmergedSegments(dataSegment)).asScala();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Unmerged SEGMENT [").append(((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).append("]").toString());
        this.unmerged = var3_3;
        this.sparkSchedulerPool = "merge";
    }

    public class LayoutMergeTask
    implements SegmentExec.Task,
    Product,
    scala.Serializable {
        private final Seq<NDataLayout> grouped;
        public final /* synthetic */ MergeStage $outer;

        public Seq<NDataLayout> grouped() {
            return this.grouped;
        }

        @Override
        public String getTaskDesc() {
            return String.valueOf(BoxesRunTime.boxToLong((long)((NDataLayout)this.grouped().head()).getLayoutId()));
        }

        public LayoutMergeTask copy(Seq<NDataLayout> grouped) {
            return new LayoutMergeTask(this.org$apache$kylin$engine$spark$job$step$merge$MergeStage$LayoutMergeTask$$$outer(), grouped);
        }

        public Seq<NDataLayout> copy$default$1() {
            return this.grouped();
        }

        public String productPrefix() {
            return "LayoutMergeTask";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.grouped();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LayoutMergeTask;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LayoutMergeTask)) return false;
            if (((LayoutMergeTask)object).org$apache$kylin$engine$spark$job$step$merge$MergeStage$LayoutMergeTask$$$outer() != this.org$apache$kylin$engine$spark$job$step$merge$MergeStage$LayoutMergeTask$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LayoutMergeTask layoutMergeTask = (LayoutMergeTask)x$1;
            Seq<NDataLayout> seq = this.grouped();
            Seq<NDataLayout> seq2 = layoutMergeTask.grouped();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!layoutMergeTask.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MergeStage org$apache$kylin$engine$spark$job$step$merge$MergeStage$LayoutMergeTask$$$outer() {
            return this.$outer;
        }

        public LayoutMergeTask(MergeStage $outer, Seq<NDataLayout> grouped) {
            this.grouped = grouped;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

