/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.obf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.Logger;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.tool.obf.FileObfuscator;
import org.apache.kylin.tool.obf.MappingRecorder;
import org.apache.kylin.tool.obf.ObfLevel;
import org.apache.kylin.tool.obf.ResultRecorder;
import org.apache.kylin.tool.util.ToolUtil;

public class IpObfuscator
extends FileObfuscator {
    private List<String> zipFiles = new ArrayList<String>();
    private Map<String, String> ipDirHiddens = Maps.newHashMap();
    private static final String IP_NETWORK_NUMBER = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]?\\d)\\.){3}";
    private static final String IP_HOST_NUMBER = "(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|[1-9])";
    private static final String IP_PATTERN = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|[1-9])";
    private static final int BUFFER_SIZE = 0xA00000;
    private static final Pattern IP_PATTERN_PATTERN = Pattern.compile("(.*)((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|[1-9])(.*)");

    public IpObfuscator(ObfLevel level, MappingRecorder recorder, ResultRecorder resultRecorder) {
        super(level, recorder, resultRecorder);
    }

    @Override
    public void doObfuscateFile(File orig) {
        String path = orig.getAbsolutePath();
        File tmpFile = new File(orig.getAbsolutePath() + ".tmp");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(orig), Charset.defaultCharset()), 0xA00000);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), Charset.defaultCharset()), 0xA00000);){
            String readLine;
            while ((readLine = reader.readLine()) != null) {
                bw.write(readLine.replaceAll(IP_PATTERN, "<hidden>"));
                bw.newLine();
            }
            bw.flush();
            boolean renameResult = tmpFile.renameTo(orig);
            if (!renameResult) {
                logger.error("{} processed failed", (Object)path);
                this.resultRecorder.addFailedFile(path);
            }
            logger.info("{} processed successfully", (Object)path);
            this.resultRecorder.addSuccessFile(path);
        }
        catch (IOException e) {
            logger.error("{} processed failed", (Object)path, (Object)e);
            this.resultRecorder.addFailedFile(path);
        }
    }

    @Override
    public void obfuscate(File orig, FileFilter fileFilter) {
        this.ipObfuscatorPrepare(orig);
        if (fileFilter == null && ToolUtil.existsLinuxCommon("sed")) {
            this.obfuscateByLinux(orig);
        } else {
            super.obfuscate(orig, fileFilter);
        }
        this.ipObfuscatorClean();
    }

    public void obfuscateByLinux(File rootDir) {
        logger.info("diag start obf ip by linux");
        String rex = "([0-9]{1,3}\\.){3}(([0-9]{2,3})|[1-9])";
        String finalCommand = String.format(Locale.ROOT, "cd %s/ && sed -ri 's/%s/<hidden>/g' $(grep -E '%s' -rl %s)", KylinConfig.getKylinHome(), rex, rex, rootDir.getAbsolutePath());
        CliCommandExecutor commandExecutor = new CliCommandExecutor();
        BufferedLogger patternedLogger = new BufferedLogger(logger);
        String uuid = rootDir.getAbsolutePath();
        try {
            logger.info("command = {}", (Object)finalCommand);
            commandExecutor.execute(finalCommand, (Logger)patternedLogger, uuid);
            logger.info("diag end obf ip by linux");
        }
        catch (ShellException e) {
            logger.error("Failed to execute obf ip diag by linux", (Throwable)e);
            super.obfuscate(rootDir, null);
        }
    }

    public static boolean existsIp(String text) {
        Matcher ipMatcher = IP_PATTERN_PATTERN.matcher(text);
        return ipMatcher.matches();
    }

    public void ipObfuscatorPrepare(File root) {
        logger.info("ip obfuscator do prepare");
        this.zipFiles = this.findZipFileAndUnzip(root);
        this.ipDirHiddens = this.findIpDir(root);
        this.changeZipFileByIpDirs(root);
        this.moveFileByIpDirs();
    }

    public void moveFileByIpDirs() {
        logger.info("ip obfuscator do move file by ip dirs");
        for (Map.Entry<String, String> entry : this.ipDirHiddens.entrySet()) {
            File srcFile = new File(entry.getKey());
            File destFile = new File(entry.getValue());
            destFile.getParentFile().mkdirs();
            try {
                FileUtils.moveFile((File)srcFile, (File)destFile);
                IpObfuscator.removeEmptyParentsDirectory(srcFile.getParentFile());
            }
            catch (IOException e) {
                logger.error("{} processed move file By ipDirs failed", (Object)entry.getKey(), (Object)e);
                this.resultRecorder.addFailedFile(entry.getKey());
            }
        }
    }

    public static void removeEmptyParentsDirectory(File parentFile) throws IOException {
        if (Array.isEmpty((Object[])parentFile.listFiles())) {
            Files.delete(parentFile.toPath());
            IpObfuscator.removeEmptyParentsDirectory(parentFile.getParentFile());
        }
    }

    private void changeZipFileByIpDirs(File root) {
        logger.info("ip obfuscator do change zip file name by ip dirs");
        List ipDirZips = this.zipFiles.stream().filter(file -> this.ipDirHiddens.containsKey(file)).collect(Collectors.toList());
        if (ipDirZips.isEmpty()) {
            return;
        }
        this.zipFiles.removeAll(ipDirZips);
        List hiddenIpZipFiles = ipDirZips.stream().map(ipDirZip -> IpObfuscator.getHiddenIpDir(root, ipDirZip)).collect(Collectors.toList());
        this.zipFiles.addAll(hiddenIpZipFiles);
    }

    private Map<String, String> findIpDir(File root) {
        List<String> ipDirs = IpObfuscator.findFiles(root, file -> IpObfuscator.existsIp(file.getAbsolutePath()));
        HashMap ipDirHidden = Maps.newHashMap();
        if (ipDirs.isEmpty()) {
            return ipDirHidden;
        }
        for (String ipDir : ipDirs) {
            String hiddenIpDir = IpObfuscator.getHiddenIpDir(root, ipDir);
            ipDirHidden.put(ipDir, hiddenIpDir);
        }
        return ipDirHidden;
    }

    public static String getHiddenIpDir(File root, String ipDir) {
        return root.getAbsolutePath() + ipDir.replace(root.getAbsolutePath(), "").replaceAll(IP_PATTERN, "<hidden>");
    }

    public List<String> findZipFileAndUnzip(File root) {
        List<String> zipFileList = IpObfuscator.findFiles(root, file -> file.getName().endsWith(".zip"));
        for (String zipFile : zipFileList) {
            try {
                ZipFileUtils.decompressZipFile((String)zipFile, (String)new File(zipFile).getParent());
            }
            catch (IOException e) {
                logger.error("{} processed decompress zip failed", (Object)zipFile, (Object)e);
                this.resultRecorder.addFailedFile(zipFile);
            }
        }
        return zipFileList;
    }

    public void ipObfuscatorClean() {
        logger.info("ip obfuscator do clean");
        this.compressZipFileAndCleanZipDir();
    }

    private void compressZipFileAndCleanZipDir() {
        logger.info("ip obfuscator do compress zip file and clean zip dir");
        for (String zipFile : this.zipFiles) {
            try {
                String zipDir = zipFile.replace(".zip", "");
                ZipFileUtils.compressZipFile((String)zipDir, (String)zipFile);
                FileUtils.deleteQuietly((File)new File(zipDir));
            }
            catch (IOException e) {
                logger.error("{} processed ip Obfuscator compress zip failed", (Object)zipFile, (Object)e);
                this.resultRecorder.addFailedFile(zipFile);
            }
        }
    }

    public static List<String> findFiles(File dirName, Function<File, Boolean> findFunction) {
        ArrayList<String> zipFiles = new ArrayList<String>();
        if (dirName == null) {
            return zipFiles;
        }
        File[] files = dirName.listFiles();
        if (files == null) {
            return zipFiles;
        }
        for (File subFile : files) {
            if (subFile.isDirectory()) {
                List<String> zipFilePath = IpObfuscator.findFiles(subFile, findFunction);
                zipFiles.addAll(zipFilePath);
                continue;
            }
            if (!Boolean.TRUE.equals(findFunction.apply(subFile))) continue;
            zipFiles.add(subFile.getAbsolutePath());
        }
        return zipFiles;
    }
}

