/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.util.ArrayList;
import java.util.List;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class ZookeeperServiceInstanceListSupplier
implements ServiceInstanceListSupplier {
    private final ServiceInstanceListSupplier delegate;
    private final String serviceId;

    public ZookeeperServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, ZookeeperDependencies zookeeperDependencies) {
        this.delegate = delegate;
        this.serviceId = this.getServiceIdFromDepsOrClientName(delegate.getServiceId(), zookeeperDependencies);
    }

    private String getServiceIdFromDepsOrClientName(String delegateServiceId, ZookeeperDependencies zookeeperDependencies) {
        String serviceIdFromDeps = zookeeperDependencies.getPathForAlias(delegateServiceId);
        return StringUtils.hasText((String)serviceIdFromDeps) ? serviceIdFromDeps : delegateServiceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Flux<List<org.springframework.cloud.client.ServiceInstance>> get() {
        return ((Flux)this.delegate.get()).map(this::filteredByZookeeperStatusUp);
    }

    private List<org.springframework.cloud.client.ServiceInstance> filteredByZookeeperStatusUp(List<org.springframework.cloud.client.ServiceInstance> serviceInstances) {
        ArrayList<org.springframework.cloud.client.ServiceInstance> filteredInstances = new ArrayList<org.springframework.cloud.client.ServiceInstance>();
        for (org.springframework.cloud.client.ServiceInstance serviceInstance : serviceInstances) {
            if (!(serviceInstance instanceof ZookeeperServiceInstance)) continue;
            ServiceInstance<ZookeeperInstance> zookeeperServiceInstance = ((ZookeeperServiceInstance)serviceInstance).getServiceInstance();
            String instanceStatus = null;
            if (zookeeperServiceInstance.getPayload() != null && ((ZookeeperInstance)zookeeperServiceInstance.getPayload()).getMetadata() != null) {
                instanceStatus = ((ZookeeperInstance)zookeeperServiceInstance.getPayload()).getMetadata().get("instance_status");
            }
            if (StringUtils.hasText(instanceStatus) && !instanceStatus.equalsIgnoreCase("UP")) continue;
            filteredInstances.add(serviceInstance);
        }
        return filteredInstances;
    }
}

