/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.RuleQueue;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

class IterativeRuleQueue
extends RuleQueue {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    final MatchList matchList = new MatchList();

    IterativeRuleQueue(VolcanoPlanner planner) {
        super(planner);
    }

    @Override
    public boolean clear() {
        boolean empty = true;
        if (!this.matchList.queue.isEmpty() || !this.matchList.preQueue.isEmpty()) {
            empty = false;
        }
        this.matchList.clear();
        return !empty;
    }

    @Override
    public void addMatch(VolcanoRuleMatch match) {
        String matchName = match.toString();
        if (!this.matchList.names.add(matchName)) {
            return;
        }
        LOGGER.trace("Rule-match queued: {}", (Object)matchName);
        this.matchList.offer(match);
        this.matchList.matchMap.put((Object)this.planner.getSubset(match.rels[0]), (Object)match);
    }

    public @Nullable VolcanoRuleMatch popMatch() {
        VolcanoRuleMatch match;
        this.dumpPlannerState();
        while (true) {
            if (this.matchList.size() == 0) {
                return null;
            }
            IterativeRuleQueue.dumpRuleQueue(this.matchList);
            match = this.matchList.poll();
            if (match == null) {
                return null;
            }
            if (!this.skipMatch(match)) break;
            LOGGER.debug("Skip match: {}", (Object)match);
        }
        this.matchList.matchMap.remove((Object)this.planner.getSubset(match.rels[0]), (Object)match);
        LOGGER.debug("Pop match: {}", (Object)match);
        return match;
    }

    private static void dumpRuleQueue(MatchList matchList) {
        if (LOGGER.isTraceEnabled()) {
            StringBuilder b = new StringBuilder();
            b.append("Rule queue:");
            for (VolcanoRuleMatch rule : matchList.preQueue) {
                b.append("\n");
                b.append(rule);
            }
            for (VolcanoRuleMatch rule : matchList.queue) {
                b.append("\n");
                b.append(rule);
            }
            LOGGER.trace(b.toString());
        }
    }

    private void dumpPlannerState() {
        if (LOGGER.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.planner.dump(pw);
            pw.flush();
            LOGGER.trace(sw.toString());
            RelNode root = this.planner.getRoot();
            if (root != null) {
                root.getCluster().invalidateMetadataQuery();
            }
        }
    }

    private static class MatchList {
        private final Queue<VolcanoRuleMatch> preQueue = new ArrayDeque<VolcanoRuleMatch>();
        private final Queue<VolcanoRuleMatch> queue = new ArrayDeque<VolcanoRuleMatch>();
        final Set<String> names = new HashSet<String>();
        final Multimap<RelSubset, VolcanoRuleMatch> matchMap = HashMultimap.create();

        private MatchList() {
        }

        int size() {
            return this.preQueue.size() + this.queue.size();
        }

        @Nullable VolcanoRuleMatch poll() {
            VolcanoRuleMatch match = this.preQueue.poll();
            if (match == null) {
                match = this.queue.poll();
            }
            return match;
        }

        void offer(VolcanoRuleMatch match) {
            if (match.getRule() instanceof SubstitutionRule) {
                this.preQueue.offer(match);
            } else {
                this.queue.offer(match);
            }
        }

        void clear() {
            this.preQueue.clear();
            this.queue.clear();
            this.names.clear();
            this.matchMap.clear();
        }
    }
}

