/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@MetadataInfo(project="ssb")
class HadoopUtilTest {
    @TempDir
    java.nio.file.Path tempDir;

    HadoopUtilTest() {
    }

    @Test
    void testGetFileStatusPathsFromHDFSDir_Dir() throws IOException {
        File mainDir = new File(this.tempDir.toFile(), "tt");
        FileUtils.forceMkdir((File)mainDir);
        Assertions.assertTrue((boolean)mainDir.exists());
        List fileStatus = HadoopUtil.getFileStatusPathsFromHDFSDir((String)this.tempDir.toString(), (boolean)false);
        Assertions.assertEquals((int)1, (int)fileStatus.size());
        Assertions.assertTrue((boolean)((FileStatus)fileStatus.get(0)).isDirectory());
    }

    @Test
    void testGetFileStatusPathsFromHDFSDIR_File() throws IOException {
        File tmpFile = new File(this.tempDir.toFile(), "abc.log");
        Assertions.assertTrue((boolean)tmpFile.createNewFile());
        Assertions.assertTrue((boolean)tmpFile.exists());
        List fileStatus = HadoopUtil.getFileStatusPathsFromHDFSDir((String)this.tempDir.toString(), (boolean)true);
        Assertions.assertEquals((int)1, (int)fileStatus.size());
        Assertions.assertTrue((boolean)((FileStatus)fileStatus.get(0)).isFile());
    }

    @Test
    void testMkdirIfNotExist_NotExist() {
        File mainDir = new File(this.tempDir.toFile(), "tt");
        Assertions.assertFalse((boolean)mainDir.exists());
        HadoopUtil.mkdirIfNotExist((String)mainDir.getAbsolutePath());
        Assertions.assertTrue((boolean)mainDir.exists());
        Assertions.assertTrue((boolean)mainDir.isDirectory());
    }

    @Test
    void testMkdirIfNotExist_Existed() throws IOException {
        File mainDir = new File(this.tempDir.toFile(), "tt");
        FileUtils.forceMkdir((File)mainDir);
        Assertions.assertTrue((boolean)mainDir.exists());
        HadoopUtil.mkdirIfNotExist((String)mainDir.getAbsolutePath());
        Assertions.assertTrue((boolean)mainDir.exists());
        Assertions.assertTrue((boolean)mainDir.isDirectory());
    }

    @Test
    void testDeletePath() throws IOException {
        File mainDir = new File(this.tempDir.toFile(), "testDeletePath");
        Assertions.assertFalse((boolean)mainDir.exists());
        boolean deleteSuccess = HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(mainDir.getAbsolutePath()));
        Assertions.assertFalse((boolean)deleteSuccess);
        FileUtils.forceMkdir((File)mainDir);
        Assertions.assertTrue((boolean)mainDir.exists());
        deleteSuccess = HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(mainDir.getAbsolutePath()));
        Assertions.assertTrue((boolean)deleteSuccess);
    }

    @Test
    void testGetPathWithoutScheme() {
        String pathStr = "file://asdasd";
        String path = HadoopUtil.getPathWithoutScheme((String)"file://asdasd");
        Assertions.assertEquals((Object)"file://asdasd", (Object)path);
        pathStr = "file:/asdasd";
        path = HadoopUtil.getPathWithoutScheme((String)"file:/asdasd");
        Assertions.assertEquals((Object)"file:///asdasd", (Object)path);
        pathStr = "maprfs://asdasd";
        path = HadoopUtil.getPathWithoutScheme((String)"maprfs://asdasd");
        Assertions.assertEquals((Object)"asdasd", (Object)path);
        pathStr = "xxx://asdasd";
        path = HadoopUtil.getPathWithoutScheme((String)"xxx://asdasd");
        Assertions.assertEquals((Object)"xxx://asdasd/", (Object)path);
    }

    @Test
    void testToBytes() {
        ArrayWritable arrayWritable = new ArrayWritable(new String[]{"a"});
        byte[] resultBytes = HadoopUtil.toBytes((Writable)arrayWritable);
        Assertions.assertNotNull((Object)resultBytes);
    }

    @Test
    void testFixWindowsPath() {
        String pathStr = "C:\\\\//asdasd";
        String path = HadoopUtil.fixWindowsPath((String)"C:\\\\//asdasd");
        Assertions.assertEquals((Object)"file:///C:////asdasd", (Object)path);
        pathStr = "D:\\\\//asdasd";
        path = HadoopUtil.fixWindowsPath((String)"D:\\\\//asdasd");
        Assertions.assertEquals((Object)"file:///D:////asdasd", (Object)path);
        pathStr = "C:///asdasd";
        path = HadoopUtil.fixWindowsPath((String)"C:///asdasd");
        Assertions.assertEquals((Object)"file:///C:///asdasd", (Object)path);
        pathStr = "D:///asdasd";
        path = HadoopUtil.fixWindowsPath((String)"D:///asdasd");
        Assertions.assertEquals((Object)"file:///D:///asdasd", (Object)path);
    }

    @Test
    void testMakeURI() {
        String pathStr = "C:\\\\//asdasd";
        URI path = HadoopUtil.makeURI((String)"C:\\\\//asdasd");
        Assertions.assertEquals((Object)"file:///C:////asdasd", (Object)path.toString());
        pathStr = "D:\\\\//asdasd";
        path = HadoopUtil.makeURI((String)"D:\\\\//asdasd");
        Assertions.assertEquals((Object)"file:///D:////asdasd", (Object)path.toString());
        pathStr = "C:///asdasd";
        path = HadoopUtil.makeURI((String)"C:///asdasd");
        Assertions.assertEquals((Object)"file:///C:///asdasd", (Object)path.toString());
        pathStr = "D:///asdasd";
        path = HadoopUtil.makeURI((String)"D:///asdasd");
        Assertions.assertEquals((Object)"file:///D:///asdasd", (Object)path.toString());
    }

    @Test
    void testWriteStringToHdfsAndRead() throws IOException {
        String strWrite = "STA-1:start,event=cpu";
        File profileFlagDir = new File(this.tempDir.toFile(), "profiler_flags");
        Path hdfsPath = new Path(profileFlagDir.getAbsolutePath());
        HadoopUtil.writeStringToHdfs((String)strWrite, (Path)hdfsPath);
        Assertions.assertEquals((Object)strWrite, (Object)HadoopUtil.readStringFromHdfs((Path)hdfsPath));
    }

    @Test
    void testGetWritingClusterFileSystem() {
        Assertions.assertNotNull((Object)HadoopUtil.getWritingClusterFileSystem());
    }

    @Test
    void testUploadFileToHdfsAndDownload() throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        File localDir1 = new File(this.tempDir.toFile(), "logs");
        File localDir2 = new File(this.tempDir.toFile(), "diag_logs");
        File localHdfs = new File(this.tempDir.toFile(), "_logs");
        Path hdfsPath = new Path(localHdfs.getAbsolutePath());
        FileUtils.forceMkdir((File)localDir1);
        FileUtils.forceMkdir((File)localDir2);
        fs.mkdirs(hdfsPath);
        File tmpFile = new File(localDir1, "kylin.gc.pid1.0");
        Path tmpHdfsPath = new Path(hdfsPath, "kylin.gc.pid1.0");
        TestUtils.writeToFile(tmpFile);
        HadoopUtil.uploadFileToHdfs((File)tmpFile, (Path)hdfsPath);
        HadoopUtil.downloadFileFromHdfsWithoutError((Path)tmpHdfsPath, (File)localDir2);
        this.checkFile(localDir1, localDir2);
        FileUtils.cleanDirectory((File)localDir2);
        FileUtils.cleanDirectory((File)localHdfs);
        File tmpFile2 = new File(localDir1, "kylin.gc.pid1.1");
        TestUtils.writeToFile(tmpFile2);
        HadoopUtil.uploadFileToHdfs((File)localDir1, (Path)hdfsPath);
        HadoopUtil.downloadFileFromHdfsWithoutError((Path)hdfsPath, (File)localDir2);
        this.checkFile(localDir1, localDir2);
        FileUtils.cleanDirectory((File)localDir2);
        FileUtils.cleanDirectory((File)localHdfs);
        File tmpFolder = new File(localDir1, "f1");
        File tmpFolder2 = new File(tmpFolder, "f2");
        File tmpFile3 = new File(tmpFolder, "kylin.gc.pid1.1");
        File tmpFile4 = new File(tmpFolder, "kylin.gc.pid1.1");
        File tmpFile5 = new File(tmpFolder2, "kylin.gc.pid1.1");
        File tmpFile6 = new File(tmpFolder2, "kylin.gc.pid1.1");
        FileUtils.forceMkdir((File)tmpFolder);
        FileUtils.forceMkdir((File)tmpFolder2);
        TestUtils.writeToFile(tmpFile3);
        TestUtils.writeToFile(tmpFile4);
        TestUtils.writeToFile(tmpFile5);
        TestUtils.writeToFile(tmpFile6);
        HadoopUtil.uploadFileToHdfs((File)localDir1, (Path)hdfsPath);
        HadoopUtil.downloadFileFromHdfsWithoutError((Path)hdfsPath, (File)localDir2);
        this.checkFile(localDir1, localDir2);
    }

    private void checkFile(File file1, File file2) {
        if (file1.isDirectory() && file2.isDirectory()) {
            Assert.assertEquals((long)file1.listFiles().length, (long)file2.listFiles().length);
            for (File file : file1.listFiles()) {
                this.checkFile(new File(file1, file.getName()), new File(file2, file.getName()));
            }
        } else if (file1.isFile() && file2.isFile()) {
            try (FileInputStream is1 = new FileInputStream(file1);
                 FileInputStream is2 = new FileInputStream(file2);){
                Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is1, (InputStream)is2));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        } else {
            Assert.fail();
        }
    }
}

