/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.udf;

import java.util.Locale;
import org.apache.spark.sql.catalyst.util.KapDateTimeUtils$;

public final class TimestampDiffImpl$ {
    public static TimestampDiffImpl$ MODULE$;

    static {
        new TimestampDiffImpl$();
    }

    public long evaluate(String unit, long timestamp, int date) {
        long before = timestamp / 1000L;
        long after = KapDateTimeUtils$.MODULE$.daysToMillis(date);
        return this.convertDuration(unit, before, after);
    }

    public long evaluate(String unit, long timestamp1, long timestamp2) {
        long before = timestamp1 / 1000L;
        long after = timestamp2 / 1000L;
        return this.convertDuration(unit, before, after);
    }

    public long evaluate(String unit, int date1, int date2) {
        long before = KapDateTimeUtils$.MODULE$.daysToMillis(date1);
        long after = KapDateTimeUtils$.MODULE$.daysToMillis(date2);
        return this.convertDuration(unit, before, after);
    }

    public long evaluate(String unit, int date, long timestamp) {
        long before = KapDateTimeUtils$.MODULE$.daysToMillis(date);
        long after = timestamp / 1000L;
        return this.convertDuration(unit, before, after);
    }

    private long convertDuration(String unit, long bMillis, long aMillis) {
        long l;
        String string = unit.toUpperCase(Locale.ROOT);
        boolean bl = "FRAC_SECOND".equals(string) ? true : "SQL_TSI_FRAC_SECOND".equals(string);
        if (bl) {
            l = aMillis - bMillis;
        } else {
            boolean bl2 = "SECOND".equals(string) ? true : "SQL_TSI_SECOND".equals(string);
            if (bl2) {
                l = (aMillis - bMillis) / 1000L;
            } else {
                boolean bl3 = "MINUTE".equals(string) ? true : "SQL_TSI_MINUTE".equals(string);
                if (bl3) {
                    l = (aMillis - bMillis) / 60000L;
                } else {
                    boolean bl4 = "HOUR".equals(string) ? true : "SQL_TSI_HOUR".equals(string);
                    if (bl4) {
                        l = (aMillis - bMillis) / 3600000L;
                    } else {
                        boolean bl5 = "DAY".equals(string) ? true : "SQL_TSI_DAY".equals(string);
                        if (bl5) {
                            l = (aMillis - bMillis) / 86400000L;
                        } else {
                            boolean bl6 = "WEEK".equals(string) ? true : "SQL_TSI_WEEK".equals(string);
                            if (bl6) {
                                l = (aMillis - bMillis) / 86400000L / (long)7;
                            } else {
                                boolean bl7 = "MONTH".equals(string) ? true : "SQL_TSI_MONTH".equals(string);
                                if (bl7) {
                                    l = KapDateTimeUtils$.MODULE$.subtractMonths(aMillis, bMillis);
                                } else {
                                    boolean bl8 = "QUARTER".equals(string) ? true : "SQL_TSI_QUARTER".equals(string);
                                    if (bl8) {
                                        l = (long)KapDateTimeUtils$.MODULE$.subtractMonths(aMillis, bMillis) / KapDateTimeUtils$.MODULE$.MONTHS_PER_QUARTER();
                                    } else {
                                        boolean bl9 = "YEAR".equals(string) ? true : "SQL_TSI_YEAR".equals(string);
                                        if (bl9) {
                                            l = (long)KapDateTimeUtils$.MODULE$.subtractMonths(aMillis, bMillis) / KapDateTimeUtils$.MODULE$.MONTHS_PER_QUARTER() / KapDateTimeUtils$.MODULE$.QUARTERS_PER_YEAR();
                                        } else {
                                            throw new IllegalArgumentException(new StringBuilder(246).append("Illegal unit: ").append(unit).append(",").append(" only support [YEAR, SQL_TSI_YEAR, QUARTER, SQL_TSI_QUARTER, MONTH, SQL_TSI_MONTH, WEEK, SQL_TSI_WEEK, DAY, SQL_TSI_DAY,").append(" HOUR, SQL_TSI_HOUR, MINUTE, SQL_TSI_MINUTE, SECOND, SQL_TSI_SECOND, FRAC_SECOND, SQL_TSI_FRAC_SECOND] for now.").toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    private TimestampDiffImpl$() {
        MODULE$ = this;
    }
}

