/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.query.util.SparkJobTraceMetric;

public final class SparkJobTrace$ {
    public static SparkJobTrace$ MODULE$;
    private final KapConfig kapConfig;
    private final int sparkJobTraceParallelMax;
    private final int sparkJobTraceCacheMax;
    private final long sparkJobTraceTimeoutMs;
    private final ThreadPoolExecutor jobTraceThreadPool;
    private final Cache<String, SparkJobTraceMetric> sparkJobTraceCache;

    static {
        new SparkJobTrace$();
    }

    public long $lessinit$greater$default$5() {
        return System.currentTimeMillis();
    }

    public KapConfig kapConfig() {
        return this.kapConfig;
    }

    public int sparkJobTraceParallelMax() {
        return this.sparkJobTraceParallelMax;
    }

    public int sparkJobTraceCacheMax() {
        return this.sparkJobTraceCacheMax;
    }

    public long sparkJobTraceTimeoutMs() {
        return this.sparkJobTraceTimeoutMs;
    }

    public ThreadPoolExecutor jobTraceThreadPool() {
        return this.jobTraceThreadPool;
    }

    public Cache<String, SparkJobTraceMetric> sparkJobTraceCache() {
        return this.sparkJobTraceCache;
    }

    public SparkJobTraceMetric getSparkJobTraceMetric(String queryId) {
        return (SparkJobTraceMetric)this.sparkJobTraceCache().getIfPresent((Object)queryId);
    }

    private SparkJobTrace$() {
        MODULE$ = this;
        this.kapConfig = KapConfig.getInstanceFromEnv();
        this.sparkJobTraceParallelMax = this.kapConfig().getSparkJobTraceParallelMax();
        this.sparkJobTraceCacheMax = this.kapConfig().getSparkJobTraceCacheMax();
        this.sparkJobTraceTimeoutMs = this.kapConfig().getSparkJobTraceTimeoutMs();
        this.jobTraceThreadPool = new ThreadPoolExecutor(0, this.sparkJobTraceParallelMax(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("handler-job-trace-thread-pool"));
        this.sparkJobTraceCache = CacheBuilder.newBuilder().maximumSize((long)this.sparkJobTraceCacheMax()).expireAfterAccess(this.sparkJobTraceTimeoutMs() + 20000L, TimeUnit.MILLISECONDS).build();
    }
}

