/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime.plan;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.gluten.extension.GlutenSessionExtensions$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.BigQueryException;
import org.apache.kylin.common.exception.NewQueryRefuseException;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.QueryCostCollector;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.BigQueryThresholdUpdater;
import org.apache.kylin.metadata.state.QueryShareStateManager;
import org.apache.kylin.query.engine.RelColumnMetaDataExtractor;
import org.apache.kylin.query.engine.exec.ExecuteResult;
import org.apache.kylin.query.pushdown.SparkSqlClient$;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.runtime.plan.QueryToExecutionIDCache$;
import org.apache.kylin.query.util.AsyncQueryUtil;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.SparkJobTrace;
import org.apache.kylin.query.util.SparkJobTrace$;
import org.apache.kylin.query.util.SparkQueryJobManager$;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.execution.CollectLimitExec;
import org.apache.spark.sql.execution.ColumnarToRowExec;
import org.apache.spark.sql.execution.InputAdapter;
import org.apache.spark.sql.execution.KylinFileSourceScanExec;
import org.apache.spark.sql.execution.LocalLimitExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.WholeStageCodegenExec;
import org.apache.spark.sql.execution.gluten.KylinFileSourceScanExecTransformer;
import org.apache.spark.sql.hive.QueryMetricUtils$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ResultPlan$
implements LogEx {
    public static ResultPlan$ MODULE$;
    private final long PARTITION_SPLIT_BYTES;
    private final String SPARK_SCHEDULER_POOL;
    private final String QUOTE_CHAR;
    private final String END_OF_LINE_SYMBOLS;
    private final int CHECK_WRITE_SIZE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResultPlan$();
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long PARTITION_SPLIT_BYTES() {
        return this.PARTITION_SPLIT_BYTES;
    }

    public String SPARK_SCHEDULER_POOL() {
        return this.SPARK_SCHEDULER_POOL;
    }

    public String QUOTE_CHAR() {
        return this.QUOTE_CHAR;
    }

    public String END_OF_LINE_SYMBOLS() {
        return this.END_OF_LINE_SYMBOLS;
    }

    public int CHECK_WRITE_SIZE() {
        return this.CHECK_WRITE_SIZE;
    }

    public void saveAsyncQueryResult(Dataset<Row> df, String format, String encode, RelDataType rowType) {
        block14: {
            KapConfig kapConfig = KapConfig.getInstanceFromEnv();
            SparderEnv$.MODULE$.setDF(df);
            String path = new java.lang.StringBuilder(1).append(KapConfig.getInstanceFromEnv().getAsyncResultBaseDir(QueryContext.current().getProject())).append("/").append(QueryContext.current().getQueryId()).toString();
            String queryExecutionId = RandomUtil.randomUUIDStr();
            String jobGroup = Thread.currentThread().getName();
            SparkContext sparkContext = SparderEnv$.MODULE$.getSparkSession().sparkContext();
            sparkContext.setJobGroup(jobGroup, QueryContext.current().getMetrics().getCorrectedSql(), true);
            if (kapConfig.isQueryLimitEnabled() && SparderEnv$.MODULE$.isSparkExecutorResourceLimited(sparkContext.getConf())) {
                sparkContext.setLocalProperty(this.SPARK_SCHEDULER_POOL(), "async_query_tasks");
            }
            df.sparkSession().sparkContext().setLocalProperty(QueryToExecutionIDCache$.MODULE$.KYLIN_QUERY_EXECUTION_ID(), queryExecutionId);
            QueryContext.currentTrace().endLastSpan();
            SparkJobTrace jobTrace = new SparkJobTrace(jobGroup, QueryContext.currentTrace(), QueryContext.current().getQueryId(), sparkContext, SparkJobTrace$.MODULE$.$lessinit$greater$default$5());
            String dateTimeFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            String queryId = QueryContext.current().getQueryId();
            boolean includeHeader = QueryContext.current().getQueryTagInfo().isIncludeHeader();
            String string = format;
            if ("json".equals(string)) {
                String[] oldColumnNames = df.columns();
                List columnNames = QueryContext.current().getColumnNames();
                ObjectRef newDf = ObjectRef.create(df);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnNames.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    newDf$1.elem = ((Dataset)newDf$1.elem).withColumnRenamed(oldColumnNames[i], (String)columnNames.get(i));
                });
                ((Dataset)newDf.elem).write().option("timestampFormat", dateTimeFormat).option("encoding", encode).option("charset", "utf-8").mode(SaveMode.Append).json(path);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("parquet".equals(string)) {
                SQLContext sqlContext = SparderEnv$.MODULE$.getSparkSession().sqlContext();
                sqlContext.setConf("spark.sql.parquet.writeLegacyFormat", "true");
                if (rowType != null) {
                    Dataset<Row> newDf = this.wrapAlias(df, rowType);
                    this.normalizeSchema(newDf).write().mode(SaveMode.Overwrite).option("encoding", encode).option("charset", "utf-8").parquet(path);
                } else {
                    this.normalizeSchema(df).write().mode(SaveMode.Overwrite).option("encoding", encode).option("charset", "utf-8").parquet(path);
                }
                sqlContext.setConf("spark.sql.parquet.writeLegacyFormat", "false");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("csv".equals(string)) {
                this.processCsv(df, format, rowType, path, queryId, includeHeader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("xlsx".equals(string)) {
                this.processXlsx(df, format, rowType, path, queryId, includeHeader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.normalizeSchema(df).write().option("timestampFormat", dateTimeFormat).option("encoding", encode).option("charset", "utf-8").mode(SaveMode.Append).parquet(path);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            AsyncQueryUtil.SuccessFileContent successFileContent = QueryContext.current().isOutOfSegmentRange() ? new AsyncQueryUtil.SuccessFileContent(ErrorCodeServer.ASYNC_QUERY_OUT_OF_DATA_RANGE.getErrorCode().getCode()) : null;
            AsyncQueryUtil.createSuccessFlagWithContent((String)QueryContext.current().getProject(), (String)QueryContext.current().getQueryId(), (AsyncQueryUtil.SuccessFileContent)successFileContent);
            if (kapConfig.isQuerySparkJobTraceEnabled()) {
                jobTrace.jobFinished();
            }
            if (KylinConfig.getInstanceFromEnv().isUTEnv()) break block14;
            QueryExecution newExecution = QueryToExecutionIDCache$.MODULE$.getQueryExecution(queryExecutionId);
            Tuple2<List<Long>, List<Long>> tuple2 = QueryMetricUtils$.MODULE$.collectScanMetrics(newExecution.executedPlan());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List scanRows = (List)tuple2._1();
            List scanBytes = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)scanRows, (Object)scanBytes);
            Tuple2 tuple23 = tuple22;
            List scanRows2 = (List)tuple23._1();
            List scanBytes2 = (List)tuple23._2();
            Tuple3<Long, Long, Long> tuple3 = QueryMetricUtils$.MODULE$.collectTaskRelatedMetrics(jobGroup, sparkContext);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Long jobCount = (Long)tuple3._1();
            Long stageCount = (Long)tuple3._2();
            Long taskCount = (Long)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)jobCount, (Object)stageCount, (Object)taskCount);
            Tuple3 tuple33 = tuple32;
            Long jobCount2 = (Long)tuple33._1();
            Long stageCount2 = (Long)tuple33._2();
            Long taskCount2 = (Long)tuple33._3();
            long cpuTime = QueryCostCollector.getAndCleanStatus((String)QueryContext.current().getQueryId());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("scanRows is ").append(scanRows2).append(", scanBytes is ").append(scanBytes2).toString());
            QueryContext.current().getMetrics().setScanRows(scanRows2);
            QueryContext.current().getMetrics().setScanBytes(scanBytes2);
            QueryContext.current().getMetrics().setQueryJobCount(Predef$.MODULE$.Long2long(jobCount2));
            QueryContext.current().getMetrics().setQueryStageCount(Predef$.MODULE$.Long2long(stageCount2));
            QueryContext.current().getMetrics().setQueryTaskCount(Predef$.MODULE$.Long2long(taskCount2));
            QueryContext.current().getMetrics().setCpuTime(cpuTime);
            this.setResultRowCount(newExecution.executedPlan());
        }
    }

    private void ifRefuseQuery(long sumOfSourceScanRows, long bigQueryThreshold, List<Long> sourceScanRows, boolean ifBigQuery) {
        if (QueryShareStateManager.isShareStateSwitchEnabled() && sumOfSourceScanRows >= bigQueryThreshold && (SparkQueryJobManager$.MODULE$.isNewBigQueryRefuse() || KapConfig.getInstanceFromEnv().isBigQueryLimitEnable())) {
            if (ifBigQuery) {
                QueryContext.current().setBigQuery(true);
                QueryContext.current().getMetrics().setScanRows(sourceScanRows);
                throw new BigQueryException("This query is bigquery.");
            }
            QueryContext.current().getQueryTagInfo().setRefused(true);
            throw new NewQueryRefuseException(new java.lang.StringBuilder(125).append("Refuse new big query, sum of source_scan_rows is ").append(sumOfSourceScanRows).append(", refuse query threshold is ").append(bigQueryThreshold).append(". Current step: Collecting dataset for sparder. ").toString());
        }
        if (ifBigQuery) {
            QueryContext.current().getMetrics().setScanRows(sourceScanRows);
            QueryContext.current().setBigQuery(false);
            throw new BigQueryException("This query is non bigquery.");
        }
    }

    public void asyncQueryIteratorWriteCsv(Iterator<Row> resultRows, OutputStreamWriter outputStream, RelDataType rowType) {
        Iterable<List<String>> iterable;
        IntRef asyncQueryRowSize = IntRef.create((int)0);
        String separator = QueryContext.current().getQueryTagInfo().getSeparator();
        if (rowType != null) {
            Buffer resultTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala();
            iterable = this.readResultRow(resultRows, (Buffer<RelDataTypeField>)resultTypes);
        } else {
            iterable = SparkSqlClient$.MODULE$.readPushDownResultRow(resultRows, false);
        }
        Iterable<List<String>> asyncQueryResult = iterable;
        asyncQueryResult.forEach(row -> {
            block0: {
                ++asyncQueryRowSize$1.elem;
                StringBuilder builder = new StringBuilder();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.size()).foreach((Function1 & Serializable & scala.Serializable)i -> ResultPlan$.$anonfun$asyncQueryIteratorWriteCsv$2(row, builder, separator, BoxesRunTime.unboxToInt((Object)i)));
                builder.append(MODULE$.END_OF_LINE_SYMBOLS());
                outputStream.write(builder.toString());
                if (asyncQueryRowSize$1.elem % MODULE$.CHECK_WRITE_SIZE() != 0) break block0;
                outputStream.flush();
            }
        });
        outputStream.flush();
    }

    private String getNormalizedExplain(Dataset<Row> df) {
        return df.queryExecution().executedPlan().toString().replaceAll("#\\d+", "#x");
    }

    public String getQueryFairSchedulerPool(SparkConf sparkConf, QueryContext queryContext, long bigQueryThreshold, long sumOfSourceScanRows, int partitionsNum) {
        String pool;
        block1: {
            block3: {
                block2: {
                    block0: {
                        pool = "heavy_tasks";
                        if (!queryContext.getQueryTagInfo().isHighPriorityQuery()) break block0;
                        pool = "vip_tasks";
                        break block1;
                    }
                    if (!queryContext.getQueryTagInfo().isTableIndex()) break block2;
                    pool = "extreme_heavy_tasks";
                    break block1;
                }
                if (!KapConfig.getInstanceFromEnv().isQueryLimitEnabled() || !SparderEnv$.MODULE$.isSparkExecutorResourceLimited(sparkConf)) break block3;
                if (sumOfSourceScanRows >= bigQueryThreshold) break block1;
                pool = "lightweight_tasks";
                break block1;
            }
            if (partitionsNum >= SparderEnv$.MODULE$.getTotalCore()) break block1;
            pool = "lightweight_tasks";
        }
        return pool;
    }

    public void extractEachStageLimitRows(SparkPlan exPlan, int stageLimitRows, AtomicLong rowsCounter) {
        SparkPlan sparkPlan = exPlan;
        if (sparkPlan instanceof KylinFileSourceScanExec) {
            KylinFileSourceScanExec kylinFileSourceScanExec = (KylinFileSourceScanExec)sparkPlan;
            long sourceScanRows = kylinFileSourceScanExec.getSourceScanRows();
            long finalScanRows = stageLimitRows > 0 ? Math.min((long)stageLimitRows, sourceScanRows) : sourceScanRows;
            rowsCounter.addAndGet(finalScanRows);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(75).append("Apply limit to source scan, sourceScanRows: ").append(sourceScanRows).append(", ").append("stageLimit: ").append(stageLimitRows).append(", finalScanRows: ").append(finalScanRows).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof KylinFileSourceScanExecTransformer) {
            KylinFileSourceScanExecTransformer kylinFileSourceScanExecTransformer = (KylinFileSourceScanExecTransformer)sparkPlan;
            long sourceScanRows = kylinFileSourceScanExecTransformer.getSourceScanRows();
            long finalScanRows = stageLimitRows > 0 ? Math.min((long)stageLimitRows, sourceScanRows) : sourceScanRows;
            rowsCounter.addAndGet(finalScanRows);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(75).append("Apply limit to source scan, sourceScanRows: ").append(sourceScanRows).append(", ").append("stageLimit: ").append(stageLimitRows).append(", finalScanRows: ").append(finalScanRows).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            IntRef tempStageLimitRows = IntRef.create((int)stageLimitRows);
            SparkPlan sparkPlan2 = exPlan;
            if (sparkPlan2 instanceof LocalLimitExec) {
                LocalLimitExec localLimitExec = (LocalLimitExec)sparkPlan2;
                tempStageLimitRows.elem = localLimitExec.limit();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (sparkPlan2 instanceof CollectLimitExec) {
                CollectLimitExec collectLimitExec = (CollectLimitExec)sparkPlan2;
                tempStageLimitRows.elem = collectLimitExec.limit();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (!(exPlan instanceof ProjectExec || exPlan instanceof ColumnarToRowExec || exPlan instanceof InputAdapter || exPlan instanceof WholeStageCodegenExec)) {
                    tempStageLimitRows.elem = -1;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            exPlan.children().foreach((Function1 & Serializable & scala.Serializable)childPlan -> {
                ResultPlan$.MODULE$.extractEachStageLimitRows(childPlan, tempStageLimitRows.elem, rowsCounter);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <U> U withScope(Dataset<Row> df, Function0<U> methodBody) {
        Object object;
        HadoopUtil.setCurrentConfiguration((Configuration)df.sparkSession().sparkContext().hadoopConfiguration());
        try {
            object = methodBody.apply();
        }
        finally {
            df.sparkSession().sparkContext().setLocalProperty(this.SPARK_SCHEDULER_POOL(), null);
            df.sparkSession().sessionState().conf().setLocalProperty("spark.sql.shuffle.partitions", null);
            SparderEnv$.MODULE$.setDF(df);
            HadoopUtil.setCurrentConfiguration(null);
        }
        return (U)object;
    }

    public ExecuteResult getResult(Dataset<Row> df, RelDataType rowType) {
        return (ExecuteResult)this.withScope(df, (Function0 & Serializable & scala.Serializable)() -> {
            QueryContext.QueryTagInfo queryTagInfo;
            if (!ContextUtil.getNativeRealizations().isEmpty() && !KylinConfig.getInstanceFromEnv().queryIndexUseGluten()) {
                df.sparkSession().sparkContext().setLocalProperty(GlutenSessionExtensions$.MODULE$.GLUTEN_ENABLE_FOR_THREAD_KEY(), "false");
            }
            if ((queryTagInfo = QueryContext.current().getQueryTagInfo()).isAsyncQuery()) {
                MODULE$.saveAsyncQueryResult(df, queryTagInfo.getFileFormat(), queryTagInfo.getFileEncode(), rowType);
            }
            Tuple2 result = Predef$.MODULE$.Boolean2boolean(SparderEnv$.MODULE$.needCompute()) && !QueryContext.current().getQueryTagInfo().isAsyncQuery() ? MODULE$.collectInternal(df, rowType) : new Tuple2(new LinkedList(), (Object)BoxesRunTime.boxToInteger((int)0));
            return new ExecuteResult((Iterable)result._1(), result._2$mcI$sp());
        });
    }

    public ExecuteResult completeResultForMdx(Dataset<Row> df, RelDataType rowType) {
        Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RelColumnMetaDataExtractor.getColumnMetadata((RelDataType)rowType)).asScala();
        Seq fieldAlias = (Seq)fields.map((Function1 & Serializable & scala.Serializable)filed -> filed.getName(), Buffer$.MODULE$.canBuildFrom());
        SparderEnv$.MODULE$.setDF((Dataset<Row>)df.toDF(fieldAlias));
        return new ExecuteResult(new LinkedList(), 0);
    }

    public Dataset<Row> wrapAlias(Dataset<Row> originDS, RelDataType rowType) {
        Buffer newFields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)t -> t.getName(), Buffer$.MODULE$.canBuildFrom());
        Dataset newDS = originDS.toDF((Seq)newFields);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Wrap ALIAS ").append(originDS.schema().treeString()).append(" TO ").append(newDS.schema().treeString()).toString());
        return newDS;
    }

    private Tuple2<Iterable<List<String>>, Object> collectInternal(Dataset<Row> df, RelDataType rowType) {
        return (Tuple2)this.logTime("collectInternal", true, (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            String jobGroup = Thread.currentThread().getName();
            SparkContext sparkContext = SparderEnv$.MODULE$.getSparkSession().sparkContext();
            KapConfig kapConfig = KapConfig.getInstanceFromEnv();
            int partitionsNum = kapConfig.getSparkSqlShufflePartitions() != -1 ? kapConfig.getSparkSqlShufflePartitions() : (int)Math.min(QueryContext.current().getMetrics().getSourceScanBytes() / MODULE$.PARTITION_SPLIT_BYTES() + 1L, (long)SparderEnv$.MODULE$.getTotalCore());
            QueryContext.current().setShufflePartitions(partitionsNum);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(63).append("partitions num are: ").append(partitionsNum).append(",").append(" total scan bytes are: ").append(QueryContext.current().getMetrics().getSourceScanBytes()).append(",").append(" total cores are: ").append(SparderEnv$.MODULE$.getTotalCore()).toString());
            String queryId = QueryContext.current().getQueryId();
            sparkContext.setLocalProperty(QueryToExecutionIDCache$.MODULE$.KYLIN_QUERY_ID_KEY(), queryId);
            sparkContext.setJobGroup(jobGroup, QueryContext.current().getMetrics().getCorrectedSql(), true);
            try {
                try {
                    long autoBroadcastJoinThreshold = SparderEnv$.MODULE$.getSparkSession().sessionState().conf().autoBroadcastJoinThreshold();
                    SparkPlan sparkPlan = df.queryExecution().executedPlan();
                    LongRef sumOfSourceScanRows = LongRef.create((long)QueryContext.current().getMetrics().getAccumSourceScanRows());
                    if (KapConfig.getInstanceFromEnv().isQueryLimitEnabled() && KapConfig.getInstanceFromEnv().isApplyLimitInfoToSourceScanRowsEnabled()) {
                        AtomicLong accumRowsCounter = new AtomicLong(0L);
                        MODULE$.extractEachStageLimitRows(sparkPlan, -1, accumRowsCounter);
                        sumOfSourceScanRows.elem = accumRowsCounter.get();
                        MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(47).append("Spark executed plan is \n ").append(sparkPlan).append("; \n accumRowsCounter: ").append(accumRowsCounter).toString());
                    }
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("autoBroadcastJoinThreshold: [before:").append(autoBroadcastJoinThreshold).append(", ").append("after: ").append(SparderEnv$.MODULE$.getSparkSession().sessionState().conf().autoBroadcastJoinThreshold()).append("]").toString());
                    sparkContext.setLocalProperty("source_scan_rows", Long.toString(QueryContext.current().getMetrics().getSourceScanRows()));
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("source_scan_rows is ").append(Long.toString(QueryContext.current().getMetrics().getSourceScanRows())).toString());
                    long bigQueryThreshold = BigQueryThresholdUpdater.getBigQueryThreshold();
                    String pool = MODULE$.getQueryFairSchedulerPool(sparkContext.getConf(), QueryContext.current(), bigQueryThreshold, sumOfSourceScanRows.elem, partitionsNum);
                    sparkContext.setLocalProperty(MODULE$.SPARK_SCHEDULER_POOL(), pool);
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(24).append("Total source scan rows: ").append(sumOfSourceScanRows$1.elem).toString());
                    List sourceScanRows = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Long[]{new Long(sumOfSourceScanRows.elem)})).toList()).asJava();
                    boolean ifBigQuery = QueryContext.current().isIfBigQuery();
                    MODULE$.ifRefuseQuery(sumOfSourceScanRows.elem, bigQueryThreshold, sourceScanRows, ifBigQuery);
                    QueryContext.current().record("executed_plan");
                    QueryContext.currentTrace().endLastSpan();
                    SparkJobTrace jobTrace = new SparkJobTrace(jobGroup, QueryContext.currentTrace(), QueryContext.current().getQueryId(), sparkContext, SparkJobTrace$.MODULE$.$lessinit$greater$default$5());
                    Tuple2 results = NProjectManager.getProjectConfig((String)QueryContext.current().getProject()).isQueryUseIterableCollectApi() ? df.collectToIterator() : df.toIterator();
                    Iterator resultRows = (Iterator)results._1();
                    int resultSize = results._2$mcI$sp();
                    if (kapConfig.isQuerySparkJobTraceEnabled()) {
                        jobTrace.jobFinished();
                    }
                    QueryContext.current().record("collect_result");
                    Tuple2<List<Long>, List<Long>> tuple22 = QueryMetricUtils$.MODULE$.collectScanMetrics(df.queryExecution().executedPlan());
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    List scanRows = (List)tuple22._1();
                    List scanBytes = (List)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)scanRows, (Object)scanBytes);
                    Tuple2 tuple24 = tuple23;
                    List scanRows2 = (List)tuple24._1();
                    List scanBytes2 = (List)tuple24._2();
                    Tuple3<Long, Long, Long> tuple3 = QueryMetricUtils$.MODULE$.collectTaskRelatedMetrics(jobGroup, sparkContext);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    Long jobCount = (Long)tuple3._1();
                    Long stageCount = (Long)tuple3._2();
                    Long taskCount = (Long)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)jobCount, (Object)stageCount, (Object)taskCount);
                    Tuple3 tuple33 = tuple32;
                    Long jobCount2 = (Long)tuple33._1();
                    Long stageCount2 = (Long)tuple33._2();
                    Long taskCount2 = (Long)tuple33._3();
                    long cpuTime = QueryCostCollector.getAndCleanStatus((String)QueryContext.current().getQueryId());
                    QueryContext.current().getMetrics().setScanRows(scanRows2);
                    QueryContext.current().getMetrics().setScanBytes(scanBytes2);
                    QueryContext.current().getMetrics().setQueryJobCount(Predef$.MODULE$.Long2long(jobCount2));
                    QueryContext.current().getMetrics().setQueryStageCount(Predef$.MODULE$.Long2long(stageCount2));
                    QueryContext.current().getMetrics().setQueryTaskCount(Predef$.MODULE$.Long2long(taskCount2));
                    QueryContext.current().getMetrics().setCpuTime(cpuTime);
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(144).append("Actual total scan count: ").append(scanRows2).append(", ").append("file scan row count: ").append(QueryContext.current().getMetrics().getAccumSourceScanRows()).append(", ").append("may apply limit row count: ").append(sumOfSourceScanRows$1.elem).append(", Big query threshold: ").append(bigQueryThreshold).append(", Allocate pool: ").append(pool).append(", ").append("Is Vip: ").append(QueryContext.current().getQueryTagInfo().isHighPriorityQuery()).append(", ").append("Is TableIndex: ").append(QueryContext.current().getQueryTagInfo().isTableIndex()).toString());
                    Buffer resultTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala();
                    tuple2 = new Tuple2(MODULE$.readResultRow(resultRows, (Buffer<RelDataTypeField>)resultTypes), (Object)BoxesRunTime.boxToInteger((int)resultSize));
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        sparkContext.cancelJobGroup(jobGroup);
                        QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted at the stage of collecting result in ResultPlan.", (String)"Current step: Collecting dataset for sparder.");
                    }
                    throw e;
                }
            }
            finally {
                QueryContext.current().setExecutionID(QueryToExecutionIDCache$.MODULE$.getQueryExecutionID(queryId));
            }
            return tuple2;
        });
    }

    public void setResultRowCount(SparkPlan plan) {
        block0: {
            if (QueryContext.current().getMetrics().getResultRowCount() != 0L) break block0;
            QueryContext.current().getMetrics().setResultRowCount(BoxesRunTime.unboxToLong((Object)plan.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        }
    }

    public void processCsv(Dataset<Row> df, String format, RelDataType rowType, String path, String queryId, boolean includeHeader) {
        Tuple2 tuple2;
        File file = this.createTmpFile(queryId, format);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        if (includeHeader) {
            this.processCsvHeader(writer, rowType);
        }
        if ((tuple2 = df.toIterator()) == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator iterator = (Iterator)tuple2._1();
        int resultRowSize = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)iterator, (Object)BoxesRunTime.boxToInteger((int)resultRowSize));
        Tuple2 tuple23 = tuple22;
        Iterator iterator2 = (Iterator)tuple23._1();
        int resultRowSize2 = tuple23._2$mcI$sp();
        this.asyncQueryIteratorWriteCsv(iterator2, writer, rowType);
        this.uploadAsyncQueryResult(file, path, queryId, format);
        this.setResultRowCount(resultRowSize2);
    }

    public void processXlsx(Dataset<Row> df, String format, RelDataType rowType, String path, String queryId, boolean includeHeader) {
        Tuple2 tuple2;
        File file = this.createTmpFile(queryId, format);
        FileOutputStream outputStream = new FileOutputStream(file);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("query_result");
        IntRef num = IntRef.create((int)0);
        if (includeHeader) {
            this.processXlsxHeader(sheet, rowType);
            ++num.elem;
        }
        if ((tuple2 = df.toIterator()) == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator iterator = (Iterator)tuple2._1();
        int resultRowSize = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)iterator, (Object)BoxesRunTime.boxToInteger((int)resultRowSize));
        Tuple2 tuple23 = tuple22;
        Iterator iterator2 = (Iterator)tuple23._1();
        int resultRowSize2 = tuple23._2$mcI$sp();
        ImplicitConversions$.MODULE$.iterator$u0020asScala(iterator2).foreach((Function1 & Serializable & scala.Serializable)row -> {
            ResultPlan$.$anonfun$processXlsx$1(sheet, num, row);
            return BoxedUnit.UNIT;
        });
        workbook.write((OutputStream)outputStream);
        this.uploadAsyncQueryResult(file, path, queryId, format);
        this.setResultRowCount(resultRowSize2);
    }

    private void setResultRowCount(int resultRowSize) {
        block0: {
            if (KylinConfig.getInstanceFromEnv().isUTEnv()) break block0;
            QueryContext.current().getMetrics().setResultRowCount((long)resultRowSize);
        }
    }

    public void processCsvHeader(OutputStreamWriter writer, RelDataType rowType) {
        String separator = QueryContext.current().getQueryTagInfo().getSeparator();
        RelDataType relDataType = rowType;
        if (relDataType == null) {
            String columnNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(QueryContext.current().getColumnNames()).asScala()).mkString(separator);
            writer.write(new java.lang.StringBuilder(0).append(columnNames).append(this.END_OF_LINE_SYMBOLS()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            StringBuilder builder = new StringBuilder();
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)t -> t.getName(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)column -> builder.append(new java.lang.StringBuilder(0).append(separator).append((String)column).toString()));
            builder.deleteCharAt(0);
            writer.write(new java.lang.StringBuilder(0).append(builder.toString()).append(this.END_OF_LINE_SYMBOLS()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        writer.flush();
    }

    public void processXlsxHeader(XSSFSheet sheet, RelDataType rowType) {
        XSSFRow excelRow = sheet.createRow(0);
        RelDataType relDataType = rowType;
        if (relDataType == null) {
            List columnNameArray = QueryContext.current().getColumnNames();
            ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(columnNameArray).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)it -> {
                ResultPlan$.$anonfun$processXlsxHeader$1(excelRow, it);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Buffer columnArray = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)t -> t.getName(), Buffer$.MODULE$.canBuildFrom());
            ((IterableLike)columnArray.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)it -> {
                ResultPlan$.$anonfun$processXlsxHeader$3(excelRow, it);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public File createTmpFile(String queryId, String format) {
        void var3_3;
        File file = new File(new java.lang.StringBuilder(0).append(queryId).append(format).toString());
        file.createNewFile();
        return var3_3;
    }

    public void uploadAsyncQueryResult(File file, String path, String queryId, String format) {
        block0: {
            AsyncQueryUtil.getFileSystem().copyFromLocalFile(true, true, new Path(file.getAbsolutePath()), new Path(new java.lang.StringBuilder(2).append(path).append("/").append(queryId).append(".").append(format).toString()));
            if (!file.exists()) break block0;
            file.delete();
        }
    }

    public Iterable<List<String>> readResultRow(Iterator<Row> resultRows, Buffer<RelDataTypeField> resultTypes) {
        return () -> new Iterator<List<String>>(resultRows, resultTypes){
            private final Iterator resultRows$1;
            private final Buffer resultTypes$1;

            public void remove() {
                Iterator.super.remove();
            }

            public void forEachRemaining(Consumer<? super List<String>> x$1) {
                Iterator.super.forEachRemaining(x$1);
            }

            public boolean hasNext() {
                return this.resultRows$1.hasNext();
            }

            public List<String> next() {
                Row row = (Row)this.resultRows$1.next();
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)row.toSeq().zip((GenIterable)this.resultTypes$1, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object value = tuple2._1();
                    RelDataTypeField relField = (RelDataTypeField)tuple2._2();
                    String string = SparderTypeUtil$.MODULE$.convertToStringWithCalciteType(value, relField.getType(), SparderTypeUtil$.MODULE$.convertToStringWithCalciteType$default$3());
                    return string;
                }, Seq$.MODULE$.canBuildFrom())).asJava();
            }
            {
                this.resultRows$1 = resultRows$1;
                this.resultTypes$1 = resultTypes$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public String encodeCell(String column1, String separator) {
        void var3_3;
        boolean needQuote;
        String column = column1;
        boolean bl = needQuote = column.contains(separator) || column.contains("\r") || column.contains("\n");
        if (column.contains(this.QUOTE_CHAR())) {
            needQuote = true;
            column = column.replace(this.QUOTE_CHAR(), new java.lang.StringBuilder(0).append(this.QUOTE_CHAR()).append(this.QUOTE_CHAR()).toString());
        }
        return needQuote ? new java.lang.StringBuilder(0).append(this.QUOTE_CHAR()).append(column).append(this.QUOTE_CHAR()).toString() : var3_3;
    }

    public Seq<String> normalize(Seq<String> columns) {
        return (Seq)columns.map((Function1 & Serializable & scala.Serializable)c -> c.replace(" ", "_").replace(",", "_").replace(";", "_").replace("{", "_").replace("}", "_").replace("(", "_").replace(")", "_").replace("\\n", "_").replace("\\t", "_").replace("=", "_"), Seq$.MODULE$.canBuildFrom());
    }

    public Dataset<Row> normalizeSchema(Dataset<Row> originDS) {
        return originDS.toDF(this.normalize((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])originDS.columns())));
    }

    public static final /* synthetic */ StringBuilder $anonfun$asyncQueryIteratorWriteCsv$2(List row$1, StringBuilder builder$1, String separator$1, int i) {
        String column = row$1.get(i) == null ? "" : (String)row$1.get(i);
        Object object = i > 0 ? builder$1.append(separator$1) : BoxedUnit.UNIT;
        String escapedCsv = MODULE$.encodeCell(column, separator$1);
        return builder$1.append(escapedCsv);
    }

    public static final /* synthetic */ void $anonfun$processXlsx$2(XSSFRow row1$1, Tuple2 it) {
        row1$1.createCell(it._2$mcI$sp()).setCellValue(it._1().toString());
    }

    public static final /* synthetic */ void $anonfun$processXlsx$1(XSSFSheet sheet$1, IntRef num$1, Row row) {
        XSSFRow row1 = sheet$1.createRow(num$1.elem);
        ((IterableLike)row.toSeq().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)it -> {
            ResultPlan$.$anonfun$processXlsx$2(row1, it);
            return BoxedUnit.UNIT;
        });
        ++num$1.elem;
    }

    public static final /* synthetic */ void $anonfun$processXlsxHeader$1(XSSFRow excelRow$1, Tuple2 it) {
        excelRow$1.createCell(it._2$mcI$sp()).setCellValue((String)it._1());
    }

    public static final /* synthetic */ void $anonfun$processXlsxHeader$3(XSSFRow excelRow$1, Tuple2 it) {
        excelRow$1.createCell(it._2$mcI$sp()).setCellValue((String)it._1());
    }

    private ResultPlan$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.PARTITION_SPLIT_BYTES = KylinConfig.getInstanceFromEnv().getQueryPartitionSplitSizeMB() * 1024 * 1024;
        this.SPARK_SCHEDULER_POOL = "spark.scheduler.pool";
        this.QUOTE_CHAR = "\"";
        this.END_OF_LINE_SYMBOLS = "\n";
        this.CHECK_WRITE_SIZE = 1000;
    }
}

