/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AclTCRRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/acl"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenAclTCRController
extends NBasicController {
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRService aclTCRService;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;

    @ApiOperation(value="updateProjectAcl", tags={"MID"}, notes="Update URL: {project}; Update Param: project")
    @PutMapping(value={"/sid/{sid_type:.+}/{sid:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> updateProject(@PathVariable(value="sid_type") String sidType, @PathVariable(value="sid") String sid, @RequestParam(value="project") String project, @RequestBody List<AclTCRRequest> requests) throws IOException {
        this.checkProjectName(project);
        AclPermissionUtil.checkAclUpdatable((String)project, (Set)this.aclTCRService.getCurrentUserGroups());
        requests.stream().forEach(request -> Optional.ofNullable(request.getTables()).orElse(Lists.newArrayList()).stream().forEach(table -> table.setRowFilter(null)));
        if (sidType.equalsIgnoreCase("user")) {
            sid = this.makeUserNameCaseInSentive(sid);
            this.mergeSidAclTCR(project, sid, true, requests);
        } else if (sidType.equalsIgnoreCase("group")) {
            this.mergeSidAclTCR(project, sid, false, requests);
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidSidType());
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private void mergeSidAclTCR(String project, String sid, boolean principal, List<AclTCRRequest> requests) throws IOException {
        this.mergeSidAclTCR(project, sid, principal, requests, null);
    }

    private void mergeSidAclTCR(String project, String sid, boolean principal, List<AclTCRRequest> requests, Set<String> allGroups) throws IOException {
        if (allGroups != null) {
            this.accessService.batchCheckSid(sid, principal, allGroups);
        } else {
            this.accessService.checkSid(sid, principal);
        }
        boolean hasProjectPermission = this.accessService.hasProjectPermission(project, sid, principal);
        if (!hasProjectPermission) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, String.format(Locale.ROOT, msg.getGrantTableWithSidHasNotProjectPermission(), sid, project));
        }
        this.aclTCRService.mergeAclTCR(project, sid, principal, requests);
    }

    @ApiOperation(value="updateProjectAcl With New Foramt", tags={"MID"}, notes="Update URL: {project}; Update Param: project")
    @PutMapping(value={"/batch/{sid_type:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> batchUpdateProject(@PathVariable(value="sid_type") String sidType, @RequestParam(value="project") String project, @RequestBody Map<String, List<AclTCRRequest>> requests) throws IOException {
        this.checkProjectName(project);
        Preconditions.checkState((boolean)sidType.equalsIgnoreCase("group"));
        AclPermissionUtil.checkAclUpdatable((String)project, (Set)this.aclTCRService.getCurrentUserGroups());
        List allGroups = this.userGroupService.getAllUserGroups();
        if (CollectionUtils.isEmpty((Collection)allGroups)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USERGROUP_NAME, MsgPicker.getMsg().getEmptySid());
        }
        HashSet groupSet = Sets.newHashSet((Iterable)allGroups);
        for (Map.Entry<String, List<AclTCRRequest>> entry : requests.entrySet()) {
            this.mergeSidAclTCR(project, entry.getKey(), false, entry.getValue(), groupSet);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateProjectAcl With New Foramt", tags={"MID"}, notes="Update URL: {project}; Update Param: project")
    @PutMapping(value={"/{sid_type:.+}/{sid:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> updateProjectV2(@PathVariable(value="sid_type") String sidType, @PathVariable(value="sid") String sid, @RequestParam(value="project") String project, @RequestBody List<AclTCRRequest> requests) throws IOException {
        this.checkProjectName(project);
        AclPermissionUtil.checkAclUpdatable((String)project, (Set)this.aclTCRService.getCurrentUserGroups());
        if (sidType.equalsIgnoreCase("user")) {
            sid = this.makeUserNameCaseInSentive(sid);
            this.mergeSidAclTCR(project, sid, true, requests);
        } else if (sidType.equalsIgnoreCase("group")) {
            this.mergeSidAclTCR(project, sid, false, requests);
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidSidType());
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

