/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.server.share.persister.PartitionErrorData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PersisterResult;
import org.apache.kafka.server.share.persister.TopicData;

public class InitializeShareGroupStateResult
implements PersisterResult {
    private final List<TopicData<PartitionErrorData>> topicsData;

    private InitializeShareGroupStateResult(List<TopicData<PartitionErrorData>> topicsData) {
        this.topicsData = topicsData;
    }

    public List<TopicData<PartitionErrorData>> topicsData() {
        return this.topicsData;
    }

    public static InitializeShareGroupStateResult from(InitializeShareGroupStateResponseData data) {
        return new Builder().setTopicsData(data.results().stream().map(initializeStateResult -> new TopicData(initializeStateResult.topicId(), initializeStateResult.partitions().stream().map(partitionResult -> PartitionFactory.newPartitionErrorData(partitionResult.partition(), partitionResult.errorCode(), partitionResult.errorMessage())).collect(Collectors.toList()))).collect(Collectors.toList())).build();
    }

    public static class Builder {
        private List<TopicData<PartitionErrorData>> topicsData;

        public Builder setTopicsData(List<TopicData<PartitionErrorData>> topicsData) {
            this.topicsData = topicsData;
            return this;
        }

        public InitializeShareGroupStateResult build() {
            return new InitializeShareGroupStateResult(this.topicsData);
        }
    }
}

