/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.ConsumerGroupMigrationPolicy;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;

public class GroupCoordinatorConfig {
    public static final String NEW_GROUP_COORDINATOR_ENABLE_CONFIG = "group.coordinator.new.enable";
    public static final String NEW_GROUP_COORDINATOR_ENABLE_DOC = "Enable the new group coordinator.";
    public static final boolean NEW_GROUP_COORDINATOR_ENABLE_DEFAULT = true;
    public static final String GROUP_COORDINATOR_REBALANCE_PROTOCOLS_CONFIG = "group.coordinator.rebalance.protocols";
    public static final String GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DOC = "The list of enabled rebalance protocols.The " + String.valueOf((Object)Group.GroupType.SHARE) + " rebalance protocol is in early access and therefore must not be used in production.";
    public static final List<String> GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DEFAULT = List.of(Group.GroupType.CLASSIC.toString(), Group.GroupType.CONSUMER.toString());
    public static final String GROUP_COORDINATOR_APPEND_LINGER_MS_CONFIG = "group.coordinator.append.linger.ms";
    public static final String GROUP_COORDINATOR_APPEND_LINGER_MS_DOC = "The duration in milliseconds that the coordinator will wait for writes to accumulate before flushing them to disk. Transactional writes are not accumulated.";
    public static final int GROUP_COORDINATOR_APPEND_LINGER_MS_DEFAULT = 5;
    public static final String GROUP_COORDINATOR_NUM_THREADS_CONFIG = "group.coordinator.threads";
    public static final String GROUP_COORDINATOR_NUM_THREADS_DOC = "The number of threads used by the group coordinator.";
    public static final int GROUP_COORDINATOR_NUM_THREADS_DEFAULT = 4;
    public static final String OFFSETS_LOAD_BUFFER_SIZE_CONFIG = "offsets.load.buffer.size";
    public static final int OFFSETS_LOAD_BUFFER_SIZE_DEFAULT = 0x500000;
    public static final String OFFSETS_LOAD_BUFFER_SIZE_DOC = "Batch size for reading from the offsets segments when loading group metadata  into the cache (soft-limit, overridden if records are too large).";
    public static final String OFFSET_COMMIT_TIMEOUT_MS_CONFIG = "offsets.commit.timeout.ms";
    public static final int OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000;
    public static final String OFFSET_COMMIT_TIMEOUT_MS_DOC = "Offset commit will be delayed until all replicas for the offsets topic receive the commit or this timeout is reached. This is similar to the producer request timeout. This is applied to all the writes made by the coordinator.";
    public static final String OFFSETS_TOPIC_PARTITIONS_CONFIG = "offsets.topic.num.partitions";
    public static final int OFFSETS_TOPIC_PARTITIONS_DEFAULT = 50;
    public static final String OFFSETS_TOPIC_PARTITIONS_DOC = "The number of partitions for the offset commit topic (should not change after deployment).";
    public static final String OFFSETS_TOPIC_SEGMENT_BYTES_CONFIG = "offsets.topic.segment.bytes";
    public static final int OFFSETS_TOPIC_SEGMENT_BYTES_DEFAULT = 0x6400000;
    public static final String OFFSETS_TOPIC_SEGMENT_BYTES_DOC = "The offsets topic segment bytes should be kept relatively small in order to facilitate faster log compaction and cache loads.";
    public static final String OFFSETS_TOPIC_REPLICATION_FACTOR_CONFIG = "offsets.topic.replication.factor";
    public static final short OFFSETS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String OFFSETS_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the offsets topic (set higher to ensure availability). Internal topic creation will fail until the cluster size meets this replication factor requirement.";
    public static final String OFFSETS_TOPIC_COMPRESSION_CODEC_CONFIG = "offsets.topic.compression.codec";
    public static final CompressionType OFFSETS_TOPIC_COMPRESSION_CODEC_DEFAULT = CompressionType.NONE;
    public static final String OFFSETS_TOPIC_COMPRESSION_CODEC_DOC = "Compression codec for the offsets topic - compression may be used to achieve \"atomic\" commits.";
    public static final String OFFSET_METADATA_MAX_SIZE_CONFIG = "offset.metadata.max.bytes";
    public static final int OFFSET_METADATA_MAX_SIZE_DEFAULT = 4096;
    public static final String OFFSET_METADATA_MAX_SIZE_DOC = "The maximum size for a metadata entry associated with an offset commit.";
    public static final String OFFSETS_RETENTION_MINUTES_CONFIG = "offsets.retention.minutes";
    public static final int OFFSETS_RETENTION_MINUTES_DEFAULT = 10080;
    public static final String OFFSETS_RETENTION_MINUTES_DOC = "For subscribed consumers, committed offset of a specific partition will be expired and discarded when 1) this retention period has elapsed after the consumer group loses all its consumers (i.e. becomes empty); 2) this retention period has elapsed since the last time an offset is committed for the partition and the group is no longer subscribed to the corresponding topic. For standalone consumers (using manual assignment), offsets will be expired after this retention period has elapsed since the time of last commit. Note that when a group is deleted via the delete-group request, its committed offsets will also be deleted without extra retention period; also when a topic is deleted via the delete-topic request, upon propagated metadata update any group's committed offsets for that topic will also be deleted without extra retention period.";
    public static final String OFFSETS_RETENTION_CHECK_INTERVAL_MS_CONFIG = "offsets.retention.check.interval.ms";
    public static final long OFFSETS_RETENTION_CHECK_INTERVAL_MS_DEFAULT = 600000L;
    public static final String OFFSETS_RETENTION_CHECK_INTERVAL_MS_DOC = "Frequency at which to check for stale offsets";
    public static final String GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.min.session.timeout.ms";
    public static final String GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for registered consumers. Shorter timeouts result in quicker failure detection at the cost of more frequent consumer heartbeating, which can overwhelm broker resources.";
    public static final int GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 6000;
    public static final String GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.max.session.timeout.ms";
    public static final String GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.";
    public static final int GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 1800000;
    public static final String GROUP_INITIAL_REBALANCE_DELAY_MS_CONFIG = "group.initial.rebalance.delay.ms";
    public static final String GROUP_INITIAL_REBALANCE_DELAY_MS_DOC = "The amount of time the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins.";
    public static final int GROUP_INITIAL_REBALANCE_DELAY_MS_DEFAULT = 3000;
    public static final String GROUP_MAX_SIZE_CONFIG = "group.max.size";
    public static final String GROUP_MAX_SIZE_DOC = "The maximum number of consumers that a single consumer group can accommodate.";
    public static final int GROUP_MAX_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final String CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.session.timeout.ms";
    public static final String CONSUMER_GROUP_SESSION_TIMEOUT_MS_DOC = "The timeout to detect client failures when using the consumer group protocol.";
    public static final int CONSUMER_GROUP_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.min.session.timeout.ms";
    public static final String CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for registered consumers.";
    public static final int CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.max.session.timeout.ms";
    public static final String CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for registered consumers.";
    public static final int CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_DOC = "The heartbeat interval given to the members of a consumer group.";
    public static final int CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.min.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DOC = "The minimum heartbeat interval for registered consumers.";
    public static final int CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.max.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DOC = "The maximum heartbeat interval for registered consumers.";
    public static final int CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DEFAULT = 15000;
    public static final String CONSUMER_GROUP_MAX_SIZE_CONFIG = "group.consumer.max.size";
    public static final String CONSUMER_GROUP_MAX_SIZE_DOC = "The maximum number of consumers that a single consumer group can accommodate. This value will only impact groups under the CONSUMER group protocol. To configure the max group size when using the CLASSIC group protocol use group.max.size instead.";
    public static final int CONSUMER_GROUP_MAX_SIZE_DEFAULT = Integer.MAX_VALUE;
    private static final List<ConsumerGroupPartitionAssignor> CONSUMER_GROUP_BUILTIN_ASSIGNORS = List.of(new UniformAssignor(), new RangeAssignor());
    public static final String CONSUMER_GROUP_ASSIGNORS_CONFIG = "group.consumer.assignors";
    public static final String CONSUMER_GROUP_ASSIGNORS_DOC = "The server side assignors as a list of either names for builtin assignors or full class names for customer assignors. The first one in the list is considered as the default assignor to be used in the case where the consumer does not specify an assignor. The supported builtin assignors are: " + CONSUMER_GROUP_BUILTIN_ASSIGNORS.stream().map(PartitionAssignor::name).collect(Collectors.joining(", ")) + ".";
    public static final List<String> CONSUMER_GROUP_ASSIGNORS_DEFAULT = CONSUMER_GROUP_BUILTIN_ASSIGNORS.stream().map(PartitionAssignor::name).toList();
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_CONFIG = "group.consumer.migration.policy";
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_DEFAULT = ConsumerGroupMigrationPolicy.BIDIRECTIONAL.toString();
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_DOC = "The config that enables converting the non-empty classic group using the consumer embedded protocol to the non-empty consumer group using the consumer group protocol and vice versa; conversions of empty groups in both directions are always enabled regardless of this policy. " + String.valueOf((Object)ConsumerGroupMigrationPolicy.BIDIRECTIONAL) + ": both upgrade from classic group to consumer group and downgrade from consumer group to classic group are enabled, " + String.valueOf((Object)ConsumerGroupMigrationPolicy.UPGRADE) + ": only upgrade from classic group to consumer group is enabled, " + String.valueOf((Object)ConsumerGroupMigrationPolicy.DOWNGRADE) + ": only downgrade from consumer group to classic group is enabled, " + String.valueOf((Object)ConsumerGroupMigrationPolicy.DISABLED) + ": neither upgrade nor downgrade is enabled.";
    public static final String SHARE_GROUP_MAX_SIZE_CONFIG = "group.share.max.size";
    public static final int SHARE_GROUP_MAX_SIZE_DEFAULT = 200;
    public static final String SHARE_GROUP_MAX_SIZE_DOC = "The maximum number of members that a single share group can accommodate.";
    public static final String SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG = "group.share.session.timeout.ms";
    public static final int SHARE_GROUP_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String SHARE_GROUP_SESSION_TIMEOUT_MS_DOC = "The timeout to detect client failures when using the share group protocol.";
    public static final String SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.share.min.session.timeout.ms";
    public static final int SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for share group members.";
    public static final String SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.share.max.session.timeout.ms";
    public static final int SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for share group members.";
    public static final String SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.heartbeat.interval.ms";
    public static final int SHARE_GROUP_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String SHARE_GROUP_HEARTBEAT_INTERVAL_MS_DOC = "The heartbeat interval given to the members of a share group.";
    public static final String SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.min.heartbeat.interval.ms";
    public static final int SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DOC = "The minimum heartbeat interval for share group members.";
    public static final String SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.max.heartbeat.interval.ms";
    public static final int SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DEFAULT = 15000;
    public static final String SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DOC = "The maximum heartbeat interval for share group members.";
    public static final ConfigDef GROUP_COORDINATOR_CONFIG_DEF = new ConfigDef().define("group.coordinator.rebalance.protocols", ConfigDef.Type.LIST, GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.in((String[])Group.GroupType.documentValidValues()), ConfigDef.Importance.MEDIUM, GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DOC).define("group.coordinator.threads", ConfigDef.Type.INT, (Object)4, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of threads used by the group coordinator.").define("group.coordinator.append.linger.ms", ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The duration in milliseconds that the coordinator will wait for writes to accumulate before flushing them to disk. Transactional writes are not accumulated.").define("offsets.commit.timeout.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Offset commit will be delayed until all replicas for the offsets topic receive the commit or this timeout is reached. This is similar to the producer request timeout. This is applied to all the writes made by the coordinator.").define("offsets.load.buffer.size", ConfigDef.Type.INT, (Object)0x500000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Batch size for reading from the offsets segments when loading group metadata  into the cache (soft-limit, overridden if records are too large).").define("offsets.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The replication factor for the offsets topic (set higher to ensure availability). Internal topic creation will fail until the cluster size meets this replication factor requirement.").define("offsets.topic.num.partitions", ConfigDef.Type.INT, (Object)50, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of partitions for the offset commit topic (should not change after deployment).").define("offsets.topic.segment.bytes", ConfigDef.Type.INT, (Object)0x6400000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The offsets topic segment bytes should be kept relatively small in order to facilitate faster log compaction and cache loads.").define("offsets.topic.compression.codec", ConfigDef.Type.INT, (Object)GroupCoordinatorConfig.OFFSETS_TOPIC_COMPRESSION_CODEC_DEFAULT.id, ConfigDef.Importance.HIGH, "Compression codec for the offsets topic - compression may be used to achieve \"atomic\" commits.").defineInternal("group.coordinator.new.enable", ConfigDef.Type.BOOLEAN, (Object)true, null, ConfigDef.Importance.MEDIUM, "Enable the new group coordinator.");
    public static final ConfigDef OFFSET_MANAGEMENT_CONFIG_DEF = new ConfigDef().define("offset.metadata.max.bytes", ConfigDef.Type.INT, (Object)4096, ConfigDef.Importance.HIGH, "The maximum size for a metadata entry associated with an offset commit.").define("offsets.retention.minutes", ConfigDef.Type.INT, (Object)10080, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "For subscribed consumers, committed offset of a specific partition will be expired and discarded when 1) this retention period has elapsed after the consumer group loses all its consumers (i.e. becomes empty); 2) this retention period has elapsed since the last time an offset is committed for the partition and the group is no longer subscribed to the corresponding topic. For standalone consumers (using manual assignment), offsets will be expired after this retention period has elapsed since the time of last commit. Note that when a group is deleted via the delete-group request, its committed offsets will also be deleted without extra retention period; also when a topic is deleted via the delete-topic request, upon propagated metadata update any group's committed offsets for that topic will also be deleted without extra retention period.").define("offsets.retention.check.interval.ms", ConfigDef.Type.LONG, (Object)600000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Frequency at which to check for stale offsets");
    public static final ConfigDef CLASSIC_GROUP_CONFIG_DEF = new ConfigDef().define("group.min.session.timeout.ms", ConfigDef.Type.INT, (Object)6000, ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for registered consumers. Shorter timeouts result in quicker failure detection at the cost of more frequent consumer heartbeating, which can overwhelm broker resources.").define("group.max.session.timeout.ms", ConfigDef.Type.INT, (Object)1800000, ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.").define("group.initial.rebalance.delay.ms", ConfigDef.Type.INT, (Object)3000, ConfigDef.Importance.MEDIUM, "The amount of time the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins.").define("group.max.size", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of consumers that a single consumer group can accommodate.");
    public static final ConfigDef CONSUMER_GROUP_CONFIG_DEF = new ConfigDef().define("group.consumer.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the consumer group protocol.").define("group.consumer.min.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for registered consumers.").define("group.consumer.max.session.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for registered consumers.").define("group.consumer.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a consumer group.").define("group.consumer.min.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for registered consumers.").define("group.consumer.max.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for registered consumers.").define("group.consumer.max.size", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of consumers that a single consumer group can accommodate. This value will only impact groups under the CONSUMER group protocol. To configure the max group size when using the CLASSIC group protocol use group.max.size instead.").define("group.consumer.assignors", ConfigDef.Type.LIST, CONSUMER_GROUP_ASSIGNORS_DEFAULT, null, ConfigDef.Importance.MEDIUM, CONSUMER_GROUP_ASSIGNORS_DOC).define("group.consumer.migration.policy", ConfigDef.Type.STRING, (Object)CONSUMER_GROUP_MIGRATION_POLICY_DEFAULT, (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])Utils.enumOptions(ConsumerGroupMigrationPolicy.class)), ConfigDef.Importance.MEDIUM, CONSUMER_GROUP_MIGRATION_POLICY_DOC);
    public static final ConfigDef SHARE_GROUP_CONFIG_DEF = new ConfigDef().define("group.share.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the share group protocol.").define("group.share.min.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for share group members.").define("group.share.max.session.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for share group members.").define("group.share.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a share group.").define("group.share.min.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for share group members.").define("group.share.max.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for share group members.").define("group.share.max.size", ConfigDef.Type.INT, (Object)200, (ConfigDef.Validator)ConfigDef.Range.between((Number)1, (Number)1000), ConfigDef.Importance.MEDIUM, "The maximum number of members that a single share group can accommodate.");
    public static final int CLASSIC_GROUP_NEW_MEMBER_JOIN_TIMEOUT_MS = 300000;
    private final int numThreads;
    private final int appendLingerMs;
    private final int consumerGroupSessionTimeoutMs;
    private final int consumerGroupHeartbeatIntervalMs;
    private final int consumerGroupMaxSize;
    private final List<ConsumerGroupPartitionAssignor> consumerGroupAssignors;
    private final int offsetsTopicSegmentBytes;
    private final int offsetMetadataMaxSize;
    private final int classicGroupMaxSize;
    private final int classicGroupInitialRebalanceDelayMs;
    private final int classicGroupMinSessionTimeoutMs;
    private final int classicGroupMaxSessionTimeoutMs;
    private final long offsetsRetentionCheckIntervalMs;
    private final long offsetsRetentionMs;
    private final int offsetCommitTimeoutMs;
    private final ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy;
    private final CompressionType offsetTopicCompressionType;
    private final int offsetsLoadBufferSize;
    private final int offsetsTopicPartitions;
    private final short offsetsTopicReplicationFactor;
    private final int consumerGroupMinSessionTimeoutMs;
    private final int consumerGroupMaxSessionTimeoutMs;
    private final int consumerGroupMinHeartbeatIntervalMs;
    private final int consumerGroupMaxHeartbeatIntervalMs;
    private final int shareGroupMaxSize;
    private final int shareGroupSessionTimeoutMs;
    private final int shareGroupMinSessionTimeoutMs;
    private final int shareGroupMaxSessionTimeoutMs;
    private final int shareGroupHeartbeatIntervalMs;
    private final int shareGroupMinHeartbeatIntervalMs;
    private final int shareGroupMaxHeartbeatIntervalMs;

    public GroupCoordinatorConfig(AbstractConfig config) {
        this.numThreads = config.getInt(GROUP_COORDINATOR_NUM_THREADS_CONFIG);
        this.appendLingerMs = config.getInt(GROUP_COORDINATOR_APPEND_LINGER_MS_CONFIG);
        this.consumerGroupSessionTimeoutMs = config.getInt(CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.consumerGroupMaxSize = config.getInt(CONSUMER_GROUP_MAX_SIZE_CONFIG);
        this.consumerGroupAssignors = this.consumerGroupAssignors(config);
        this.offsetsTopicSegmentBytes = config.getInt(OFFSETS_TOPIC_SEGMENT_BYTES_CONFIG);
        this.offsetMetadataMaxSize = config.getInt(OFFSET_METADATA_MAX_SIZE_CONFIG);
        this.classicGroupMaxSize = config.getInt(GROUP_MAX_SIZE_CONFIG);
        this.classicGroupInitialRebalanceDelayMs = config.getInt(GROUP_INITIAL_REBALANCE_DELAY_MS_CONFIG);
        this.classicGroupMinSessionTimeoutMs = config.getInt(GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.classicGroupMaxSessionTimeoutMs = config.getInt(GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.offsetsRetentionCheckIntervalMs = config.getLong(OFFSETS_RETENTION_CHECK_INTERVAL_MS_CONFIG);
        this.offsetsRetentionMs = (long)config.getInt(OFFSETS_RETENTION_MINUTES_CONFIG).intValue() * 60L * 1000L;
        this.offsetCommitTimeoutMs = config.getInt(OFFSET_COMMIT_TIMEOUT_MS_CONFIG);
        this.consumerGroupMigrationPolicy = ConsumerGroupMigrationPolicy.parse(config.getString(CONSUMER_GROUP_MIGRATION_POLICY_CONFIG));
        this.offsetTopicCompressionType = Optional.ofNullable(config.getInt(OFFSETS_TOPIC_COMPRESSION_CODEC_CONFIG)).map(CompressionType::forId).orElse(null);
        this.offsetsLoadBufferSize = config.getInt(OFFSETS_LOAD_BUFFER_SIZE_CONFIG);
        this.offsetsTopicPartitions = config.getInt(OFFSETS_TOPIC_PARTITIONS_CONFIG);
        this.offsetsTopicReplicationFactor = config.getShort(OFFSETS_TOPIC_REPLICATION_FACTOR_CONFIG);
        this.consumerGroupMinSessionTimeoutMs = config.getInt(CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupMaxSessionTimeoutMs = config.getInt(CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupMinHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.consumerGroupMaxHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupSessionTimeoutMs = config.getInt(SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupMinSessionTimeoutMs = config.getInt(SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupMaxSessionTimeoutMs = config.getInt(SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupHeartbeatIntervalMs = config.getInt(SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMinHeartbeatIntervalMs = config.getInt(SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMaxHeartbeatIntervalMs = config.getInt(SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMaxSize = config.getInt(SHARE_GROUP_MAX_SIZE_CONFIG);
        Utils.require((this.consumerGroupMaxHeartbeatIntervalMs >= this.consumerGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.consumerGroupHeartbeatIntervalMs >= this.consumerGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.consumerGroupHeartbeatIntervalMs <= this.consumerGroupMaxHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.consumerGroupMaxSessionTimeoutMs >= this.consumerGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.consumerGroupSessionTimeoutMs >= this.consumerGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.consumerGroupSessionTimeoutMs <= this.consumerGroupMaxSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.consumerGroupHeartbeatIntervalMs < this.consumerGroupSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.shareGroupMaxHeartbeatIntervalMs >= this.shareGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.shareGroupHeartbeatIntervalMs >= this.shareGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.shareGroupHeartbeatIntervalMs <= this.shareGroupMaxHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.shareGroupMaxSessionTimeoutMs >= this.shareGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.shareGroupSessionTimeoutMs >= this.shareGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.shareGroupSessionTimeoutMs <= this.shareGroupMaxSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.shareGroupHeartbeatIntervalMs < this.shareGroupSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG));
    }

    public static GroupCoordinatorConfig fromProps(Map<?, ?> props) {
        return new GroupCoordinatorConfig(new AbstractConfig(Utils.mergeConfigs(List.of(GROUP_COORDINATOR_CONFIG_DEF, OFFSET_MANAGEMENT_CONFIG_DEF, CLASSIC_GROUP_CONFIG_DEF, CONSUMER_GROUP_CONFIG_DEF, SHARE_GROUP_CONFIG_DEF)), props));
    }

    protected List<ConsumerGroupPartitionAssignor> consumerGroupAssignors(AbstractConfig config) {
        Map defaultAssignors = CONSUMER_GROUP_BUILTIN_ASSIGNORS.stream().collect(Collectors.toMap(PartitionAssignor::name, Function.identity()));
        ArrayList<ConsumerGroupPartitionAssignor> assignors = new ArrayList<ConsumerGroupPartitionAssignor>();
        try {
            for (Object object : config.getList(CONSUMER_GROUP_ASSIGNORS_CONFIG)) {
                ConsumerGroupPartitionAssignor assignor;
                if (object instanceof String) {
                    String klass = (String)object;
                    assignor = (ConsumerGroupPartitionAssignor)defaultAssignors.get(klass);
                    if (assignor == null) {
                        try {
                            assignor = (ConsumerGroupPartitionAssignor)Utils.newInstance((String)klass, ConsumerGroupPartitionAssignor.class);
                        }
                        catch (ClassNotFoundException e) {
                            throw new KafkaException("Class " + klass + " cannot be found", (Throwable)e);
                        }
                        catch (ClassCastException e) {
                            throw new KafkaException(klass + " is not an instance of " + ConsumerGroupPartitionAssignor.class.getName());
                        }
                    }
                } else if (object instanceof Class) {
                    Class klass = (Class)object;
                    Object o = Utils.newInstance((Class)klass);
                    if (!ConsumerGroupPartitionAssignor.class.isInstance(o)) {
                        throw new KafkaException(String.valueOf(klass) + " is not an instance of " + ConsumerGroupPartitionAssignor.class.getName());
                    }
                    assignor = (ConsumerGroupPartitionAssignor)o;
                } else {
                    throw new KafkaException("Unexpected element of type " + object.getClass().getName() + ", expected String or Class");
                }
                assignors.add(assignor);
                if (!(assignor instanceof Configurable)) continue;
                Configurable configurable = (Configurable)assignor;
                configurable.configure(config.originals());
            }
        }
        catch (Exception e) {
            for (ConsumerGroupPartitionAssignor assignor : assignors) {
                Utils.maybeCloseQuietly((Object)assignor, (String)"AutoCloseable object constructed and configured during failed call to consumerGroupAssignors");
            }
            throw e;
        }
        return assignors;
    }

    public Map<String, Integer> extractGroupConfigMap(ShareGroupConfig shareGroupConfig) {
        HashMap<String, Integer> defaultConfigs = new HashMap<String, Integer>();
        defaultConfigs.putAll(this.extractConsumerGroupConfigMap());
        defaultConfigs.putAll(shareGroupConfig.extractShareGroupConfigMap());
        return Collections.unmodifiableMap(defaultConfigs);
    }

    public Map<String, Integer> extractConsumerGroupConfigMap() {
        return Map.of("consumer.session.timeout.ms", this.consumerGroupSessionTimeoutMs(), "consumer.heartbeat.interval.ms", this.consumerGroupHeartbeatIntervalMs());
    }

    public int numThreads() {
        return this.numThreads;
    }

    public int appendLingerMs() {
        return this.appendLingerMs;
    }

    public int consumerGroupSessionTimeoutMs() {
        return this.consumerGroupSessionTimeoutMs;
    }

    public int consumerGroupHeartbeatIntervalMs() {
        return this.consumerGroupHeartbeatIntervalMs;
    }

    public int consumerGroupMaxSize() {
        return this.consumerGroupMaxSize;
    }

    public List<ConsumerGroupPartitionAssignor> consumerGroupAssignors() {
        return this.consumerGroupAssignors;
    }

    public int offsetsTopicSegmentBytes() {
        return this.offsetsTopicSegmentBytes;
    }

    public int offsetMetadataMaxSize() {
        return this.offsetMetadataMaxSize;
    }

    public int classicGroupMaxSize() {
        return this.classicGroupMaxSize;
    }

    public int classicGroupInitialRebalanceDelayMs() {
        return this.classicGroupInitialRebalanceDelayMs;
    }

    public int classicGroupNewMemberJoinTimeoutMs() {
        return 300000;
    }

    public int classicGroupMinSessionTimeoutMs() {
        return this.classicGroupMinSessionTimeoutMs;
    }

    public int classicGroupMaxSessionTimeoutMs() {
        return this.classicGroupMaxSessionTimeoutMs;
    }

    public long offsetsRetentionCheckIntervalMs() {
        return this.offsetsRetentionCheckIntervalMs;
    }

    public long offsetsRetentionMs() {
        return this.offsetsRetentionMs;
    }

    public int offsetCommitTimeoutMs() {
        return this.offsetCommitTimeoutMs;
    }

    public ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy() {
        return this.consumerGroupMigrationPolicy;
    }

    public CompressionType offsetTopicCompressionType() {
        return this.offsetTopicCompressionType;
    }

    public int offsetsLoadBufferSize() {
        return this.offsetsLoadBufferSize;
    }

    public int offsetsTopicPartitions() {
        return this.offsetsTopicPartitions;
    }

    public short offsetsTopicReplicationFactor() {
        return this.offsetsTopicReplicationFactor;
    }

    public int consumerGroupMinSessionTimeoutMs() {
        return this.consumerGroupMinSessionTimeoutMs;
    }

    public int consumerGroupMaxSessionTimeoutMs() {
        return this.consumerGroupMaxSessionTimeoutMs;
    }

    public int consumerGroupMinHeartbeatIntervalMs() {
        return this.consumerGroupMinHeartbeatIntervalMs;
    }

    public int consumerGroupMaxHeartbeatIntervalMs() {
        return this.consumerGroupMaxHeartbeatIntervalMs;
    }

    public int shareGroupSessionTimeoutMs() {
        return this.shareGroupSessionTimeoutMs;
    }

    public int shareGroupHeartbeatIntervalMs() {
        return this.shareGroupHeartbeatIntervalMs;
    }

    public int shareGroupMaxSize() {
        return this.shareGroupMaxSize;
    }

    public int shareGroupMinSessionTimeoutMs() {
        return this.shareGroupMinSessionTimeoutMs;
    }

    public int shareGroupMaxSessionTimeoutMs() {
        return this.shareGroupMaxSessionTimeoutMs;
    }

    public int shareGroupMinHeartbeatIntervalMs() {
        return this.shareGroupMinHeartbeatIntervalMs;
    }

    public int shareGroupMaxHeartbeatIntervalMs() {
        return this.shareGroupMaxHeartbeatIntervalMs;
    }
}

