/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kafka.cluster.Partition;
import kafka.server.LogReadResult;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.share.ShareFetchUtils;
import kafka.server.share.SharePartition;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchGroupKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchKey;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.runtime.BoxedUnit;

public class DelayedShareFetch
extends DelayedOperation {
    private static final Logger log = LoggerFactory.getLogger(DelayedShareFetch.class);
    private final ShareFetch shareFetch;
    private final ReplicaManager replicaManager;
    private final BiConsumer<SharePartitionKey, Throwable> exceptionHandler;
    private final LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions;
    private LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> partitionsAcquired;
    private LinkedHashMap<TopicIdPartition, LogReadResult> partitionsAlreadyFetched;

    DelayedShareFetch(ShareFetch shareFetch, ReplicaManager replicaManager, BiConsumer<SharePartitionKey, Throwable> exceptionHandler, LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions) {
        super(shareFetch.fetchParams().maxWaitMs, Optional.empty());
        this.shareFetch = shareFetch;
        this.replicaManager = replicaManager;
        this.partitionsAcquired = new LinkedHashMap();
        this.partitionsAlreadyFetched = new LinkedHashMap();
        this.exceptionHandler = exceptionHandler;
        this.sharePartitions = sharePartitions;
    }

    public void onExpiration() {
    }

    public void onComplete() {
        this.lock.lock();
        log.trace("Completing the delayed share fetch request for group {}, member {}, topic partitions {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), this.partitionsAcquired.keySet()});
        try {
            LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData = this.partitionsAcquired.isEmpty() ? this.acquirablePartitions() : this.partitionsAcquired;
            if (topicPartitionData.isEmpty()) {
                this.shareFetch.maybeComplete(Collections.emptyMap());
                return;
            }
            log.trace("Fetchable share partitions data: {} with groupId: {} fetch params: {}", new Object[]{topicPartitionData, this.shareFetch.groupId(), this.shareFetch.fetchParams()});
            this.completeShareFetchRequest(topicPartitionData);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeShareFetchRequest(LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData) {
        try {
            LinkedHashMap<TopicIdPartition, LogReadResult> responseData = this.partitionsAlreadyFetched.isEmpty() ? this.readFromLog(topicPartitionData) : this.combineLogReadResponse(topicPartitionData, this.partitionsAlreadyFetched);
            LinkedHashMap<TopicIdPartition, FetchPartitionData> fetchPartitionsData = new LinkedHashMap<TopicIdPartition, FetchPartitionData>();
            for (Map.Entry<TopicIdPartition, LogReadResult> entry : responseData.entrySet()) {
                fetchPartitionsData.put(entry.getKey(), entry.getValue().toFetchPartitionData(false));
            }
            this.shareFetch.maybeComplete(ShareFetchUtils.processFetchResponse(this.shareFetch, fetchPartitionsData, this.sharePartitions, this.replicaManager, this.exceptionHandler));
        }
        catch (Exception e) {
            log.error("Error processing delayed share fetch request", (Throwable)e);
            this.handleFetchException(this.shareFetch, topicPartitionData.keySet(), e);
        }
        finally {
            this.releasePartitionLocks(topicPartitionData.keySet());
            this.replicaManager.addToActionQueue(() -> topicPartitionData.keySet().forEach(topicIdPartition -> this.replicaManager.completeDelayedShareFetchRequest((DelayedShareFetchKey)new DelayedShareFetchGroupKey(this.shareFetch.groupId(), topicIdPartition.topicId(), topicIdPartition.partition()))));
        }
    }

    public boolean tryComplete() {
        LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData = this.acquirablePartitions();
        try {
            if (!topicPartitionData.isEmpty()) {
                LinkedHashMap<TopicIdPartition, LogReadResult> replicaManagerReadResponse = this.maybeReadFromLog(topicPartitionData);
                this.maybeUpdateFetchOffsetMetadata(topicPartitionData, replicaManagerReadResponse);
                if (this.anyPartitionHasLogReadError(replicaManagerReadResponse) || this.isMinBytesSatisfied(topicPartitionData)) {
                    this.partitionsAcquired = topicPartitionData;
                    this.partitionsAlreadyFetched = replicaManagerReadResponse;
                    boolean completedByMe = this.forceComplete();
                    if (!completedByMe) {
                        this.releasePartitionLocks(this.partitionsAcquired.keySet());
                    }
                    return completedByMe;
                }
                log.debug("minBytes is not satisfied for the share fetch request for group {}, member {}, topic partitions {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), this.sharePartitions.keySet()});
                this.releasePartitionLocks(topicPartitionData.keySet());
            } else {
                log.trace("Can't acquire records for any partition in the share fetch request for group {}, member {}, topic partitions {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), this.sharePartitions.keySet()});
            }
            return false;
        }
        catch (Exception e) {
            log.error("Error processing delayed share fetch request", (Throwable)e);
            this.partitionsAcquired.clear();
            this.partitionsAlreadyFetched.clear();
            this.releasePartitionLocks(topicPartitionData.keySet());
            return this.forceComplete();
        }
    }

    LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> acquirablePartitions() {
        LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData = new LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData>();
        this.sharePartitions.forEach((topicIdPartition, sharePartition) -> {
            int partitionMaxBytes = this.shareFetch.partitionMaxBytes().getOrDefault(topicIdPartition, 0);
            if (sharePartition.maybeAcquireFetchLock()) {
                try {
                    if (sharePartition.canAcquireRecords()) {
                        topicPartitionData.put((TopicIdPartition)topicIdPartition, new FetchRequest.PartitionData(topicIdPartition.topicId(), sharePartition.nextFetchOffset(), 0L, partitionMaxBytes, Optional.empty()));
                    } else {
                        sharePartition.releaseFetchLock();
                        log.trace("Record lock partition limit exceeded for SharePartition {}, cannot acquire more records", sharePartition);
                    }
                }
                catch (Exception e) {
                    log.error("Error checking condition for SharePartition: {}", sharePartition, (Object)e);
                    sharePartition.releaseFetchLock();
                }
            }
        });
        return topicPartitionData;
    }

    private LinkedHashMap<TopicIdPartition, LogReadResult> maybeReadFromLog(LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData) {
        LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> partitionsNotMatchingFetchOffsetMetadata = new LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData>();
        topicPartitionData.forEach((topicIdPartition, partitionData) -> {
            SharePartition sharePartition = this.sharePartitions.get(topicIdPartition);
            if (sharePartition.fetchOffsetMetadata(partitionData.fetchOffset).isEmpty()) {
                partitionsNotMatchingFetchOffsetMetadata.put((TopicIdPartition)topicIdPartition, (FetchRequest.PartitionData)partitionData);
            }
        });
        if (partitionsNotMatchingFetchOffsetMetadata.isEmpty()) {
            return new LinkedHashMap<TopicIdPartition, LogReadResult>();
        }
        return this.readFromLog(partitionsNotMatchingFetchOffsetMetadata);
    }

    private void maybeUpdateFetchOffsetMetadata(LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData, LinkedHashMap<TopicIdPartition, LogReadResult> replicaManagerReadResponseData) {
        for (Map.Entry<TopicIdPartition, LogReadResult> entry : replicaManagerReadResponseData.entrySet()) {
            TopicIdPartition topicIdPartition = entry.getKey();
            SharePartition sharePartition = this.sharePartitions.get(topicIdPartition);
            LogReadResult replicaManagerLogReadResult = entry.getValue();
            if (replicaManagerLogReadResult.error().code() != Errors.NONE.code()) {
                log.debug("Replica manager read log result {} errored out for topic partition {}", (Object)replicaManagerLogReadResult, (Object)topicIdPartition);
                continue;
            }
            sharePartition.updateFetchOffsetMetadata(topicPartitionData.get((Object)topicIdPartition).fetchOffset, replicaManagerLogReadResult.info().fetchOffsetMetadata);
        }
    }

    private boolean isMinBytesSatisfied(LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData) {
        long accumulatedSize = 0L;
        for (Map.Entry<TopicIdPartition, FetchRequest.PartitionData> entry : topicPartitionData.entrySet()) {
            SharePartition sharePartition;
            Optional<LogOffsetMetadata> optionalFetchOffsetMetadata;
            LogOffsetMetadata endOffsetMetadata;
            TopicIdPartition topicIdPartition = entry.getKey();
            FetchRequest.PartitionData partitionData = entry.getValue();
            try {
                endOffsetMetadata = this.endOffsetMetadataForTopicPartition(topicIdPartition);
            }
            catch (Exception e) {
                this.shareFetch.addErroneous(topicIdPartition, (Throwable)e);
                this.exceptionHandler.accept(new SharePartitionKey(this.shareFetch.groupId(), topicIdPartition), e);
                continue;
            }
            if (endOffsetMetadata == LogOffsetMetadata.UNKNOWN_OFFSET_METADATA || (optionalFetchOffsetMetadata = (sharePartition = this.sharePartitions.get(topicIdPartition)).fetchOffsetMetadata(partitionData.fetchOffset)).isEmpty() || optionalFetchOffsetMetadata.get() == LogOffsetMetadata.UNKNOWN_OFFSET_METADATA) continue;
            LogOffsetMetadata fetchOffsetMetadata = optionalFetchOffsetMetadata.get();
            if (fetchOffsetMetadata.messageOffset > endOffsetMetadata.messageOffset) {
                log.debug("Satisfying delayed share fetch request for group {}, member {} since it is fetching later segments of topicIdPartition {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), topicIdPartition});
                return true;
            }
            if (fetchOffsetMetadata.messageOffset >= endOffsetMetadata.messageOffset) continue;
            if (fetchOffsetMetadata.onOlderSegment(endOffsetMetadata)) {
                log.debug("Satisfying delayed share fetch request for group {}, member {} immediately since it is fetching older segments of topicIdPartition {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), topicIdPartition});
                return true;
            }
            if (!fetchOffsetMetadata.onSameSegment(endOffsetMetadata)) continue;
            long bytesAvailable = Math.min(endOffsetMetadata.positionDiff(fetchOffsetMetadata), partitionData.maxBytes);
            accumulatedSize += bytesAvailable;
        }
        return accumulatedSize >= (long)this.shareFetch.fetchParams().minBytes;
    }

    private LogOffsetMetadata endOffsetMetadataForTopicPartition(TopicIdPartition topicIdPartition) {
        Partition partition = ShareFetchUtils.partition(this.replicaManager, topicIdPartition.topicPartition());
        LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(Optional.empty(), true);
        FetchIsolation isolationType = this.shareFetch.fetchParams().isolation;
        if (isolationType == FetchIsolation.LOG_END) {
            return offsetSnapshot.logEndOffset;
        }
        if (isolationType == FetchIsolation.HIGH_WATERMARK) {
            return offsetSnapshot.highWatermark;
        }
        return offsetSnapshot.lastStableOffset;
    }

    private LinkedHashMap<TopicIdPartition, LogReadResult> readFromLog(LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData) {
        Set partitionsToFetch = this.shareFetch.filterErroneousTopicPartitions(topicPartitionData.keySet());
        if (partitionsToFetch.isEmpty()) {
            return new LinkedHashMap<TopicIdPartition, LogReadResult>();
        }
        Seq<Tuple2<TopicIdPartition, LogReadResult>> responseLogResult = this.replicaManager.readFromLog(this.shareFetch.fetchParams(), (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)CollectionConverters.asScala(partitionsToFetch.stream().map(topicIdPartition -> new Tuple2(topicIdPartition, (Object)((FetchRequest.PartitionData)topicPartitionData.get(topicIdPartition)))).collect(Collectors.toList())), QuotaFactory.UNBOUNDED_QUOTA, true);
        LinkedHashMap<TopicIdPartition, LogReadResult> responseData = new LinkedHashMap<TopicIdPartition, LogReadResult>();
        responseLogResult.foreach(tpLogResult -> {
            responseData.put((TopicIdPartition)tpLogResult._1(), (LogReadResult)tpLogResult._2());
            return BoxedUnit.UNIT;
        });
        log.trace("Data successfully retrieved by replica manager: {}", responseData);
        return responseData;
    }

    private boolean anyPartitionHasLogReadError(LinkedHashMap<TopicIdPartition, LogReadResult> replicaManagerReadResponse) {
        return replicaManagerReadResponse.values().stream().anyMatch(logReadResult -> logReadResult.error().code() != Errors.NONE.code());
    }

    private void handleFetchException(ShareFetch shareFetch, Set<TopicIdPartition> topicIdPartitions, Throwable throwable) {
        topicIdPartitions.forEach(topicIdPartition -> this.exceptionHandler.accept(new SharePartitionKey(shareFetch.groupId(), topicIdPartition), throwable));
        shareFetch.maybeCompleteWithException(topicIdPartitions, throwable);
    }

    LinkedHashMap<TopicIdPartition, LogReadResult> combineLogReadResponse(LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData, LinkedHashMap<TopicIdPartition, LogReadResult> existingFetchedData) {
        LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> missingLogReadTopicPartitions = new LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData>();
        topicPartitionData.forEach((topicIdPartition, partitionData) -> {
            if (!existingFetchedData.containsKey(topicIdPartition)) {
                missingLogReadTopicPartitions.put((TopicIdPartition)topicIdPartition, (FetchRequest.PartitionData)partitionData);
            }
        });
        if (missingLogReadTopicPartitions.isEmpty()) {
            return existingFetchedData;
        }
        LinkedHashMap<TopicIdPartition, LogReadResult> missingTopicPartitionsLogReadResponse = this.readFromLog(missingLogReadTopicPartitions);
        missingTopicPartitionsLogReadResponse.putAll(existingFetchedData);
        return missingTopicPartitionsLogReadResponse;
    }

    void releasePartitionLocks(Set<TopicIdPartition> topicIdPartitions) {
        topicIdPartitions.forEach(tp -> {
            SharePartition sharePartition = this.sharePartitions.get(tp);
            sharePartition.releaseFetchLock();
        });
    }

    Lock lock() {
        return this.lock;
    }
}

