/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.AccessRuleLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.ExternalLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.InterWikiLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.LocalFootnoteLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.LocalFootnoteRefLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.LocalLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.MetadataLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.PluginLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.VariableLinkNodePostProcessorState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.util.TextUtil;

public class JSPWikiLinkNodePostProcessor
extends NodePostProcessor {
    protected final Context m_context;
    protected final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;
    protected boolean m_useOutlinkImage = true;
    protected final Document document;

    public JSPWikiLinkNodePostProcessor(Context m_context, Document document, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.m_context = m_context;
        this.document = document;
        this.linkOperations = new LinkParsingOperations(m_context);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
        this.m_useOutlinkImage = m_context.getBooleanWikiProperty("jspwiki.translatorReader.useOutlinkImage", this.m_useOutlinkImage);
    }

    public void process(NodeTracker state, Node node) {
        if (node instanceof Link) {
            JSPWikiLink link = this.replaceLinkWithJSPWikiLink(state, node);
            NodePostProcessorState<JSPWikiLink> linkPostProcessor = this.linkOperations.isAccessRule(link.getUrl().toString()) ? new AccessRuleLinkNodePostProcessorState(this.m_context) : (this.linkOperations.isMetadata(link.getUrl().toString()) ? new MetadataLinkNodePostProcessorState(this.m_context) : (this.linkOperations.isPluginLink(link.getUrl().toString()) ? new PluginLinkNodePostProcessorState(this.m_context) : (this.linkOperations.isVariableLink(link.getUrl().toString()) ? new VariableLinkNodePostProcessorState(this.m_context) : (this.linkOperations.isExternalLink(link.getUrl().toString()) ? new ExternalLinkNodePostProcessorState(this.m_context, this.isImageInlining, this.inlineImagePatterns) : (this.linkOperations.isInterWikiLink(link.getUrl().toString()) ? new InterWikiLinkNodePostProcessorState(this.m_context, this.document, this.isImageInlining, this.inlineImagePatterns) : (StringUtils.startsWith((CharSequence)link.getUrl().toString(), (CharSequence)"#") ? new LocalFootnoteLinkNodePostProcessorState(this.m_context) : (TextUtil.isNumber((String)link.getUrl().toString()) ? new LocalFootnoteRefLinkNodePostProcessorState(this.m_context) : new LocalLinkNodePostProcessorState(this.m_context, this.isImageInlining, this.inlineImagePatterns))))))));
            linkPostProcessor.process(state, link);
        }
    }

    JSPWikiLink replaceLinkWithJSPWikiLink(NodeTracker state, Node node) {
        JSPWikiLink link = new JSPWikiLink((Link)node);
        Node previous = node.getPrevious();
        Node parent = node.getParent();
        link.takeChildren(node);
        node.unlink();
        if (previous != null) {
            previous.insertAfter((Node)link);
        } else if (parent != null) {
            parent.appendChild((Node)link);
        }
        state.nodeRemoved(node);
        state.nodeAddedWithChildren((Node)link);
        return link;
    }
}

