/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.postgres;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationRepository;
import org.apache.james.vacation.postgres.PostgresVacationResponseDAO;
import reactor.core.publisher.Mono;

public class PostgresVacationRepository
implements VacationRepository {
    private final PostgresExecutor.Factory executorFactory;

    @Inject
    @Singleton
    public PostgresVacationRepository(PostgresExecutor.Factory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public Mono<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)vacationPatch);
        if (vacationPatch.isIdentity()) {
            return Mono.empty();
        }
        return this.vacationResponseDao(accountId).modifyVacation(accountId, vacationPatch);
    }

    public Mono<Vacation> retrieveVacation(AccountId accountId) {
        return this.vacationResponseDao(accountId).retrieveVacation(accountId).map(optional -> optional.orElse(DEFAULT_VACATION));
    }

    private PostgresVacationResponseDAO vacationResponseDao(AccountId accountId) {
        return new PostgresVacationResponseDAO(this.executorFactory.create(Username.of((String)accountId.getIdentifier()).getDomainPart()));
    }
}

