/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.pipe.resource.memory.InsertNodeMemoryEstimator;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertTablet;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class InsertTabletStatement
extends InsertBaseStatement
implements ISchemaValidation {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertTabletStatement.class);
    private static final String DATATYPE_UNSUPPORTED = "Data type %s is not supported.";
    protected long[] times;
    protected BitMap[] nullBitMaps;
    protected Object[] columns;
    protected IDeviceID[] deviceIDs;
    protected boolean singleDevice;
    protected int rowCount = 0;
    protected boolean[] measurementIsAligned;

    public InsertTabletStatement() {
        this.statementType = StatementType.BATCH_INSERT;
        this.recordedBeginOfLogicalViewSchemaList = 0;
        this.recordedEndOfLogicalViewSchemaList = 0;
    }

    public InsertTabletStatement(InsertTabletNode node) {
        this();
        this.setDevicePath(node.getTargetPath());
        this.setMeasurements(node.getMeasurements());
        this.setTimes(node.getTimes());
        this.setColumns(node.getColumns());
        this.setBitMaps(node.getBitMaps());
        this.setRowCount(node.getRowCount());
        this.setDataTypes(node.getDataTypes());
        this.setAligned(node.isAligned());
        this.setMeasurementSchemas(node.getMeasurementSchemas());
    }

    public InsertTabletStatement(RelationalInsertTabletNode node) {
        this((InsertTabletNode)node);
        this.setColumnCategories(node.getColumnCategories());
        this.setWriteToTable(true);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public BitMap[] getBitMaps() {
        return this.nullBitMaps;
    }

    public void setBitMaps(BitMap[] bitMaps) {
        this.nullBitMaps = bitMaps;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    @Override
    public boolean isEmpty() {
        return this.rowCount == 0 || this.times.length == 0 || this.measurements.length == 0 || this.dataTypes.length == 0 || this.columns.length == 0;
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        long upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[0]);
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[0]);
        for (int i = 1; i < this.times.length; ++i) {
            if (this.times[i] < upperBoundOfTimePartition) continue;
            result.add(timePartitionSlot);
            upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[i]);
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[i]);
        }
        result.add(timePartitionSlot);
        return result;
    }

    public TTimePartitionSlot getTimePartitionSlot(int i) {
        return TimePartitionUtils.getTimePartitionSlot((long)this.times[i]);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertTablet(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            MeasurementPath fullPath = this.devicePath.concatAsMeasurementPath(m);
            ret.add((PartialPath)fullPath);
        }
        return ret;
    }

    @Override
    public ISchemaValidation getSchemaValidation() {
        return this;
    }

    @Override
    public List<ISchemaValidation> getSchemaValidationList() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        if (dataType.isCompatible(this.dataTypes[columnIndex])) {
            this.columns[columnIndex] = dataType.castFromArray(this.dataTypes[columnIndex], this.columns[columnIndex]);
            this.dataTypes[columnIndex] = dataType;
            return true;
        }
        return false;
    }

    @Override
    public void markFailedMeasurement(int index, Exception cause) {
        if (this.measurements[index] == null) {
            return;
        }
        if (this.failedMeasurementIndex2Info == null) {
            this.failedMeasurementIndex2Info = new HashMap();
        }
        InsertBaseStatement.FailedMeasurementInfo failedMeasurementInfo = new InsertBaseStatement.FailedMeasurementInfo(this.measurements[index], this.dataTypes[index], this.columns[index], cause);
        this.failedMeasurementIndex2Info.putIfAbsent(index, failedMeasurementInfo);
        this.measurements[index] = null;
        this.dataTypes[index] = null;
        this.columns[index] = null;
    }

    @Override
    public void removeAllFailedMeasurementMarks() {
        if (this.failedMeasurementIndex2Info == null) {
            return;
        }
        this.failedMeasurementIndex2Info.forEach((index, info) -> {
            this.measurements[index.intValue()] = info.getMeasurement();
            this.dataTypes[index.intValue()] = info.getDataType();
            this.columns[index.intValue()] = info.getValue();
        });
        this.failedMeasurementIndex2Info.clear();
    }

    @Override
    public void semanticCheck() {
        super.semanticCheck();
        if (this.measurements.length != this.columns.length) {
            throw new SemanticException(String.format("the measurementList's size %d is not consistent with the columnList's size %d", this.measurements.length, this.columns.length));
        }
    }

    public boolean isNeedSplit() {
        return this.hasLogicalViewNeedProcess();
    }

    public List<InsertTabletStatement> getSplitList() {
        if (!this.isNeedSplit()) {
            return Collections.singletonList(this);
        }
        Map<PartialPath, List<Pair<String, Integer>>> mapFromDeviceToMeasurementAndIndex = this.getMapFromDeviceToMeasurementAndIndex();
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (Map.Entry<PartialPath, List<Pair<String, Integer>>> entry : mapFromDeviceToMeasurementAndIndex.entrySet()) {
            List<Pair<String, Integer>> pairList = entry.getValue();
            InsertTabletStatement statement = new InsertTabletStatement();
            statement.setTimes(this.times);
            statement.setDevicePath(entry.getKey());
            statement.setRowCount(this.rowCount);
            statement.setAligned(this.isAligned);
            Object[] copiedColumns = new Object[pairList.size()];
            String[] measurements = new String[pairList.size()];
            BitMap[] copiedBitMaps = new BitMap[pairList.size()];
            MeasurementSchema[] measurementSchemas = new MeasurementSchema[pairList.size()];
            TSDataType[] dataTypes = new TSDataType[pairList.size()];
            for (int i = 0; i < pairList.size(); ++i) {
                int realIndex = (Integer)pairList.get((int)i).right;
                copiedColumns[i] = this.columns[realIndex];
                measurements[i] = Objects.nonNull(this.measurements[realIndex]) ? (String)pairList.get((int)i).left : null;
                measurementSchemas[i] = this.measurementSchemas[realIndex];
                dataTypes[i] = this.dataTypes[realIndex];
                if (this.nullBitMaps != null) {
                    copiedBitMaps[i] = this.nullBitMaps[realIndex];
                }
                if (this.measurementIsAligned == null) continue;
                statement.setAligned(this.measurementIsAligned[realIndex]);
            }
            statement.setColumns(copiedColumns);
            statement.setMeasurements(measurements);
            statement.setMeasurementSchemas(measurementSchemas);
            statement.setDataTypes(dataTypes);
            if (this.nullBitMaps != null) {
                statement.setBitMaps(copiedBitMaps);
            }
            statement.setFailedMeasurementIndex2Info(this.failedMeasurementIndex2Info);
            insertTabletStatementList.add(statement);
        }
        return insertTabletStatementList;
    }

    @Override
    public InsertBaseStatement removeLogicalView() {
        if (!this.isNeedSplit()) {
            return this;
        }
        List<InsertTabletStatement> insertTabletStatementList = this.getSplitList();
        if (insertTabletStatementList.size() == 1) {
            return insertTabletStatementList.get(0);
        }
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        return insertMultiTabletsStatement;
    }

    @Override
    public long getMinTime() {
        return this.times[0];
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        Object value;
        switch (this.dataTypes[index]) {
            case INT32: 
            case DATE: {
                int[] intValues = (int[])this.columns[index];
                value = intValues[0];
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])this.columns[index];
                value = longValues[0];
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[index];
                value = Float.valueOf(floatValues[0]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[index];
                value = doubleValues[0];
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[index];
                value = boolValues[0];
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])this.columns[index];
                value = binaryValues[0];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[index]));
            }
        }
        return value;
    }

    @Override
    public TSDataType getDataType(int index) {
        return this.dataTypes != null ? this.dataTypes[index] : null;
    }

    @Override
    public TSEncoding getEncoding(int index) {
        return null;
    }

    @Override
    public CompressionType getCompressionType(int index) {
        return null;
    }

    @Override
    public void validateDeviceSchema(boolean isAligned) {
        this.isAligned = isAligned;
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo) {
        if (this.measurementSchemas == null) {
            this.measurementSchemas = new MeasurementSchema[this.measurements.length];
        }
        if (measurementSchemaInfo == null) {
            this.measurementSchemas[index] = null;
        } else {
            if (measurementSchemaInfo.isLogicalView()) {
                if (this.logicalViewSchemaList == null || this.indexOfSourcePathsOfLogicalViews == null) {
                    this.logicalViewSchemaList = new ArrayList();
                    this.indexOfSourcePathsOfLogicalViews = new ArrayList();
                }
                this.logicalViewSchemaList.add(measurementSchemaInfo.getSchemaAsLogicalViewSchema());
                this.indexOfSourcePathsOfLogicalViews.add(index);
                return;
            }
            this.measurementSchemas[index] = measurementSchemaInfo.getSchemaAsMeasurementSchema();
        }
        try {
            this.selfCheckDataTypes(index);
        }
        catch (DataTypeMismatchException | PathNotExistException e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo, boolean isAligned) {
        this.validateMeasurementSchema(index, measurementSchemaInfo);
        if (this.measurementIsAligned == null) {
            this.measurementIsAligned = new boolean[this.measurements.length];
            Arrays.fill(this.measurementIsAligned, this.isAligned);
        }
        this.measurementIsAligned[index] = isAligned;
    }

    @Override
    public boolean hasLogicalViewNeedProcess() {
        if (this.indexOfSourcePathsOfLogicalViews == null) {
            return false;
        }
        return !this.indexOfSourcePathsOfLogicalViews.isEmpty();
    }

    @Override
    public List<LogicalViewSchema> getLogicalViewSchemaList() {
        return this.logicalViewSchemaList;
    }

    @Override
    public List<Integer> getIndexListOfLogicalViewPaths() {
        return this.indexOfSourcePathsOfLogicalViews;
    }

    @Override
    public void recordRangeOfLogicalViewSchemaListNow() {
        if (this.logicalViewSchemaList != null) {
            this.recordedBeginOfLogicalViewSchemaList = this.recordedEndOfLogicalViewSchemaList;
            this.recordedEndOfLogicalViewSchemaList = this.logicalViewSchemaList.size();
        }
    }

    @Override
    public Pair<Integer, Integer> getRangeOfLogicalViewSchemaListRecorded() {
        return new Pair((Object)this.recordedBeginOfLogicalViewSchemaList, (Object)this.recordedEndOfLogicalViewSchemaList);
    }

    @Override
    public Statement toRelationalStatement(MPPQueryContext context) {
        return new InsertTablet(this, context);
    }

    public IDeviceID getTableDeviceID(int rowIdx) {
        if (this.deviceIDs == null) {
            this.deviceIDs = new IDeviceID[this.rowCount];
        }
        if (this.deviceIDs[rowIdx] == null) {
            String[] deviceIdSegments = new String[this.getIdColumnIndices().size() + 1];
            deviceIdSegments[0] = this.getTableName();
            for (int i = 0; i < this.getIdColumnIndices().size(); ++i) {
                Integer columnIndex = this.getIdColumnIndices().get(i);
                boolean isNull = this.isNull(rowIdx, i);
                deviceIdSegments[i + 1] = isNull ? null : ((Object[])this.columns[columnIndex])[rowIdx].toString();
            }
            this.deviceIDs[rowIdx] = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdSegments);
        }
        return this.deviceIDs[rowIdx];
    }

    public IDeviceID[] getRawTableDeviceIDs() {
        return this.deviceIDs;
    }

    public void setSingleDevice() {
        this.singleDevice = true;
    }

    public boolean isSingleDevice() {
        return this.singleDevice;
    }

    @Override
    public void insertColumn(int pos, ColumnSchema columnSchema) {
        super.insertColumn(pos, columnSchema);
        if (this.nullBitMaps == null) {
            this.nullBitMaps = new BitMap[this.measurements.length];
            this.nullBitMaps[pos] = new BitMap(this.rowCount);
            for (int i = 0; i < this.rowCount; ++i) {
                this.nullBitMaps[pos].mark(i);
            }
        } else {
            BitMap[] tmpBitmaps = new BitMap[this.nullBitMaps.length + 1];
            System.arraycopy(this.nullBitMaps, 0, tmpBitmaps, 0, pos);
            tmpBitmaps[pos] = new BitMap(this.rowCount);
            for (int i = 0; i < this.rowCount; ++i) {
                tmpBitmaps[pos].mark(i);
            }
            System.arraycopy(this.nullBitMaps, pos, tmpBitmaps, pos + 1, this.nullBitMaps.length - pos);
            this.nullBitMaps = tmpBitmaps;
        }
        Object[] tmpColumns = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, tmpColumns, 0, pos);
        tmpColumns[pos] = CommonUtils.createValueColumnOfDataType(InternalTypeManager.getTSDataType(columnSchema.getType()), columnSchema.getColumnCategory(), this.rowCount);
        System.arraycopy(this.columns, pos, tmpColumns, pos + 1, this.columns.length - pos);
        this.columns = tmpColumns;
        this.deviceIDs = null;
    }

    @Override
    public void swapColumn(int src, int target) {
        super.swapColumn(src, target);
        if (this.nullBitMaps != null) {
            CommonUtils.swapArray(this.nullBitMaps, src, target);
        }
        CommonUtils.swapArray(this.columns, src, target);
        this.deviceIDs = null;
    }

    @Override
    protected long calculateBytesUsed() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOf((long[])this.times) + InsertNodeMemoryEstimator.sizeOfBitMapArray(this.nullBitMaps) + InsertNodeMemoryEstimator.sizeOfColumns(this.columns, this.measurementSchemas) + (Objects.nonNull(this.deviceIDs) ? Arrays.stream(this.deviceIDs).mapToLong(InsertNodeMemoryEstimator::sizeOfIDeviceID).reduce(0L, Long::sum) : 0L);
    }

    public boolean isNull(int row, int col) {
        if (this.nullBitMaps == null || this.nullBitMaps[col] == null) {
            return false;
        }
        return this.nullBitMaps[col].isMarked(row);
    }

    @Override
    protected void subRemoveAttributeColumns(List<Integer> columnsToKeep) {
        if (this.columns != null) {
            this.columns = columnsToKeep.stream().map(i -> this.columns[i]).toArray();
        }
        if (this.nullBitMaps != null) {
            this.nullBitMaps = (BitMap[])columnsToKeep.stream().map(i -> this.nullBitMaps[i]).toArray(BitMap[]::new);
        }
    }
}

