/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class StringLiteral
extends Literal {
    private final String value;
    private final int length;

    public StringLiteral(String value) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
        this.length = value.codePointCount(0, value.length());
    }

    public StringLiteral(NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
        this.length = value.codePointCount(0, value.length());
    }

    public String getValue() {
        return this.value;
    }

    public int length() {
        return this.length;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitStringLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!StringLiteral.sameClass(this, other)) {
            return false;
        }
        return Objects.equals(this.value, ((StringLiteral)other).value);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.STRING_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.length, (OutputStream)stream);
    }

    public StringLiteral(ByteBuffer byteBuffer) {
        super(null);
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.length = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
    }

    @Override
    public Object getTsValue() {
        return new Binary(this.value.getBytes(StandardCharsets.UTF_8));
    }
}

