/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;

public class LiteralOperand
extends FilterOperand
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=595");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=596");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=597");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15208");
    private final Variant value;

    public LiteralOperand(Variant value) {
        this.value = value;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Variant getValue() {
        return this.value;
    }

    protected LiteralOperand(LiteralOperandBuilder<?, ?> b) {
        super((FilterOperand.FilterOperandBuilder<?, ?>)b);
        this.value = ((LiteralOperandBuilder)b).value;
    }

    public static LiteralOperandBuilder<?, ?> builder() {
        return new LiteralOperandBuilderImpl();
    }

    public LiteralOperandBuilder<?, ?> toBuilder() {
        return new LiteralOperandBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiteralOperand)) {
            return false;
        }
        LiteralOperand other = (LiteralOperand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Variant this$value = this.getValue();
        Variant other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LiteralOperand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Variant $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LiteralOperand(value=" + this.getValue() + ")";
    }

    private static final class LiteralOperandBuilderImpl
    extends LiteralOperandBuilder<LiteralOperand, LiteralOperandBuilderImpl> {
        private LiteralOperandBuilderImpl() {
        }

        @Override
        protected LiteralOperandBuilderImpl self() {
            return this;
        }

        @Override
        public LiteralOperand build() {
            return new LiteralOperand(this);
        }
    }

    public static abstract class LiteralOperandBuilder<C extends LiteralOperand, B extends LiteralOperandBuilder<C, B>>
    extends FilterOperand.FilterOperandBuilder<C, B> {
        private Variant value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LiteralOperandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(LiteralOperand instance, LiteralOperandBuilder<?, ?> b) {
            b.value(instance.value);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B value(Variant value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "LiteralOperand.LiteralOperandBuilder(super=" + super.toString() + ", value=" + this.value + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<LiteralOperand> {
        @Override
        public Class<LiteralOperand> getType() {
            return LiteralOperand.class;
        }

        @Override
        public LiteralOperand decode(SerializationContext context, UaDecoder decoder) {
            Variant value = decoder.readVariant("Value");
            return new LiteralOperand(value);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, LiteralOperand value) {
            encoder.writeVariant("Value", value.getValue());
        }
    }
}

